#include <swmgr.h>
#include <markupfiltmgr.h>
#include <versekey.h>
#include <rawtext.h>
#include <iostream>

#ifndef __GNUC__
#include <io.h>
#else
#include <unistd.h>
#endif

#ifndef O_BINARY
#define O_BINARY 0
#endif

using namespace std;
using namespace sword;

SWMgr *mgr = 0;


void getModText(const char *modName, const char *key) {
	SWModule *mod = mgr->getModule(modName);
	//cout << "KEY:"<<key<<"<br>";
	if (mod) {
		mod->setKey(key);
		cout << mod->KeyText() << "|";
		cout << mod->getRawEntry();
	}
}


void exportRange(const char *modName, const char *key) {
	SWModule *mod = mgr->getModule(modName);
	//cout << "KEY:"<<key<<"<br>";
	if (mod) {
		VerseKey parser;
		ListKey scope = parser.ParseVerseList(key, parser, true);
		scope.Persist(1);
		mod->setKey(scope);
		RawText::createModule("./");
		RawText *outmod = new RawText("./");
		for (mod->setPosition(TOP); !mod->Error(); mod->increment()) {
			outmod->setKey(mod->KeyText());
			outmod->setEntry(mod->getRawEntry());
		}

	}
}


void writeModEntry(const char *modName, const char *key, const char *text) {
	SWModule *mod = mgr->getModule(modName);
	//cout << "KEY:"<<key<<"<br>";
	if (mod) {
		mod->setKey(key);
		mod->getRawEntry();
		mod->setEntry(text);
		(*mod)++;
		cout << mod->KeyText();
	}
}


void writeModEntryFromFile(const char *modName, const char *key, const char *fname) {
	SWModule *mod = mgr->getModule(modName);
	//cout << "KEY:"<<key<<"<br>";
	if (mod) {
		int fd = open(fname, O_RDONLY|O_BINARY);
		if (fd > -1) {
			long size = lseek(fd, 0, SEEK_END);
			lseek(fd, 0, SEEK_SET);
			char *buf = new char [ size + 1 ];
			read(fd, buf, size);
			buf[size] = 0;
			mod->setKey(key);
			mod->getRawEntry();
			mod->setEntry(buf);
			(*mod)++;
			cout << mod->KeyText();
			return;
		}
	}
	cout << key;
	return;
}


void getAttributes(const char *modName, const char *key) {
	SWModule *mod = mgr->getModule(modName);
	if (mod) {
		//cout << key << "<br>";
		mod->setKey(key);
		mod->RenderText();
		AttributeTypeList::iterator i1;
		AttributeList::iterator i2;
		AttributeValue::iterator i3;
		for (i1 = mod->getEntryAttributes().begin(); i1 != mod->getEntryAttributes().end(); i1++) {
			for (i2 = i1->second.begin(); i2 != i1->second.end(); i2++) {
				for (i3 = i2->second.begin(); i3 != i2->second.end(); i3++) {
					std::cout << i1->first << "|" << i2->first << "|" << i3->first << "|" << i3->second;
					std::cout.put(10);
				}
			}
		}
	}
}


void getModHTML(const char *modName, const char *key) {
	SWModule *mod = mgr->getModule(modName);
	if (mod) {
		mod->setKey(key);
//		cout << "<html>\n";
//		cout << "<head>\n";
//		cout << "<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n";
//		cout << "</head>\n";
//		cout << "<body>\n";
		cout << mod->KeyText() << "|";
		cout << mod->RenderText();
//		cout << "</body>\n";
//		cout << "</html>\n";
	}
}


int main(int argc, char **argv) {
	if (argc < 2) {
		fprintf(stderr, "usage: %s <read|html|write|fileWrite|attributes|export> <modname> <key> [text]\n\n", *argv);
		exit(1);
	}

	mgr = new SWMgr(new MarkupFilterMgr(FMT_HTML, ENC_UTF8));
	mgr->setGlobalOption("Textual Variants", "Secondary Reading");

//	mgr = new SWMgr("/home/sword/html/kjv2003", true, new MarkupFilterMgr(FMT_HTML, ENC_UTF8));
//SWMgr mgr("/home/sword/html/kjv2003");
	
	switch (argv[1][0]) {
	case 'r': getModText(argv[2], argv[3]);
			break;
	case 'h': getModHTML(argv[2], argv[3]);
			break;
	case 'a': getAttributes(argv[2], argv[3]);
			break;
	case 'e': exportRange(argv[2], argv[3]);
			break;
	case 'w': writeModEntry(argv[2], argv[3], argv[4]);
			break;
	case 'f': writeModEntryFromFile(argv[2], argv[3], argv[4]);
			break;
	}
	char buf[20];
//	cin >> buf;

	delete mgr;
	
	return 0;
}
