package org.crosswire.modedit;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * <p>Title: Proxy configuration</p>
 * <p>Description: prompts User to configer his/her Proxy</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Organisation: </p>
 * @author Christian Frommeyer
 * @version 1.0
 */

public class ProxyDialog extends JDialog {
  BorderLayout mainLayout = new BorderLayout();
  JPanel buttonPanel = new JPanel();
  GridLayout buttonPanelLayout = new GridLayout();
  JButton cancelButton = new JButton();
  JButton okButton = new JButton();
  Component component1;
  Component component2;
  Box centerBox;
  JTextField proxyField = new JTextField();
  JTextField portField = new JTextField();
  GridLayout textFieldPanelLayout = new GridLayout();
  GridLayout labelPanelLayout = new GridLayout();
  BorderLayout centerPanelLayout = new BorderLayout();
  JCheckBox proxyCheckBox = new JCheckBox();
  JLabel portLabel = new JLabel();
  JLabel proxyLabel = new JLabel();
  JPanel labelPanel = new JPanel();
  JPanel textFieldPanel = new JPanel();
  JPanel centerPanel = new JPanel();
  Component component3;
  JTextArea instructionText = new JTextArea();

  private boolean ok = false;
  private JCheckBox keepCheckBox = new JCheckBox();

  public ProxyDialog(boolean useProxy, String proxy, String port) {
    try {
	 jbInit();
	 if (useProxy) {
	   this.proxyCheckBox.setSelected(true);
	   if (proxy != null) this.proxyField.setText(proxy);
	   if (port != null) this.portField.setText(port);
	 }
    }
    catch(Exception e) {
	 e.printStackTrace();
    }
  }
  private void jbInit() throws Exception {
    component1 = Box.createHorizontalStrut(50);
    component2 = Box.createHorizontalStrut(50);
    component3 = Box.createVerticalStrut(20);
    centerBox = Box.createVerticalBox();
    this.setModal(true);
    this.setSize(new Dimension(489, 213));
    this.setTitle("Proxy-Configuration");
    this.getContentPane().setLayout(mainLayout);
    buttonPanel.setLayout(buttonPanelLayout);
    cancelButton.setText("Cancel");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	   button_actionPerformed(e);
	 }
    });
    okButton.setText("OK");
    okButton.addActionListener(new java.awt.event.ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	   button_actionPerformed(e);
	 }
    });
    proxyField.setEnabled(false);
    proxyField.setText("[none]");
    portField.setEnabled(false);
    portField.setText("8080");
    textFieldPanelLayout.setRows(2);
    labelPanelLayout.setRows(2);
    proxyCheckBox.setText("I need a proxy");
    proxyCheckBox.addItemListener(new java.awt.event.ItemListener() {
	 public void itemStateChanged(ItemEvent e) {
	   proxyCheckBox_itemStateChanged(e);
	 }
    });
    portLabel.setText("Port:");
    proxyLabel.setText("Proxy:");
    labelPanel.setLayout(labelPanelLayout);
    textFieldPanel.setLayout(textFieldPanelLayout);
    centerPanel.setLayout(centerPanelLayout);
    centerPanel.setMaximumSize(new Dimension(2147483647, 84));
    labelPanel.setPreferredSize(new Dimension(60, 30));
    instructionText.setMaximumSize(new Dimension(2147483647, 45));
    instructionText.setOpaque(false);
    instructionText.setRequestFocusEnabled(false);
    instructionText.setText("Please configure your Proxy-Server and Port here if you need one " +
    "to connect to the Internet");
    instructionText.setEditable(false);
    instructionText.setLineWrap(true);
    instructionText.setWrapStyleWord(true);
    keepCheckBox.setEnabled(false);
    keepCheckBox.setSelected(true);
    keepCheckBox.setText("keep settings");
    buttonPanel.add(cancelButton, null);
    buttonPanel.add(okButton, null);
    this.getContentPane().add(component2,  BorderLayout.EAST);
    this.getContentPane().add(component1,  BorderLayout.WEST);
    this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
    this.getContentPane().add(centerBox, BorderLayout.CENTER);
    centerPanel.add(textFieldPanel, BorderLayout.CENTER);
    textFieldPanel.add(proxyField, null);
    textFieldPanel.add(portField, null);
    centerPanel.add(labelPanel, BorderLayout.WEST);
    labelPanel.add(proxyLabel, null);
    labelPanel.add(portLabel, null);
    centerPanel.add(proxyCheckBox, BorderLayout.NORTH);
    centerPanel.add(keepCheckBox,  BorderLayout.SOUTH);
    centerBox.add(instructionText, null);
    this.getContentPane().add(component3, BorderLayout.NORTH);
    centerBox.add(centerPanel, null);
  }

  void proxyCheckBox_itemStateChanged(ItemEvent e) {
    this.proxyField.setEnabled(this.proxyCheckBox.isSelected());
    this.portField.setEnabled(this.proxyCheckBox.isSelected());
    this.keepCheckBox.setEnabled(this.proxyCheckBox.isSelected());
  }

  public String getProxy() {
    if (this.proxyCheckBox.isSelected()) return this.proxyField.getText();
    else return null;
  }

  public String getPort() {
    if (this.proxyCheckBox.isSelected()) return this.portField.getText();
    else return null;
  }

  public boolean isKeepSettings() { return (this.proxyCheckBox.isSelected() && this.keepCheckBox.isSelected()); }
  public boolean isOK() { return ok; }

  void button_actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals(okButton.getActionCommand())) ok = true;
    else ok = false;
    this.hide();
  }
}
