package org.crosswire.modedit;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.html.*;
import javax.swing.text.*;
import javax.swing.event.*;
import java.io.*;
import javax.swing.border.*;
import java.net.URLEncoder;
import java.net.URLDecoder;
//import com.borland.jbcl.layout.*;
import java.util.Hashtable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.zip.ZipOutputStream;
import java.util.zip.ZipEntry;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.text.SimpleDateFormat;
import java.lang.Cloneable;

public class MainFrame extends JFrame {
	JPanel contentPane;
	BorderLayout contentPaneLayout = new BorderLayout();
	JPanel rightPanel = new JPanel();
	JPanel leftPanel = new JPanel();
	JPanel currentTagPanel = new JPanel();
	JPanel textPanel = new JPanel();
	BorderLayout leftPanelLayout = new BorderLayout();
	JEditorPane translatedTextEditor = new JEditorPane() {
		public boolean isManagingFocus() { return true; }
	};
	GridLayout textPanelLayout = new GridLayout();
	JTextArea greekTextEditor = new JTextArea() {
		public boolean isManagingFocus() { return true; }
	};
	JPanel signSavePanel = new JPanel();
	JPanel tagPanel = new JPanel();
	BorderLayout currentTagPanelLayout = new BorderLayout();
	JLabel currentTagLabel = new JLabel();
	GridLayout tagPanelLayout = new GridLayout();
	JTextField currentTagText = new JTextField();
	JPanel currentActionPanel = new JPanel();
	JLabel currentActionLabel = new JLabel();
	JLabel actionLabel = new JLabel();
	JButton signSaveButton = new JButton();
	JButton guessTagButton = new JButton();
	JPanel loginPanel = new JPanel();
	JLabel userIDLabel = new JLabel();
	JTextField userIDText = new JTextField();
	JButton loginButton = new JButton();
	JLabel loginStatusLabel = new JLabel();
	GridLayout loginPanelLayout = new GridLayout();
	BorderLayout rightPanelLayout = new BorderLayout();
	int currentCaret = -1;
	Object greekHighlight;

	/**Construct the frame*/
	public MainFrame() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try {
			jbInit();
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	private JEditorPane strongTextEditor = new JEditorPane();
	private TitledBorder translatedTextEditorBorder;
	private TitledBorder greekTextEditorBorder;
	private TitledBorder strongTextEditorBorder;
	private Hashtable tags = new Hashtable();
	private JScrollPane strongTextScroll = new JScrollPane();
	private JScrollPane translatedTextScroll = new JScrollPane();
	private JScrollPane greekTextScroll = new JScrollPane();
	private JPanel aPanel = new JPanel();
	private JPanel currentVersePanel = new JPanel();
	private BorderLayout aPanelLayout = new BorderLayout();
	private JLabel currentVerseLabel = new JLabel();
	private JTextField currentVerseText = new JTextField();
	private GridLayout currentVersePanelLayout = new GridLayout();
	private JButton loadVerseButton = new JButton();
	private TitledBorder currentVersePanelBorder;
	private TitledBorder loginPanelBorder;
	private JPanel bPanel = new JPanel();
	private JPanel strongPanel = new JPanel();
	private JTextField wordText = new JTextField();
	private GridLayout strongPanelLayout = new GridLayout();
	private JTextField morphText = new JTextField();
	private JTextField strongText = new JTextField();
	private BorderLayout bPanelLayout = new BorderLayout();
	private TitledBorder signSavePanelBorder;
	private JPanel cPanel = new JPanel();

	boolean localTR = false;
	boolean localKJV = false;
	boolean localThayer = false;
	boolean localImages = false;
	String util = "./modedit";

	static String startTag1  = "<a href=\"http://SID:";
	static String startTag2  = "\"><img border=0 src=\"http://www.crosswire.org/images/starttag";
	static String startTag3  = ".gif\"></a>";
	static String endTag1    = "<a href=\"http://EID:";
	static String endTag2    = "\"><img border=0 src=\"http://www.crosswire.org/images/endtag";
	static String endTag3    = ".gif\"></a>";

	private String userID = null;
	private String loginToken = null;

    private String proxyHost = null;
    private String proxyPort = null;
    private boolean useProxy = false;

	public String currentKey = null;
	private JPanel currentRangePanel = new JPanel();
	private JLabel currentRangeLabel = new JLabel();
	private JTextField rangeText = new JTextField();
	private GridLayout currentRangePanelLayout = new GridLayout();
	private BorderLayout cPanelLayout = new BorderLayout();
	private TitledBorder currentRangePanelBorder;
	private JButton exportRangeButton = new JButton();
	private TitledBorder leftPanelBorder;
	private JMenuBar jMenuBar1 = new JMenuBar();
	private JMenu jMenu1 = new JMenu();
	private JMenuItem jMenuItem1 = new JMenuItem();
	private JMenu jMenu2 = new JMenu();
	private JMenuItem jMenuItem2 = new JMenuItem();
	private JLabel jLabel1 = new JLabel();
	private JScrollPane jScrollPane1 = new JScrollPane();
	private JTextArea notesText = new JTextArea();
	private BorderLayout borderLayout1 = new BorderLayout();
	private JPanel jPanel1 = new JPanel();
	private BorderLayout borderLayout2 = new BorderLayout();
	private TitledBorder titledBorder1;
	private JMenu jMenu3 = new JMenu();
	private JMenuItem jMenuItem3 = new JMenuItem();
	private JPanel jPanel2 = new JPanel();
	private JButton jButton1 = new JButton();

	/**Component initialization*/
	private void jbInit() throws Exception  {
		//setIconImage(Toolkit.getDefaultToolkit().createImage(MainFrame.class.getResource("[Your Icon]")));
		contentPane = (JPanel) this.getContentPane();

		HTMLEditorKit htmlKit = new HTMLEditorKit();
		currentVersePanelBorder = new TitledBorder("");
		loginPanelBorder = new TitledBorder("");
		signSavePanelBorder = new TitledBorder("");
		currentRangePanelBorder = new TitledBorder("");
		leftPanelBorder = new TitledBorder("");
		titledBorder1 = new TitledBorder("");
		translatedTextEditor.setEditable(false);
		translatedTextEditor.setEditorKit(htmlKit);
		translatedTextEditor.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(KeyEvent e) {
				translatedTextEditor_keyPressed(e);
			}
		});

		HTMLEditorKit htmlKit3 = new HTMLEditorKit();
		strongTextEditor.setEditable(false);
		strongTextEditor.setEditorKit(htmlKit3);

		HTMLEditorKit htmlKit2 = new HTMLEditorKit();
		greekTextEditor.setLineWrap(true);
		greekTextEditor.setEditable(false);
		greekTextEditor.setWrapStyleWord(true);
		greekTextEditor.addKeyListener(new MainFrame_greekTextEditor_keyAdapter(this));
		greekTextEditor.addMouseListener(new MainFrame_greekTextEditor_mouseAdapter(this));
//		greekTextEditor.setEditorKit(htmlKit2);

		translatedTextEditorBorder = new TitledBorder("");
		greekTextEditorBorder = new TitledBorder("");
		strongTextEditorBorder = new TitledBorder("");
		translatedTextEditor.setFont(new java.awt.Font("Monospaced", 0, 14));
		translatedTextEditor.setBorder(translatedTextEditorBorder);
		translatedTextEditor.addKeyListener(new MainFrame_translatedTextEditor_keyAdapter(this));
		translatedTextEditor.addMouseMotionListener(new MainFrame_translatedTextEditor_mouseMotionAdapter(this));
		translatedTextEditor.addMouseListener(new MainFrame_translatedTextEditor_mouseAdapter(this));
		translatedTextEditor.addHyperlinkListener(new Hyperactive());
		HTMLDocument doc = (HTMLDocument)translatedTextEditor.getDocument();
		doc.setPreservesUnknownTags(true);

		contentPane.setLayout(contentPaneLayout);
		this.setJMenuBar(jMenuBar1);
		this.setSize(new Dimension(587, 564));
		this.setTitle("Module Editor");
		this.addKeyListener(new MainFrame_this_keyAdapter(this));
		leftPanel.setLayout(leftPanelLayout);
		textPanelLayout.setRows(3);
		textPanelLayout.setColumns(1);
		textPanel.setLayout(textPanelLayout);
		greekTextEditor.setBackground(Color.lightGray);
		greekTextEditor.setFont(new java.awt.Font("Dialog", 0, 18));
		greekTextEditor.setBorder(greekTextEditorBorder);
		currentTagPanel.setLayout(currentTagPanelLayout);
		currentTagLabel.setText("Current Tag");
		tagPanel.setLayout(tagPanelLayout);
		currentTagText.setText("0");
		currentActionLabel.setText("Current Action:");
		actionLabel.setText("[none]");
		signSaveButton.setText("Sign & Save");
		signSaveButton.addActionListener(new MainFrame_signSaveButton_actionAdapter(this));
		guessTagButton.setText("Guess at all tags");
		guessTagButton.addActionListener(new MainFrame_guessTagButton_actionAdapter(this));
		rightPanel.setLayout(rightPanelLayout);
		userIDLabel.setText("UserID");
		loginButton.setText("Login");
		loginButton.addActionListener(new MainFrame_loginButton_actionAdapter(this));
		loginStatusLabel.setBorder(BorderFactory.createLineBorder(Color.black));
		loginStatusLabel.setText("Not Logged In");
		loginPanel.setLayout(loginPanelLayout);
		strongTextEditor.setBackground(Color.lightGray);
		strongTextEditor.setBorder(strongTextEditorBorder);
		rightPanel.setBorder(BorderFactory.createEtchedBorder());
		loginPanel.setBorder(loginPanelBorder);
		greekTextScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		translatedTextScroll.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		aPanel.setLayout(aPanelLayout);
		currentVerseLabel.setText("Current Verse");
		currentVersePanel.setLayout(currentVersePanelLayout);
		currentVersePanelLayout.setColumns(1);
		currentVersePanelLayout.setRows(0);
		loadVerseButton.setText("Load");
		loadVerseButton.addActionListener(new MainFrame_loadVerseButton_actionAdapter(this));
		currentVersePanel.setBorder(currentVersePanelBorder);
		currentVerseText.addKeyListener(new MainFrame_currentVerseText_keyAdapter(this));
		strongPanel.setLayout(strongPanelLayout);
		strongPanelLayout.setColumns(1);
		strongPanelLayout.setRows(0);
		bPanel.setLayout(bPanelLayout);
		signSavePanel.setLayout(borderLayout1);
		signSavePanel.setBorder(signSavePanelBorder);
		contentPane.addKeyListener(new MainFrame_contentPane_keyAdapter(this));
		currentRangeLabel.setText("Current Range");
		currentRangePanel.setLayout(currentRangePanelLayout);
		cPanel.setLayout(cPanelLayout);
		currentRangePanelLayout.setColumns(1);
		currentRangePanelLayout.setRows(0);
		currentRangePanel.setBorder(currentRangePanelBorder);
		exportRangeButton.setText("Export");
		exportRangeButton.addActionListener(new MainFrame_exportRangeButton_actionAdapter(this));
		leftPanel.setBorder(leftPanelBorder);
		jMenu1.setText("File");
		jMenuItem1.setText("Exit");
		jMenuItem1.addActionListener(new MainFrame_jMenuItem1_actionAdapter(this));
		jMenu2.setText("Settings");
		jMenuItem2.setText("Proxy");
		jMenuItem2.addActionListener(new MainFrame_jMenuItem2_actionAdapter(this));
		jLabel1.setText("Notes");
		jPanel1.setLayout(borderLayout2);
		jPanel1.setBorder(titledBorder1);
		jMenu3.setText("Help");
		jMenuItem3.setText("Guidelines");
		jMenuItem3.addActionListener(new MainFrame_jMenuItem3_actionAdapter(this));
		jButton1.setText("Split");
		jButton1.addActionListener(new MainFrame_jButton1_actionAdapter(this));
		contentPane.add(rightPanel, BorderLayout.EAST);
		rightPanel.add(loginPanel, BorderLayout.NORTH);
		loginPanel.add(userIDLabel, null);
		loginPanel.add(userIDText, null);
		loginPanel.add(loginButton, null);
		loginPanel.add(loginStatusLabel, null);
		rightPanel.add(aPanel, BorderLayout.CENTER);
		aPanel.add(currentRangePanel, BorderLayout.NORTH);
		currentVersePanel.add(currentVerseLabel, null);
		currentVersePanel.add(currentVerseText, null);
		currentVersePanel.add(loadVerseButton, null);
		currentVersePanel.add(guessTagButton, null);
		aPanel.add(bPanel,  BorderLayout.CENTER);
		bPanel.add(signSavePanel,  BorderLayout.CENTER);
		strongPanel.add(wordText, null);
		strongPanel.add(strongText, null);
		strongPanel.add(morphText, null);
		currentTagPanel.add(jPanel2,  BorderLayout.EAST);
		jPanel2.add(jButton1, null);
		contentPane.add(leftPanel, BorderLayout.CENTER);
		leftPanel.add(currentTagPanel, BorderLayout.SOUTH);
		currentTagPanel.add(tagPanel, BorderLayout.WEST);
		tagPanelLayout.setRows(3);
		tagPanelLayout.setColumns(1);
		loginPanelLayout.setRows(4);
		loginPanelLayout.setColumns(1);
		tagPanel.add(currentTagLabel, null);
		tagPanel.add(currentTagText, null);
		tagPanel.add(currentActionPanel, null);
		currentActionPanel.add(currentActionLabel, null);
		currentActionPanel.add(actionLabel, null);
		currentTagPanel.add(strongPanel,  BorderLayout.CENTER);
		signSavePanel.add(signSaveButton,  BorderLayout.SOUTH);
		signSavePanel.add(jPanel1,  BorderLayout.CENTER);
		jPanel1.add(jLabel1, BorderLayout.NORTH);
		jPanel1.add(jScrollPane1, BorderLayout.CENTER);
		jScrollPane1.getViewport().add(notesText, null);
		bPanel.add(cPanel, BorderLayout.NORTH);
		cPanel.add(currentVersePanel, BorderLayout.NORTH);
		currentRangePanel.add(currentRangeLabel, null);
		currentRangePanel.add(rangeText, null);
		currentRangePanel.add(exportRangeButton, null);
		leftPanel.add(textPanel, BorderLayout.CENTER);
		textPanel.add(translatedTextScroll, null);
		translatedTextScroll.getViewport().add(translatedTextEditor, null);
		textPanel.add(greekTextScroll, null);
		greekTextScroll.getViewport().add(greekTextEditor, null);
		textPanel.add(strongTextScroll, null);
		strongTextScroll.getViewport().add(strongTextEditor, null);
		jMenuBar1.add(jMenu1);
		jMenuBar1.add(jMenu2);
		jMenuBar1.add(jMenu3);
		jMenu1.add(jMenuItem1);
		jMenu2.add(jMenuItem2);
		jMenu3.add(jMenuItem3);

		Highlighter h = greekTextEditor.getHighlighter();
		DefaultHighlighter.DefaultHighlightPainter hp = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
		greekHighlight = h.addHighlight(0, 0, hp);

		loadPreferences();
	}


	protected void finalize() throws Throwable {
		super.finalize();
	}


	/**Overridden so we can exit when window is closed*/
	protected void processWindowEvent(WindowEvent e) {
		super.processWindowEvent(e);
		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			savePreferences();
			System.exit(0);
		}
	}

	void signSaveButton_actionPerformed(ActionEvent e) {

		// assert we are ok to save something
		if (currentKey == null) {
			JOptionPane.showMessageDialog(this, "No key selected");
			return;
		}
		if (getUserID() == null) {
			JOptionPane.showMessageDialog(this, "Not logged in");
			return;
		}

		String entry = getRawEntry();
		StringBuffer result = new StringBuffer();
		if (!localKJV)
			callServer("action=w&key=" + URLEncoder.encode(currentKey) +"&uid=" + userID + "&ltok=" + loginToken + "&mod=KJV2003&text=" + URLEncoder.encode(entry), result);
		else	{
			try {
				FileOutputStream fos = new FileOutputStream("entry.txt");
				fos.write(entry.getBytes());
				fos.close();
				callLocalAgent(new String[] {util, "f", "KJV2003", currentKey, "entry.txt"}, result, false);
			}
			catch (Exception e1) { e1.printStackTrace(); }
		}

		if (result.length() > 1) {
			stripChar(result, '\n');
			stripChar(result, '\r');
			loadVerse(result.toString());
		}
		else {
			// failed
			login(null);
			JOptionPane.showMessageDialog(this, "Unable to save edits to the server, try to re-login.");
		}
	}


	void loadPreferences() {
		Properties props = new Properties();

		try {
			props.load(new FileInputStream("ModEdit.properties"));
		}
		catch (Exception e) {e.printStackTrace();}

		localKJV = props.getProperty("localKJV", "false").equalsIgnoreCase("true");
		localTR = props.getProperty("localTR", "false").equalsIgnoreCase("true");
		localThayer = props.getProperty("localThayer", "false").equalsIgnoreCase("true");
		localImages = props.getProperty("localImages", "false").equalsIgnoreCase("true");

		if (localImages) {
			startTag2  = "\"><img border=0 src=\"file:images/starttag";
			endTag2    = "\"><img border=0 src=\"file:images/endtag";
		}

		rangeText.setText(props.getProperty("currentRange", "jn"));
		userIDText.setText(props.getProperty("userID", ""));

		useProxy = (props.getProperty("useProxy", "false").equals("true"));
		proxyHost = props.getProperty("proxyHost", "[none]");
		proxyPort = props.getProperty("proxyPort", "8080");

		loadVerse(props.getProperty("lastVerse", "jn 1:1"));
		if (!localKJV)
			exportRangeButton.setVisible(false);
	}

	void savePreferences() {
		Properties props = new Properties();
		props.setProperty("localKJV", (localKJV) ? "true" : "false");
		props.setProperty("localTR", (localTR) ? "true" : "false");
		props.setProperty("localThayer", (localThayer) ? "true" : "false");
		props.setProperty("localImages", (localImages) ? "true" : "false");
		props.setProperty("currentRange", rangeText.getText());
		props.setProperty("userID", userIDText.getText());
		props.setProperty("lastVerse", currentKey);
		props.setProperty("proxyHost", proxyHost);
		props.setProperty("proxyPort", proxyPort);
		props.setProperty("useProxy", (useProxy) ? "true" : "false");
		try {
			props.store(new FileOutputStream("ModEdit.properties"), "ModEdit Properties");
		}
		catch (Exception e) { e.printStackTrace(); }

	}

	void loadTextArea(JTextArea control, StringBuffer agentResult) {
		try {
			StringBuffer newText = agentResult;
			stripTags(newText);
			int pos = newText.toString().indexOf('|');
			if (pos > -1) {
				newText.delete(0,pos+1);
			}
			control.setText(newText.toString());
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	void loadHTML(JEditorPane control, StringBuffer agentResult) {
		try {
			StringBuffer newText = agentResult;
			String htmlstr = newText.toString();
			int pos = newText.toString().indexOf('|');
			if (pos > -1) {
				newText.delete(0,pos+1);
			}
			htmlstr = newText.toString();
			newText.insert(0, "<html>");
			int tagPos = newText.toString().indexOf("<br />");
			while (tagPos > -1) {
				int endPos = newText.toString().indexOf('>', tagPos+1);
				newText.delete(tagPos, endPos+1);
				if (tagPos < newText.length())
					newText.insert(tagPos, "<br>");
				tagPos = newText.toString().indexOf("<br />");
			}
			htmlstr = newText.toString();
			setHTML(control, newText);
			control.setCaretPosition(0);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public int callLocalAgent(String command[], StringBuffer result, boolean html) {
		int retVal = -1;
		try {
	//result.write("running command:");
	//for (int i = 0; i < command.length; i++)
	//      result.write("["+command[i]+"]");
	//result.flush();
	//return 0;
			java.lang.Process p = Runtime.getRuntime().exec(command);

			InputStream is = p.getInputStream();
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			BufferedInputStream bis = new BufferedInputStream(is);

			int len;
			byte inBuf[] = new byte[8192];
			do {
				len = bis.read(inBuf, 0, 8192);
				if (len != -1)
					bos.write(inBuf, 0, len);
			} while (len != -1);
			StringBuffer newText = new StringBuffer(new String(bos.toByteArray(), "UTF-8"));
			result.append(newText.toString());

			// silly replacement for DOS nl encoding
			StringBuffer crlf = new StringBuffer("  ");
			crlf.setCharAt(0, (char)13);
			crlf.setCharAt(1, (char)10);
			StringBuffer lf = new StringBuffer(" ");
			lf.setCharAt(0, (char)10);
			replaceString(result, crlf.toString(), lf.toString());
			replaceString(result, "\n", (html) ? "<br>": "\n ");

			retVal = p.waitFor();
		}
		catch (Exception e) {e.printStackTrace();}
		return retVal;
	}

	int callServer(String command, StringBuffer result) {
		try {
			String lookupURL = "http://www.crosswire.org/sword/kjv2003/modedit.jsp?" + command;
			URLConnection connection = new URL(lookupURL).openConnection();
			InputStream is = connection.getInputStream();
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			BufferedInputStream bis = new BufferedInputStream(is);

			int len;
			byte inBuf[] = new byte[8192];
			do {
				len = bis.read(inBuf, 0, 8192);
				if (len != -1)
					bos.write(inBuf, 0, len);
			} while (len != -1);
			StringBuffer newText = new StringBuffer(new String(bos.toByteArray(), "UTF-8"));
			result.append(newText.toString());
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		return 0;
	}


	public void exportRange(String key, String fileName) {
		try {
			StringBuffer agentResult = new StringBuffer();
			callLocalAgent(new String[] {util, "e", "KJV2003", key}, agentResult, false);
			ZipOutputStream zstream = new ZipOutputStream(new FileOutputStream(fileName));
			zstream.putNextEntry(new ZipEntry("key"));
			zstream.write(key.getBytes());
			zstream.putNextEntry(new ZipEntry("nt"));
			copyFile(zstream, "nt");
			zstream.putNextEntry(new ZipEntry("nt.vss"));
			copyFile(zstream, "nt.vss");
			zstream.close();
		}
		catch (Exception e) { e.printStackTrace(); }
	}


	void copyFile(OutputStream os, String fileName) {
		try {
			FileInputStream fin = new FileInputStream(fileName);
			byte [] buffer = new byte[ 20000 ];
			int len;
			while ((len = fin.read(buffer)) > 0) {
				os.write(buffer, 0, len);
			}
			fin.close();
		}
		catch (Exception e) { e.printStackTrace(); }
	}



	void showStrongs() {
		TagInfo tagInfo = (TagInfo)tags.get(Integer.toString(getCurrentTag()));
		if (tagInfo == null)
			return;
		try {
			StringBuffer agentResult = new StringBuffer();
			if (tagInfo.thayerCache.length() < 1) {
				if (!localThayer)
					callServer("action=h&mod=Thayer&key="+tagInfo.strong, agentResult);
				else callLocalAgent(new String[] {util, "h", "Thayer", tagInfo.strong}, agentResult, true);
				tagInfo.thayerCache = agentResult.toString();
			}
			agentResult = new StringBuffer(tagInfo.thayerCache);
			loadHTML(strongTextEditor, agentResult);
		} catch (Throwable t) {
			t.printStackTrace();
		}
		strongText.setText(tagInfo.strong);
		morphText.setText(tagInfo.morph);
		wordText.setText(tagInfo.word);

		try {
			greekTextEditor.getHighlighter().changeHighlight(greekHighlight, tagInfo.start, tagInfo.end);
		}
		catch (Exception e) { e.printStackTrace(); }
	}

	class Hyperactive implements HyperlinkListener {

		public void hyperlinkUpdate(HyperlinkEvent e) {
			if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
				JEditorPane pane = (JEditorPane) e.getSource();
				try {
					String url = e.getURL().toString();
					int id = e.getURL().getPort();
					if (url.indexOf("SID") > -1) {
						setCurrentAction(id, "MoveTag");
					}
					else if (url.indexOf("EID") > -1) {
						setCurrentAction(id, "SizeTag");
					}
					else	{
						setCurrentAction(id, "[none]");
					}
				} catch (Throwable t) {
					t.printStackTrace();
				}
			}
		}
	}

	void translatedTextEditor_mouseClicked(MouseEvent e) {
	}

	void translatedTextEditor_mouseDragged(MouseEvent e) {
		Point clickPoint = e.getPoint();
		int position = translatedTextEditor.viewToModel(clickPoint);
		boolean sizeTag = false;
		if (!getCurrentAction().equals("[none]")) {
			if (getCurrentAction().equals("SizeTag"))
				sizeTag = true;
			if (position != currentCaret) {
				currentCaret = position;
				moveTag(getCurrentTag(), position, sizeTag);
			}
		}

	}


	void stripChar(StringBuffer buf, char ch) {
		// remove silly new lines added by editor kit
		// better way?
		int pos = buf.toString().indexOf(ch);
		while (pos > -1) {
			buf.deleteCharAt(pos);
			pos = buf.toString().indexOf(ch);
		}
	}


	void replaceString(StringBuffer buf, String ch, String r) {
		int pos = buf.toString().indexOf(ch);
		while (pos > -1) {
			buf.replace(pos, pos+ch.length(), r);
			pos = buf.toString().indexOf(ch, pos+1);
		}
	}

	void replaceChar(StringBuffer buf, char ch, char r) {
		int pos = buf.toString().indexOf(ch);
		while (pos > -1) {
			buf.setCharAt(pos, r);
			pos = buf.toString().indexOf(ch);
		}
	}

	void stripJunk(StringBuffer html) {
		// remove silly new lines added by editor kit
		// better way?
		int pos = html.toString().indexOf('\n');
		while (pos > -1) {
			html.deleteCharAt(pos);
			while (pos < html.length()) {
				if (html.charAt(pos) == ' ')
					html.deleteCharAt(pos);
				else break;
			}
			pos = html.toString().indexOf('\n');
		}
	}


	StringBuffer getHTML(JEditorPane editor) {
		HTMLDocument doc = (HTMLDocument)editor.getDocument();
		StringWriter writer = new StringWriter();
		try {
			editor.getEditorKit().write(writer, doc, 0, doc.getLength());
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}

		StringBuffer html = writer.getBuffer();
		replaceString(html, "&#8217;", "'");

		// remove silly new lines added by editor kit
		stripJunk(html);

		return html;
	}

	void setHTML(JEditorPane editor, StringBuffer html) {
		HTMLDocument doc = (HTMLDocument)editor.getDocument();
		try {
			editor.setText("");
			editor.getEditorKit().read(new StringReader(html.toString()), doc, 0);
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}
	}

	void slideTag(int offset, boolean sizeTag) {
		slideTag(getCurrentTag(), offset, sizeTag, "y", "y");
	}


	String getStartTag(TagInfo tag, String color) {
		return startTag1 + tag.id + startTag2 + color + tag.type + startTag3;
	}

	String getEndTag(TagInfo tag, String color) {
		return endTag1 + tag.id + endTag2 + color + tag.type + endTag3;
	}


	void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor) {
		slideTag(tagNum, offset, sizeTag, startColor, endColor, false);
	}

	void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor, boolean delete) {
		slideTag(tagNum, offset, sizeTag, startColor, endColor, delete, -1);
	}

	void slideTag(int tagNum, int offset, boolean sizeTag, String startColor, String endColor, boolean delete, int addSplitID) {

		TagInfo tagInfo = (TagInfo)tags.get(Integer.toString(tagNum));

		// assert we have a valid tag
		if (tagInfo == null)
			return;

		String startTag = (delete) ? "" : getStartTag(tagInfo, startColor);
		String endTag = (delete) ? "" : getEndTag(tagInfo, endColor);
		if (addSplitID > -1) {
			TagInfo splitInfo = (TagInfo)tags.get(Integer.toString(addSplitID));
			endTag += getStartTag(splitInfo, "r") + getEndTag(splitInfo, "r");
		}
		String startSearch = startTag1+Integer.toString(tagNum)+"\">";
		String endSearch = endTag1+Integer.toString(tagNum)+"\">";

		boolean addNewImage = false;

		StringBuffer html = getHTML(translatedTextEditor);
		String htmlstr = html.toString();

		int tagStart = html.toString().indexOf(startSearch);
		int endStart = html.toString().indexOf(endSearch);

		// remove current images
		if (!sizeTag) {
			if (tagStart >= 0) {
				addNewImage = true;
				int end = html.toString().indexOf('>', tagStart+1);
				end = html.toString().indexOf('>', end+1);
				end = html.toString().indexOf('>', end+1);
				if (offset != 0)
					html.replace(tagStart, end+1, "$$$");
				else {
					html.replace(tagStart, end+1, startTag);
				}
			}
			else addNewImage = false;
		}

		htmlstr = html.toString();
		// recompute
		endStart = html.toString().indexOf(endSearch);

		if (addNewImage || (sizeTag)) {
			if (endStart >= 0) {
				int end = html.toString().indexOf('>', endStart+1);
				end = html.toString().indexOf('>', end+1);
				end = html.toString().indexOf('>', end+1);
				if (addNewImage) {
					if (offset != 0)
						html.delete(endStart, end+1);
					else html.replace(endStart, end+1, endTag);
				}
				else html.replace(endStart, end+1, "$$$");
				addNewImage = true;
			}
			else addNewImage = false;
		}

		htmlstr = html.toString();
		// recompute
		int targetStart = html.toString().indexOf("$$$");
		while (offset != 0 && targetStart > -1) {
			if (offset > 0) {
				if (targetStart+3 < html.length()) {
					char moveChar = html.charAt(targetStart+3);
					if ((moveChar != '<') && (moveChar != '{')) {
						html.deleteCharAt(targetStart+3);
						html.insert(targetStart, moveChar);
					}
					else if (sizeTag)
						break;
					else if (moveChar == '<') {
						String tagKey = null;
						int pos = html.toString().indexOf(startTag1, targetStart);
						// if we're another tag jump over
						if (pos == targetStart+3) {
							int end = html.toString().indexOf('\"', pos+startTag1.length());
							if (end > -1) {
								tagKey = html.substring(pos+startTag1.length(), end);
								pos = html.toString().indexOf(endTag1+tagKey+"\"", pos);
								if (pos > -1) {
									end = html.toString().indexOf('>', pos);
									end = html.toString().indexOf('>', end+1);
									end = html.toString().indexOf('>', end+1);
									if (++end < html.length()) {
										html.insert(end, "$$$");
										html.delete(targetStart, targetStart+3);
									}
								}
							}
						}
					}
					else if (moveChar == '{') {
						int end = html.toString().indexOf('}', targetStart+3);
						if (++end < html.length()) {
							html.insert(end, "$$$");
							html.delete(targetStart, targetStart+3);
						}
					}
				}
				else break;
				offset--;
			}
			if (offset < 0) {
				if (targetStart-1 >= 0) {
					char moveChar = html.charAt(targetStart-1);
					if ((moveChar != '>') && (moveChar != '}')) {
						html.deleteCharAt(targetStart-1);
						html.insert(targetStart+2, moveChar);
					}
					else if (sizeTag)
						break;
					else if (moveChar == '>') {
						String tagKey = null;
						int end;
						int pos = html.toString().lastIndexOf(endTag1, targetStart);
						if (pos > -1) {
							end = html.toString().indexOf('>', pos);
							end = html.toString().indexOf('>', end+1);
							end = html.toString().indexOf('>', end+1);
							// if we're another tag jump over
							if (end == targetStart-1) {
								end = html.toString().indexOf('\"', pos+endTag1.length());
								if (end > -1) {
									tagKey = html.substring(pos+startTag1.length(), end);
									pos = html.toString().lastIndexOf(startTag1+tagKey+"\"", pos);
									if (pos > -1) {
										html.delete(targetStart, targetStart+3);
										html.insert(pos, "$$$");
									}
								}
							}
						}
					}
					else if (moveChar == '}') {
						int pos = html.toString().lastIndexOf('{', targetStart);
						if (pos > -1) {
							html.delete(targetStart, targetStart+3);
							html.insert(pos, "$$$");
						}
					}
				}
				else break;
				offset++;
			}
		}

		htmlstr = html.toString();

		// replace place holder with image tag
		targetStart = html.toString().indexOf("$$$");
		if (targetStart >= 0) {
			if (addNewImage)
				html.replace(targetStart, targetStart+3, (sizeTag) ? endTag:startTag+endTag);
			else	html.delete(targetStart, targetStart+3);
		}
		htmlstr = html.toString();
		setHTML(translatedTextEditor, html);
	} //end of slideTag


	int getTagFromPosition(int offset) {

		int position = offset;
		int retVal = 0;

		//remove selection
		translatedTextEditor.setSelectionEnd(translatedTextEditor.getSelectionStart());

		if (position != currentCaret) {
			currentCaret = position;

			String startSearch = startTag1;
			String endSearch = endTag1;

			HTMLDocument doc = (HTMLDocument)translatedTextEditor.getDocument();
			try {
				translatedTextEditor.getEditorKit().read(new StringReader("$$$"), doc, position);
			}
			catch(Exception ex) {
				ex.printStackTrace();
			}

			StringBuffer html = getHTML(translatedTextEditor);

			String htmlstr = html.toString();

			int targetStart = html.toString().indexOf("$$$");

			if (targetStart > -1) {	// better be
				html.delete(targetStart, targetStart + 3);
			}


			int endStart = html.toString().indexOf(endSearch, targetStart);
			int tagStart = html.toString().indexOf(startSearch, targetStart);

			if (endStart < tagStart) {
				int begin = endStart+endSearch.length();
				int end = html.toString().indexOf('\"', begin);
				if (end > endStart) {
					String tagNum = html.substring(begin, end);
					retVal = Integer.parseInt(tagNum);
				}
			}
			setHTML(translatedTextEditor, html);
		}
		return retVal;
	}

	void moveTag(int tagNum, int position, boolean sizeTag) {

		//remove selection
		translatedTextEditor.setSelectionEnd(translatedTextEditor.getSelectionStart());

		TagInfo tagInfo = (TagInfo)tags.get(Integer.toString(tagNum));

		String startTag = getStartTag(tagInfo, "y");
		String endTag = getEndTag(tagInfo, "y");
		String startSearch = startTag1+Integer.toString(tagNum)+"\">";
		String endSearch = endTag1+Integer.toString(tagNum)+"\">";

		boolean addNewImage = false;

		HTMLDocument doc = (HTMLDocument)translatedTextEditor.getDocument();
		try {
			translatedTextEditor.getEditorKit().read(new StringReader("$$$"), doc, position);
		}
		catch(Exception ex) {
			ex.printStackTrace();
		}

		StringBuffer html = getHTML(translatedTextEditor);
		String htmlstr = html.toString();

		int targetStart = html.toString().indexOf("$$$");
		int tagStart = html.toString().indexOf(startSearch);
		int endStart = html.toString().indexOf(endSearch);
		boolean beforeStart = false;
		if (targetStart < tagStart)
			beforeStart = true;

		// remove current images
		if (!sizeTag) {
			if (tagStart >= 0) {
				addNewImage = true;
				int end = html.toString().indexOf('>', tagStart+1);
				end = html.toString().indexOf('>', end+1);
				end = html.toString().indexOf('>', end+1);
				html.delete(tagStart, end+1);
			}
			else addNewImage = false;
		}

		// recompute
		endStart = html.toString().indexOf(endSearch);

		if (addNewImage || (sizeTag && !beforeStart)) {
			if (endStart >= 0) {
				addNewImage = true;
				int end = html.toString().indexOf('>', endStart+1);
				end = html.toString().indexOf('>', end+1);
				end = html.toString().indexOf('>', end+1);
				html.delete(endStart, end+1);
			}
			else addNewImage = false;
		}

		// recompute
		targetStart = html.toString().indexOf("$$$");

		htmlstr = html.toString();

		// replace place holder with image tag
		if (targetStart >= 0) {
			if (addNewImage)
				html.replace(targetStart, targetStart+3, (sizeTag) ? endTag:startTag+endTag);
			else	html.delete(targetStart, targetStart+3);
		}
		htmlstr = html.toString();
		setHTML(translatedTextEditor, html);
	}


	void translatedTextEditor_keyTyped(KeyEvent e) {
	}


	void setCurrentAction(int tag, String action) {
		int lastTag = getCurrentTag();
		boolean changedTag = false;

		// Set last tag to green
		if (lastTag != tag) {
			changedTag = true;
			slideTag(getCurrentTag(), 0, false, "g", "g");
			slideTag(tag, 0, false, "y", "y");
		}

		currentTagText.setText(Integer.toString(tag));

		if ((!getCurrentAction().equals("MoveTag") || changedTag) && (action.equals("MoveTag"))) {
			slideTag(getCurrentTag(), 0, false, "y", "y");
		}
		else if ((!getCurrentAction().equals("SizeTag") || changedTag) && (action.equals("SizeTag"))) {
			slideTag(getCurrentTag(), 0, false, "g", "y");
		}
		else if ((!getCurrentAction().equals("[none]") || changedTag) && (action.equals("[none]"))) {
			slideTag(getCurrentTag(), 0, false, "g", "g");
		}
		actionLabel.setText(action);
		if (changedTag) {
			showStrongs();
		}
	}


	public String getCurrentAction() {
		return actionLabel.getText();
	}


	public int getCurrentTag() {
		return Integer.parseInt(currentTagText.getText());
	}


	void translatedTextEditor_keyPressed(KeyEvent e) {
		handleKeyboard(e);
	}


	void handleKeyboard(KeyEvent e) {


		boolean sizeTag = true;
		if (getCurrentAction().equals("MoveTag"))
			sizeTag = false;

		if (!getCurrentAction().equals("[none]")) {
			if (e.getKeyCode() == e.VK_LEFT) {
				slideTag(-1, sizeTag);
			}
			else if (e.getKeyCode() == e.VK_RIGHT) {
				slideTag(1, sizeTag);
			}
		}
		if (e.getKeyCode() == e.VK_TAB) {
			if (e.isShiftDown())
				previousTag();
			else nextTag();
		}
		else if (e.getKeyCode() == e.VK_UP) {
			previousTag();
		}
		else if (e.getKeyCode() == e.VK_DOWN) {
			nextTag();
		}
		else if (e.getKeyCode() == e.VK_SPACE) {
			if (getCurrentAction().equals("MoveTag"))
				setCurrentAction(getCurrentTag(), "SizeTag");
			else if (getCurrentAction().equals("SizeTag")) {
				setCurrentAction(getCurrentTag(), "[none]");
			}
			else if (getCurrentAction().equals("[none]")) {
				setCurrentAction(getCurrentTag(), "MoveTag");
			}
		}
	}


	public void loadStrongsTable(String key) {
		try {
			StringBuffer text = new StringBuffer();

			if (!localTR)
				callServer("action=a&key=" + URLEncoder.encode(key) +"&mod=TR", text);
			else callLocalAgent(new String[] {util, "a", "TR", key}, text, false);

			BufferedReader br = new BufferedReader(new StringReader(text.toString()));
			String line;
			tags = new Hashtable();
			while ((line = br.readLine()) != null) {
				String [] entry = new String[4];
				int pos = line.indexOf('|');
				int start = 0;
				int type = 0;
				while (pos > -1) {
					StringBuffer sb = new StringBuffer(line.substring(start, pos));
					stripTags(sb);
					entry[type] = sb.toString().trim();
					type++;
					start = pos + 1;
					pos = line.indexOf('|', start);
				}
				StringBuffer sb = new StringBuffer(line.substring(start, line.length()));
				stripTags(sb);
				entry[type] = sb.toString().trim();
				if (type < 2)
					continue;
				entry[1] = new Integer(entry[1]).toString();	// strip preceeding 000..
				if (entry[0].equals("Word")) {
					TagInfo tag = (TagInfo)tags.get(entry[1]);
					if (tag == null) {
						tag = new TagInfo(entry[1]);
						tags.put(entry[1], tag);
					}
					if (entry[2].equals("Morph")) {
						tag.morph = entry[3];
						if (tag.morph.startsWith("V"))
						    tag.type = "verb";
					}
					if (entry[2].equals("MorphClass")) {
						tag.morphClass = entry[3];
					}
					if (entry[2].equals("Strongs")) {
						tag.strong = entry[3].substring(1, entry[3].length());
						if (tag.strong.equals("3588"))
							tag.type = "art";
					}
					if (entry[2].equals("Text")) {
						tag.word = entry[3];
					}
				}
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}


	public void loadTranslationFrequencies(TagInfo tag) {
		try {
			StringBuffer text = new StringBuffer();

			if (!localThayer)
				callServer("action=a&key=" + URLEncoder.encode(tag.strong) +"&mod=Thayer", text);
			else	callLocalAgent(new String[] {util, "a", "Thayer", tag.strong}, text, false);

			BufferedReader br = new BufferedReader(new StringReader(text.toString()));
			String line;

			tag.translations = new Hashtable();

			while ((line = br.readLine()) != null) {
				try {
					String [] entry = new String[4];
					int pos = line.indexOf('|');
					int start = 0;
					int type = 0;
					while (pos > -1) {
						StringBuffer sb = new StringBuffer(line.substring(start, pos));
						stripTags(sb);
						entry[type] = sb.toString().trim();
						type++;
						start = pos + 1;
						pos = line.indexOf('|', start);
					}
					StringBuffer sb = new StringBuffer(line.substring(start, line.length()));
					stripTags(sb);
					entry[type] = sb.toString().trim();
					if (type < 2)
						continue;
					entry[1] = new Integer(entry[1]).toString();	// strip preceeding 000..
					if (entry[0].equals("AVPhrase")) {
						TransInfo trans = (TransInfo)tag.translations.get(entry[1]);
						if (trans == null) {
							trans = new TransInfo(entry[1]);
							tag.translations.put(entry[1], trans);
						}
						if (entry[2].equals("Phrase")) {
							trans.english = entry[3];
						}
						if (entry[2].equals("Alt")) {
							trans.english2 = entry[3];
						}
						if (entry[2].equals("CompoundedWith")) {
							trans.compoundedWith = entry[3];
						}
						if (entry[2].equals("Frequency")) {
							trans.frequency = Integer.parseInt(entry[3]);
						}
					}
				}
				catch (Exception e1) { e1.printStackTrace(); }
			}
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}


	public void computeTagOffsets() {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		String greek = greekTextEditor.getText();
		int pos = 0;
		for (int i = 0; i < tagKeys.length; i++) {
			TagInfo tag = (TagInfo)tags.get(tagKeys[i]);
			int start = greek.indexOf(tag.word, pos);
			if (start > -1) {
				tag.start = start;
				tag.end = start + tag.word.length();
				pos = tag.end;
			}
		}
	}


	public void confirmAllStrongs(StringBuffer text) {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		for (int i = 0; i < tagKeys.length; i ++) {
			// look for tag already in text
			TagInfo tagInfo = (TagInfo)tags.get(tagKeys[i]);
			boolean found = false;
			int pos = text.toString().indexOf("<w_src=\""+tagKeys[i]+"\"");
			boolean splitHandled = false;
			while (pos > -1) {
				tagInfo = (TagInfo)tags.get(tagKeys[i]);
				int end = text.toString().indexOf(">", pos);
				if (end > -1) {
					// check if we're a split tag
					String tagText = text.substring(pos, end+1);
					int split = tagText.indexOf("splitID=\"");
					if (split > -1) {
//						int sEnd = tagText.indexOf("\"", split+9);
//						if (sEnd > -1) {
//							String splitKey = tagText.substring(split+9, sEnd);
							// only allow one split
							if (!splitHandled) {
								tagInfo = addSplitTag(Integer.parseInt(tagInfo.id), false);
								int pos1 = text.toString().indexOf("\"", pos+1);
								int end1 = text.toString().indexOf("\"", pos1+1);
								text.replace(pos1+1, end1, tagInfo.id);
								splitHandled = true;
							}
//						}
					}
					int endWord = text.toString().indexOf("</w>", end);
					// recompute end in case we are different size e.g. "4" -> "26"
					end = text.toString().indexOf(">", pos);
					if (endWord > -1) {
						text.replace(endWord, endWord+4, getEndTag(tagInfo, "r"));
						text.replace(pos, end+1, getStartTag(tagInfo, "r"));
						found = true;
					}
				}
				pos = text.toString().indexOf("<w_src=\""+tagKeys[i]+"\"", pos+1);
			}
			if (!found) {
				text.append(getStartTag(tagInfo, "r"));
				text.append(getEndTag(tagInfo, "r"));
			}
		}
	}


	public void loadVerse(String key) {
		try {
			StringBuffer text = new StringBuffer();

			if (!localKJV)
				callServer("action=r&key=" + URLEncoder.encode(key) +"&mod=KJV2003", text);
			else callLocalAgent(new String[] {util, "r", "KJV2003", key}, text, false);
			String htmlstr = text.toString();

			stripChar(text, '\n');
			stripChar(text, '\r');
			if (text.charAt(text.length()-1) == ' ')
				text.setLength(text.length()-1);	// trip trailing space from return
			htmlstr = text.toString();
			// grab key from front
			int pos = text.toString().indexOf('|');
			if (pos > -1) {
				key = text.substring(0, pos);
				text.delete(0,pos+1);
			}

			// grab any note tags
			notesText.setText("");
			pos = text.toString().indexOf("<note type=\"strongsMarkup\"");
			while (pos > -1) {
				int end = text.toString().indexOf('>', pos+1);
				if (end > -1)
					text.delete(pos, end+1);
				end = text.toString().indexOf("</note>", pos);
				if (end > -1) {
					String note = text.substring(pos, end);
					note = URLDecoder.decode(note);
					notesText.setText(notesText.getText() + note);
					text.delete(pos, end+7);
				}
				pos = text.toString().indexOf("<resp ");
			}
			// remove all resp tags for now
			pos = text.toString().indexOf("<resp ");
			while (pos > -1) {
				int end = text.toString().indexOf('>', pos+1);
				if (end > -1)
					text.delete(pos, end+1);
				pos = text.toString().indexOf("<resp ");
			}

			htmlstr = text.toString();
			replaceChar(text, ' ', '_');
			htmlstr = text.toString();
			loadStrongsTable(key);

			StringBuffer agentResult = new StringBuffer();
			if (!localTR)
				callServer("action=h&key=" + URLEncoder.encode(key) +"&mod=TR", agentResult);
			else callLocalAgent(new String[] {util, "h", "TR", key}, agentResult, true);
			loadTextArea(greekTextEditor, agentResult);

			computeTagOffsets();

			text.insert(0, "<HTML><BODY>");

			confirmAllStrongs(text);

			htmlstr = text.toString();

			text.append("</BODY></HTML>");
			setHTML(translatedTextEditor, text);
			translatedTextEditor.setCaretPosition(0);
			currentKey = key;
			currentVerseText.setText(currentKey);
			setCurrentAction(0, "[none]");
		}
		catch(Exception e) {
			e.printStackTrace();
		}
	}

	public void replaceTagsWithHolders(StringBuffer newText) {
		String startSearch = startTag1;
		String endSearch = endTag1;
		int tagPos = newText.toString().indexOf(endSearch);
		while (tagPos > -1) {
			int endPos = newText.toString().indexOf('>', tagPos+endSearch.length()+1);
			newText.delete(tagPos, endPos+1);
			newText.insert(tagPos, '|');
			tagPos = newText.toString().indexOf(endSearch);
		}
		tagPos = newText.toString().indexOf(startSearch);
		while (tagPos > -1) {
			int endPos = newText.toString().indexOf('>', tagPos+startSearch.length()+1);
			newText.delete(tagPos, endPos+1);
			newText.insert(tagPos, '|');
			tagPos = newText.toString().indexOf(startSearch);
		}
	}

	void stripTags(StringBuffer newText) {
		int tagPos = newText.toString().indexOf('<');
		while (tagPos > -1) {
		int endPos = newText.toString().indexOf('>', tagPos+1);
		newText.delete(tagPos, endPos+1);
		if (tagPos < newText.length())
			newText.insert(tagPos, ' ');
		tagPos = newText.toString().indexOf('<');
		}
	}

	void loadVerseButton_actionPerformed(ActionEvent e) {
		loadVerse(currentVerseText.getText());
	}

	void currentVerseText_keyTyped(KeyEvent e) {
	}

	void this_keyPressed(KeyEvent e) {
		if (e.getKeyCode() == e.VK_ENTER) {
			loadVerse(currentVerseText.getText());
		}
		else if (e.getKeyCode() == e.VK_TAB) {
			nextTag();
		}
	}

	void guessTagButton_actionPerformed(ActionEvent e) {
		guessTagPositions();
	}

	public void guessTagPositions() {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		for (int i = 0; i < tagKeys.length; i++) {
			moveTag(Integer.parseInt((String)tagKeys[i]), 1, false);
		}
		for (int i = 0; i < tagKeys.length; i++) {
			TagInfo tagInfo = (TagInfo)tags.get(tagKeys[i]);

			// ignore definite article for now
			if (tagInfo.strong.equals("3588"))
				continue;

			String text = translatedTextEditor.getText();
			StringBuffer sb = new StringBuffer(text);
			replaceTagsWithHolders(sb);
			stripTags(sb);
			stripJunk(sb);
			stripChar(sb, ' ');
			replaceChar(sb, '_', ' ');
			text = sb.toString().trim().toUpperCase();

			loadTranslationFrequencies(tagInfo);
			Object [] transKeys = tagInfo.translations.keySet().toArray();
			java.util.Arrays.sort(transKeys, new Comparator() {
					public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
				});
			TransInfo best = null;
			for (int j = 0; j < transKeys.length; j++) {
				TransInfo ti = (TransInfo)tagInfo.translations.get(transKeys[j]);

				// skip CompoundedWith, for now. works a little better.
				if (ti.compoundedWith != null)
					continue;

				// twice, once for english and once for english2
				for (int k = 0; k < 2; k++) {
					String english = (k > 0) ? ti.english2 : ti.english;

					if (english == null)
						continue;

					english = english.toUpperCase();

					// be sure to skip 'misc' entries
					if (english.equalsIgnoreCase("MISC"))
						continue;

					int attempt = text.indexOf(english);
					while (attempt > -1) {
						if (getTagFromPosition(attempt+1) == 0) { // FOUND
							if (attempt > 0) {
								if (java.lang.Character.isLetter(text.charAt(attempt-1))) {
									attempt = text.indexOf(english, attempt+1);
									continue;	// FOUND, but midword
								}
							}
							if (best != null) {
								if (english.length() <= best.english.length()) {
									attempt = text.indexOf(english, attempt+1);
									continue;	// FOUND, but smaller in length
								}
								// sure we have a larger match, but is it at least near the previous match
								if (attempt > best.start + 7) {
									attempt = text.indexOf(english, attempt+1);
									continue;	// FOUND, but too far away
								}
								ti.wholeWord = true;
								try { if (java.lang.Character.isLetter(text.charAt(attempt + best.english.length()))) ti.wholeWord = false; } catch (Exception e1) {}
								if (!ti.wholeWord && best.wholeWord) {	// if we're not a whole word match, and we have a previous whole world match, keep previous
									attempt = text.indexOf(english, attempt+1);
									continue;	// FOUND, but smaller in length
								}
							}
							best = ti;
							best.english = english;	// in case english2 is better
							best.start = attempt;
							best.wholeWord = true;
							try { if (java.lang.Character.isLetter(text.charAt(attempt+best.english.length()))) best.wholeWord = false; } catch (Exception e1) {}
						}
						attempt = text.indexOf(english, attempt+1);
					}
				}
			}
			if (best != null) {
				int end = best.start+best.english.length();

				// check for definite article
				if (best.start >= 4) {
					if (text.substring(best.start-4, best.start).equalsIgnoreCase("the ")) {
						if ((best.start - 5) > -1) {
							if (!Character.isLetter(text.charAt(best.start-5))) {
								best.start -= 4;
							}
						}
					}
				}

				// check for indefinite article
				if (best.start >= 2) {
					if (text.substring(best.start-2, best.start).equalsIgnoreCase("a ")) {
						if ((best.start - 3) > -1) {
							if (!Character.isLetter(text.charAt(best.start-3))) {
								best.start -= 2;
							}
						}
					}
				}

				// check for genitive 'of'
				if (best.start >= 3) {
					if (tagInfo.morph.indexOf('G') > -1) {
						if (text.substring(best.start-3, best.start).equalsIgnoreCase("of ")) {
							if ((best.start - 4) > -1) {
								if (!Character.isLetter(text.charAt(best.start-4))) {
									best.start -= 3;
								}
							}
						}
					}
				}

				// include rest of word
				while (end < text.length()) {
					if (!Character.isLetter(text.charAt(end)))
					    break;
					end++;
				}

				moveTag(Integer.parseInt((String)tagKeys[i]), best.start + 1, false);
				moveTag(Integer.parseInt((String)tagKeys[i]), end + 1, true);
			}
		}
		for (int i = 0; i < tagKeys.length; i++) {
			slideTag(Integer.parseInt((String)tagKeys[i]), 0, false, "r", "r");
		}
	}

	void exportRangeButton_actionPerformed(ActionEvent e) {
		exportRange(rangeText.getText(), "export.zip");
		JOptionPane.showMessageDialog(this, "File [export.zip] written.");
	}

	void previousTag() {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o2) - Integer.parseInt((String)o1); }
			});
		int tag = getCurrentTag();
		boolean found = false;
		int i;
		for (i = 0; i < tagKeys.length; i++) {
			if (found) {
				setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
				break;
			}
			if (tag == Integer.parseInt((String)tagKeys[i]))
				found = true;
		}
		if (found && (i == tagKeys.length))
			setCurrentAction(Integer.parseInt((String)tagKeys[0]), "MoveTag");
	}


	void nextTag() {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		int tag = getCurrentTag();
		boolean found = false;
		int i;
		for (i = 0; i < tagKeys.length; i++) {
			if (found) {
				setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
				break;
			}
			if (tag == Integer.parseInt((String)tagKeys[i]))
				found = true;
		}
		if (found && (i == tagKeys.length))
			setCurrentAction(Integer.parseInt((String)tagKeys[0]), "MoveTag");
	}

	void greekTextEditor_mouseClicked(MouseEvent e) {
		Point clickPoint = e.getPoint();
		int position = greekTextEditor.viewToModel(clickPoint);
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		for (int i = 0; i < tagKeys.length; i++) {
			TagInfo ti = (TagInfo)tags.get(tagKeys[i]);
			if ((position >= ti.start) && (position <= ti.end+1)) {
				setCurrentAction(Integer.parseInt((String)tagKeys[i]), "MoveTag");
				break;
			}
		}
	}


	public String getUserID() {
		return userID;
	}


	public int login(String userID) {
		// no validation right now
		if (userID != null) {
			if (userID.length() > 0) {
				if (localKJV) {
					this.userID = userID;
					loginStatusLabel.setText("["+userID+"] logged in.");
					return 0;
				}
				else {
					String passwd = JOptionPane.showInputDialog(this, "Please enter your password", "Password", JOptionPane.QUESTION_MESSAGE);
					if (passwd != null) {
						StringBuffer result = new StringBuffer();
						callServer("action=l&uid=" + URLEncoder.encode(userID) +"&passwd=" + URLEncoder.encode(passwd), result);
						stripChar(result, '\n');
						String ltok = result.toString().trim();
						if (ltok.length() > 1) {
							loginToken = ltok;
							this.userID = userID;
							loginStatusLabel.setText("["+userID+"] logged in.");
							return 0;
						}
						else {
							JOptionPane.showMessageDialog(this, "Incorrect Login");
						}
					}
				}
			}
		}
		loginStatusLabel.setText("Not Logged In");
		this.userID = null;
		return -1;
	}


	public String getRawEntry() {
		StringBuffer text = getHTML(translatedTextEditor);
		replaceChar(text, '_', ' ');
		int pos = text.toString().indexOf("<body>");
		if (pos > -1)
			text.delete(0, pos+6);

		String htmlstr = text.toString();

		String startSearch = startTag1;
		String endSearch = endTag1;
		int tagPos = text.toString().indexOf(endSearch);
		while (tagPos > -1) {
			int endPos = text.toString().indexOf('>', tagPos+endSearch.length()+1);
			endPos = text.toString().indexOf('>', endPos+1);
			endPos = text.toString().indexOf('>', endPos+1);
			text.delete(tagPos, endPos+1);
			text.insert(tagPos, "</w>");
			tagPos = text.toString().indexOf(endSearch);
		}
		tagPos = text.toString().indexOf(startSearch);
		while (tagPos > -1) {
			int endPos = text.toString().indexOf('\"', tagPos+startSearch.length()+1);
			String tagKey = text.substring(tagPos+startSearch.length(), endPos);
			TagInfo ti = (TagInfo)tags.get(tagKey);
			String src = (ti.splitID == null) ? ti.id : ti.splitID;
			String wordTag = "<w src=\"" + src + "\"";
			if (ti.strong != null)
				wordTag += " lemma=\"x-Strongs:G"+ti.strong+"\"";
			if (ti.morph != null)
				wordTag += " morph=\"x-Robinson:"+ti.morph+"\"";

			// not correct OSIS encoding, but we're saving our ID as splitID even though the main tag doesn't have an equiv splitID
			if (ti.splitID != null)
				wordTag += " splitID=\""+ti.id+"\"";

			wordTag += ">";

			endPos = text.toString().indexOf('>', tagPos+startSearch.length()+1);
			endPos = text.toString().indexOf('>', endPos+1);
			endPos = text.toString().indexOf('>', endPos+1);
			text.delete(tagPos, endPos+1);
			text.insert(tagPos, wordTag);
			tagPos = text.toString().indexOf(startSearch);
		}
		pos = text.toString().indexOf("</body>");
		if (pos > -1)
			text.delete(pos, text.length());
		String notes = notesText.getText().trim();
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm");
		String currentDate = formatter.format(new Date());

		if (notes.length() > 0)
			text.append("<note type=\"strongsMarkup\" name=\""+getUserID()+"\" date=\""+currentDate+"\"/>"+URLEncoder.encode(notes)+"</note>");
		text.append("<resp type=\"strongsMarkup\" name=\""+getUserID()+"\" date=\""+currentDate+"\"/>");
		return text.toString();
	}


	void contentPane_keyPressed(KeyEvent e) {
		if (e.getKeyCode() == e.VK_TAB)
			nextTag();
	}

	void greekTextEditor_keyPressed(KeyEvent e) {
		handleKeyboard(e);
	}

	void jToggleButton1_actionPerformed(ActionEvent e) {
		exportRange(rangeText.getText(), "export.zip");
	}

	void loginButton_actionPerformed(ActionEvent e) {
		login(userIDText.getText());
	}

	void jMenuItem1_actionPerformed(ActionEvent e) {
		processWindowEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
	}

	void jMenuItem2_actionPerformed(ActionEvent e) {
		ProxyDialog pd = new ProxyDialog(useProxy,proxyHost,proxyPort);
		pd.validate();
		pd.show();
		if (pd.isOK()) {
			String proxy; String port;
			if ((proxy = pd.getProxy()) != null) {
				port = pd.getPort();
				if (pd.isKeepSettings()) {
					proxyHost = proxy;
					proxyPort = port;
				}
				Properties prop = System.getProperties();
				prop.put("http.proxyHost", proxy);
				prop.put("http.proxyPort", port);
			}
		}
	}


	public void deleteTag(int tag) {
		slideTag(tag, 0, false, "y", "y", true);
		tags.remove(Integer.toString(tag));
	}


	public TagInfo addSplitTag(int tag) {
		return addSplitTag(tag, true);
	}

	public TagInfo addSplitTag(int tag, boolean createMarkup) {
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		int highest = Integer.parseInt((String)tagKeys[tagKeys.length-1]);
		TagInfo tagInfo = (TagInfo)tags.get(Integer.toString(tag));
		TagInfo newTag = (TagInfo)tagInfo.clone();
		highest++;
		newTag.id = Integer.toString(highest);
		tags.put(Integer.toString(highest), newTag);
		newTag.splitID = Integer.toString(tag);
		newTag.type = "split";
		if (createMarkup)
			slideTag(tag, 0, false, "y", "y", false, highest);
		return newTag;
	}


	public void toggleSplitTag(int tag) {
		TagInfo tagInfo = (TagInfo)tags.get(Integer.toString(tag));

		if (tagInfo == null)
			return;

		String tagKey = (tagInfo.splitID == null) ? tagInfo.id : tagInfo.splitID;

		// see if we have any splits already and delete them
		Object [] tagKeys = tags.keySet().toArray();
		java.util.Arrays.sort(tagKeys, new Comparator() {
				public int compare(Object o1, Object o2) { return Integer.parseInt((String)o1) - Integer.parseInt((String)o2); }
			});
		boolean split = true;
		for (int i = 0; i < tagKeys.length; i++) {
			TagInfo ti = (TagInfo)tags.get(tagKeys[i]);
			if (tagKey.equals(ti.splitID)) {
				deleteTag(Integer.parseInt(ti.id));
				split = false;
			}
		}
		if (split) {
			addSplitTag(Integer.parseInt(tagInfo.id));
		}
	}


	void jMenuItem3_actionPerformed(ActionEvent e) {
		About aboutBox = new About();
		aboutBox.validate();
		aboutBox.show();
	}

	void jButton1_actionPerformed(ActionEvent e) {
		toggleSplitTag(getCurrentTag());
	}
}


class MainFrame_translatedTextEditor_mouseAdapter extends java.awt.event.MouseAdapter {
    MainFrame adaptee;

    MainFrame_translatedTextEditor_mouseAdapter(MainFrame adaptee) {
	   this.adaptee = adaptee;
    }
    public void mouseClicked(MouseEvent e) {
	   adaptee.translatedTextEditor_mouseClicked(e);
    }
}

class MainFrame_translatedTextEditor_mouseMotionAdapter extends java.awt.event.MouseMotionAdapter {
	MainFrame adaptee;

	MainFrame_translatedTextEditor_mouseMotionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void mouseDragged(MouseEvent e) {
		adaptee.translatedTextEditor_mouseDragged(e);
	}
}

class MainFrame_translatedTextEditor_keyAdapter extends java.awt.event.KeyAdapter {
	private MainFrame adaptee;

	MainFrame_translatedTextEditor_keyAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void keyTyped(KeyEvent e) {
		adaptee.translatedTextEditor_keyTyped(e);
	}
}


class TagInfo implements Cloneable {
	public TagInfo(String id) { this.id = id; }
	public Hashtable translations = null;
	public String id;
	public String strong;
	public String morph;
	public String morphClass;
	public String word;
	public int start = 0;
	public int end = 0;
	public String splitID = null;
	public String thayerCache = "";
	public String type = "";
	public Object clone() { Object ret = null; try { ret = super.clone(); } catch (Exception e) { e.printStackTrace(); } return ret; }

}


class TransInfo {
	public TransInfo(String id) { this.id = id; }
	public String id;
	public String english;
	public String english2;
	public String compoundedWith = null;
	public int frequency = 0;
	public int start = 0;
	public boolean wholeWord;
}

class MainFrame_loadVerseButton_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_loadVerseButton_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.loadVerseButton_actionPerformed(e);
	}
}

class MainFrame_currentVerseText_keyAdapter extends java.awt.event.KeyAdapter {
	private MainFrame adaptee;

	MainFrame_currentVerseText_keyAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void keyTyped(KeyEvent e) {
		adaptee.currentVerseText_keyTyped(e);
	}
}

class MainFrame_this_keyAdapter extends java.awt.event.KeyAdapter {
	private MainFrame adaptee;

	MainFrame_this_keyAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void keyPressed(KeyEvent e) {
		adaptee.this_keyPressed(e);
	}
}

class MainFrame_guessTagButton_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_guessTagButton_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.guessTagButton_actionPerformed(e);
	}
}

class MainFrame_signSaveButton_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_signSaveButton_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.signSaveButton_actionPerformed(e);
	}
}

class MainFrame_greekTextEditor_mouseAdapter extends java.awt.event.MouseAdapter {
	private MainFrame adaptee;

	MainFrame_greekTextEditor_mouseAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void mouseClicked(MouseEvent e) {
		adaptee.greekTextEditor_mouseClicked(e);
	}
}

class MainFrame_contentPane_keyAdapter extends java.awt.event.KeyAdapter {
	private MainFrame adaptee;

	MainFrame_contentPane_keyAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void keyPressed(KeyEvent e) {
		adaptee.contentPane_keyPressed(e);
	}
}

class MainFrame_greekTextEditor_keyAdapter extends java.awt.event.KeyAdapter {
	private MainFrame adaptee;

	MainFrame_greekTextEditor_keyAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void keyPressed(KeyEvent e) {
		adaptee.greekTextEditor_keyPressed(e);
	}
}

class MainFrame_exportRangeButton_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_exportRangeButton_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.exportRangeButton_actionPerformed(e);
	}
}

class MainFrame_loginButton_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_loginButton_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.loginButton_actionPerformed(e);
	}
}

class MainFrame_jMenuItem1_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_jMenuItem1_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.jMenuItem1_actionPerformed(e);
	}
}

class MainFrame_jMenuItem2_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_jMenuItem2_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.jMenuItem2_actionPerformed(e);
	}
}

class MainFrame_jMenuItem3_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_jMenuItem3_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.jMenuItem3_actionPerformed(e);
	}
}

class MainFrame_jButton1_actionAdapter implements java.awt.event.ActionListener {
	private MainFrame adaptee;

	MainFrame_jButton1_actionAdapter(MainFrame adaptee) {
		this.adaptee = adaptee;
	}
	public void actionPerformed(ActionEvent e) {
		adaptee.jButton1_actionPerformed(e);
	}
}
