package org.crosswire.modedit;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import javax.swing.text.html.*;
import java.lang.StringBuffer;
import java.io.StringReader;

/**
 * <p>Title: Proxy configuration</p>
 * <p>Description: prompts User to configer his/her Proxy</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Organisation: </p>
 * @author Christian Frommeyer
 * @version 1.0
 */

public class About extends JDialog {
  BorderLayout mainLayout = new BorderLayout();
  JPanel buttonPanel = new JPanel();
  GridLayout buttonPanelLayout = new GridLayout();
  JButton okButton = new JButton();

  private boolean ok = false;
	private JPanel jPanel1 = new JPanel();
	private JPanel jPanel2 = new JPanel();
	private BorderLayout borderLayout1 = new BorderLayout();
	private JLabel jLabel1 = new JLabel();
	private GridLayout gridLayout1 = new GridLayout();
	private JLabel jLabel2 = new JLabel();
	private JPanel jPanel3 = new JPanel();
	private JScrollPane jScrollPane1 = new JScrollPane();
	private BorderLayout borderLayout2 = new BorderLayout();
	private JEditorPane jEditorPane1 = new JEditorPane();
	private JLabel jLabel3 = new JLabel();

  public About() {
    try {
	 jbInit();
    }
    catch(Exception e) {
	 e.printStackTrace();
    }
  }


  private void jbInit() throws Exception {
    this.setModal(true);
    this.setSize(new Dimension(591, 604));
    this.setTitle("About ModEdit");
    this.getContentPane().setLayout(mainLayout);
    buttonPanel.setLayout(buttonPanelLayout);
    okButton.setText("OK");
    okButton.addActionListener(new java.awt.event.ActionListener() {
	 public void actionPerformed(ActionEvent e) {
	   button_actionPerformed(e);
	 }
    });
    jPanel1.setLayout(borderLayout1);
		jLabel1.setText("Module Editor (c) 2002 CrossWire Bible Society");
		jPanel2.setLayout(gridLayout1);
		gridLayout1.setColumns(1);
		gridLayout1.setRows(0);
		jLabel2.setText("-- licensed under the terms of the GNU GPL");
		jPanel3.setLayout(borderLayout2);
		HTMLEditorKit htmlKit = new HTMLEditorKit();
		jEditorPane1.setEditable(false);
		jEditorPane1.setEditorKit(htmlKit);
		jEditorPane1.setText("");
		HTMLDocument doc = (HTMLDocument)jEditorPane1.getDocument();
		StringBuffer sb = new StringBuffer();
		sb.append("<html><body>");
		sb.append("<h1>Markup Guidelines</h1>");
		sb.append("<ul>");
		sb.append("<li><b>What To Tag</b> - All words in the English should be enclosed in a Greek tag <i>except</i> words marked with {FI}word{Fi} tags, which are declared as 'added' (see {tags} below).  Even if you don't feel the translation is good or valid (and may be justifiably correct), the words should still be marked.  Our job with this project is only to <u>tag the translator's choices, not critique them.<br>");
		sb.append("<li><b>The Article</b> - Articles that appear in the Greek <u><i>should <b>not</b> be used to tag English</i></u> <b>unless</b> the article has only an <b>implied noun</b>.  If the noun is actually present in the Greek (98% of the time), any article in English should be marked <b>with the noun</b>.  These empty article tags will be programmatically combined with the greek noun and the noun marked 'definite' or 'indefinite' after the tagging project is complete.<br><br>eg. OIKOS (a house); hO (empty) OIKOS (the house).</li><br>");
		sb.append("<li><b>Genitive and Dative</b> - Typically in the KJV, the genitive and dative forms of nouns are translated with 'of' and 'to' respectively.  The English 'of' or 'to' should be included in the genitive or dative noun tag.<br><br>eg. OIKON (to a house); hOU (empty) OIKOU (of the house)</li><br>");
		sb.append("<li><b>Tag Placement</b> - Tags should not include spaces (_) unless between multiple words for the tag.  Tags should never be nested or crossed, ie.  the start or end of a tag should never be placed <b>between</b> the start and end of another tag.</li><br>");
		sb.append("<li><b>Split Tags</b> - Use the [Split] button only when absolutely necessary, when the translation string is discontiguous.  The button will toggle on/off the split status of the tag, so only 1 split for a tag is possible.</li><br>");
		sb.append("<li><b>UNSURE</b> - Leave a note.  Any notes on verses will be reviewed.  In some instances, KJV phrases were translated from Latin sources.  You will probably not find a Greek counterpart to mark these English phrases.  Do the best you can and leave a note.</li><br>");
		sb.append("<li><b>{tags}</b> - You may see tags marked with <b>{ }</b> symbols in the text.  These represent 'General Bible Format' markers and are typically for presentation, but some can be helpful to your markup.  Some you'll see in the KJV text:<ul>");
		sb.append("<li><b>{CM}</b> - Paragraph break.</li>");
		sb.append("<li><b>{FR} {Fr}</b> - Start and end of 'words of Jesus' (red-letter Bibles use these).  Remember: FR = Format Red</li>");
		sb.append("<li><b>{FI} {Fi}</b> - Start and end of <b>translation change (added)</b> words.  These, by definition <u><i>should not be tagged</i></u> with Greek.  Remember: FI = Format Italics</li>");
		sb.append("</ul>");
//		sb.append("<li><b></b> - </li>");
//		sb.append("");
		sb.append("</ul>");
		sb.append("</br>");
		sb.append("</body></html>");
		StringReader sr = new StringReader(sb.toString());
		jEditorPane1.getEditorKit().read(sr, doc, 0);
		jEditorPane1.setCaretPosition(0);


		jEditorPane1.setToolTipText("");
		jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		jLabel3.setText(".v1.0.3");
		buttonPanel.add(okButton, null);
		this.getContentPane().add(jPanel1, BorderLayout.CENTER);
		jPanel1.add(jPanel2, BorderLayout.NORTH);
		jPanel2.add(jLabel1, null);
		jPanel2.add(jLabel3, null);
		jPanel2.add(jLabel2, null);
		jPanel1.add(jPanel3, BorderLayout.CENTER);
		jPanel3.add(jScrollPane1,  BorderLayout.CENTER);
		jScrollPane1.getViewport().add(jEditorPane1, null);

		this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
	}

  void button_actionPerformed(ActionEvent e) {
    if (e.getActionCommand().equals(okButton.getActionCommand())) ok = true;
    else ok = false;
    this.hide();
  }


}