/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.commons.validator.Var;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.RequestUtils;
import org.apache.struts.validator.Resources;

public class JavascriptValidatorTag
extends BodyTagSupport {
    protected String bundle = "org.apache.struts.action.MESSAGE";
    protected static Locale defaultLocale = Locale.getDefault();
    protected String formName = null;
    protected int page = 0;
    protected String methodName = null;
    protected String staticJavascript = "true";
    protected String dynamicJavascript = "true";
    protected String src = null;
    protected String htmlComment = "true";
    protected String cdata = "true";
    private String htmlBeginComment = "\n<!-- Begin \n";
    private String htmlEndComment = "//End --> \n";

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String getMethod() {
        return this.methodName;
    }

    public void setMethod(String methodName) {
        this.methodName = methodName;
    }

    public String getStaticJavascript() {
        return this.staticJavascript;
    }

    public void setStaticJavascript(String staticJavascript) {
        this.staticJavascript = staticJavascript;
    }

    public String getDynamicJavascript() {
        return this.dynamicJavascript;
    }

    public void setDynamicJavascript(String dynamicJavascript) {
        this.dynamicJavascript = dynamicJavascript;
    }

    public String getHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(String htmlComment) {
        this.htmlComment = htmlComment;
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public int doStartTag() throws JspException {
        StringBuffer results = new StringBuffer();
        ModuleConfig config = RequestUtils.getModuleConfig(this.pageContext);
        ValidatorResources resources = (ValidatorResources)this.pageContext.getAttribute("org.apache.commons.validator.VALIDATOR_RESOURCES" + config.getPrefix(), 4);
        Locale locale = null;
        try {
            locale = (Locale)this.pageContext.getAttribute("org.apache.struts.action.LOCALE", 3);
        }
        catch (IllegalStateException e) {
            locale = null;
        }
        if (locale == null) {
            locale = defaultLocale;
        }
        Form form = null;
        form = resources.get(locale, (Object)this.formName);
        if (form != null) {
            if ("true".equals(this.dynamicJavascript)) {
                MessageResources messages = (MessageResources)this.pageContext.getAttribute(this.bundle + config.getPrefix(), 4);
                ArrayList<ValidatorAction> lActions = new ArrayList<ValidatorAction>();
                ArrayList lActionMethods = new ArrayList();
                Iterator i = form.getFields().iterator();
                while (i.hasNext()) {
                    Field field = (Field)i.next();
                    Iterator x = field.getDependencies().iterator();
                    while (x.hasNext()) {
                        Object o = x.next();
                        if (o == null || lActionMethods.contains(o)) continue;
                        lActionMethods.add(o);
                    }
                }
                Iterator i2 = lActionMethods.iterator();
                while (i2.hasNext()) {
                    String depends = (String)i2.next();
                    ValidatorAction va = resources.getValidatorAction(depends);
                    if (va == null) {
                        throw new NullPointerException("Depends string \"" + depends + "\" was not found in validator-rules.xml.");
                    }
                    String javascript = va.getJavascript();
                    if (javascript != null && javascript.length() > 0) {
                        lActions.add(va);
                        continue;
                    }
                    i2.remove();
                }
                Collections.sort(lActions, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        ValidatorAction va1 = (ValidatorAction)o1;
                        ValidatorAction va2 = (ValidatorAction)o2;
                        if (!(va1.getDepends() != null && va1.getDepends().length() != 0 || va2.getDepends() != null && va2.getDepends().length() != 0)) {
                            return 0;
                        }
                        if (va1.getDepends() != null && va1.getDepends().length() > 0 && (va2.getDepends() == null || va2.getDepends().length() == 0)) {
                            return 1;
                        }
                        if ((va1.getDepends() == null || va1.getDepends().length() == 0) && va2.getDepends() != null && va2.getDepends().length() > 0) {
                            return -1;
                        }
                        return va1.getDependencies().size() - va2.getDependencies().size();
                    }
                });
                String methods = null;
                Iterator i3 = lActions.iterator();
                while (i3.hasNext()) {
                    ValidatorAction va = (ValidatorAction)i3.next();
                    methods = methods == null ? va.getMethod() + "(form)" : methods + " && " + va.getMethod() + "(form)";
                }
                results.append(this.getJavascriptBegin(methods));
                Iterator i4 = lActions.iterator();
                while (i4.hasNext()) {
                    ValidatorAction va = (ValidatorAction)i4.next();
                    String jscriptVar = null;
                    String functionName = null;
                    functionName = va.getJsFunctionName() != null && va.getJsFunctionName().length() > 0 ? va.getJsFunctionName() : va.getName();
                    results.append("    function " + functionName + " () { \n");
                    Iterator x = form.getFields().iterator();
                    while (x.hasNext()) {
                        Field field = (Field)x.next();
                        if (field.isIndexed() || field.getPage() != this.page || !field.isDependency(va.getName())) continue;
                        String message = Resources.getMessage(messages, locale, va, field);
                        message = message != null ? message : "";
                        jscriptVar = this.getNextVar(jscriptVar);
                        results.append("     this." + jscriptVar + " = new Array(\"" + field.getKey() + "\", \"" + message + "\", ");
                        results.append("new Function (\"varName\", \"");
                        Map hVars = field.getVars();
                        Iterator iVars = hVars.keySet().iterator();
                        while (iVars.hasNext()) {
                            String varKey = (String)iVars.next();
                            Var var = (Var)hVars.get(varKey);
                            String varValue = var.getValue();
                            String jsType = var.getJsType();
                            if ("int".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "=" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "; ");
                                continue;
                            }
                            if ("regexp".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "=/" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            if ("string".equalsIgnoreCase(jsType)) {
                                results.append("this." + varKey + "='" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                                continue;
                            }
                            if ("mask".equalsIgnoreCase(varKey)) {
                                results.append("this." + varKey + "=/" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "/; ");
                                continue;
                            }
                            results.append("this." + varKey + "='" + ValidatorUtil.replace((String)varValue, (String)"\\", (String)"\\\\") + "'; ");
                        }
                        results.append(" return this[varName];\"));\n");
                    }
                    results.append("    } \n\n");
                }
            } else if ("true".equals(this.staticJavascript)) {
                results.append(this.getStartElement());
                if ("true".equals(this.htmlComment)) {
                    results.append(this.htmlBeginComment);
                }
            }
        }
        if ("true".equals(this.staticJavascript)) {
            results.append(this.getJavascriptStaticMethods(resources));
        }
        if (form != null && ("true".equals(this.dynamicJavascript) || "true".equals(this.staticJavascript))) {
            results.append(this.getJavascriptEnd());
        }
        JspWriter writer = this.pageContext.getOut();
        try {
            writer.print(results.toString());
        }
        catch (IOException e) {
            throw new JspException(e.getMessage());
        }
        return 2;
    }

    public void release() {
        super.release();
        this.bundle = "org.apache.struts.action.MESSAGE";
        this.formName = null;
        this.page = 0;
        this.methodName = null;
        this.staticJavascript = "true";
        this.dynamicJavascript = "true";
        this.htmlComment = "true";
        this.cdata = "true";
        this.src = null;
    }

    protected String getJavascriptBegin(String methods) {
        StringBuffer sb = new StringBuffer();
        String name = this.formName.substring(0, 1).toUpperCase() + this.formName.substring(1, this.formName.length());
        sb.append(this.getStartElement());
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("<![CDATA[\r\n");
        }
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(this.htmlBeginComment);
        }
        sb.append("\n     var bCancel = false; \n\n");
        if (this.methodName == null || this.methodName.length() == 0) {
            sb.append("    function validate" + name + "(form) {                                                                   \n");
        } else {
            sb.append("    function " + this.methodName + "(form) {                                                                   \n");
        }
        sb.append("        if (bCancel) \n");
        sb.append("      return true; \n");
        sb.append("        else \n");
        if (methods == null || methods.length() == 0) {
            sb.append("       return true; \n");
        } else {
            sb.append("       return " + methods + "; \n");
        }
        sb.append("   } \n\n");
        return sb.toString();
    }

    protected String getJavascriptStaticMethods(ValidatorResources resources) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n");
        Iterator i = resources.getValidatorActions().values().iterator();
        while (i.hasNext()) {
            String javascript;
            ValidatorAction va = (ValidatorAction)i.next();
            if (va == null || (javascript = va.getJavascript()) == null || javascript.length() <= 0) continue;
            sb.append(javascript + "\n");
        }
        return sb.toString();
    }

    protected String getJavascriptEnd() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (!this.isXhtml() && "true".equals(this.htmlComment)) {
            sb.append(this.htmlEndComment);
        }
        if (this.isXhtml() && "true".equalsIgnoreCase(this.cdata)) {
            sb.append("]]>\r\n");
        }
        sb.append("</script>\n\n");
        return sb.toString();
    }

    private String getNextVar(String input) {
        if (input == null) {
            return "aa";
        }
        input = input.toLowerCase();
        int i = input.length();
        while (i > 0) {
            int pos = i - 1;
            char c = input.charAt(pos);
            if ((c = (char)(c + '\u0001')) <= 'z') {
                if (i == 0) {
                    return c + input.substring(pos, input.length());
                }
                if (i == input.length()) {
                    return input.substring(0, pos) + c;
                }
                return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
            }
            input = this.replaceChar(input, pos, 'a');
            --i;
        }
        return null;
    }

    private String replaceChar(String input, int pos, char c) {
        if (pos == 0) {
            return c + input.substring(pos, input.length());
        }
        if (pos == input.length()) {
            return input.substring(0, pos) + c;
        }
        return input.substring(0, pos) + c + input.substring(pos, input.length() - 1);
    }

    private String getStartElement() {
        StringBuffer start = new StringBuffer("<script type=\"text/javascript\"");
        if (!this.isXhtml()) {
            start.append(" language=\"Javascript1.1\"");
        }
        if (this.src != null) {
            start.append(" src=\"" + this.src + "\"");
        }
        start.append("> \n");
        return start.toString();
    }

    private boolean isXhtml() {
        String xhtml = (String)this.pageContext.getAttribute("org.apache.struts.globals.XHTML", 1);
        return "true".equalsIgnoreCase(xhtml);
    }

    public String getCdata() {
        return this.cdata;
    }

    public void setCdata(String cdata) {
        this.cdata = cdata;
    }
}

