/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.webapp.admin.resources.BaseForm;

public final class DataSourceForm
extends BaseForm {
    private String url = null;
    private String jndiName = null;
    private String driverClass = null;
    private String username = null;
    private String password = null;
    private String active = null;
    private String idle = null;
    private String wait = null;
    private String resourcetype = null;
    private String path = null;
    private String host = null;
    private String domain = null;
    private String query = null;
    private String type = null;
    private ActionErrors errors = null;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getActive() {
        return this.active;
    }

    public void setActive(String active) {
        this.active = active;
    }

    public String getIdle() {
        return this.idle;
    }

    public void setIdle(String idle) {
        this.idle = idle;
    }

    public String getWait() {
        return this.wait;
    }

    public void setWait(String wait) {
        this.wait = wait;
    }

    public String getResourcetype() {
        return this.resourcetype;
    }

    public void setResourcetype(String resourcetype) {
        this.resourcetype = resourcetype;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.url = null;
        this.jndiName = null;
        this.driverClass = null;
        this.username = null;
        this.password = null;
        this.type = null;
        this.active = null;
        this.idle = null;
        this.wait = null;
        this.query = null;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        this.errors = new ActionErrors();
        if (this.url == null || this.url.length() < 1) {
            this.errors.add("url", new ActionMessage("resources.error.url.required"));
        }
        if (this.jndiName == null || this.jndiName.length() < 1) {
            this.errors.add("jndiName", new ActionMessage("resources.error.jndiName.required"));
        }
        if (this.driverClass == null || this.driverClass.length() < 1) {
            this.errors.add("driverClass", new ActionMessage("resources.error.driverClass.required"));
        }
        this.numberCheck("active", this.active, false, 0, 10000);
        this.numberCheck("idle", this.idle, false, 0, 10000);
        this.numberCheck("wait", this.wait, false, 0, 10000);
        if (this.username != null && this.username.indexOf(34) >= 0) {
            this.errors.add("username", new ActionMessage("users.error.quotes"));
        }
        if (this.password != null && this.password.indexOf(34) > 0) {
            this.errors.add("password", new ActionMessage("users.error.quotes"));
        }
        return this.errors;
    }

    private void numberCheck(String field, String numText, boolean rangeCheck, int min, int max) {
        if (numText == null || numText.length() < 1) {
            this.errors.add(field, new ActionMessage("resources.error." + field + ".required"));
        } else {
            try {
                int num = Integer.parseInt(numText);
                if (rangeCheck && (num < min || num > max)) {
                    this.errors.add(field, new ActionMessage("resources.error." + field + ".range"));
                }
            }
            catch (NumberFormatException e) {
                this.errors.add(field, new ActionMessage("resources.integer.error"));
            }
        }
    }
}

