/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.catalina.storeconfig.StoreFileMover;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.resources.ProxyDirContext;

public class StandardContextSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog((Class)StandardContextSF.class);

    public void store(PrintWriter aWriter, int indent, Object aContext) throws Exception {
        String configFile;
        StoreDescription desc;
        if (aContext instanceof StandardContext && (desc = this.getRegistry().findDescription(aContext.getClass())).isStoreSeparate() && (configFile = ((StandardContext)aContext).getConfigFile()) != null && desc.isExternalAllowed()) {
            if (desc.isBackup()) {
                this.storeWithBackup((StandardContext)aContext);
            } else {
                this.storeContextSeparate(aWriter, indent, (StandardContext)aContext);
            }
            return;
        }
        super.store(aWriter, indent, aContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeContextSeparate(PrintWriter aWriter, int indent, StandardContext aContext) throws Exception {
        block12: {
            block14: {
                String configFile = aContext.getConfigFile();
                PrintWriter writer = null;
                if (configFile == null) break block14;
                File config = new File(configFile);
                if (!config.isAbsolute()) {
                    config = new File(System.getProperty("catalina.base"), configFile);
                }
                if (!config.isFile() || !config.canWrite()) {
                    log.error((Object)("Cannot write context output file at " + configFile + ", not saving."));
                    throw new IOException("Context save file at " + configFile + " not a file, or not writable.");
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Store Context " + aContext.getPath() + " separate at file " + config));
                }
                try {
                    writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config), this.getRegistry().getEncoding()));
                    this.storeXMLHead(writer);
                    super.store(writer, -2, aContext);
                    Object var8_7 = null;
                    if (writer == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (writer != null) {
                        try {
                            writer.flush();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        try {
                            writer.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    writer.flush();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    writer.close();
                }
                catch (Throwable t) {}
                break block12;
            }
            super.store(aWriter, indent, aContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeWithBackup(StandardContext aContext) throws Exception {
        StoreFileMover mover = this.getConfigFileWriter((Context)aContext);
        if (mover != null) {
            if (mover.getConfigOld() == null || !mover.getConfigOld().isFile() || !mover.getConfigOld().canWrite()) {
                log.error((Object)("Cannot move orignal context output file at " + mover.getConfigOld()));
                throw new IOException("Context orginal file at " + mover.getConfigOld() + " is null, not a file or not writable.");
            }
            File dir = mover.getConfigSave().getParentFile();
            if (dir != null && dir.isDirectory() && !dir.canWrite()) {
                log.error((Object)("Cannot save context output file at " + mover.getConfigSave()));
                throw new IOException("Context save file at " + mover.getConfigSave() + " is not writable.");
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Store Context " + aContext.getPath() + " separate with backup (at file " + mover.getConfigSave() + " )"));
            }
            PrintWriter writer = mover.getWriter();
            try {
                this.storeXMLHead(writer);
                super.store(writer, -2, aContext);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    writer.flush();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                writer.close();
                throw throwable;
            }
            try {
                writer.flush();
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            writer.close();
            mover.move();
        }
    }

    protected StoreFileMover getConfigFileWriter(Context context) throws IOException {
        String configFile = context.getConfigFile();
        Object writer = null;
        StoreFileMover mover = null;
        if (configFile != null) {
            File config = new File(configFile);
            if (!config.isAbsolute()) {
                config = new File(System.getProperty("catalina.base"), configFile);
            }
            mover = new StoreFileMover("", config.getCanonicalPath(), this.getRegistry().getEncoding());
        }
        return mover;
    }

    public void storeChilds(PrintWriter aWriter, int indent, Object aContext, StoreDescription parentDesc) throws Exception {
        if (aContext instanceof StandardContext) {
            DirContext resources;
            StandardContext context = (StandardContext)aContext;
            if (context instanceof Lifecycle) {
                Object[] listeners = context.findLifecycleListeners();
                this.storeElementArray(aWriter, indent, listeners);
            }
            if (context instanceof Pipeline) {
                Object[] valves = context.getValves();
                this.storeElementArray(aWriter, indent, valves);
            }
            Loader loader = context.getLoader();
            this.storeElement(aWriter, indent, loader);
            Manager manager = context.getManager();
            this.storeElement(aWriter, indent, manager);
            Realm realm = context.getRealm();
            if (realm != null) {
                Realm parentRealm = null;
                if (context.getParent() != null) {
                    parentRealm = context.getParent().getRealm();
                }
                if (realm != parentRealm) {
                    this.storeElement(aWriter, indent, realm);
                }
            }
            if ((resources = context.getResources()) instanceof ProxyDirContext) {
                resources = ((ProxyDirContext)resources).getDirContext();
            }
            this.storeElement(aWriter, indent, resources);
            String[] iListeners = context.findInstanceListeners();
            this.getStoreAppender().printTagArray(aWriter, "InstanceListener", indent + 2, iListeners);
            String[] wLifecycles = context.findWrapperLifecycles();
            this.getStoreAppender().printTagArray(aWriter, "WrapperListener", indent + 2, wLifecycles);
            String[] wListeners = context.findWrapperListeners();
            this.getStoreAppender().printTagArray(aWriter, "WrapperLifecycle", indent + 2, wListeners);
            Object[] appParams = context.findApplicationParameters();
            this.storeElementArray(aWriter, indent, appParams);
            NamingResources nresources = context.getNamingResources();
            this.storeElement(aWriter, indent, nresources);
            String[] wresources = context.findWatchedResources();
            wresources = this.filterWatchedResources(context, wresources);
            this.getStoreAppender().printTagArray(aWriter, "WatchedResource", indent + 2, wresources);
        }
    }

    protected File configBase(Context context) {
        File file = new File(System.getProperty("catalina.base"), "conf");
        Host host = (Host)context.getParent();
        if (host != null && host instanceof Host) {
            Container engine = host.getParent();
            if (engine != null && engine instanceof Engine) {
                file = new File(file, engine.getName());
            }
            file = new File(file, host.getName());
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        return file;
    }

    protected String[] filterWatchedResources(StandardContext context, String[] wresources) throws IOException {
        File configBase = this.configBase((Context)context);
        String confContext = new File(System.getProperty("catalina.base"), "conf/context.xml").getCanonicalPath();
        String confHostDefault = new File(configBase, "context.xml.default").getCanonicalPath();
        String configFile = context.getConfigFile();
        String webxml = "WEB-INF/web.xml";
        ArrayList<String> resource = new ArrayList<String>();
        for (int i = 0; i < wresources.length; ++i) {
            if (wresources[i].equals(confContext) || wresources[i].equals(confHostDefault) || wresources[i].equals(configFile) || wresources[i].equals(webxml)) continue;
            resource.add(wresources[i]);
        }
        return resource.toArray(new String[resource.size()]);
    }
}

