/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.sword.mgr;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import org.crosswire.sword.mgr.SWConfig;

public class SWMgr {
    public static Hashtable staticInstances = new Hashtable();
    private SWConfig myconfig = null;
    private SWConfig mysysconfig = null;
    private char configType;
    public SWConfig config = null;
    public SWConfig sysconfig = null;
    public String prefixPath = null;
    public String configPath = null;

    public static void clearCachedInstances() {
        staticInstances = new Hashtable();
    }

    public static SWMgr getInstance(String string) {
        SWMgr sWMgr = (SWMgr)staticInstances.get(string);
        if (sWMgr == null) {
            sWMgr = new SWMgr(string);
            staticInstances.put(string, sWMgr);
        }
        return sWMgr;
    }

    protected void init() {
    }

    public SWMgr(SWConfig sWConfig, SWConfig sWConfig2, boolean bl) {
        this.init();
        if (sWConfig != null) {
            this.config = sWConfig;
            this.myconfig = null;
        } else {
            this.config = null;
        }
        if (sWConfig2 != null) {
            this.sysconfig = sWConfig2;
            this.mysysconfig = null;
        } else {
            this.sysconfig = null;
        }
        if (bl) {
            this.Load();
        }
    }

    public SWMgr(String string) {
        this(string, true);
    }

    public SWMgr(String string, boolean bl) {
        this.init();
        String string2 = string;
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (this.existsFile(string2, "mods.conf")) {
            this.prefixPath = string2;
            this.configPath = string2 = string2 + "mods.conf";
        } else if (this.existsDir(string2, "mods.d")) {
            this.prefixPath = string2;
            this.configPath = string2 = string2 + "mods.d";
            this.configType = '\u0001';
        }
        this.config = null;
        this.sysconfig = null;
        if (bl && this.configPath != null) {
            this.Load();
        }
    }

    private boolean existsFile(String string, String string2) {
        String string3 = string;
        string3 = string3 + "/";
        String string4 = string3 + string2;
        File file = new File(string4);
        return file.exists();
    }

    private boolean existsDir(String string, String string2) {
        String string3 = string;
        string3 = string3 + "/";
        String string4 = string3 + string2;
        File file = new File(string4);
        return file.isDirectory();
    }

    protected void findConfig() {
    }

    protected void loadConfigDir(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".conf");
                }
            });
            try {
                String string2;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(".") || stringArray[i].equals("..")) continue;
                    string2 = string;
                    if (!string2.endsWith("/")) {
                        string2 = string2 + "/";
                    }
                    string2 = string2 + stringArray[i];
                    if (this.config != null) {
                        SWConfig sWConfig = new SWConfig(string2);
                        this.config.augment(sWConfig);
                        continue;
                    }
                    this.config = this.myconfig = new SWConfig(string2);
                }
                if (this.config == null) {
                    string2 = string;
                    string2 = string2 + "/globals.conf";
                    this.config = this.myconfig = new SWConfig(string2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void Load() {
        try {
            if (this.config == null) {
                if (this.configPath == null) {
                    this.findConfig();
                }
                if (this.configPath != null) {
                    if (this.configType != '\u0000') {
                        this.loadConfigDir(this.configPath);
                    } else {
                        this.config = this.myconfig = new SWConfig(this.configPath);
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.config == null) {
            System.err.println("SWMgr: Can't find 'mods.conf' or 'mods.d'.  Try setting:\n\tSWORD_PATH=<directory containing mods.conf>\n\tOr see the README file for a full description of setup options (" + (this.configPath != null ? this.configPath : "<configPath is null>") + ")");
        }
    }
}

