/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.sword.keys;

import org.crosswire.sword.keys.Canon;
import org.crosswire.sword.keys.ListKey;
import org.crosswire.sword.keys.SWKey;
import org.crosswire.sword.mgr.LocaleMgr;
import org.crosswire.sword.mgr.SWLocale;

public class VerseKey
extends SWKey {
    public static final char MAXVERSE = '\u0003';
    public static final char MAXCHAPTER = '\u0004';
    public static final char MAXBOOK = '\u0005';
    private VerseKey upperBound = null;
    private VerseKey lowerBound = null;
    Canon.Abbrev[] abbrevs = null;
    int abbrevsCnt;
    int testament;
    int book;
    int chapter;
    int verse;
    boolean autonorm;
    boolean headings;
    char[] BMAX;
    Canon.Book[][] books;
    static Canon.Book[] builtin_books = null;
    static char[] builtin_BMAX = new char[]{'\'', '\u001b'};
    static LocaleCache localeCache = null;

    public void setText(String string) {
        super.setText(string);
        this.parse();
    }

    boolean isTraversable() {
        return true;
    }

    void init() {
        if (builtin_books == null) {
            this.initStatics();
        }
        this.autonorm = true;
        this.headings = false;
        this.testament = 0;
        this.book = 0;
        this.chapter = 0;
        this.verse = 0;
        this.setLocale(LocaleMgr.systemLocaleMgr.getDefaultLocaleName());
    }

    public VerseKey() {
        this("");
    }

    public VerseKey(SWKey sWKey) {
        super(sWKey);
        this.init();
        if (sWKey != null) {
            this.parse();
        }
    }

    VerseKey(String string) {
        super(string);
        this.init();
        if (string != null) {
            this.parse();
        }
    }

    VerseKey(VerseKey verseKey) {
        super(verseKey.keytext);
        this.init();
        this.autonorm = verseKey.autonorm;
        this.headings = verseKey.headings;
        this.testament = verseKey.getTestament();
        this.book = verseKey.getBook();
        this.chapter = verseKey.getChapter();
        this.verse = verseKey.getVerse();
        this.setLowerBound(verseKey.getLowerBound());
        this.setUpperBound(verseKey.getUpperBound());
    }

    VerseKey(String string, String string2) {
        this.init();
        this.setLowerBound(string);
        this.setUpperBound(string2);
        this.position(1);
    }

    public Object clone() {
        return new VerseKey(this);
    }

    public void setLocale(String string) {
        boolean bl = false;
        if (VerseKey.localeCache.name != null) {
            bl = VerseKey.localeCache.name.equals(string);
        }
        if (!bl) {
            VerseKey.localeCache.name = string;
            VerseKey.localeCache.abbrevsCnt = 0;
        }
    }

    public void setBooks(char[] cArray, Canon.Book[][] bookArray) {
        this.BMAX = cArray;
        this.books = bookArray;
    }

    public void setBookAbbrevs(Canon.Abbrev[] abbrevArray, int n) {
        this.abbrevs = abbrevArray;
        if (n == 0) {
            this.abbrevsCnt = 1;
            while (this.abbrevs[this.abbrevsCnt].ab != null) {
                ++this.abbrevsCnt;
            }
        } else {
            this.abbrevsCnt = n;
        }
    }

    private void initStatics() {
    }

    protected int parse() {
        return this.error;
    }

    void freshtext() {
    }

    int getBookAbbrev(String string) {
        int n = (string = string.trim().toUpperCase()).length();
        if (n > 0) {
            int n2;
            int n3;
            int n4 = 0;
            int n5 = this.abbrevsCnt;
            while (true) {
                n3 = n4 + (n5 - n4) / 2;
                n2 = string.compareTo(this.abbrevs[n3].ab.length() > n ? this.abbrevs[n3].ab.substring(1, n) : this.abbrevs[n3].ab);
                if (n2 == 0 || n3 >= n5 || n3 <= n4) break;
                if (n2 > 0) {
                    n4 = n3;
                    continue;
                }
                n5 = n3;
            }
            return n2 == 0 ? this.abbrevs[n3].book : -1;
        }
        return -1;
    }

    public ListKey ParseVerseList(String string, String string2, boolean bl) {
        ListKey listKey = new ListKey();
        return listKey;
    }

    public VerseKey getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(SWKey sWKey) {
        this.setLowerBound(sWKey.getText());
    }

    public void setLowerBound(String string) {
        if (this.lowerBound == null) {
            this.initBounds();
        }
        this.lowerBound.setText(string);
        this.lowerBound.normalize();
    }

    public VerseKey getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(SWKey sWKey) {
        this.setUpperBound(sWKey.getText());
    }

    public void setUpperBound(String string) {
        if (this.upperBound == null) {
            this.initBounds();
        }
        this.upperBound.setText(string);
        if (this.upperBound.compareTo(this.lowerBound) < 0) {
            this.upperBound.set(this.lowerBound);
        }
        this.upperBound.normalize();
    }

    public void clearBounds() {
        this.initBounds();
    }

    protected void initBounds() {
        if (this.upperBound == null) {
            this.upperBound = new VerseKey();
            this.upperBound.setAutoNormalize(false);
            this.upperBound.setHeadings(true);
        }
        if (this.lowerBound == null) {
            this.lowerBound = new VerseKey();
            this.lowerBound.setAutoNormalize(false);
            this.lowerBound.setHeadings(true);
        }
        this.lowerBound.setTestament(0);
        this.lowerBound.setBook(0);
        this.lowerBound.setChapter(0);
        this.lowerBound.setVerse(0);
        this.upperBound.setTestament(2);
        this.upperBound.setBook(this.BMAX[1]);
        this.upperBound.setChapter(this.books[1][this.BMAX[1] - '\u0001'].chapmax);
        this.upperBound.setVerse(this.books[1][this.BMAX[1] - '\u0001'].versemax[this.upperBound.getChapter() - 1]);
    }

    public void normalize() {
        this.normalize(false);
    }

    public void normalize(boolean bl) {
        this.error = 0;
        if (bl && !this.autonorm) {
            return;
        }
        if (this.headings && this.verse == 0) {
            return;
        }
        while (this.testament < 3 && this.testament > 0) {
            if (this.book > this.BMAX[this.testament - 1]) {
                this.book -= this.BMAX[this.testament - 1];
                ++this.testament;
                continue;
            }
            if (this.book < 1) {
                if (--this.testament <= 0) continue;
                this.book += this.BMAX[this.testament - 1];
                continue;
            }
            if (this.chapter > this.books[this.testament - 1][this.book - 1].chapmax) {
                this.chapter -= this.books[this.testament - 1][this.book - 1].chapmax;
                ++this.book;
                continue;
            }
            if (this.chapter < 1) {
                if (--this.book > 0) {
                    this.chapter += this.books[this.testament - 1][this.book - 1].chapmax;
                    continue;
                }
                if (this.testament <= 1) continue;
                this.chapter += this.books[0][this.BMAX[0] - '\u0001'].chapmax;
                continue;
            }
            if (this.verse > this.books[this.testament - 1][this.book - 1].versemax[this.chapter - 1]) {
                this.verse -= this.books[this.testament - 1][this.book - 1].versemax[this.chapter++ - 1];
                continue;
            }
            if (this.verse >= 1) break;
            if (--this.chapter > 0) {
                this.verse += this.books[this.testament - 1][this.book - 1].versemax[this.chapter - 1];
                continue;
            }
            if (this.book > 1) {
                this.verse += this.books[this.testament - 1][this.book - 2].versemax[this.books[this.testament - 1][this.book - 2].chapmax - 1];
                continue;
            }
            if (this.testament <= 1) continue;
            this.verse += this.books[0][this.BMAX[0] - '\u0001'].versemax[this.books[0][this.BMAX[0] - '\u0001'].chapmax - 1];
        }
        if (this.testament > 2) {
            this.testament = 2;
            this.book = this.BMAX[this.testament - 1];
            this.chapter = this.books[this.testament - 1][this.book - 1].chapmax;
            this.verse = this.books[this.testament - 1][this.book - 1].versemax[this.chapter - 1];
            this.error = 1;
        }
        if (this.testament < 1) {
            this.error = !this.headings || this.testament < 0 || this.book < 0 ? 1 : 0;
            this.testament = this.headings ? 0 : 1;
            this.book = this.headings ? 0 : 1;
            this.chapter = this.headings ? 0 : 1;
            int n = this.verse = this.headings ? 0 : 1;
        }
        if (this.getUpperBound().compareTo(this) < 0) {
            this.set(this.getUpperBound());
            this.error = 1;
        }
        if (this.getLowerBound().compareTo(this) > 0) {
            this.set(this.getLowerBound());
            this.error = 1;
        }
    }

    public int getTestament() {
        return this.testament;
    }

    public void setTestament(int n) {
        this.testament = n;
        this.normalize(true);
    }

    public int getBook() {
        return this.book;
    }

    public void setBook(int n) {
        this.setChapter(1);
        this.book = n;
        this.normalize(true);
    }

    public int getChapter() {
        return this.chapter;
    }

    public void setChapter(int n) {
        this.setVerse(1);
        this.chapter = n;
        this.normalize(true);
    }

    public int getVerse() {
        return this.verse;
    }

    public void setVerse(int n) {
        this.verse = n;
        this.normalize(true);
    }

    public boolean isAutoNormalize() {
        return this.autonorm;
    }

    public void setAutoNormalize(boolean bl) {
        this.autonorm = bl;
        this.normalize(true);
    }

    public boolean isHeadings() {
        return this.headings;
    }

    public void setHeadings(boolean bl) {
        this.headings = bl;
        this.normalize(true);
    }

    class LocaleCache {
        String name = null;
        int abbrevsCnt = 0;
        SWLocale locale = null;

        LocaleCache() {
        }
    }
}

