/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.AsciiToBetacode;
import greekconverter.BetacodeToSPIonic;
import greekconverter.BetacodeToUnicode;
import greekconverter.BibleWorksToBetacode;
import greekconverter.BibleWorksToUnicode;
import greekconverter.CodeCharts;
import greekconverter.DynShortArray;
import greekconverter.GreekConvCaps;
import greekconverter.GreekConverter;
import greekconverter.GreekFileConverter;
import greekconverter.GreekKeysToUnicode;
import greekconverter.MessageHandler;
import greekconverter.Nereus;
import greekconverter.UC;
import greekconverter.UnicodeDecompose;
import greekconverter.UnicodePrecompose;
import greekconverter.UnicodeToAscii;
import greekconverter.UnicodeToBetacode;
import greekconverter.UnicodeToGreekKeys;
import greekconverter.UnicodeToHtml;
import greekconverter.UnicodeToName;

public class VersionInfo {
    public static final String DEVELOPER_MN = "Michael Neuhold <homepage.neuhold@aon.at>";
    public static final int CLASSINFO_VERSION_DATE = 0;
    public static final int CLASSINFO_PROG_DESCR = 1;
    public static final int CLASSINFO_DEVELOPER = 2;
    private static int currVersionDate;
    private static int maxVersionDate;
    private static String currVersionDateString;
    private static String maxVersionDateString;
    private static String[] months;
    private static final String blanks = "                                                                                ";

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "21-Jun-2004";
                break;
            }
            case 1: {
                string = "Prints out version info";
                break;
            }
            case 2: {
                string = DEVELOPER_MN;
                break;
            }
            default: {
                string = "Medio tutissimus ibis.";
            }
        }
        return string;
    }

    private static int getNumericDate(String string) {
        int n = Integer.parseInt(string.substring(7));
        String string2 = string.substring(3, 6);
        int n2 = Integer.parseInt(string.substring(0, 2));
        int n3 = 0;
        while (n3 < 12) {
            if (months[n3].equalsIgnoreCase(string2)) break;
            ++n3;
        }
        return n2 + (n3 + 1) * 100 + n * 10000;
    }

    private static String pad(String string, int n) {
        return string + blanks.substring(0, n - string.length());
    }

    private static void checkDate(String string) {
        System.out.println(VersionInfo.pad(string, 25) + ": " + currVersionDateString);
        currVersionDate = VersionInfo.getNumericDate(currVersionDateString);
        if (currVersionDate > maxVersionDate) {
            maxVersionDate = currVersionDate;
            maxVersionDateString = currVersionDateString;
        }
    }

    public static void main(String[] stringArray) {
        int n = 0;
        System.out.println("\n- = g r e e k c o n v e r t e r = -");
        System.out.println("Package for conversion between various representations of accented Greek");
        System.out.println("Written and currently maintained by Michael Neuhold <homepage.neuhold@aon.at>");
        System.out.println("\nConversion classes:\n===================");
        currVersionDateString = AsciiToBetacode.getClassInfo(n);
        VersionInfo.checkDate("AsciiToBetacode");
        currVersionDateString = BetacodeToSPIonic.getClassInfo(n);
        VersionInfo.checkDate("BetacodeToSPIonic");
        currVersionDateString = BetacodeToUnicode.getClassInfo(n);
        VersionInfo.checkDate("BetacodeToUnicode");
        currVersionDateString = BibleWorksToBetacode.getClassInfo(n);
        VersionInfo.checkDate("BibleWorksToBetacode");
        currVersionDateString = BibleWorksToUnicode.getClassInfo(n);
        VersionInfo.checkDate("BibleWorksToUnicode");
        currVersionDateString = GreekKeysToUnicode.getClassInfo(n);
        VersionInfo.checkDate("GreekKeysToUnicode");
        currVersionDateString = UnicodeDecompose.getClassInfo(n);
        VersionInfo.checkDate("UnicodeDecompose");
        currVersionDateString = UnicodePrecompose.getClassInfo(n);
        VersionInfo.checkDate("UnicodePrecompose");
        currVersionDateString = UnicodeToAscii.getClassInfo(n);
        VersionInfo.checkDate("UnicodeToAscii");
        currVersionDateString = UnicodeToBetacode.getClassInfo(n);
        VersionInfo.checkDate("UnicodeToBetacode");
        currVersionDateString = UnicodeToGreekKeys.getClassInfo(n);
        VersionInfo.checkDate("UnicodeToGreekKeys");
        currVersionDateString = UnicodeToHtml.getClassInfo(n);
        VersionInfo.checkDate("UnicodeToHtml");
        currVersionDateString = UnicodeToName.getClassInfo(n);
        VersionInfo.checkDate("UnicodeToName");
        System.out.println("\nWrapper classes:\n================");
        currVersionDateString = GreekConverter.getClassInfo(n);
        VersionInfo.checkDate("GreekConverter");
        currVersionDateString = GreekFileConverter.getClassInfo(n);
        VersionInfo.checkDate("GreekFileConverter");
        currVersionDateString = Nereus.getClassInfo(n);
        VersionInfo.checkDate("Nereus");
        System.out.println("\nHelper classes:\n===============");
        currVersionDateString = CodeCharts.getClassInfo(n);
        VersionInfo.checkDate("CodeCharts");
        currVersionDateString = DynShortArray.getClassInfo(n);
        VersionInfo.checkDate("DynShortArray");
        currVersionDateString = GreekConvCaps.getClassInfo(n);
        VersionInfo.checkDate("GreekConvCaps");
        currVersionDateString = MessageHandler.getClassInfo(n);
        VersionInfo.checkDate("MessageHandler");
        currVersionDateString = UC.getClassInfo(n);
        VersionInfo.checkDate("UC");
        currVersionDateString = VersionInfo.getClassInfo(n);
        VersionInfo.checkDate("VersionInfo");
        System.out.println("\n---");
        System.out.println(VersionInfo.pad("Latest version date", 25) + ": " + maxVersionDateString);
        System.out.println("---");
    }

    static {
        maxVersionDate = 0;
        months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

