/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

public class UnicodeToName {
    private static final String NOT_SUPPORTED = new String(": Not supported by GreekConverter");
    private static final String NOT_ASSIGNED = new String(": Reserved (not yet assigned)");
    private static final String[][] tblLookup = new String[256][];
    private static final String[] tblLatin1 = new String[256];
    private static final String[] tblModif = new String[256];
    private static final String[] tblDiacritGreek = new String[256];
    private static final String[] tblGreekExtended = new String[256];
    private static final String[] tblPunct = new String[256];
    private static final String[] tblNotSupported = new String[256];

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "01-Apr-2002";
                break;
            }
            case 1: {
                string = "Converts Unicode into official character names";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Amicus certus in re incerta cernitur.";
            }
        }
        return string;
    }

    public static final String convertString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 50);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(UnicodeToName.convertChar(string.charAt(n2)) + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    static final String convertChar(char c) {
        String string = tblLookup[c >> 8][c & 0xFF];
        if (string == NOT_SUPPORTED || string == NOT_ASSIGNED) {
            return "U+" + Integer.toHexString(c) + string;
        }
        return string;
    }

    static {
        int n = 0;
        while (n < 256) {
            UnicodeToName.tblLookup[n] = tblNotSupported;
            UnicodeToName.tblNotSupported[n] = NOT_SUPPORTED;
            UnicodeToName.tblModif[n] = NOT_SUPPORTED;
            UnicodeToName.tblDiacritGreek[n] = NOT_ASSIGNED;
            UnicodeToName.tblGreekExtended[n] = NOT_ASSIGNED;
            UnicodeToName.tblPunct[n] = NOT_SUPPORTED;
            ++n;
        }
        UnicodeToName.tblLookup[0] = tblLatin1;
        UnicodeToName.tblLookup[2] = tblModif;
        UnicodeToName.tblLookup[3] = tblDiacritGreek;
        UnicodeToName.tblLookup[31] = tblGreekExtended;
        UnicodeToName.tblLookup[32] = tblPunct;
        UnicodeToName.tblLatin1[0] = "<control> NULL";
        UnicodeToName.tblLatin1[1] = "<control> START OF HEADING";
        UnicodeToName.tblLatin1[2] = "<control> START OF TEXT";
        UnicodeToName.tblLatin1[3] = "<control> END OF TEXT";
        UnicodeToName.tblLatin1[4] = "<control> END OF TRANSMISSION";
        UnicodeToName.tblLatin1[5] = "<control> ENQUIRY";
        UnicodeToName.tblLatin1[6] = "<control> ACKNOWLEDGE";
        UnicodeToName.tblLatin1[7] = "<control> BELL";
        UnicodeToName.tblLatin1[8] = "<control> BACKSPACE";
        UnicodeToName.tblLatin1[9] = "<control> HORIZONTAL TABULATION";
        UnicodeToName.tblLatin1[10] = "<control> LINE FEED";
        UnicodeToName.tblLatin1[11] = "<control> VERTICAL TABULATION";
        UnicodeToName.tblLatin1[12] = "<control> FORM FEED";
        UnicodeToName.tblLatin1[13] = "<control> CARRIAGE RETURN";
        UnicodeToName.tblLatin1[14] = "<control> SHIFT OUT";
        UnicodeToName.tblLatin1[15] = "<control> SHIFT IN";
        UnicodeToName.tblLatin1[16] = "<control> DATA LINK ESCAPE";
        UnicodeToName.tblLatin1[17] = "<control> DEVICE CONTROL ONE";
        UnicodeToName.tblLatin1[18] = "<control> DEVICE CONTROL TWO";
        UnicodeToName.tblLatin1[19] = "<control> DEVICE CONTROL THREE";
        UnicodeToName.tblLatin1[20] = "<control> DEVICE CONTROL FOUR";
        UnicodeToName.tblLatin1[21] = "<control> NEGATIVE ACKNOWLEDGE";
        UnicodeToName.tblLatin1[22] = "<control> SYNCHRONOUS IDLE";
        UnicodeToName.tblLatin1[23] = "<control> END OF TRANSMISSION BLOCK";
        UnicodeToName.tblLatin1[24] = "<control> CANCEL";
        UnicodeToName.tblLatin1[25] = "<control> END OF MEDIUM";
        UnicodeToName.tblLatin1[26] = "<control> SUBSTITUTE";
        UnicodeToName.tblLatin1[27] = "<control> ESCAPE";
        UnicodeToName.tblLatin1[28] = "<control> FILE SEPARATOR";
        UnicodeToName.tblLatin1[29] = "<control> GROUP SEPARATOR";
        UnicodeToName.tblLatin1[30] = "<control> RECORD SEPARATOR";
        UnicodeToName.tblLatin1[31] = "<control> UNIT SEPARATOR";
        UnicodeToName.tblLatin1[32] = "SPACE";
        UnicodeToName.tblLatin1[33] = "EXCLAMATION MARK";
        UnicodeToName.tblLatin1[34] = "QUOTATION MARK";
        UnicodeToName.tblLatin1[35] = "NUMBER SIGN (hash, crosshatch)";
        UnicodeToName.tblLatin1[36] = "DOLLAR SIGN";
        UnicodeToName.tblLatin1[37] = "PERCENT SIGN";
        UnicodeToName.tblLatin1[38] = "AMPERSAND";
        UnicodeToName.tblLatin1[39] = "APOSTROPHE = APOSTROPHE-QUOTE = APL";
        UnicodeToName.tblLatin1[40] = "LEFT PARENTHESIS = OPENING PARENTHESIS";
        UnicodeToName.tblLatin1[41] = "RIGHT PARENTHESIS = CLOSING PARENTHESIS";
        UnicodeToName.tblLatin1[42] = "ASTERISK (star)";
        UnicodeToName.tblLatin1[43] = "PLUS SIGN";
        UnicodeToName.tblLatin1[44] = "COMMA";
        UnicodeToName.tblLatin1[45] = "HYPHEN-MINUS";
        UnicodeToName.tblLatin1[46] = "FULL STOP = PERIOD";
        UnicodeToName.tblLatin1[47] = "SOLIDUS = SLASH";
        UnicodeToName.tblLatin1[48] = "DIGIT ZERO";
        UnicodeToName.tblLatin1[49] = "DIGIT ONE";
        UnicodeToName.tblLatin1[50] = "DIGIT TWO";
        UnicodeToName.tblLatin1[51] = "DIGIT THREE";
        UnicodeToName.tblLatin1[52] = "DIGIT FOUR";
        UnicodeToName.tblLatin1[53] = "DIGIT FIVE";
        UnicodeToName.tblLatin1[54] = "DIGIT SIX";
        UnicodeToName.tblLatin1[55] = "DIGIT SEVEN";
        UnicodeToName.tblLatin1[56] = "DIGIT EIGHT";
        UnicodeToName.tblLatin1[57] = "DIGIT NINE";
        UnicodeToName.tblLatin1[58] = "COLON";
        UnicodeToName.tblLatin1[59] = "SEMICOLON";
        UnicodeToName.tblLatin1[60] = "LESS-THAN SIGN";
        UnicodeToName.tblLatin1[61] = "EQUALS SIGN";
        UnicodeToName.tblLatin1[62] = "GREATER-THAN SIGN";
        UnicodeToName.tblLatin1[63] = "QUESTION MARK";
        UnicodeToName.tblLatin1[64] = "COMMERCIAL AT";
        UnicodeToName.tblLatin1[65] = "LATIN CAPITAL LETTER A";
        UnicodeToName.tblLatin1[66] = "LATIN CAPITAL LETTER B";
        UnicodeToName.tblLatin1[67] = "LATIN CAPITAL LETTER C";
        UnicodeToName.tblLatin1[68] = "LATIN CAPITAL LETTER D";
        UnicodeToName.tblLatin1[69] = "LATIN CAPITAL LETTER E";
        UnicodeToName.tblLatin1[70] = "LATIN CAPITAL LETTER F";
        UnicodeToName.tblLatin1[71] = "LATIN CAPITAL LETTER G";
        UnicodeToName.tblLatin1[72] = "LATIN CAPITAL LETTER H";
        UnicodeToName.tblLatin1[73] = "LATIN CAPITAL LETTER I";
        UnicodeToName.tblLatin1[74] = "LATIN CAPITAL LETTER J";
        UnicodeToName.tblLatin1[75] = "LATIN CAPITAL LETTER K";
        UnicodeToName.tblLatin1[76] = "LATIN CAPITAL LETTER L";
        UnicodeToName.tblLatin1[77] = "LATIN CAPITAL LETTER M";
        UnicodeToName.tblLatin1[78] = "LATIN CAPITAL LETTER N";
        UnicodeToName.tblLatin1[79] = "LATIN CAPITAL LETTER O";
        UnicodeToName.tblLatin1[80] = "LATIN CAPITAL LETTER P";
        UnicodeToName.tblLatin1[81] = "LATIN CAPITAL LETTER Q";
        UnicodeToName.tblLatin1[82] = "LATIN CAPITAL LETTER R";
        UnicodeToName.tblLatin1[83] = "LATIN CAPITAL LETTER S";
        UnicodeToName.tblLatin1[84] = "LATIN CAPITAL LETTER T";
        UnicodeToName.tblLatin1[85] = "LATIN CAPITAL LETTER U";
        UnicodeToName.tblLatin1[86] = "LATIN CAPITAL LETTER V";
        UnicodeToName.tblLatin1[87] = "LATIN CAPITAL LETTER W";
        UnicodeToName.tblLatin1[88] = "LATIN CAPITAL LETTER X";
        UnicodeToName.tblLatin1[89] = "LATIN CAPITAL LETTER Y";
        UnicodeToName.tblLatin1[90] = "LATIN CAPITAL LETTER Z";
        UnicodeToName.tblLatin1[91] = "LEFT SQUARE BRACKET = OPENING SQUARE BRACKET";
        UnicodeToName.tblLatin1[92] = "REVERSE SOLIDUS = BACKSLASH";
        UnicodeToName.tblLatin1[93] = "RIGHT SQUARE BRACKET = CLOSING SQUARE BRACKET";
        UnicodeToName.tblLatin1[94] = "CIRCUMFLEX ACCENT";
        UnicodeToName.tblLatin1[95] = "LOW LINE = SPACING UNDERSCORE";
        UnicodeToName.tblLatin1[96] = "GRAVE ACCENT";
        UnicodeToName.tblLatin1[97] = "LATIN SMALL LETTER A";
        UnicodeToName.tblLatin1[98] = "LATIN SMALL LETTER B";
        UnicodeToName.tblLatin1[99] = "LATIN SMALL LETTER C";
        UnicodeToName.tblLatin1[100] = "LATIN SMALL LETTER D";
        UnicodeToName.tblLatin1[101] = "LATIN SMALL LETTER E";
        UnicodeToName.tblLatin1[102] = "LATIN SMALL LETTER F";
        UnicodeToName.tblLatin1[103] = "LATIN SMALL LETTER G";
        UnicodeToName.tblLatin1[104] = "LATIN SMALL LETTER H";
        UnicodeToName.tblLatin1[105] = "LATIN SMALL LETTER I";
        UnicodeToName.tblLatin1[106] = "LATIN SMALL LETTER J";
        UnicodeToName.tblLatin1[107] = "LATIN SMALL LETTER K";
        UnicodeToName.tblLatin1[108] = "LATIN SMALL LETTER L";
        UnicodeToName.tblLatin1[109] = "LATIN SMALL LETTER M";
        UnicodeToName.tblLatin1[110] = "LATIN SMALL LETTER N";
        UnicodeToName.tblLatin1[111] = "LATIN SMALL LETTER O";
        UnicodeToName.tblLatin1[112] = "LATIN SMALL LETTER P";
        UnicodeToName.tblLatin1[113] = "LATIN SMALL LETTER Q";
        UnicodeToName.tblLatin1[114] = "LATIN SMALL LETTER R";
        UnicodeToName.tblLatin1[115] = "LATIN SMALL LETTER S";
        UnicodeToName.tblLatin1[116] = "LATIN SMALL LETTER T";
        UnicodeToName.tblLatin1[117] = "LATIN SMALL LETTER U";
        UnicodeToName.tblLatin1[118] = "LATIN SMALL LETTER V";
        UnicodeToName.tblLatin1[119] = "LATIN SMALL LETTER W";
        UnicodeToName.tblLatin1[120] = "LATIN SMALL LETTER X";
        UnicodeToName.tblLatin1[121] = "LATIN SMALL LETTER Y";
        UnicodeToName.tblLatin1[122] = "LATIN SMALL LETTER Z";
        UnicodeToName.tblLatin1[123] = "LEFT CURLY BRACKET = OPENING CURLY BRACKET";
        UnicodeToName.tblLatin1[124] = "VERTICAL LINE = VERTICAL BAR";
        UnicodeToName.tblLatin1[125] = "RIGHT CURLY BRACKET = CLOSLING CURLY BRACKET";
        UnicodeToName.tblLatin1[126] = "TILDE";
        UnicodeToName.tblLatin1[127] = "<control> DELETE";
        UnicodeToName.tblLatin1[128] = "<control>";
        UnicodeToName.tblLatin1[129] = "<control>";
        UnicodeToName.tblLatin1[130] = "<control> BREAK PERMITTED HERE";
        UnicodeToName.tblLatin1[131] = "<control> NO BREAK HERE";
        UnicodeToName.tblLatin1[132] = "<control>";
        UnicodeToName.tblLatin1[133] = "<control> NEXT LINE";
        UnicodeToName.tblLatin1[134] = "<control> START OF SELECTED AREA";
        UnicodeToName.tblLatin1[135] = "<control> END OF SELECTED AREA";
        UnicodeToName.tblLatin1[136] = "<control> CHARACTER TABULATION SET";
        UnicodeToName.tblLatin1[137] = "<control> CHARACTER TABULATION WITH JUSTIFICATION";
        UnicodeToName.tblLatin1[138] = "<control> LINE TABULATION SET";
        UnicodeToName.tblLatin1[139] = "<control> PARTIAL LINE DOWN";
        UnicodeToName.tblLatin1[140] = "<control> PARTIAL LINE UP";
        UnicodeToName.tblLatin1[141] = "<control> REVERSE LINE FEED";
        UnicodeToName.tblLatin1[142] = "<control> SINGLE SHIFT TWO";
        UnicodeToName.tblLatin1[143] = "<control> SINGLE SHIFT THREE";
        UnicodeToName.tblLatin1[144] = "<control> DEVICE CONTROL STRING";
        UnicodeToName.tblLatin1[145] = "<control> PRIVATE USE ONE";
        UnicodeToName.tblLatin1[146] = "<control> PRIVATE USE TWO";
        UnicodeToName.tblLatin1[147] = "<control> SET TRANSMIT STATE";
        UnicodeToName.tblLatin1[148] = "<control> CANCEL CHARACTER";
        UnicodeToName.tblLatin1[149] = "<control> MESSAGE WAITING";
        UnicodeToName.tblLatin1[150] = "<control> START OF GUARDED AREA";
        UnicodeToName.tblLatin1[151] = "<control> END OF GUARDED AREA";
        UnicodeToName.tblLatin1[152] = "<control> START OF STRING";
        UnicodeToName.tblLatin1[153] = "<control>";
        UnicodeToName.tblLatin1[154] = "<control> SINGLE CHARACTER INTRODUCER";
        UnicodeToName.tblLatin1[155] = "<control> CONTROL SEQUENCE INTRODUCER";
        UnicodeToName.tblLatin1[156] = "<control> STRING TERMINATOR";
        UnicodeToName.tblLatin1[157] = "<control> OPERATING SYSTEM COMMAND";
        UnicodeToName.tblLatin1[158] = "<control> PRIVACY MESSAGE";
        UnicodeToName.tblLatin1[159] = "<control> APPLICATION PROGRAM COMMAND";
        UnicodeToName.tblLatin1[160] = "NO-BREAK SPACE";
        UnicodeToName.tblLatin1[161] = "INVERTED EXCLAMATION MARK";
        UnicodeToName.tblLatin1[162] = "CENT SIGN";
        UnicodeToName.tblLatin1[163] = "POUND SIGN";
        UnicodeToName.tblLatin1[164] = "CURRENCY SIGN";
        UnicodeToName.tblLatin1[165] = "YEN SIGN";
        UnicodeToName.tblLatin1[166] = "BROKEN BAR = BROKEN VERTICAL BAR";
        UnicodeToName.tblLatin1[167] = "SECTION SIGN (paragraph sign)";
        UnicodeToName.tblLatin1[168] = "DIAERESIS";
        UnicodeToName.tblLatin1[169] = "COPYRIGHT SIGN";
        UnicodeToName.tblLatin1[170] = "FEMININE ORDINAL INDICATOR";
        UnicodeToName.tblLatin1[171] = "LEFT-POINTING DOUBLE ANGLE QUOTATION MARK = LEFT POINTING GUILLEMET (chevrons)";
        UnicodeToName.tblLatin1[172] = "NOT SIGN";
        UnicodeToName.tblLatin1[173] = "<control> SOFT HYPHEN";
        UnicodeToName.tblLatin1[174] = "REGISTERED SIGN = REGISTERED TRADE MARK SIGN";
        UnicodeToName.tblLatin1[175] = "MACRON";
        UnicodeToName.tblLatin1[176] = "DEGREE SIGN";
        UnicodeToName.tblLatin1[177] = "PLUS-MINUS SIGN";
        UnicodeToName.tblLatin1[178] = "SUPERSCRIPT TWO";
        UnicodeToName.tblLatin1[179] = "SUPERSCRIPT THREE";
        UnicodeToName.tblLatin1[180] = "ACUTE ACCENT";
        UnicodeToName.tblLatin1[181] = "MICRO SIGN";
        UnicodeToName.tblLatin1[182] = "PILCROW SIGN = PARAGRAPH SIGN";
        UnicodeToName.tblLatin1[183] = "MIDDLE DOT";
        UnicodeToName.tblLatin1[184] = "CEDILLA";
        UnicodeToName.tblLatin1[185] = "SUPERSCRIPT ONE";
        UnicodeToName.tblLatin1[186] = "MASCULINE ORDINAL INDICATOR";
        UnicodeToName.tblLatin1[187] = "RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK = RIGHT POINTING GUILLEMET";
        UnicodeToName.tblLatin1[188] = "VULGAR FRACTION ONE QUARTER";
        UnicodeToName.tblLatin1[189] = "VULGAR FRACTION ONE HALF";
        UnicodeToName.tblLatin1[190] = "VULGAR FRACTION THREE QUARTERS";
        UnicodeToName.tblLatin1[191] = "INVERTED QUESTION MARK";
        UnicodeToName.tblLatin1[192] = "LATIN CAPITAL LETTER A WITH GRAVE";
        UnicodeToName.tblLatin1[193] = "LATIN CAPITAL LETTER A WITH ACUTE";
        UnicodeToName.tblLatin1[194] = "LATIN CAPITAL LETTER A WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[195] = "LATIN CAPITAL LETTER A WITH TILDE";
        UnicodeToName.tblLatin1[196] = "LATIN CAPITAL LETTER A WITH DIAERESIS (umlaut A)";
        UnicodeToName.tblLatin1[197] = "LATIN CAPITAL LETTER A WITH RING ABOVE (angstrom sign)";
        UnicodeToName.tblLatin1[198] = "LATIN CAPITAL LETTER AE = LATIN CAPITAL LIGATURE AE";
        UnicodeToName.tblLatin1[199] = "LATIN CAPITAL LETTER C WITH CEDILLA";
        UnicodeToName.tblLatin1[200] = "LATIN CAPITAL LETTER E WITH GRAVE";
        UnicodeToName.tblLatin1[201] = "LATIN CAPITAL LETTER E WITH ACUTE";
        UnicodeToName.tblLatin1[202] = "LATIN CAPITAL LETTER E WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[203] = "LATIN CAPITAL LETTER E WITH DIAERESIS";
        UnicodeToName.tblLatin1[204] = "LATIN CAPITAL LETTER I WITH GRAVE";
        UnicodeToName.tblLatin1[205] = "LATIN CAPITAL LETTER I WITH ACUTE";
        UnicodeToName.tblLatin1[206] = "LATIN CAPITAL LETTER I WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[207] = "LATIN CAPITAL LETTER I WITH DIAERESIS";
        UnicodeToName.tblLatin1[208] = "LATIN CAPITAL LETTER ETH";
        UnicodeToName.tblLatin1[209] = "LATIN CAPITAL LETTER N WITH TILDE";
        UnicodeToName.tblLatin1[210] = "LATIN CAPITAL LETTER O WITH GRAVE";
        UnicodeToName.tblLatin1[211] = "LATIN CAPITAL LETTER O WITH ACUTE";
        UnicodeToName.tblLatin1[212] = "LATIN CAPITAL LETTER O WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[213] = "LATIN CAPITAL LETTER O WITH TILDE";
        UnicodeToName.tblLatin1[214] = "LATIN CAPITAL LETTER O WITH DIAERESIS";
        UnicodeToName.tblLatin1[215] = "MULTIPLICATION SIGN";
        UnicodeToName.tblLatin1[216] = "LATIN CAPITAL LETTER O WITH STROKE = LATIN CAPITAL LETTER O SLASH";
        UnicodeToName.tblLatin1[217] = "LATIN CAPITAL LETTER U WITH GRAVE";
        UnicodeToName.tblLatin1[218] = "LATIN CAPITAL LETTER U WITH ACUTE";
        UnicodeToName.tblLatin1[219] = "LATIN CAPITAL LETTER U WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[220] = "LATIN CAPITAL LETTER U WITH DIAERESIS";
        UnicodeToName.tblLatin1[221] = "LATIN CAPITAL LETTER Y WITH ACUTE";
        UnicodeToName.tblLatin1[222] = "LATIN CAPITAL LETTER THORN";
        UnicodeToName.tblLatin1[223] = "LATIN SMALL LETTER SHARP S (Eszett)";
        UnicodeToName.tblLatin1[224] = "LATIN SMALL LETTER A WITH GRAVE";
        UnicodeToName.tblLatin1[225] = "LATIN SMALL LETTER A WITH ACUTE";
        UnicodeToName.tblLatin1[226] = "LATIN SMALL LETTER A WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[227] = "LATIN SMALL LETTER A WITH TILDE";
        UnicodeToName.tblLatin1[228] = "LATIN SMALL LETTER A WITH DIAERESIS";
        UnicodeToName.tblLatin1[229] = "LATIN SMALL LETTER A WITH RING ABOVE";
        UnicodeToName.tblLatin1[230] = "LATIN SMALL LETTER AE = LATIN SMALL LIGATURE AE (ash)";
        UnicodeToName.tblLatin1[231] = "LATIN SMALL LETTER C WITH CEDILLA";
        UnicodeToName.tblLatin1[232] = "LATIN SMALL LETTER E WITH GRAVE";
        UnicodeToName.tblLatin1[233] = "LATIN SMALL LETTER E WITH ACUTE";
        UnicodeToName.tblLatin1[234] = "LATIN SMALL LETTER E WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[235] = "LATIN SMALL LETTER E WITH DIAERESIS";
        UnicodeToName.tblLatin1[236] = "LATIN SMALL LETTER I WITH GRAVE";
        UnicodeToName.tblLatin1[237] = "LATIN SMALL LETTER I WITH ACUTE";
        UnicodeToName.tblLatin1[238] = "LATIN SMALL LETTER I WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[239] = "LATIN SMALL LETTER I WITH DIAERESIS";
        UnicodeToName.tblLatin1[240] = "LATIN SMALL LETTER ETH";
        UnicodeToName.tblLatin1[241] = "LATIN SMALL LETTER N WITH TILDE";
        UnicodeToName.tblLatin1[242] = "LATIN SMALL LETTER O WITH GRAVE";
        UnicodeToName.tblLatin1[243] = "LATIN SMALL LETTER O WITH ACUTE";
        UnicodeToName.tblLatin1[244] = "LATIN SMALL LETTER O WITH CICRUMFLEX";
        UnicodeToName.tblLatin1[245] = "LATIN SMALL LETTER O WITH TILDE";
        UnicodeToName.tblLatin1[246] = "LATIN SMALL LETTER O WITH DIAERESIS";
        UnicodeToName.tblLatin1[247] = "DIVISION SIGN";
        UnicodeToName.tblLatin1[248] = "LATIN SMALL LETTER O WITH STROKE = LATIN SMALL LETTER O SLASH";
        UnicodeToName.tblLatin1[249] = "LATIN SMALL LETTER U WITH GRAVE";
        UnicodeToName.tblLatin1[250] = "LATIN SMALL LETTER U WITH ACUTE";
        UnicodeToName.tblLatin1[251] = "LATIN SMALL LETTER U WITH CIRCUMFLEX";
        UnicodeToName.tblLatin1[252] = "LATIN SMALL LETTER U WITH DIAERESIS";
        UnicodeToName.tblLatin1[253] = "LATIN SMALL LETTER Y WITH ACUTE";
        UnicodeToName.tblLatin1[254] = "LATIN SMALL LETTER THORN";
        UnicodeToName.tblLatin1[255] = "LATIN SMALL LETTER Y WITH DIAERESIS";
        UnicodeToName.tblModif[176] = "MODIFIER LETTER SMALL H";
        UnicodeToName.tblModif[177] = "MODIFIER LETTER SMALL H WITH HOOK";
        UnicodeToName.tblModif[178] = "MODIFIER LETTER SMALL J";
        UnicodeToName.tblModif[179] = "MODIFIER LETTER SMALL R";
        UnicodeToName.tblModif[180] = "MODIFIER LETTER SMALL TURNED R";
        UnicodeToName.tblModif[181] = "MODIFIER LETTER SMALL TURNED R WITH HOOK";
        UnicodeToName.tblModif[182] = "MODIFIER LETTER SMALL CAPITAL INVERTED R";
        UnicodeToName.tblModif[183] = "MODIFIER LETTER SMALL W";
        UnicodeToName.tblModif[184] = "MODIFIER LETTER SMALL Y";
        UnicodeToName.tblModif[185] = "MODIFIER LETTER PRIME";
        UnicodeToName.tblModif[186] = "MODIFIER LETTER DOUBLE PRIME";
        UnicodeToName.tblModif[187] = "MODIFIER LETTER TURNED COMMA";
        UnicodeToName.tblModif[188] = "MODIFIER LETTER APOSTROPHE";
        UnicodeToName.tblModif[189] = "MODIFIER LETTER REVERSED COMMA";
        UnicodeToName.tblModif[190] = "MODIFIER LETTER RIGHT HALF RING";
        UnicodeToName.tblModif[191] = "MODIFIER LETTER LEFT HALF RING";
        UnicodeToName.tblModif[192] = "MODIFIER LETTER GLOTTAL STOP";
        UnicodeToName.tblModif[193] = "MODIFIER LETTER REVERSED GLOTTAL STOP";
        UnicodeToName.tblModif[194] = "MODIFIER LETTER LEFT ARROWHEAD";
        UnicodeToName.tblModif[195] = "MODIFIER LETTER RIGHT ARROWHEAD";
        UnicodeToName.tblModif[196] = "MODIFIER LETTER UP ARROWHEAD";
        UnicodeToName.tblModif[197] = "MODIFIER LETTER DOWN ARROWHEAD";
        UnicodeToName.tblModif[198] = "MODIFIER LETTER CIRCUMFLEX ACCENT";
        UnicodeToName.tblModif[199] = "CARON";
        UnicodeToName.tblModif[200] = "MODIFIER LETTER VERTICAL LINE";
        UnicodeToName.tblModif[201] = "MODIFIER LETTER MACRON";
        UnicodeToName.tblModif[202] = "MODIFIER LETTER ACUTE ACCENT";
        UnicodeToName.tblModif[203] = "MODIFIER LETTER GRAVE ACCENT";
        UnicodeToName.tblModif[204] = "MODIFIER LETTER LOW VERTICAL LINE";
        UnicodeToName.tblModif[205] = "MODIFIER LETTER LOW MACRON";
        UnicodeToName.tblModif[206] = "MODIFIER LETTER LOW GRAVE ACCENT";
        UnicodeToName.tblModif[207] = "MODIFIER LETTER LOW ACUTE ACCENT";
        UnicodeToName.tblModif[208] = "MODIFIER LETTER TRIANGULAR COLON";
        UnicodeToName.tblModif[209] = "MODIFIER LETTER HALF TRIANGULAR COLON";
        UnicodeToName.tblModif[210] = "MODIFIER LETTER CENTRED RIGHT HALF RING";
        UnicodeToName.tblModif[211] = "MODIFIER LETTER CENTRED LEFT HALF RING";
        UnicodeToName.tblModif[212] = "MODIFIER LETTER UP TACK";
        UnicodeToName.tblModif[213] = "MODIFIER LETTER DOWN TACK";
        UnicodeToName.tblModif[214] = "MODIFIER LETTER PLUS SIGN";
        UnicodeToName.tblModif[215] = "MODIFIER LETTER MINUS SIGN";
        UnicodeToName.tblModif[216] = "BREVE";
        UnicodeToName.tblModif[217] = "DOT ABOVE";
        UnicodeToName.tblModif[218] = "RING ABOVE";
        UnicodeToName.tblModif[219] = "OGONEK";
        UnicodeToName.tblModif[220] = "SMALL TILDE";
        UnicodeToName.tblModif[221] = "DOUBLE ACUTE ACCENT";
        UnicodeToName.tblModif[222] = "MODIFIER LETTER RHOTIC HOOK";
        UnicodeToName.tblModif[223] = "MODIFIER LETTER CROSS ACCENT";
        UnicodeToName.tblModif[224] = "MODIFIER LETTER SMALL GAMMA";
        UnicodeToName.tblModif[225] = "MODIFIER LETTER SMALL L";
        UnicodeToName.tblModif[226] = "MODIFIER LETTER SMALL S";
        UnicodeToName.tblModif[227] = "MODIFIER LETTER SMALL X";
        UnicodeToName.tblModif[228] = "MODIFIER LETTER SMALL REVERSED GLOTTAL STOP";
        UnicodeToName.tblModif[229] = "MODIFIER LETTER EXTRA-HIGH TONE BAR";
        UnicodeToName.tblModif[230] = "MODIFIER LETTER HIGH TONE BAR";
        UnicodeToName.tblModif[231] = "MODIFIER LETTER MID TONE BAR";
        UnicodeToName.tblModif[232] = "MODIFIER LETTER LOW TONE BAR";
        UnicodeToName.tblModif[233] = "MODIFIER LETTER EXTRA-LOW TONE BAR";
        UnicodeToName.tblModif[234] = "MODIFIER LETTER YIN DEPARTING TONE MARK";
        UnicodeToName.tblModif[235] = "MODIFIER LETTER YANG DEPARTING TONE MARK";
        UnicodeToName.tblModif[236] = "MODIFIER LETTER VOICING";
        UnicodeToName.tblModif[237] = "MODIFIER LETTER UNASPIRATED";
        UnicodeToName.tblModif[238] = "MODIFIER LETTER DOUBLE APOSTROPHE";
        UnicodeToName.tblDiacritGreek[0] = "COMBINING GRAVE ACCENT";
        UnicodeToName.tblDiacritGreek[1] = "COMBINING ACUTE ACCENT";
        UnicodeToName.tblDiacritGreek[2] = "COMBINING CIRCUMFLEX ACCENT";
        UnicodeToName.tblDiacritGreek[3] = "COMBINING TILDE";
        UnicodeToName.tblDiacritGreek[4] = "COMBINING MACRON";
        UnicodeToName.tblDiacritGreek[5] = "COMBINING OVERLINE";
        UnicodeToName.tblDiacritGreek[6] = "COMBINING BREVE (Greek vrachy)";
        UnicodeToName.tblDiacritGreek[7] = "COMBINING DOT ABOVE";
        UnicodeToName.tblDiacritGreek[8] = "COMBINING DIAERESIS (umlaut, Greek dialytika)";
        UnicodeToName.tblDiacritGreek[9] = "COMBINING HOOK ABOVE";
        UnicodeToName.tblDiacritGreek[10] = "COMBINING RING ABOVE";
        UnicodeToName.tblDiacritGreek[11] = "COMBINING DOUBLE ACUTE ACCENT";
        UnicodeToName.tblDiacritGreek[12] = "COMBINING CARON (hacek)";
        UnicodeToName.tblDiacritGreek[13] = "COMBINING VERTICAL LINE ABOVE";
        UnicodeToName.tblDiacritGreek[14] = "COMBINING DOUBLE VERTICAL LINE ABOVE";
        UnicodeToName.tblDiacritGreek[15] = "COMBINING DOUBLE GRAVE ACCENT";
        UnicodeToName.tblDiacritGreek[16] = "COMBINING CANDRABINDU";
        UnicodeToName.tblDiacritGreek[17] = "COMBINING INVERTED BREVE";
        UnicodeToName.tblDiacritGreek[18] = "COMBINING TURNED COMMA ABOVE (cedilla)";
        UnicodeToName.tblDiacritGreek[19] = "COMBINING COMMA ABOVE (Greek psili)";
        UnicodeToName.tblDiacritGreek[20] = "COMBINING REVERSED COMMA ABOVE (Greek dasia)";
        UnicodeToName.tblDiacritGreek[21] = "COMBINING COMMA ABOVE RIGHT";
        UnicodeToName.tblDiacritGreek[22] = "COMBINING GRAVE ACCENT BELOW";
        UnicodeToName.tblDiacritGreek[23] = "COMBINING ACUTE ACCENT BELOW";
        UnicodeToName.tblDiacritGreek[24] = "COMBINING LEFT TACK BELOW";
        UnicodeToName.tblDiacritGreek[25] = "COMBINING RIGHT TACK BELOW";
        UnicodeToName.tblDiacritGreek[26] = "COMBINING LEFT ANGLE ABOVE";
        UnicodeToName.tblDiacritGreek[27] = "COMBINING HORN";
        UnicodeToName.tblDiacritGreek[28] = "COMBINING LEFT HALF RING BELOW";
        UnicodeToName.tblDiacritGreek[29] = "COMBINING UP TACK BELOW";
        UnicodeToName.tblDiacritGreek[30] = "COMBINING DOWN TACK BELOW";
        UnicodeToName.tblDiacritGreek[31] = "COMBINING PLUS SIGN BELOW";
        UnicodeToName.tblDiacritGreek[32] = "COMBINING MINUS SIGN BELOW";
        UnicodeToName.tblDiacritGreek[33] = "COMBINING PALATALIZED HOOK BELOW";
        UnicodeToName.tblDiacritGreek[34] = "COMBINING RETROFLEX HOOK BELOW";
        UnicodeToName.tblDiacritGreek[35] = "COMBINING DOT BELOW (nang)";
        UnicodeToName.tblDiacritGreek[36] = "COMBINING DIAERESIS BELOW";
        UnicodeToName.tblDiacritGreek[37] = "COMBINING RING BELOW";
        UnicodeToName.tblDiacritGreek[38] = "COMBINING COMMA BELOW";
        UnicodeToName.tblDiacritGreek[39] = "COMBINING CEDILLA";
        UnicodeToName.tblDiacritGreek[40] = "COMBINING OGONEK";
        UnicodeToName.tblDiacritGreek[41] = "COMBINING VERTICAL LINE BELOW";
        UnicodeToName.tblDiacritGreek[42] = "COMBINING BRIDGE BELOW";
        UnicodeToName.tblDiacritGreek[43] = "COMBINING INVERTED DOUBLE ARCH BELOW";
        UnicodeToName.tblDiacritGreek[44] = "COMBINING CARON BELOW";
        UnicodeToName.tblDiacritGreek[45] = "COMBINING CIRCUMFLEX ACCENT BELOW";
        UnicodeToName.tblDiacritGreek[46] = "COMBINING BREVE BELOW";
        UnicodeToName.tblDiacritGreek[47] = "COMBINING INVERTED BREVE BELOW";
        UnicodeToName.tblDiacritGreek[48] = "COMBINING TILDE BELOW";
        UnicodeToName.tblDiacritGreek[49] = "COMBINING MACRON BELOW";
        UnicodeToName.tblDiacritGreek[50] = "COMBINING LOW LINE";
        UnicodeToName.tblDiacritGreek[51] = "COMBINING DOUBLE LOW LINE";
        UnicodeToName.tblDiacritGreek[52] = "COMBINING TILDE OVERLAY";
        UnicodeToName.tblDiacritGreek[53] = "COMBINING SHORT STROKE OVERLAY";
        UnicodeToName.tblDiacritGreek[54] = "COMBINING LONG STROKE OVERLAY";
        UnicodeToName.tblDiacritGreek[55] = "COMBINING SHORT SOLIDUS OVERLAY";
        UnicodeToName.tblDiacritGreek[56] = "COMBINING LONG SOLIDUS OVERLAY";
        UnicodeToName.tblDiacritGreek[57] = "COMBINING RIGHT HALF RING BELOW";
        UnicodeToName.tblDiacritGreek[58] = "COMBINING INVERTED BRIDGE BELOW";
        UnicodeToName.tblDiacritGreek[59] = "COMBINING SQUARE BELOW";
        UnicodeToName.tblDiacritGreek[60] = "COMBINING SEAGULL BELOW";
        UnicodeToName.tblDiacritGreek[61] = "COMBINING X ABOVE";
        UnicodeToName.tblDiacritGreek[62] = "COMBINING VERTICAL TILDE";
        UnicodeToName.tblDiacritGreek[63] = "COMBINING DOUBLE OVERLINE";
        UnicodeToName.tblDiacritGreek[64] = "COMBINING GRAVE TONE MARK";
        UnicodeToName.tblDiacritGreek[65] = "COMBINING ACUTE TONE MARK";
        UnicodeToName.tblDiacritGreek[66] = "COMBINING GREEK PERISPOMENI";
        UnicodeToName.tblDiacritGreek[67] = "COMBINING GREEK KORONIS";
        UnicodeToName.tblDiacritGreek[68] = "COMBINING GREEK DIALYTIKA TONOS";
        UnicodeToName.tblDiacritGreek[69] = "COMBINING GREEK YPOGEGRAMMENI = GRREK NON-SPACING IOTA BELOW (iota subcript and adscript)";
        UnicodeToName.tblDiacritGreek[70] = "COMBINING BRIDGE ABOVE";
        UnicodeToName.tblDiacritGreek[71] = "COMBINING EQUALS SIGN BELOW";
        UnicodeToName.tblDiacritGreek[72] = "COMBINING DOUBLE VERTICAL LINE BELOW";
        UnicodeToName.tblDiacritGreek[73] = "COMBINING LEFT ANGLE BELOW";
        UnicodeToName.tblDiacritGreek[74] = "COMBINING NOT TILDE ABOVE";
        UnicodeToName.tblDiacritGreek[75] = "COMBINING HOMOTHETIC ABOVE";
        UnicodeToName.tblDiacritGreek[76] = "COMBINING ALMOST EQUAL TO ABOVE";
        UnicodeToName.tblDiacritGreek[77] = "COMBINING LEFT RIGHT ARROW BELOW";
        UnicodeToName.tblDiacritGreek[78] = "COMBINING UPWARDS ARROW BELOW";
        UnicodeToName.tblDiacritGreek[96] = "COMBINING DOUBLE TILDE";
        UnicodeToName.tblDiacritGreek[97] = "COMBINING DOUBLE INVERTED BREVE";
        UnicodeToName.tblDiacritGreek[98] = "COMBINING DOUBLE RIGHTWARDS ARROW BELOW";
        UnicodeToName.tblDiacritGreek[116] = "GREEK NUMERAL SIGN (dexia keraia)";
        UnicodeToName.tblDiacritGreek[117] = "GREEK LOWER NUMERAL SIGN (aristeri keraia)";
        UnicodeToName.tblDiacritGreek[122] = "GREEK YPOGEGRAMMENI (iota subscript)";
        UnicodeToName.tblDiacritGreek[126] = "GREEK QUESTION MARK (erotimatiko)";
        UnicodeToName.tblDiacritGreek[132] = "GREEK TONOS";
        UnicodeToName.tblDiacritGreek[133] = "GREEK DIALYTIKA TONOS";
        UnicodeToName.tblDiacritGreek[134] = "GREEK CAPITAL LETTER ALPHA WITH TONOS";
        UnicodeToName.tblDiacritGreek[135] = "GREEK ANO TELEIA (Greek semicolon)";
        UnicodeToName.tblDiacritGreek[136] = "GREEK CAPITAL LETTER EPSILON WITH TONOS";
        UnicodeToName.tblDiacritGreek[137] = "GREEK CAPITAL LETTER ETA WITH TONOS";
        UnicodeToName.tblDiacritGreek[138] = "GREEK CAPITAL LETTER IOTA WITH TONOS";
        UnicodeToName.tblDiacritGreek[140] = "GREEK CAPITAL LETTER OMICRON WITH TONOS";
        UnicodeToName.tblDiacritGreek[142] = "GREEK CAPITAL LETTER UPSILON WITH TONOS";
        UnicodeToName.tblDiacritGreek[143] = "GREEK CAPITAL LETTER OMEGA WITH TONOS";
        UnicodeToName.tblDiacritGreek[144] = "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS";
        UnicodeToName.tblDiacritGreek[145] = "GREEK CAPITAL LETTER ALPHA";
        UnicodeToName.tblDiacritGreek[146] = "GREEK CAPITAL LETTER BETA";
        UnicodeToName.tblDiacritGreek[147] = "GREEK CAPITAL LETTER GAMMA";
        UnicodeToName.tblDiacritGreek[148] = "GREEK CAPITAL LETTER DELTA";
        UnicodeToName.tblDiacritGreek[149] = "GREEK CAPITAL LETTER EPSILON";
        UnicodeToName.tblDiacritGreek[150] = "GREEK CAPITAL LETTER ZETA";
        UnicodeToName.tblDiacritGreek[151] = "GREEK CAPITAL LETTER ETA";
        UnicodeToName.tblDiacritGreek[152] = "GREEK CAPITAL LETTER THETA";
        UnicodeToName.tblDiacritGreek[153] = "GREEK CAPITAL LETTER IOTA (iota adscript)";
        UnicodeToName.tblDiacritGreek[154] = "GREEK CAPITAL LETTER KAPPA";
        UnicodeToName.tblDiacritGreek[155] = "GREEK CAPITAL LETTER LAMDA";
        UnicodeToName.tblDiacritGreek[156] = "GREEK CAPITAL LETTER MU";
        UnicodeToName.tblDiacritGreek[157] = "GREEK CAPITAL LETTER NU";
        UnicodeToName.tblDiacritGreek[158] = "GREEK CAPITAL LETTER XI";
        UnicodeToName.tblDiacritGreek[159] = "GREEK CAPITAL LETTER OMICRON";
        UnicodeToName.tblDiacritGreek[160] = "GREEK CAPITAL LETTER PI";
        UnicodeToName.tblDiacritGreek[161] = "GREEK CAPITAL LETTER RHO";
        UnicodeToName.tblDiacritGreek[163] = "GREEK CAPITAL LETTER SIGMA";
        UnicodeToName.tblDiacritGreek[164] = "GREEK CAPITAL LETTER TAU";
        UnicodeToName.tblDiacritGreek[165] = "GREEK CAPITAL LETTER UPSILON";
        UnicodeToName.tblDiacritGreek[166] = "GREEK CAPITAL LETTER PHI";
        UnicodeToName.tblDiacritGreek[167] = "GREEK CAPITAL LETTER CHI";
        UnicodeToName.tblDiacritGreek[168] = "GREEK CAPITAL LETTER PSI";
        UnicodeToName.tblDiacritGreek[169] = "GREEK CAPITAL LETTER OMEGA";
        UnicodeToName.tblDiacritGreek[170] = "GREEK CAPITAL LETTER IOTA WITH DIALYTIKA";
        UnicodeToName.tblDiacritGreek[171] = "GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA";
        UnicodeToName.tblDiacritGreek[172] = "GREEK SMALL LETTER ALPHA WITH TONOS";
        UnicodeToName.tblDiacritGreek[173] = "GREEK SMALL LETTER EPSILON WITH TONOS";
        UnicodeToName.tblDiacritGreek[174] = "GREEK SMALL LETTER ETA WITH TONOS";
        UnicodeToName.tblDiacritGreek[175] = "GREEK SMALL LETTER IOTA WITH TONOS";
        UnicodeToName.tblDiacritGreek[176] = "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS";
        UnicodeToName.tblDiacritGreek[177] = "GREEK SMALL LETTER ALPHA";
        UnicodeToName.tblDiacritGreek[178] = "GREEK SMALL LETTER BETA";
        UnicodeToName.tblDiacritGreek[179] = "GREEK SMALL LETTER GAMMA";
        UnicodeToName.tblDiacritGreek[180] = "GREEK SMALL LETTER DELTA";
        UnicodeToName.tblDiacritGreek[181] = "GREEK SMALL LETTER EPSILON";
        UnicodeToName.tblDiacritGreek[182] = "GREEK SMALL LETTER ZETA";
        UnicodeToName.tblDiacritGreek[183] = "GREEK SMALL LETTER ETA";
        UnicodeToName.tblDiacritGreek[184] = "GREEK SMALL LETTER THETA";
        UnicodeToName.tblDiacritGreek[185] = "GREEK SMALL LETTER IOTA";
        UnicodeToName.tblDiacritGreek[186] = "GREEK SMALL LETTER KAPPA";
        UnicodeToName.tblDiacritGreek[187] = "GREEK SMALL LETTER LAMDA";
        UnicodeToName.tblDiacritGreek[188] = "GREEK SMALL LETTER MU";
        UnicodeToName.tblDiacritGreek[189] = "GREEK SMALL LETTER NU";
        UnicodeToName.tblDiacritGreek[190] = "GREEK SMALL LETTER XI";
        UnicodeToName.tblDiacritGreek[191] = "GREEK SMALL LETTER OMICRON";
        UnicodeToName.tblDiacritGreek[192] = "GREEK SMALL LETTER PI";
        UnicodeToName.tblDiacritGreek[193] = "GREEK SMALL LETTER RHO";
        UnicodeToName.tblDiacritGreek[194] = "GREEK SMALL LETTER FINAL SIGMA";
        UnicodeToName.tblDiacritGreek[195] = "GREEK SMALL LETTER SIGMA";
        UnicodeToName.tblDiacritGreek[196] = "GREEK SMALL LETTER TAU";
        UnicodeToName.tblDiacritGreek[197] = "GREEK SMALL LETTER UPSILON";
        UnicodeToName.tblDiacritGreek[198] = "GREEK SMALL LETTER PHI";
        UnicodeToName.tblDiacritGreek[199] = "GREEK SMALL LETTER CHI";
        UnicodeToName.tblDiacritGreek[200] = "GREEK SMALL LETTER PSI";
        UnicodeToName.tblDiacritGreek[201] = "GREEK SMALL LETTER OMEGA";
        UnicodeToName.tblDiacritGreek[202] = "GREEK SMALL LETTER IOTA WITH DIALYTIKA";
        UnicodeToName.tblDiacritGreek[203] = "GREEK SMALL LETTER UPSILON WITH DIALYTIKA";
        UnicodeToName.tblDiacritGreek[204] = "GREEK SMALL LETTER OMICRON WITH TONOS";
        UnicodeToName.tblDiacritGreek[205] = "GREEK SMALL LETTER UPSILON WITH TONOS";
        UnicodeToName.tblDiacritGreek[206] = "GREEK SMALL LETTER OMEGA WITH TONOS";
        UnicodeToName.tblDiacritGreek[208] = "GREEK BETA SYMBOL = GREEK SMALL LETTER CURLED BETA";
        UnicodeToName.tblDiacritGreek[209] = "GREEK THETA SYMBOL = GREEK SMALL LETTER SCRIPT THETA";
        UnicodeToName.tblDiacritGreek[210] = "GREEK UPSILON WITH HOOK SYMBOL = GREEK CAPITAL LETTER UPSILON HOOK";
        UnicodeToName.tblDiacritGreek[211] = "GREEK UPSILON WITH ACUTE AND HOOK SYMBOL = GREEK CAPITAL LETTER UPSILON HOOK TONOS";
        UnicodeToName.tblDiacritGreek[212] = "GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL = GREEK CAPITAL LETTER UPSILON HOOK DIAERESIS";
        UnicodeToName.tblDiacritGreek[213] = "GREEK PHI SYMBOL = GREEK SMALL LETTER SCRIPT PHI";
        UnicodeToName.tblDiacritGreek[214] = "GREEK PI SYMBOL = GREEK SMALL LETTER OMEGA PI";
        UnicodeToName.tblDiacritGreek[215] = "GREEK KAI SYMBOL";
        UnicodeToName.tblDiacritGreek[218] = "GREEK LETTER STIGMA";
        UnicodeToName.tblDiacritGreek[219] = "GREEK SMALL LETTER STIGMA";
        UnicodeToName.tblDiacritGreek[220] = "GREEK LETTER DIGAMMA";
        UnicodeToName.tblDiacritGreek[221] = "GREEK SMALL LETTER DIGAMMA";
        UnicodeToName.tblDiacritGreek[222] = "GREEK LETTER KOPPA";
        UnicodeToName.tblDiacritGreek[223] = "GREEK SMALL LETTER KOPPA";
        UnicodeToName.tblDiacritGreek[224] = "GREEK LETTER SAMPI";
        UnicodeToName.tblDiacritGreek[225] = "GREEK SMALL LETTER SAMPI";
        UnicodeToName.tblDiacritGreek[226] = "COPTIC CAPITAL LETTER SHEI (shai)";
        UnicodeToName.tblDiacritGreek[227] = "COPTIC SMALL LETTER SHEI (shai)";
        UnicodeToName.tblDiacritGreek[228] = "COPTIC CAPITAL LETTER FEI (fai)";
        UnicodeToName.tblDiacritGreek[229] = "COPTIC SMALL LETTER FEI (fai)";
        UnicodeToName.tblDiacritGreek[230] = "COPTIC CAPITAL LETTER KHEI (chai)";
        UnicodeToName.tblDiacritGreek[231] = "COPTIC SMALL LETTER KHEI (chai)";
        UnicodeToName.tblDiacritGreek[232] = "COPTIC CAPITAL LETTER HORI";
        UnicodeToName.tblDiacritGreek[233] = "COPTIC SMALL LETTER HORI";
        UnicodeToName.tblDiacritGreek[234] = "COPTIC CAPITAL LETTER GANGIA (janjia)";
        UnicodeToName.tblDiacritGreek[235] = "COPTIC SMALL LETTER GANGIA (janjia)";
        UnicodeToName.tblDiacritGreek[236] = "COPTIC CAPITAL LETTER SHIMA (gima)";
        UnicodeToName.tblDiacritGreek[237] = "COPTIC SMALL LETTER SHIMA (gima)";
        UnicodeToName.tblDiacritGreek[238] = "COPTIC CAPITAL LETTER DEI (ti)";
        UnicodeToName.tblDiacritGreek[239] = "COPTIC SMALL LETTER DEI (ti)";
        UnicodeToName.tblDiacritGreek[240] = "GREEK KAPPA SYMBOL = GREEK SMALL LETTER SCRIPT KAPPA";
        UnicodeToName.tblDiacritGreek[241] = "GREEK RHO SYMBOL = GREEK SMALL LETTER TAILED RHO";
        UnicodeToName.tblDiacritGreek[242] = "GREEK LUNATE SIGMA SYMBOL = GREEK SMALL LETTER LUNATE SIGMA (i.e. c-shaped sigma)";
        UnicodeToName.tblDiacritGreek[243] = "GREEK LETTER YOT (simply a 'j')";
        UnicodeToName.tblDiacritGreek[244] = "GREEK CAPITAL THETA SYMBOL";
        UnicodeToName.tblDiacritGreek[245] = "GREEK LUNATE EPSILON SYMBOL";
        UnicodeToName.tblGreekExtended[0] = "GREEK SMALL LETTER ALPHA WITH PSILI";
        UnicodeToName.tblGreekExtended[1] = "GREEK SMALL LETTER ALPHA WITH DASIA";
        UnicodeToName.tblGreekExtended[2] = "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[3] = "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[4] = "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[5] = "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[6] = "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[7] = "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[8] = "GREEK CAPITAL LETTER ALPHA WITH PSILI";
        UnicodeToName.tblGreekExtended[9] = "GREEK CAPITAL LETTER ALPHA WITH DASIA";
        UnicodeToName.tblGreekExtended[10] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[11] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[12] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[13] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[14] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[15] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[16] = "GREEK SMALL LETTER EPSILON WITH PSILI";
        UnicodeToName.tblGreekExtended[17] = "GREEK SMALL LETTER EPSILON WITH DASIA";
        UnicodeToName.tblGreekExtended[18] = "GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[19] = "GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[20] = "GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[21] = "GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[24] = "GREEK CAPITAL LETTER EPSILON WITH PSILI";
        UnicodeToName.tblGreekExtended[25] = "GREEK CAPITAL LETTER EPSILON WITH DASIA";
        UnicodeToName.tblGreekExtended[26] = "GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[27] = "GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[28] = "GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[29] = "GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[32] = "GREEK SMALL LETTER ETA WITH PSILI";
        UnicodeToName.tblGreekExtended[33] = "GREEK SMALL LETTER ETA WITH DASIA";
        UnicodeToName.tblGreekExtended[34] = "GREEK SMALL LETTER ETA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[35] = "GREEK SMALL LETTER ETA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[36] = "GREEK SMALL LETTER ETA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[37] = "GREEK SMALL LETTER ETA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[38] = "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[39] = "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[40] = "GREEK CAPITAL LETTER ETA WITH PSILI";
        UnicodeToName.tblGreekExtended[41] = "GREEK CAPITAL LETTER ETA WITH DASIA";
        UnicodeToName.tblGreekExtended[42] = "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[43] = "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[44] = "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[45] = "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[46] = "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[47] = "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[48] = "GREEK SMALL LETTER IOTA WITH PSILI";
        UnicodeToName.tblGreekExtended[49] = "GREEK SMALL LETTER IOTA WITH DASIA";
        UnicodeToName.tblGreekExtended[50] = "GREEK SMALL LETTER IOTA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[51] = "GREEK SMALL LETTER IOTA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[52] = "GREEK SMALL LETTER IOTA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[53] = "GREEK SMALL LETTER IOTA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[54] = "GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[55] = "GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[56] = "GREEK CAPITAL LETTER IOTA WITH PSILI";
        UnicodeToName.tblGreekExtended[57] = "GREEK CAPITAL LETTER IOTA WITH DASIA";
        UnicodeToName.tblGreekExtended[58] = "GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[59] = "GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[60] = "GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[61] = "GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[62] = "GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[63] = "GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[64] = "GREEK SMALL LETTER OMICRON WITH PSILI";
        UnicodeToName.tblGreekExtended[65] = "GREEK SMALL LETTER OMICRON WITH DASIA";
        UnicodeToName.tblGreekExtended[66] = "GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[67] = "GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[68] = "GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[69] = "GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[72] = "GREEK CAPITAL LETTER OMICRON WITH PSILI";
        UnicodeToName.tblGreekExtended[73] = "GREEK CAPITAL LETTER OMICRON WITH DASIA";
        UnicodeToName.tblGreekExtended[74] = "GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[75] = "GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[76] = "GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[77] = "GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[80] = "GREEK SMALL LETTER UPSILON WITH PSILI";
        UnicodeToName.tblGreekExtended[81] = "GREEK SMALL LETTER UPSILON WITH DASIA";
        UnicodeToName.tblGreekExtended[82] = "GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[83] = "GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[84] = "GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[85] = "GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[86] = "GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[87] = "GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[89] = "GREEK CAPITAL LETTER UPSILON WITH DASIA";
        UnicodeToName.tblGreekExtended[91] = "GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[93] = "GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[95] = "GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[96] = "GREEK SMALL LETTER OMEGA WITH PSILI";
        UnicodeToName.tblGreekExtended[97] = "GREEK SMALL LETTER OMEGA WITH DASIA";
        UnicodeToName.tblGreekExtended[98] = "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[99] = "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[100] = "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[101] = "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[102] = "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[103] = "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[104] = "GREEK CAPITAL LETTER OMEGA WITH PSILI";
        UnicodeToName.tblGreekExtended[105] = "GREEK CAPITAL LETTER OMEGA WITH DASIA";
        UnicodeToName.tblGreekExtended[106] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[107] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[108] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[109] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[110] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[111] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[112] = "GREEK SMALL LETTER ALPHA WITH VARIA";
        UnicodeToName.tblGreekExtended[113] = "GREEK SMALL LETTER ALPHA WITH OXIA";
        UnicodeToName.tblGreekExtended[114] = "GREEK SMALL LETTER EPSILON WITH VARIA";
        UnicodeToName.tblGreekExtended[115] = "GREEK SMALL LETTER EPSILON WITH OXIA";
        UnicodeToName.tblGreekExtended[116] = "GREEK SMALL LETTER ETA WITH VARIA";
        UnicodeToName.tblGreekExtended[117] = "GREEK SMALL LETTER ETA WITH OXIA";
        UnicodeToName.tblGreekExtended[118] = "GREEK SMALL LETTER IOTA WITH VARIA";
        UnicodeToName.tblGreekExtended[119] = "GREEK SMALL LETTER IOTA WITH OXIA";
        UnicodeToName.tblGreekExtended[120] = "GREEK SMALL LETTER OMICRON WITH VARIA";
        UnicodeToName.tblGreekExtended[121] = "GREEK SMALL LETTER OMICRON WITH OXIA";
        UnicodeToName.tblGreekExtended[122] = "GREEK SMALL LETTER UPSILON WITH VARIA";
        UnicodeToName.tblGreekExtended[123] = "GREEK SMALL LETTER UPSILON WITH OXIA";
        UnicodeToName.tblGreekExtended[124] = "GREEK SMALL LETTER OMEGA WITH VARIA";
        UnicodeToName.tblGreekExtended[125] = "GREEK SMALL LETTER OMEGA WITH OXIA";
        UnicodeToName.tblGreekExtended[128] = "GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[129] = "GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[130] = "GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[131] = "GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[132] = "GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[133] = "GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[134] = "GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[135] = "GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[136] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[137] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[138] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[139] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[140] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[141] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[142] = "GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[143] = "GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[144] = "GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[145] = "GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[146] = "GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[147] = "GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[148] = "GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[149] = "GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[150] = "GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[151] = "GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[152] = "GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[153] = "GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[154] = "GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[155] = "GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[156] = "GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[157] = "GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[158] = "GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[159] = "GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[160] = "GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[161] = "GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[162] = "GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[163] = "GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[164] = "GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[165] = "GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[166] = "GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[167] = "GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[168] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[169] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[170] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[171] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[172] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[173] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[174] = "GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[175] = "GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[176] = "GREEK SMALL LETTER ALPHA WITH VRACHY";
        UnicodeToName.tblGreekExtended[177] = "GREEK SMALL LETTER ALPHA WITH MACRON";
        UnicodeToName.tblGreekExtended[178] = "GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[179] = "GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[180] = "GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[182] = "GREEK SMALL LETTER ALPHA WITH PERISPOMENI";
        UnicodeToName.tblGreekExtended[183] = "GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[184] = "GREEK CAPITAL LETTER ALPHA WITH VRACHY";
        UnicodeToName.tblGreekExtended[185] = "GREEK CAPITAL LETTER ALPHA WITH MACRON";
        UnicodeToName.tblGreekExtended[186] = "GREEK CAPITAL LETTER ALPHA WITH VARIA";
        UnicodeToName.tblGreekExtended[187] = "GREEK CAPITAL LETTER ALPHA WITH OXIA";
        UnicodeToName.tblGreekExtended[188] = "GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[189] = "GREEK KORONIS";
        UnicodeToName.tblGreekExtended[190] = "GREEK PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[191] = "GREEK PSILI";
        UnicodeToName.tblGreekExtended[192] = "GREEK PERISPOMENI";
        UnicodeToName.tblGreekExtended[193] = "GREEK DIALYTIKA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[194] = "GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[195] = "GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[196] = "GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[198] = "GREEK SMALL LETTER ETA WITH PERISPOMENI";
        UnicodeToName.tblGreekExtended[199] = "GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[200] = "GREEK CAPITAL LETTER EPSILON WITH VARIA";
        UnicodeToName.tblGreekExtended[201] = "GREEK CAPITAL LETTER EPSILON WITH OXIA";
        UnicodeToName.tblGreekExtended[202] = "GREEK CAPITAL LETTER ETA WITH VARIA";
        UnicodeToName.tblGreekExtended[203] = "GREEK CAPITAL LETTER ETA WITH OXIA";
        UnicodeToName.tblGreekExtended[204] = "GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[205] = "GREEK PSILI AND VARIA";
        UnicodeToName.tblGreekExtended[206] = "GREEK PSILI AND OXIA";
        UnicodeToName.tblGreekExtended[207] = "GREEK PSILI AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[208] = "GREEK SMALL LETTER IOTA WITH VRACHY";
        UnicodeToName.tblGreekExtended[209] = "GREEK SMALL LETTER IOTA WITH MACRON";
        UnicodeToName.tblGreekExtended[210] = "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA";
        UnicodeToName.tblGreekExtended[211] = "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA";
        UnicodeToName.tblGreekExtended[214] = "GREEK SMALL LETTER IOTA WITH PERISPOMENI";
        UnicodeToName.tblGreekExtended[215] = "GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[216] = "GREEK CAPITAL LETTER IOTA WITH VRACHY";
        UnicodeToName.tblGreekExtended[217] = "GREEK CAPITAL LETTER IOTA WITH MACRON";
        UnicodeToName.tblGreekExtended[218] = "GREEK CAPITAL LETTER IOTA WITH VARIA";
        UnicodeToName.tblGreekExtended[219] = "GREEK CAPITAL LETTER IOTA WITH OXIA";
        UnicodeToName.tblGreekExtended[221] = "GREEK DASIA AND VARIA";
        UnicodeToName.tblGreekExtended[222] = "GREEK DASIA AND OXIA";
        UnicodeToName.tblGreekExtended[223] = "GREEK DASIA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[224] = "GREEK SMALL LETTER UPSILON WITH VRACHY";
        UnicodeToName.tblGreekExtended[225] = "GREEK SMALL LETTER UPSILON WITH MACRON";
        UnicodeToName.tblGreekExtended[226] = "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA";
        UnicodeToName.tblGreekExtended[227] = "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA";
        UnicodeToName.tblGreekExtended[228] = "GREEK SMALL LETTER RHO WITH PSILI";
        UnicodeToName.tblGreekExtended[229] = "GREEK SMALL LETTER RHO WITH DASIA";
        UnicodeToName.tblGreekExtended[230] = "GREEK SMALL LETTER UPSILON WITH PERISPOMENI";
        UnicodeToName.tblGreekExtended[231] = "GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI";
        UnicodeToName.tblGreekExtended[232] = "GREEK CAPITAL LETTER UPSILON WITH VRACHY";
        UnicodeToName.tblGreekExtended[233] = "GREEK CAPITAL LETTER UPSILON WITH MACRON";
        UnicodeToName.tblGreekExtended[234] = "GREEK CAPITAL LETTER UPSILON WITH VARIA";
        UnicodeToName.tblGreekExtended[235] = "GREEK CAPITAL LETTER UPSILON WITH OXIA";
        UnicodeToName.tblGreekExtended[236] = "GREEK CAPITAL LETTER RHO WITH DASIA";
        UnicodeToName.tblGreekExtended[237] = "GREEK DIALYTIKA AND VARIA";
        UnicodeToName.tblGreekExtended[238] = "GREEK DIALYTIKA AND OXIA";
        UnicodeToName.tblGreekExtended[239] = "GREEK VARIA";
        UnicodeToName.tblGreekExtended[242] = "GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[243] = "GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[244] = "GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[246] = "GREEK SMALL LETTER OMEGA WITH PERISPOMENI";
        UnicodeToName.tblGreekExtended[247] = "GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI";
        UnicodeToName.tblGreekExtended[248] = "GREEK CAPITAL LETTER OMICRON WITH VARIA";
        UnicodeToName.tblGreekExtended[249] = "GREEK CAPITAL LETTER OMICRON WITH OXIA";
        UnicodeToName.tblGreekExtended[250] = "GREEK CAPITAL LETTER OMEGA WITH VARIA";
        UnicodeToName.tblGreekExtended[251] = "GREEK CAPITAL LETTER OMEGA WITH OXIA";
        UnicodeToName.tblGreekExtended[252] = "GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI";
        UnicodeToName.tblGreekExtended[253] = "GREEK OXIA";
        UnicodeToName.tblGreekExtended[254] = "GREEK DASIA";
        UnicodeToName.tblPunct[0] = "EN QUAD";
        UnicodeToName.tblPunct[1] = "EM QUAD";
        UnicodeToName.tblPunct[2] = "EN SPACE";
        UnicodeToName.tblPunct[3] = "EM SPACE";
        UnicodeToName.tblPunct[4] = "THREE-PER-EM SPACE";
        UnicodeToName.tblPunct[5] = "FOUR-PER-EM SPACE";
        UnicodeToName.tblPunct[6] = "SIX-PER-EM SPACE";
        UnicodeToName.tblPunct[7] = "FIGURE SPACE";
        UnicodeToName.tblPunct[8] = "PUNCTUATION SPACE";
        UnicodeToName.tblPunct[9] = "THIN SPACE";
        UnicodeToName.tblPunct[10] = "HAIR SPACE";
        UnicodeToName.tblPunct[11] = "ZERO WIDTH SPACE";
        UnicodeToName.tblPunct[12] = "ZERO WIDTH NON-JOINER";
        UnicodeToName.tblPunct[13] = "ZERO WIDTH JOINER";
        UnicodeToName.tblPunct[14] = "LEFT-TO-RIGHT MARK";
        UnicodeToName.tblPunct[15] = "RIGHT-TO-LEFT-MARK";
        UnicodeToName.tblPunct[16] = "HYPHEN";
        UnicodeToName.tblPunct[17] = "NON-BREAKING HYPHEN";
        UnicodeToName.tblPunct[18] = "FIGURE DASH";
        UnicodeToName.tblPunct[19] = "EN DASH";
        UnicodeToName.tblPunct[20] = "EM DASH";
        UnicodeToName.tblPunct[21] = "HORIZONTAL BAR - QUOTATION DASH";
        UnicodeToName.tblPunct[22] = "DOUBLE VERTICAL LINE";
        UnicodeToName.tblPunct[23] = "DOUBLE LOW LINE";
        UnicodeToName.tblPunct[24] = "LEFT SINGLE QUOTATION MARK - SINGLE TURNED COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[25] = "RIGHT SINGLE QUOTATION MARK - SINGLE COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[26] = "SINGLE LOW-9 QUOTATION MARK - LOW SINGLE COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[27] = "SINGLE HIGH-REVERSED-9 QUOTATION MARK - SINGLE REVERSED COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[28] = "LEFT DOUBLE QUOTATION MARK - DOUBLE TURNED COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[29] = "RIGHT DOUBLE QUOTATION MARK - DOUBLE COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[30] = "DOUBLE LOW-9 QUOTATION MARK - LOW DOUBLE COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[31] = "DOUBLE HIGH-REVERSED-9 QUOTATION MARK - DOUBLE REVERSED COMMA QUOTATION MARK";
        UnicodeToName.tblPunct[32] = "DAGGER (obelisk)";
        UnicodeToName.tblPunct[33] = "DOUBLE DAGGER";
        UnicodeToName.tblPunct[34] = "BULLET";
        UnicodeToName.tblPunct[35] = "TRIANGULAR BULLET";
        UnicodeToName.tblPunct[36] = "ONE DOT LEADER";
        UnicodeToName.tblPunct[37] = "TWO DOT LEADER";
        UnicodeToName.tblPunct[38] = "HORIZONTAL ELLIPSIS";
        UnicodeToName.tblPunct[39] = "HYPHENATION POINT";
        UnicodeToName.tblPunct[40] = "LINE SEPARATOR";
        UnicodeToName.tblPunct[41] = "PARAGRAPH SEPARATOR";
        UnicodeToName.tblPunct[42] = "LEFT-TO-RIGHT EMBEDDING";
        UnicodeToName.tblPunct[43] = "RIGHT-TO-LEFT EMBEDDING";
        UnicodeToName.tblPunct[44] = "POP DIRECTIONAL FORMATTING";
        UnicodeToName.tblPunct[45] = "LEFT-TO-RIGHT OVERRIDE";
        UnicodeToName.tblPunct[46] = "RIGHT-TO-LEFT OVERRIDE";
        UnicodeToName.tblPunct[47] = "NARROW NO-BREAK SPACE";
        UnicodeToName.tblPunct[48] = "PER MILLE SIGN";
        UnicodeToName.tblPunct[49] = "PER TEN THOUSAND SIGN";
        UnicodeToName.tblPunct[50] = "PRIME";
        UnicodeToName.tblPunct[51] = "DOUBLE PRIME";
        UnicodeToName.tblPunct[52] = "TRIPLE PRIME";
        UnicodeToName.tblPunct[53] = "REVERSED PRIME";
        UnicodeToName.tblPunct[54] = "REVERSED DOUBLE PRIME";
        UnicodeToName.tblPunct[55] = "REVERSED TRIPLE PRIME";
        UnicodeToName.tblPunct[56] = "CARET";
        UnicodeToName.tblPunct[57] = "SINGLE LEFT-POINTING ANGLE QUOTATION MARK - LEFT POINTING SINGLE GUILLEMET";
        UnicodeToName.tblPunct[58] = "SINGLE RIGHT-POINTING ANGLE QUOTATION MARK - RIGHT POINTING SINGLE GUILLEMET";
        UnicodeToName.tblPunct[59] = "REFERENCE MARK";
        UnicodeToName.tblPunct[60] = "DOUBLE EXCLAMATION MARK";
        UnicodeToName.tblPunct[61] = "INTERROBANG";
        UnicodeToName.tblPunct[62] = "OVERLINE - SPACING OVERSCORE";
        UnicodeToName.tblPunct[63] = "UNDERTIE";
        UnicodeToName.tblPunct[64] = "CHARACTER TIE";
        UnicodeToName.tblPunct[65] = "CARET INSERTION POINT";
        UnicodeToName.tblPunct[66] = "ASTERISM";
        UnicodeToName.tblPunct[67] = "HYPHEN BULLET";
        UnicodeToName.tblPunct[68] = "FRACTION SLASH";
        UnicodeToName.tblPunct[69] = "LEFT SQUARE BRACKET WITH QUILL";
        UnicodeToName.tblPunct[70] = "RIGHT SQUARE BRACKET WITH QUILL";
        UnicodeToName.tblPunct[71] = NOT_ASSIGNED;
        UnicodeToName.tblPunct[72] = "QUESTION EXCLAMATION MARK";
        UnicodeToName.tblPunct[73] = "EXCLAMATION QUESTION MARK";
        UnicodeToName.tblPunct[74] = "TIRONIAN SIGN ET";
        UnicodeToName.tblPunct[75] = "REVERSED PILCROW SIGN";
        UnicodeToName.tblPunct[76] = "BLACK LEFTWARDS BULLET";
        UnicodeToName.tblPunct[77] = "BLACK RIGHTWARDS BULLET";
        UnicodeToName.tblPunct[106] = "INHIBIT SYMMETRIC SWAPPING";
        UnicodeToName.tblPunct[107] = "ACTIVATE SYMMETRIC SWAPPING";
        UnicodeToName.tblPunct[108] = "INHIBIT ARABIC FORM SHAPING";
        UnicodeToName.tblPunct[109] = "ACTIVATE ARABIC FORM SHAPING";
        UnicodeToName.tblPunct[110] = "NATIONAL DIGIT SHAPES";
        UnicodeToName.tblPunct[111] = "NOMINAL DIGIT SHAPES";
    }
}

