/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class UnicodeToHtml {
    public static final int USE_NAMED_ENT = 0;
    public static final int NO_NAMED_ENT = 1;
    public static final int DEC_ENT = 0;
    public static final int HEX_ENT = 2;
    public static int namedMode = 0;
    public static int numberMode = 0;
    private static final String[][] tblLookup = new String[256][];
    private static final String[] tblLatin1 = new String[256];
    private static final String[] tblDiacritGreek = new String[256];
    private static final String[] tblPunct = new String[256];
    private static final String[] tblNotSupported = new String[256];

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "21-Apr-2002";
                break;
            }
            case 1: {
                string = "Converts Unicode (precomposed or decomposed) into HTML entities";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Sapere aude!";
            }
        }
        return string;
    }

    static final void setMode(int n) {
        namedMode = n & 1;
        numberMode = n & 2;
    }

    static final String convertString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        MessageHandler.clearMsgQueue();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(UnicodeToHtml.convertChar(string.charAt(n2)));
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(n2 + 1) + "\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static final String convertChar(char c) {
        String string = new String();
        Integer n = new Integer(c);
        if (c <= 'y') {
            string = String.valueOf(c);
        } else {
            if (namedMode == 0) {
                string = tblLookup[c >> 8][c & 0xFF];
            }
            if (string.equals("")) {
                string = numberMode == 0 ? "&#" + Integer.toString(c) + ";" : "&#x" + Integer.toHexString(c) + ";";
            }
        }
        return string;
    }

    static {
        int n = 0;
        while (n < 256) {
            UnicodeToHtml.tblLookup[n] = tblNotSupported;
            UnicodeToHtml.tblNotSupported[n] = "";
            UnicodeToHtml.tblLatin1[n] = "";
            UnicodeToHtml.tblDiacritGreek[n] = "";
            UnicodeToHtml.tblPunct[n] = "";
            ++n;
        }
        UnicodeToHtml.tblLookup[0] = tblLatin1;
        UnicodeToHtml.tblLookup[3] = tblDiacritGreek;
        UnicodeToHtml.tblLookup[32] = tblPunct;
        UnicodeToHtml.tblLatin1[160] = "&nbsp;";
        UnicodeToHtml.tblLatin1[161] = "&iexcl;";
        UnicodeToHtml.tblLatin1[162] = "&cent;";
        UnicodeToHtml.tblLatin1[163] = "&pound;";
        UnicodeToHtml.tblLatin1[164] = "&curren;";
        UnicodeToHtml.tblLatin1[165] = "&yen;";
        UnicodeToHtml.tblLatin1[166] = "&brvbar;";
        UnicodeToHtml.tblLatin1[167] = "&sect;";
        UnicodeToHtml.tblLatin1[168] = "&uml;";
        UnicodeToHtml.tblLatin1[169] = "&copy;";
        UnicodeToHtml.tblLatin1[170] = "&ordf;";
        UnicodeToHtml.tblLatin1[171] = "&laquo;";
        UnicodeToHtml.tblLatin1[172] = "&not;";
        UnicodeToHtml.tblLatin1[173] = "&shy;";
        UnicodeToHtml.tblLatin1[174] = "&reg;";
        UnicodeToHtml.tblLatin1[175] = "&macr;";
        UnicodeToHtml.tblLatin1[176] = "&deg;";
        UnicodeToHtml.tblLatin1[177] = "&plusmn;";
        UnicodeToHtml.tblLatin1[178] = "&sup2;";
        UnicodeToHtml.tblLatin1[179] = "&sup3;";
        UnicodeToHtml.tblLatin1[180] = "&acute;";
        UnicodeToHtml.tblLatin1[181] = "&micro;";
        UnicodeToHtml.tblLatin1[182] = "&para;";
        UnicodeToHtml.tblLatin1[183] = "&middot;";
        UnicodeToHtml.tblLatin1[184] = "&cedil;";
        UnicodeToHtml.tblLatin1[185] = "&sup1;";
        UnicodeToHtml.tblLatin1[186] = "&ordm;";
        UnicodeToHtml.tblLatin1[187] = "&raquo;";
        UnicodeToHtml.tblLatin1[188] = "&frac14;";
        UnicodeToHtml.tblLatin1[189] = "&frac12;";
        UnicodeToHtml.tblLatin1[190] = "&frac34;";
        UnicodeToHtml.tblLatin1[191] = "&iquest;";
        UnicodeToHtml.tblLatin1[192] = "&Agrave;";
        UnicodeToHtml.tblLatin1[193] = "&Aacute;";
        UnicodeToHtml.tblLatin1[194] = "&Acirc;";
        UnicodeToHtml.tblLatin1[195] = "&Atilde;";
        UnicodeToHtml.tblLatin1[196] = "&Auml;";
        UnicodeToHtml.tblLatin1[197] = "&Aring;";
        UnicodeToHtml.tblLatin1[198] = "&AElig;";
        UnicodeToHtml.tblLatin1[199] = "&Ccedil;";
        UnicodeToHtml.tblLatin1[200] = "&Egrave;";
        UnicodeToHtml.tblLatin1[201] = "&Eacute;";
        UnicodeToHtml.tblLatin1[202] = "&Ecirc;";
        UnicodeToHtml.tblLatin1[203] = "&Euml;";
        UnicodeToHtml.tblLatin1[204] = "&Igrave;";
        UnicodeToHtml.tblLatin1[205] = "&Iacute;";
        UnicodeToHtml.tblLatin1[206] = "&Icirc;";
        UnicodeToHtml.tblLatin1[207] = "&Iuml;";
        UnicodeToHtml.tblLatin1[208] = "&ETH;";
        UnicodeToHtml.tblLatin1[209] = "&Ntilde;";
        UnicodeToHtml.tblLatin1[210] = "&Ograve;";
        UnicodeToHtml.tblLatin1[211] = "&Oacute;";
        UnicodeToHtml.tblLatin1[212] = "&Ocirc;";
        UnicodeToHtml.tblLatin1[213] = "&Otilde;";
        UnicodeToHtml.tblLatin1[214] = "&Ouml;";
        UnicodeToHtml.tblLatin1[215] = "&times;";
        UnicodeToHtml.tblLatin1[216] = "&Oslash;";
        UnicodeToHtml.tblLatin1[217] = "&Ugrave;";
        UnicodeToHtml.tblLatin1[218] = "&Uacute;";
        UnicodeToHtml.tblLatin1[219] = "&Ucirc;";
        UnicodeToHtml.tblLatin1[220] = "&Uuml;";
        UnicodeToHtml.tblLatin1[221] = "&Yacute;";
        UnicodeToHtml.tblLatin1[222] = "&THORN;";
        UnicodeToHtml.tblLatin1[223] = "&szlig;";
        UnicodeToHtml.tblLatin1[224] = "&agrave;";
        UnicodeToHtml.tblLatin1[225] = "&aacute;";
        UnicodeToHtml.tblLatin1[226] = "&acirc;";
        UnicodeToHtml.tblLatin1[227] = "&atilde;";
        UnicodeToHtml.tblLatin1[228] = "&auml;";
        UnicodeToHtml.tblLatin1[229] = "&aring;";
        UnicodeToHtml.tblLatin1[230] = "&aelig;";
        UnicodeToHtml.tblLatin1[231] = "&ccedil;";
        UnicodeToHtml.tblLatin1[232] = "&egrave;";
        UnicodeToHtml.tblLatin1[233] = "&eacute;";
        UnicodeToHtml.tblLatin1[234] = "&ecirc;";
        UnicodeToHtml.tblLatin1[235] = "&euml;";
        UnicodeToHtml.tblLatin1[236] = "&igrave;";
        UnicodeToHtml.tblLatin1[237] = "&iacute;";
        UnicodeToHtml.tblLatin1[238] = "&icirc;";
        UnicodeToHtml.tblLatin1[239] = "&iuml;";
        UnicodeToHtml.tblLatin1[240] = "&eth;";
        UnicodeToHtml.tblLatin1[241] = "&ntilde;";
        UnicodeToHtml.tblLatin1[242] = "&ograve;";
        UnicodeToHtml.tblLatin1[243] = "&oacute;";
        UnicodeToHtml.tblLatin1[244] = "&ocirc;";
        UnicodeToHtml.tblLatin1[245] = "&otilde;";
        UnicodeToHtml.tblLatin1[246] = "&ouml;";
        UnicodeToHtml.tblLatin1[247] = "&divide;";
        UnicodeToHtml.tblLatin1[248] = "&oslash;";
        UnicodeToHtml.tblLatin1[249] = "&ugrave;";
        UnicodeToHtml.tblLatin1[250] = "&uacute;";
        UnicodeToHtml.tblLatin1[251] = "&ucirc;";
        UnicodeToHtml.tblLatin1[252] = "&uuml;";
        UnicodeToHtml.tblLatin1[253] = "&yacute;";
        UnicodeToHtml.tblLatin1[254] = "&thorn;";
        UnicodeToHtml.tblLatin1[255] = "&yuml;";
        UnicodeToHtml.tblDiacritGreek[145] = "&Alpha;";
        UnicodeToHtml.tblDiacritGreek[146] = "&Beta;";
        UnicodeToHtml.tblDiacritGreek[147] = "&Gamma;";
        UnicodeToHtml.tblDiacritGreek[148] = "&Delta;";
        UnicodeToHtml.tblDiacritGreek[149] = "&Epsilon;";
        UnicodeToHtml.tblDiacritGreek[150] = "&Zeta;";
        UnicodeToHtml.tblDiacritGreek[151] = "&Eta;";
        UnicodeToHtml.tblDiacritGreek[152] = "&Theta;";
        UnicodeToHtml.tblDiacritGreek[153] = "&Iota;";
        UnicodeToHtml.tblDiacritGreek[154] = "&Kappa;";
        UnicodeToHtml.tblDiacritGreek[155] = "&Lambda;";
        UnicodeToHtml.tblDiacritGreek[156] = "&Mu;";
        UnicodeToHtml.tblDiacritGreek[157] = "&Nu;";
        UnicodeToHtml.tblDiacritGreek[158] = "&Xi;";
        UnicodeToHtml.tblDiacritGreek[159] = "&Omicron;";
        UnicodeToHtml.tblDiacritGreek[160] = "&Pi;";
        UnicodeToHtml.tblDiacritGreek[161] = "&Rho;";
        UnicodeToHtml.tblDiacritGreek[163] = "&Sigma;";
        UnicodeToHtml.tblDiacritGreek[164] = "&Tau;";
        UnicodeToHtml.tblDiacritGreek[165] = "&Upsilon;";
        UnicodeToHtml.tblDiacritGreek[166] = "&Phi;";
        UnicodeToHtml.tblDiacritGreek[167] = "&Chi;";
        UnicodeToHtml.tblDiacritGreek[168] = "&Psi;";
        UnicodeToHtml.tblDiacritGreek[169] = "&Omega;";
        UnicodeToHtml.tblDiacritGreek[177] = "&alpha;";
        UnicodeToHtml.tblDiacritGreek[178] = "&beta;";
        UnicodeToHtml.tblDiacritGreek[179] = "&gamma;";
        UnicodeToHtml.tblDiacritGreek[180] = "&delta;";
        UnicodeToHtml.tblDiacritGreek[181] = "&epsilon;";
        UnicodeToHtml.tblDiacritGreek[182] = "&zeta;";
        UnicodeToHtml.tblDiacritGreek[183] = "&eta;";
        UnicodeToHtml.tblDiacritGreek[184] = "&theta;";
        UnicodeToHtml.tblDiacritGreek[185] = "&iota;";
        UnicodeToHtml.tblDiacritGreek[186] = "&kappa;";
        UnicodeToHtml.tblDiacritGreek[187] = "&lambda;";
        UnicodeToHtml.tblDiacritGreek[188] = "&mu;";
        UnicodeToHtml.tblDiacritGreek[189] = "&nu;";
        UnicodeToHtml.tblDiacritGreek[190] = "&xi;";
        UnicodeToHtml.tblDiacritGreek[191] = "&omicron;";
        UnicodeToHtml.tblDiacritGreek[192] = "&pi;";
        UnicodeToHtml.tblDiacritGreek[193] = "&rho;";
        UnicodeToHtml.tblDiacritGreek[194] = "&sigmaf;";
        UnicodeToHtml.tblDiacritGreek[195] = "&sigma;";
        UnicodeToHtml.tblDiacritGreek[196] = "&tau;";
        UnicodeToHtml.tblDiacritGreek[197] = "&upsilon;";
        UnicodeToHtml.tblDiacritGreek[198] = "&phi;";
        UnicodeToHtml.tblDiacritGreek[199] = "&chi;";
        UnicodeToHtml.tblDiacritGreek[200] = "&psi;";
        UnicodeToHtml.tblDiacritGreek[201] = "&omega;";
        UnicodeToHtml.tblDiacritGreek[209] = "&thetasym;";
        UnicodeToHtml.tblDiacritGreek[210] = "&upsih;";
        UnicodeToHtml.tblDiacritGreek[214] = "&piv;";
        UnicodeToHtml.tblPunct[2] = "&ensp;";
        UnicodeToHtml.tblPunct[3] = "&emsp;";
        UnicodeToHtml.tblPunct[9] = "&thinsp;";
        UnicodeToHtml.tblPunct[12] = "&zwnj;";
        UnicodeToHtml.tblPunct[13] = "&zwj;";
        UnicodeToHtml.tblPunct[14] = "&lrm;";
        UnicodeToHtml.tblPunct[15] = "&rlm;";
        UnicodeToHtml.tblPunct[19] = "&ndash;";
        UnicodeToHtml.tblPunct[20] = "&mdash;";
        UnicodeToHtml.tblPunct[24] = "&lsquo;";
        UnicodeToHtml.tblPunct[25] = "&rsquo;";
        UnicodeToHtml.tblPunct[26] = "&sbquo;";
        UnicodeToHtml.tblPunct[28] = "&ldquo;";
        UnicodeToHtml.tblPunct[29] = "&rdquo;";
        UnicodeToHtml.tblPunct[30] = "&bdquo;";
        UnicodeToHtml.tblPunct[32] = "&dagger;";
        UnicodeToHtml.tblPunct[33] = "&Dagger;";
        UnicodeToHtml.tblPunct[34] = "&bull;";
        UnicodeToHtml.tblPunct[38] = "&hellip;";
        UnicodeToHtml.tblPunct[48] = "&permil;";
        UnicodeToHtml.tblPunct[50] = "&prime;";
        UnicodeToHtml.tblPunct[57] = "&lsaquo;";
        UnicodeToHtml.tblPunct[58] = "&rsaquo;";
        UnicodeToHtml.tblPunct[62] = "&oline;";
        UnicodeToHtml.tblPunct[68] = "&frasl;";
    }
}

