/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;
import greekconverter.UnicodeToName;

public class UnicodeToGreekKeys {
    private static final short[] NOT_SUPPORTED = UnicodeToGreekKeys.createArray(63, 0, 0);
    private static final short[] NOT_ASSIGNED = UnicodeToGreekKeys.createArray(63, 0, 0);
    private static final short[][][] tblLookup = new short[256][][];
    private static final short[][] tblLatin1 = new short[256][];
    private static final short[][] tblDiacritGreek = new short[256][];
    private static final short[][] tblGreekExtended = new short[256][];
    private static final short[][] tblNotSupported = new short[256][];

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "30-Aug-2002";
                break;
            }
            case 1: {
                string = "Converts Unicode into GreekKeys";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Dulce est desipere in loco.";
            }
        }
        return string;
    }

    private static final short[] createArray(int n, int n2, int n3) {
        int n4 = 1;
        if (n2 > 0) {
            n4 = 2;
        }
        if (n3 > 0) {
            n4 = 3;
        }
        short[] sArray = new short[n4];
        sArray[0] = (short)n;
        if (n4 > 1) {
            sArray[1] = (short)n2;
        }
        if (n4 > 2) {
            sArray[2] = (short)n3;
        }
        return sArray;
    }

    static final short[] convertString(String string) {
        int n = string.length();
        int n2 = 0;
        short[] sArray = new short[3 * n + 1];
        short[] sArray2 = null;
        MessageHandler.clearMsgQueue();
        int n3 = 0;
        while (n3 < n) {
            sArray2 = UnicodeToGreekKeys.convertChar(string.charAt(n3));
            MessageHandler.enqueueMsg(" at pos. " + String.valueOf(n3 + 1) + "\n");
            int n4 = sArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                sArray[n2++] = sArray2[n5];
                ++n5;
            }
            ++n3;
        }
        sArray[n2] = 0;
        return sArray;
    }

    private static final short[] convertChar(char c) {
        Integer n = new Integer(c);
        short[] sArray = tblLookup[c >> 8][c & 0xFF];
        if (sArray == NOT_ASSIGNED) {
            MessageHandler.enqueueMsg("Not defined Unicode character: U+" + Integer.toHexString(c), 10);
        } else if (sArray == NOT_SUPPORTED) {
            MessageHandler.enqueueMsg("Not supported character: U+" + Integer.toHexString(c), 10);
        } else {
            MessageHandler.enqueueMsg(UnicodeToName.convertChar(c), 30);
        }
        return sArray;
    }

    static {
        int n = 0;
        while (n < 256) {
            UnicodeToGreekKeys.tblLookup[n] = tblNotSupported;
            UnicodeToGreekKeys.tblNotSupported[n] = NOT_SUPPORTED;
            UnicodeToGreekKeys.tblLatin1[n] = NOT_SUPPORTED;
            UnicodeToGreekKeys.tblDiacritGreek[n] = NOT_ASSIGNED;
            UnicodeToGreekKeys.tblGreekExtended[n] = NOT_ASSIGNED;
            ++n;
        }
        n = 0;
        while (n < 112) {
            UnicodeToGreekKeys.tblDiacritGreek[n] = NOT_SUPPORTED;
            ++n;
        }
        UnicodeToGreekKeys.tblLookup[0] = tblLatin1;
        UnicodeToGreekKeys.tblLookup[3] = tblDiacritGreek;
        UnicodeToGreekKeys.tblLookup[31] = tblGreekExtended;
        UnicodeToGreekKeys.tblLatin1[9] = UnicodeToGreekKeys.createArray(9, 0, 0);
        UnicodeToGreekKeys.tblLatin1[10] = UnicodeToGreekKeys.createArray(10, 0, 0);
        UnicodeToGreekKeys.tblLatin1[11] = UnicodeToGreekKeys.createArray(11, 0, 0);
        UnicodeToGreekKeys.tblLatin1[12] = UnicodeToGreekKeys.createArray(12, 0, 0);
        UnicodeToGreekKeys.tblLatin1[13] = UnicodeToGreekKeys.createArray(13, 0, 0);
        UnicodeToGreekKeys.tblLatin1[32] = UnicodeToGreekKeys.createArray(32, 0, 0);
        UnicodeToGreekKeys.tblLatin1[34] = UnicodeToGreekKeys.createArray(34, 0, 0);
        UnicodeToGreekKeys.tblLatin1[39] = UnicodeToGreekKeys.createArray(39, 0, 0);
        UnicodeToGreekKeys.tblLatin1[40] = UnicodeToGreekKeys.createArray(40, 0, 0);
        UnicodeToGreekKeys.tblLatin1[41] = UnicodeToGreekKeys.createArray(41, 0, 0);
        UnicodeToGreekKeys.tblLatin1[44] = UnicodeToGreekKeys.createArray(44, 0, 0);
        UnicodeToGreekKeys.tblLatin1[45] = UnicodeToGreekKeys.createArray(45, 0, 0);
        UnicodeToGreekKeys.tblLatin1[46] = UnicodeToGreekKeys.createArray(46, 0, 0);
        UnicodeToGreekKeys.tblLatin1[47] = UnicodeToGreekKeys.createArray(47, 0, 0);
        UnicodeToGreekKeys.tblLatin1[48] = UnicodeToGreekKeys.createArray(48, 0, 0);
        UnicodeToGreekKeys.tblLatin1[49] = UnicodeToGreekKeys.createArray(49, 0, 0);
        UnicodeToGreekKeys.tblLatin1[50] = UnicodeToGreekKeys.createArray(50, 0, 0);
        UnicodeToGreekKeys.tblLatin1[51] = UnicodeToGreekKeys.createArray(51, 0, 0);
        UnicodeToGreekKeys.tblLatin1[52] = UnicodeToGreekKeys.createArray(52, 0, 0);
        UnicodeToGreekKeys.tblLatin1[53] = UnicodeToGreekKeys.createArray(53, 0, 0);
        UnicodeToGreekKeys.tblLatin1[54] = UnicodeToGreekKeys.createArray(54, 0, 0);
        UnicodeToGreekKeys.tblLatin1[55] = UnicodeToGreekKeys.createArray(55, 0, 0);
        UnicodeToGreekKeys.tblLatin1[56] = UnicodeToGreekKeys.createArray(56, 0, 0);
        UnicodeToGreekKeys.tblLatin1[57] = UnicodeToGreekKeys.createArray(57, 0, 0);
        UnicodeToGreekKeys.tblLatin1[58] = UnicodeToGreekKeys.createArray(58, 0, 0);
        UnicodeToGreekKeys.tblLatin1[59] = UnicodeToGreekKeys.createArray(59, 0, 0);
        UnicodeToGreekKeys.tblLatin1[60] = UnicodeToGreekKeys.createArray(60, 0, 0);
        UnicodeToGreekKeys.tblLatin1[62] = UnicodeToGreekKeys.createArray(62, 0, 0);
        UnicodeToGreekKeys.tblLatin1[63] = UnicodeToGreekKeys.createArray(63, 0, 0);
        UnicodeToGreekKeys.tblLatin1[91] = UnicodeToGreekKeys.createArray(91, 0, 0);
        UnicodeToGreekKeys.tblLatin1[92] = UnicodeToGreekKeys.createArray(92, 0, 0);
        UnicodeToGreekKeys.tblLatin1[93] = UnicodeToGreekKeys.createArray(93, 0, 0);
        UnicodeToGreekKeys.tblLatin1[123] = UnicodeToGreekKeys.createArray(123, 0, 0);
        UnicodeToGreekKeys.tblLatin1[124] = UnicodeToGreekKeys.createArray(124, 0, 0);
        UnicodeToGreekKeys.tblLatin1[125] = UnicodeToGreekKeys.createArray(125, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[116] = UnicodeToGreekKeys.createArray(39, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[117] = UnicodeToGreekKeys.createArray(44, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[122] = UnicodeToGreekKeys.createArray(43, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[126] = UnicodeToGreekKeys.createArray(59, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[132] = UnicodeToGreekKeys.createArray(128, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[133] = UnicodeToGreekKeys.createArray(128, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[134] = UnicodeToGreekKeys.createArray(128, 65, 0);
        UnicodeToGreekKeys.tblDiacritGreek[135] = UnicodeToGreekKeys.createArray(58, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[136] = UnicodeToGreekKeys.createArray(128, 69, 0);
        UnicodeToGreekKeys.tblDiacritGreek[137] = UnicodeToGreekKeys.createArray(128, 72, 0);
        UnicodeToGreekKeys.tblDiacritGreek[138] = UnicodeToGreekKeys.createArray(128, 73, 0);
        UnicodeToGreekKeys.tblDiacritGreek[140] = UnicodeToGreekKeys.createArray(128, 79, 0);
        UnicodeToGreekKeys.tblDiacritGreek[142] = UnicodeToGreekKeys.createArray(128, 85, 0);
        UnicodeToGreekKeys.tblDiacritGreek[143] = UnicodeToGreekKeys.createArray(128, 86, 0);
        UnicodeToGreekKeys.tblDiacritGreek[144] = UnicodeToGreekKeys.createArray(253, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[145] = UnicodeToGreekKeys.createArray(65, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[146] = UnicodeToGreekKeys.createArray(66, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[147] = UnicodeToGreekKeys.createArray(71, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[148] = UnicodeToGreekKeys.createArray(68, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[149] = UnicodeToGreekKeys.createArray(69, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[150] = UnicodeToGreekKeys.createArray(90, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[151] = UnicodeToGreekKeys.createArray(72, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[152] = UnicodeToGreekKeys.createArray(89, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[153] = UnicodeToGreekKeys.createArray(73, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[154] = UnicodeToGreekKeys.createArray(75, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[155] = UnicodeToGreekKeys.createArray(76, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[156] = UnicodeToGreekKeys.createArray(77, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[157] = UnicodeToGreekKeys.createArray(78, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[158] = UnicodeToGreekKeys.createArray(74, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[159] = UnicodeToGreekKeys.createArray(79, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[160] = UnicodeToGreekKeys.createArray(80, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[161] = UnicodeToGreekKeys.createArray(82, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[163] = UnicodeToGreekKeys.createArray(83, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[164] = UnicodeToGreekKeys.createArray(84, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[165] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[166] = UnicodeToGreekKeys.createArray(70, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[167] = UnicodeToGreekKeys.createArray(88, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[168] = UnicodeToGreekKeys.createArray(67, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[169] = UnicodeToGreekKeys.createArray(86, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[170] = UnicodeToGreekKeys.createArray(73, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[171] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[172] = UnicodeToGreekKeys.createArray(139, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[173] = UnicodeToGreekKeys.createArray(161, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[174] = UnicodeToGreekKeys.createArray(174, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[175] = UnicodeToGreekKeys.createArray(219, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[176] = UnicodeToGreekKeys.createArray(64, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[177] = UnicodeToGreekKeys.createArray(97, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[178] = UnicodeToGreekKeys.createArray(98, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[179] = UnicodeToGreekKeys.createArray(103, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[180] = UnicodeToGreekKeys.createArray(100, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[181] = UnicodeToGreekKeys.createArray(101, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[182] = UnicodeToGreekKeys.createArray(122, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[183] = UnicodeToGreekKeys.createArray(104, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[184] = UnicodeToGreekKeys.createArray(121, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[185] = UnicodeToGreekKeys.createArray(105, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[186] = UnicodeToGreekKeys.createArray(107, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[187] = UnicodeToGreekKeys.createArray(108, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[188] = UnicodeToGreekKeys.createArray(109, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[189] = UnicodeToGreekKeys.createArray(110, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[190] = UnicodeToGreekKeys.createArray(106, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[191] = UnicodeToGreekKeys.createArray(111, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[192] = UnicodeToGreekKeys.createArray(112, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[193] = UnicodeToGreekKeys.createArray(114, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[194] = UnicodeToGreekKeys.createArray(119, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[195] = UnicodeToGreekKeys.createArray(115, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[196] = UnicodeToGreekKeys.createArray(116, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[197] = UnicodeToGreekKeys.createArray(117, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[198] = UnicodeToGreekKeys.createArray(102, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[199] = UnicodeToGreekKeys.createArray(120, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[200] = UnicodeToGreekKeys.createArray(99, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[201] = UnicodeToGreekKeys.createArray(118, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[202] = UnicodeToGreekKeys.createArray(243, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[203] = UnicodeToGreekKeys.createArray(35, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[204] = UnicodeToGreekKeys.createArray(241, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[205] = UnicodeToGreekKeys.createArray(230, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[206] = UnicodeToGreekKeys.createArray(197, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[208] = UnicodeToGreekKeys.createArray(98, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[209] = UnicodeToGreekKeys.createArray(122, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[210] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[211] = UnicodeToGreekKeys.createArray(128, 85, 0);
        UnicodeToGreekKeys.tblDiacritGreek[212] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[213] = UnicodeToGreekKeys.createArray(102, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[214] = UnicodeToGreekKeys.createArray(112, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[218] = UnicodeToGreekKeys.createArray(251, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[219] = UnicodeToGreekKeys.createArray(251, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[220] = UnicodeToGreekKeys.createArray(87, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[221] = UnicodeToGreekKeys.createArray(87, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[222] = UnicodeToGreekKeys.createArray(113, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[223] = UnicodeToGreekKeys.createArray(113, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[224] = UnicodeToGreekKeys.createArray(81, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[225] = UnicodeToGreekKeys.createArray(81, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[240] = UnicodeToGreekKeys.createArray(107, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[241] = UnicodeToGreekKeys.createArray(114, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[242] = UnicodeToGreekKeys.createArray(33, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[244] = UnicodeToGreekKeys.createArray(89, 0, 0);
        UnicodeToGreekKeys.tblDiacritGreek[245] = UnicodeToGreekKeys.createArray(101, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[0] = UnicodeToGreekKeys.createArray(142, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[1] = UnicodeToGreekKeys.createArray(143, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[2] = UnicodeToGreekKeys.createArray(146, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[3] = UnicodeToGreekKeys.createArray(147, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[4] = UnicodeToGreekKeys.createArray(144, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[5] = UnicodeToGreekKeys.createArray(145, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[6] = UnicodeToGreekKeys.createArray(148, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[7] = UnicodeToGreekKeys.createArray(149, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[8] = UnicodeToGreekKeys.createArray(131, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[9] = UnicodeToGreekKeys.createArray(132, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[10] = UnicodeToGreekKeys.createArray(135, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[11] = UnicodeToGreekKeys.createArray(136, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[12] = UnicodeToGreekKeys.createArray(133, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[13] = UnicodeToGreekKeys.createArray(134, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[14] = UnicodeToGreekKeys.createArray(137, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[15] = UnicodeToGreekKeys.createArray(138, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[16] = UnicodeToGreekKeys.createArray(164, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[17] = UnicodeToGreekKeys.createArray(165, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[18] = UnicodeToGreekKeys.createArray(168, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[19] = UnicodeToGreekKeys.createArray(169, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[20] = UnicodeToGreekKeys.createArray(166, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[21] = UnicodeToGreekKeys.createArray(167, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[24] = UnicodeToGreekKeys.createArray(131, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[25] = UnicodeToGreekKeys.createArray(132, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[26] = UnicodeToGreekKeys.createArray(135, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[27] = UnicodeToGreekKeys.createArray(136, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[28] = UnicodeToGreekKeys.createArray(133, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[29] = UnicodeToGreekKeys.createArray(134, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[32] = UnicodeToGreekKeys.createArray(177, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[33] = UnicodeToGreekKeys.createArray(178, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[34] = UnicodeToGreekKeys.createArray(181, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[35] = UnicodeToGreekKeys.createArray(182, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[36] = UnicodeToGreekKeys.createArray(179, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[37] = UnicodeToGreekKeys.createArray(180, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[38] = UnicodeToGreekKeys.createArray(183, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[39] = UnicodeToGreekKeys.createArray(184, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[40] = UnicodeToGreekKeys.createArray(131, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[41] = UnicodeToGreekKeys.createArray(132, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[42] = UnicodeToGreekKeys.createArray(135, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[43] = UnicodeToGreekKeys.createArray(136, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[44] = UnicodeToGreekKeys.createArray(133, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[45] = UnicodeToGreekKeys.createArray(134, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[46] = UnicodeToGreekKeys.createArray(137, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[47] = UnicodeToGreekKeys.createArray(138, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[48] = UnicodeToGreekKeys.createArray(222, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[49] = UnicodeToGreekKeys.createArray(223, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[50] = UnicodeToGreekKeys.createArray(226, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[51] = UnicodeToGreekKeys.createArray(227, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[52] = UnicodeToGreekKeys.createArray(224, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[53] = UnicodeToGreekKeys.createArray(225, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[54] = UnicodeToGreekKeys.createArray(228, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[55] = UnicodeToGreekKeys.createArray(229, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[56] = UnicodeToGreekKeys.createArray(131, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[57] = UnicodeToGreekKeys.createArray(132, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[58] = UnicodeToGreekKeys.createArray(135, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[59] = UnicodeToGreekKeys.createArray(136, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[60] = UnicodeToGreekKeys.createArray(134, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[61] = UnicodeToGreekKeys.createArray(135, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[62] = UnicodeToGreekKeys.createArray(137, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[63] = UnicodeToGreekKeys.createArray(138, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[64] = UnicodeToGreekKeys.createArray(244, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[65] = UnicodeToGreekKeys.createArray(245, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[66] = UnicodeToGreekKeys.createArray(248, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[67] = UnicodeToGreekKeys.createArray(249, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[68] = UnicodeToGreekKeys.createArray(246, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[69] = UnicodeToGreekKeys.createArray(247, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[72] = UnicodeToGreekKeys.createArray(131, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[73] = UnicodeToGreekKeys.createArray(132, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[74] = UnicodeToGreekKeys.createArray(135, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[75] = UnicodeToGreekKeys.createArray(136, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[76] = UnicodeToGreekKeys.createArray(133, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[77] = UnicodeToGreekKeys.createArray(134, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[80] = UnicodeToGreekKeys.createArray(233, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[81] = UnicodeToGreekKeys.createArray(234, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[82] = UnicodeToGreekKeys.createArray(237, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[83] = UnicodeToGreekKeys.createArray(238, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[84] = UnicodeToGreekKeys.createArray(235, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[85] = UnicodeToGreekKeys.createArray(236, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[86] = UnicodeToGreekKeys.createArray(239, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[87] = UnicodeToGreekKeys.createArray(240, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[89] = UnicodeToGreekKeys.createArray(132, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[91] = UnicodeToGreekKeys.createArray(136, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[93] = UnicodeToGreekKeys.createArray(134, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[95] = UnicodeToGreekKeys.createArray(138, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[96] = UnicodeToGreekKeys.createArray(200, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[97] = UnicodeToGreekKeys.createArray(201, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[98] = UnicodeToGreekKeys.createArray(204, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[99] = UnicodeToGreekKeys.createArray(205, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[100] = UnicodeToGreekKeys.createArray(202, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[101] = UnicodeToGreekKeys.createArray(203, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[102] = UnicodeToGreekKeys.createArray(206, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[103] = UnicodeToGreekKeys.createArray(207, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[104] = UnicodeToGreekKeys.createArray(131, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[105] = UnicodeToGreekKeys.createArray(132, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[106] = UnicodeToGreekKeys.createArray(135, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[107] = UnicodeToGreekKeys.createArray(136, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[108] = UnicodeToGreekKeys.createArray(133, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[109] = UnicodeToGreekKeys.createArray(134, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[110] = UnicodeToGreekKeys.createArray(137, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[111] = UnicodeToGreekKeys.createArray(138, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[112] = UnicodeToGreekKeys.createArray(140, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[113] = UnicodeToGreekKeys.createArray(139, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[114] = UnicodeToGreekKeys.createArray(162, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[115] = UnicodeToGreekKeys.createArray(161, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[116] = UnicodeToGreekKeys.createArray(175, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[117] = UnicodeToGreekKeys.createArray(174, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[118] = UnicodeToGreekKeys.createArray(220, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[119] = UnicodeToGreekKeys.createArray(219, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[120] = UnicodeToGreekKeys.createArray(242, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[121] = UnicodeToGreekKeys.createArray(241, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[122] = UnicodeToGreekKeys.createArray(231, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[123] = UnicodeToGreekKeys.createArray(230, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[124] = UnicodeToGreekKeys.createArray(198, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[125] = UnicodeToGreekKeys.createArray(197, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[128] = UnicodeToGreekKeys.createArray(153, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[129] = UnicodeToGreekKeys.createArray(154, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[130] = UnicodeToGreekKeys.createArray(157, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[131] = UnicodeToGreekKeys.createArray(158, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[132] = UnicodeToGreekKeys.createArray(155, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[133] = UnicodeToGreekKeys.createArray(156, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[134] = UnicodeToGreekKeys.createArray(159, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[135] = UnicodeToGreekKeys.createArray(170, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[136] = UnicodeToGreekKeys.createArray(131, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[137] = UnicodeToGreekKeys.createArray(132, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[138] = UnicodeToGreekKeys.createArray(135, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[139] = UnicodeToGreekKeys.createArray(136, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[140] = UnicodeToGreekKeys.createArray(133, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[141] = UnicodeToGreekKeys.createArray(134, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[142] = UnicodeToGreekKeys.createArray(137, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[143] = UnicodeToGreekKeys.createArray(138, 65, 105);
        UnicodeToGreekKeys.tblGreekExtended[144] = UnicodeToGreekKeys.createArray(188, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[145] = UnicodeToGreekKeys.createArray(189, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[146] = UnicodeToGreekKeys.createArray(192, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[147] = UnicodeToGreekKeys.createArray(193, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[148] = UnicodeToGreekKeys.createArray(190, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[149] = UnicodeToGreekKeys.createArray(191, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[150] = UnicodeToGreekKeys.createArray(194, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[151] = UnicodeToGreekKeys.createArray(195, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[152] = UnicodeToGreekKeys.createArray(131, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[153] = UnicodeToGreekKeys.createArray(132, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[154] = UnicodeToGreekKeys.createArray(135, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[155] = UnicodeToGreekKeys.createArray(136, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[156] = UnicodeToGreekKeys.createArray(133, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[157] = UnicodeToGreekKeys.createArray(134, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[158] = UnicodeToGreekKeys.createArray(137, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[159] = UnicodeToGreekKeys.createArray(138, 72, 105);
        UnicodeToGreekKeys.tblGreekExtended[160] = UnicodeToGreekKeys.createArray(211, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[161] = UnicodeToGreekKeys.createArray(212, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[162] = UnicodeToGreekKeys.createArray(215, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[163] = UnicodeToGreekKeys.createArray(216, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[164] = UnicodeToGreekKeys.createArray(213, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[165] = UnicodeToGreekKeys.createArray(214, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[166] = UnicodeToGreekKeys.createArray(217, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[167] = UnicodeToGreekKeys.createArray(218, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[168] = UnicodeToGreekKeys.createArray(131, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[169] = UnicodeToGreekKeys.createArray(132, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[170] = UnicodeToGreekKeys.createArray(135, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[171] = UnicodeToGreekKeys.createArray(136, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[172] = UnicodeToGreekKeys.createArray(133, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[173] = UnicodeToGreekKeys.createArray(134, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[174] = UnicodeToGreekKeys.createArray(137, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[175] = UnicodeToGreekKeys.createArray(138, 86, 105);
        UnicodeToGreekKeys.tblGreekExtended[176] = UnicodeToGreekKeys.createArray(97, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[177] = UnicodeToGreekKeys.createArray(97, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[178] = UnicodeToGreekKeys.createArray(151, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[179] = UnicodeToGreekKeys.createArray(38, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[180] = UnicodeToGreekKeys.createArray(150, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[182] = UnicodeToGreekKeys.createArray(141, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[183] = UnicodeToGreekKeys.createArray(152, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[184] = UnicodeToGreekKeys.createArray(65, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[185] = UnicodeToGreekKeys.createArray(65, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[186] = UnicodeToGreekKeys.createArray(129, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[187] = UnicodeToGreekKeys.createArray(128, 65, 0);
        UnicodeToGreekKeys.tblGreekExtended[188] = UnicodeToGreekKeys.createArray(65, 105, 0);
        UnicodeToGreekKeys.tblGreekExtended[189] = UnicodeToGreekKeys.createArray(131, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[190] = UnicodeToGreekKeys.createArray(105, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[191] = UnicodeToGreekKeys.createArray(131, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[192] = UnicodeToGreekKeys.createArray(130, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[193] = UnicodeToGreekKeys.createArray(130, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[194] = UnicodeToGreekKeys.createArray(186, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[195] = UnicodeToGreekKeys.createArray(250, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[196] = UnicodeToGreekKeys.createArray(185, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[198] = UnicodeToGreekKeys.createArray(176, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[199] = UnicodeToGreekKeys.createArray(187, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[200] = UnicodeToGreekKeys.createArray(129, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[201] = UnicodeToGreekKeys.createArray(128, 69, 0);
        UnicodeToGreekKeys.tblGreekExtended[202] = UnicodeToGreekKeys.createArray(129, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[203] = UnicodeToGreekKeys.createArray(128, 72, 0);
        UnicodeToGreekKeys.tblGreekExtended[204] = UnicodeToGreekKeys.createArray(72, 105, 0);
        UnicodeToGreekKeys.tblGreekExtended[205] = UnicodeToGreekKeys.createArray(135, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[206] = UnicodeToGreekKeys.createArray(133, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[207] = UnicodeToGreekKeys.createArray(137, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[208] = UnicodeToGreekKeys.createArray(105, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[209] = UnicodeToGreekKeys.createArray(105, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[210] = UnicodeToGreekKeys.createArray(254, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[211] = UnicodeToGreekKeys.createArray(253, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[214] = UnicodeToGreekKeys.createArray(221, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[215] = UnicodeToGreekKeys.createArray(221, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[216] = UnicodeToGreekKeys.createArray(73, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[217] = UnicodeToGreekKeys.createArray(73, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[218] = UnicodeToGreekKeys.createArray(129, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[219] = UnicodeToGreekKeys.createArray(128, 73, 0);
        UnicodeToGreekKeys.tblGreekExtended[221] = UnicodeToGreekKeys.createArray(136, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[222] = UnicodeToGreekKeys.createArray(134, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[223] = UnicodeToGreekKeys.createArray(138, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[224] = UnicodeToGreekKeys.createArray(117, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[225] = UnicodeToGreekKeys.createArray(117, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[226] = UnicodeToGreekKeys.createArray(163, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[227] = UnicodeToGreekKeys.createArray(64, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[228] = UnicodeToGreekKeys.createArray(114, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[229] = UnicodeToGreekKeys.createArray(61, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[230] = UnicodeToGreekKeys.createArray(232, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[231] = UnicodeToGreekKeys.createArray(232, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[232] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[233] = UnicodeToGreekKeys.createArray(85, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[234] = UnicodeToGreekKeys.createArray(129, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[235] = UnicodeToGreekKeys.createArray(128, 85, 0);
        UnicodeToGreekKeys.tblGreekExtended[236] = UnicodeToGreekKeys.createArray(132, 82, 0);
        UnicodeToGreekKeys.tblGreekExtended[237] = UnicodeToGreekKeys.createArray(129, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[238] = UnicodeToGreekKeys.createArray(128, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[239] = UnicodeToGreekKeys.createArray(129, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[242] = UnicodeToGreekKeys.createArray(209, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[243] = UnicodeToGreekKeys.createArray(196, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[244] = UnicodeToGreekKeys.createArray(208, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[246] = UnicodeToGreekKeys.createArray(199, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[247] = UnicodeToGreekKeys.createArray(210, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[248] = UnicodeToGreekKeys.createArray(129, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[249] = UnicodeToGreekKeys.createArray(128, 79, 0);
        UnicodeToGreekKeys.tblGreekExtended[250] = UnicodeToGreekKeys.createArray(129, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[251] = UnicodeToGreekKeys.createArray(128, 86, 0);
        UnicodeToGreekKeys.tblGreekExtended[252] = UnicodeToGreekKeys.createArray(86, 105, 0);
        UnicodeToGreekKeys.tblGreekExtended[253] = UnicodeToGreekKeys.createArray(128, 0, 0);
        UnicodeToGreekKeys.tblGreekExtended[254] = UnicodeToGreekKeys.createArray(132, 0, 0);
    }
}

