/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.GreekConvCaps;
import greekconverter.GreekFileConverter;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Nereus
implements ActionListener,
WindowListener,
ListSelectionListener {
    private static final int INPUT_ENCODING = 0;
    private static final int OUTPUT_ENCODING = 1;
    private static final int FULL_LIST = 0;
    private static final int UNICODE_ONLY_LIST = 1;
    private GridBagLayout gridBag;
    private GridBagConstraints gridCons;
    private JFrame mainFrame;
    private JPanel mainPane;
    private JLabel srcLabel;
    private JTextField srcTf;
    private JButton srcBrowse;
    private JLabel inpEncLabel;
    private JComboBox inpEncChoice;
    private JLabel destLabel;
    private JTextField destTf;
    private JButton destBrowse;
    private JLabel outpEncLabel;
    private JComboBox outpEncChoice;
    private JLabel convLabel;
    private JList convList;
    private JScrollPane scrollPane;
    private JButton startConv;
    private JButton exitProg;
    private JFileChooser fileDlg;
    private JOptionPane msgDlg;
    private JLabel namedEntLabel;
    private JComboBox namedEntChoice;
    private JLabel numberEntLabel;
    private JComboBox numberEntChoice;
    private GreekFileConverter gfc;

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "06-Mar-2005";
                break;
            }
            case 1: {
                string = "Swing-GUI for class GreekFileConverter";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Felix qui potuit rerum cognoscere causas.";
            }
        }
        return string;
    }

    private void launchFrame() {
        System.out.println("Starting " + this.getClass().getName());
        System.out.println("Version " + Nereus.getClassInfo(0));
        this.gfc = new GreekFileConverter();
        this.srcLabel = new JLabel("Source file name:");
        this.srcTf = new JTextField("", 30);
        this.srcBrowse = new JButton("Browse...");
        this.srcBrowse.addActionListener(this);
        this.inpEncLabel = new JLabel("Input file encoding:");
        this.inpEncChoice = new JComboBox();
        this.createEncodingList(0, 0);
        this.destLabel = new JLabel("Destination file name:");
        this.destTf = new JTextField("", 30);
        this.destBrowse = new JButton("Browse...");
        this.destBrowse.addActionListener(this);
        this.outpEncLabel = new JLabel("Output file encoding:");
        this.outpEncChoice = new JComboBox();
        this.createEncodingList(1, 0);
        this.convLabel = new JLabel("Conversion:");
        String[] stringArray = new String[]{"Unicode -> Betacode", "Unicode -> ASCII", "Unicode -> HTML", "Unicode -> GreekKeys", "Unicode -> Names", "Betacode -> Unicode", "Betacode -> SPIonic", "ASCII -> Betacode", "BibleWorks -> Unicode", "BibleWorks -> Betacode*", "GreekKeys -> Unicode", "Unicode -> Decomposed", "Unicode -> Precomposed"};
        this.convList = new JList<String>(stringArray);
        this.convList.setSelectionMode(0);
        this.convList.setVisibleRowCount(5);
        this.convList.addListSelectionListener(this);
        this.scrollPane = new JScrollPane(this.convList);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.startConv = new JButton("Convert");
        this.startConv.addActionListener(this);
        this.exitProg = new JButton("Exit");
        this.exitProg.addActionListener(this);
        this.namedEntLabel = new JLabel("Use named entities:");
        this.namedEntChoice = new JComboBox();
        this.namedEntChoice.addItem("where available");
        this.namedEntChoice.addItem("never");
        this.numberEntLabel = new JLabel("Numbers for entities are:");
        this.numberEntChoice = new JComboBox();
        this.numberEntChoice.addItem("decimal");
        this.numberEntChoice.addItem("hexadecimal");
        this.gridBag = new GridBagLayout();
        this.gridCons = new GridBagConstraints();
        this.mainFrame = new JFrame(this.getClass().getName() + " v." + Nereus.getClassInfo(0));
        this.mainPane = (JPanel)this.mainFrame.getContentPane();
        this.mainPane.setLayout(this.gridBag);
        this.gridCons.insets = new Insets(5, 5, 5, 5);
        this.gridCons.gridwidth = 1;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.srcLabel, this.gridCons);
        this.mainPane.add(this.srcLabel);
        this.gridCons.fill = 3;
        this.gridBag.setConstraints(this.srcTf, this.gridCons);
        this.mainPane.add(this.srcTf);
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.srcBrowse, this.gridCons);
        this.mainPane.add(this.srcBrowse);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.inpEncLabel, this.gridCons);
        this.mainPane.add(this.inpEncLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.inpEncChoice, this.gridCons);
        this.mainPane.add(this.inpEncChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.destLabel, this.gridCons);
        this.mainPane.add(this.destLabel);
        this.gridCons.fill = 3;
        this.gridBag.setConstraints(this.destTf, this.gridCons);
        this.mainPane.add(this.destTf);
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.destBrowse, this.gridCons);
        this.mainPane.add(this.destBrowse);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.outpEncLabel, this.gridCons);
        this.mainPane.add(this.outpEncLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.outpEncChoice, this.gridCons);
        this.mainPane.add(this.outpEncChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.convLabel, this.gridCons);
        this.mainPane.add(this.convLabel);
        this.gridCons.gridheight = 2;
        this.gridCons.fill = 2;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.scrollPane, this.gridCons);
        this.mainPane.add(this.scrollPane);
        this.gridCons.gridheight = 1;
        this.gridCons.gridwidth = 0;
        this.gridCons.fill = 0;
        this.gridCons.anchor = 10;
        this.gridBag.setConstraints(this.startConv, this.gridCons);
        this.mainPane.add(this.startConv);
        this.gridBag.setConstraints(this.exitProg, this.gridCons);
        this.mainPane.add(this.exitProg);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.namedEntLabel, this.gridCons);
        this.mainPane.add(this.namedEntLabel);
        this.gridCons.gridx = -1;
        this.gridCons.gridwidth = 0;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.namedEntChoice, this.gridCons);
        this.mainPane.add(this.namedEntChoice);
        this.gridCons.gridwidth = 1;
        this.gridCons.anchor = 13;
        this.gridBag.setConstraints(this.numberEntLabel, this.gridCons);
        this.mainPane.add(this.numberEntLabel);
        this.gridCons.gridx = -1;
        this.gridCons.anchor = 17;
        this.gridBag.setConstraints(this.numberEntChoice, this.gridCons);
        this.mainPane.add(this.numberEntChoice);
        this.namedEntLabel.setVisible(false);
        this.namedEntChoice.setVisible(false);
        this.numberEntLabel.setVisible(false);
        this.numberEntChoice.setVisible(false);
        this.fileDlg = new JFileChooser();
        this.msgDlg = new JOptionPane();
        this.mainFrame.pack();
        this.mainFrame.addWindowListener(this);
        ((Component)this.mainFrame).setVisible(true);
    }

    private void errMsg(String string, int n) {
        String string2;
        switch (n) {
            case 0: {
                string2 = "Error";
                break;
            }
            case 1: {
                string2 = "Information";
                break;
            }
            case -1: {
                string2 = "Message";
                break;
            }
            case 2: {
                string2 = "Warning";
                break;
            }
            default: {
                string2 = "Read me";
            }
        }
        JOptionPane.showMessageDialog(this.mainFrame, string, string2, n);
    }

    private void errMsg(String string) {
        this.errMsg(string, 0);
    }

    private void createEncodingList(int n, int n2) {
        JComboBox jComboBox = n == 0 ? this.inpEncChoice : this.outpEncChoice;
        jComboBox.removeAllItems();
        switch (n2) {
            case 0: {
                jComboBox.addItem("Local charset");
                jComboBox.addItem("US-ASCII");
                jComboBox.addItem("ISO-8859-1");
            }
            case 1: {
                jComboBox.addItem("UTF-8");
                jComboBox.addItem("UTF-16");
                jComboBox.addItem("UTF-16BE");
                jComboBox.addItem("UTF-16LE");
            }
        }
    }

    private int getConversionNumber(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1002;
                break;
            }
            case 1: {
                n2 = 1006;
                break;
            }
            case 2: {
                n2 = 1003;
                break;
            }
            case 3: {
                n2 = 1004;
                break;
            }
            case 4: {
                n2 = 1007;
                break;
            }
            case 5: {
                n2 = 2001;
                break;
            }
            case 6: {
                n2 = 2008;
                break;
            }
            case 7: {
                n2 = 6002;
                break;
            }
            case 8: {
                n2 = 5001;
                break;
            }
            case 9: {
                n2 = 5002;
                break;
            }
            case 10: {
                n2 = 4001;
                break;
            }
            case 11: {
                n2 = 1011;
                break;
            }
            case 12: {
                n2 = 1021;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        Object object = actionEvent.getSource();
        if (object == this.startConv) {
            String string = this.srcTf.getText();
            String string2 = this.destTf.getText();
            int n2 = this.convList.getSelectedIndex();
            if (n2 == -1) {
                this.errMsg("You have to select a conversion from the list.");
                n = -1;
            }
            if (n == 0) {
                n = this.gfc.checkFileParams(string, string2);
            }
            if (n == 0) {
                String string3;
                String string4;
                int n3 = this.getConversionNumber(n2);
                System.out.println("Converting " + string + " using conversion " + this.convList.getSelectedValue() + " into " + string2);
                if (n3 == 1003) {
                    int n4 = this.namedEntChoice.getSelectedIndex();
                    int n5 = this.numberEntChoice.getSelectedIndex();
                    this.gfc.setOption(1, n4 + n5 * 2);
                }
                if ((string4 = (String)this.inpEncChoice.getSelectedItem()).equals("Local charset")) {
                    string4 = null;
                }
                if ((string3 = (String)this.outpEncChoice.getSelectedItem()).equals("Local charset")) {
                    string3 = null;
                }
                this.mainPane.setCursor(Cursor.getPredefinedCursor(3));
                n = this.gfc.convertFile(string, string2, n3, string4, string3);
                this.mainPane.setCursor(Cursor.getDefaultCursor());
            }
            if (n == 0) {
                System.out.println("\nDone");
                this.errMsg("Done", -1);
            } else {
                this.errMsg(this.gfc.getErrMsg());
            }
        } else if (object == this.srcBrowse) {
            this.fileDlg.setDialogTitle("Choose source file");
            n = this.fileDlg.showOpenDialog(this.mainFrame);
            if (n == 0) {
                this.srcTf.setText(this.fileDlg.getSelectedFile().getPath());
            }
        } else if (object == this.destBrowse) {
            this.fileDlg.setDialogTitle("Choose destination file");
            n = this.fileDlg.showSaveDialog(this.mainFrame);
            if (n == 0) {
                this.destTf.setText(this.fileDlg.getSelectedFile().getPath());
            }
        } else if (object == this.exitProg) {
            System.out.println("Good bye.");
            System.exit(0);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("Good bye.");
        System.exit(0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.convList.getSelectedIndex();
        int n2 = this.getConversionNumber(n);
        int n3 = GreekConvCaps.getConvInput(n2);
        int n4 = GreekConvCaps.getConvOutput(n2);
        switch (n3) {
            case 1: {
                this.createEncodingList(0, 1);
                this.inpEncLabel.setEnabled(true);
                this.inpEncChoice.setEnabled(true);
                break;
            }
            case 4: {
                this.createEncodingList(0, 0);
                this.inpEncLabel.setEnabled(false);
                this.inpEncChoice.setEnabled(false);
                break;
            }
            default: {
                this.createEncodingList(0, 0);
                this.inpEncLabel.setEnabled(true);
                this.inpEncChoice.setEnabled(true);
            }
        }
        switch (n4) {
            case 1: {
                this.createEncodingList(1, 1);
                this.outpEncLabel.setEnabled(true);
                this.outpEncChoice.setEnabled(true);
                break;
            }
            case 4: {
                this.createEncodingList(1, 0);
                this.outpEncLabel.setEnabled(false);
                this.outpEncChoice.setEnabled(false);
                break;
            }
            default: {
                this.createEncodingList(1, 0);
                this.outpEncLabel.setEnabled(true);
                this.outpEncChoice.setEnabled(true);
            }
        }
        if (n4 == 3) {
            this.namedEntLabel.setVisible(true);
            this.namedEntChoice.setVisible(true);
            this.numberEntLabel.setVisible(true);
            this.numberEntChoice.setVisible(true);
            this.mainFrame.pack();
        } else {
            this.namedEntLabel.setVisible(false);
            this.namedEntChoice.setVisible(false);
            this.numberEntLabel.setVisible(false);
            this.numberEntChoice.setVisible(false);
            this.mainFrame.pack();
        }
    }

    public static void main(String[] stringArray) {
        Nereus nereus = new Nereus();
        nereus.launchFrame();
    }
}

