/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

public class MessageHandler {
    public static final int MSGLVL_NOMSG = 0;
    public static final int MSGLVL_ERRORMSG = 10;
    public static final int MSGLVL_STATUSMSG = 20;
    public static final int MSGLVL_DEBUGMSG = 30;
    private static int msgLevel = 10;
    private static StringBuffer msgQueue = new StringBuffer(128);
    private static boolean msgSemaphore;

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "21-Mar-2002";
                break;
            }
            case 1: {
                string = "Contains methods for maintaining error and debug messages";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Brevis esse laboro, obscurus fio.";
            }
        }
        return string;
    }

    public static void setMsgLevel(int n) {
        msgLevel = n < 0 ? 0 : (n > 30 ? 30 : n);
    }

    public static int getMsgLevel() {
        return msgLevel;
    }

    public static void enqueueMsg(String string, int n) {
        if (n <= MessageHandler.getMsgLevel()) {
            msgQueue.append(string);
            msgSemaphore = true;
        }
    }

    public static void enqueueMsg(String string) {
        if (msgSemaphore) {
            msgQueue.append(string);
            msgSemaphore = false;
        }
    }

    public static void clearMsgQueue() {
        msgQueue.setLength(0);
        msgSemaphore = false;
    }

    public static boolean isMsgQueueEmpty() {
        return msgQueue.length() == 0;
    }

    public static void printMsgQueue(String string, String string2) {
        if (!MessageHandler.isMsgQueueEmpty()) {
            if (string != null) {
                System.err.println(string);
            }
            System.err.println(msgQueue.toString());
            if (string2 != null) {
                System.err.println(string2);
            }
            MessageHandler.clearMsgQueue();
        }
    }

    public static String dequeueMsg() {
        String string = new String(msgQueue.toString());
        MessageHandler.clearMsgQueue();
        return string;
    }
}

