/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.DynShortArray;
import greekconverter.GreekConvCaps;
import greekconverter.GreekConverter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class GreekFileConverter {
    public static final int SUCCESS = 0;
    public static final int ERR_GENERAL = -1;
    private static final int ERR_FILE_PARAMS = -2;
    private static final int ERR_UNKNOWN_CONV = -3;
    private static final int ERR_NO_UTF = -4;
    private static final int ERR_FILE_OPEN = -5;
    private static final int ERR_IO = -6;
    private static final int ERR_PARAMS = -7;
    private int convFrom;
    private int convInto;
    private String errMsg;
    private GreekConverter gc = new GreekConverter();
    private String encString = null;
    private BufferedReader cIn = null;
    private BufferedWriter cOut = null;
    private BufferedInputStream bIn = null;
    private BufferedOutputStream bOut = null;
    private InputStreamReader isr;
    private OutputStreamWriter osw;

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "06-Mar-2005";
                break;
            }
            case 1: {
                string = "Converts whole files from one Greek encoding into another one using class GreekConverter";
                break;
            }
            case 2: {
                string = "Michael Neuhold <michael.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Dimidium qui coepit habet.";
            }
        }
        return string;
    }

    public void setOption(int n, int n2) {
        switch (n) {
            case 1: {
                this.gc.setHTMLMode(n2);
            }
        }
    }

    public int openInput(String string, String string2, int n) {
        try {
            if (n == 4) {
                this.bIn = new BufferedInputStream(new DataInputStream(new FileInputStream(string)));
            } else {
                if (string2 == null && n == 1) {
                    string2 = "UTF-8";
                }
                this.isr = string2 == null ? new FileReader(string) : new InputStreamReader((InputStream)new FileInputStream(string), string2);
                this.cIn = new BufferedReader(this.isr);
            }
            return 0;
        }
        catch (IOException iOException) {
            this.handleException(iOException, "Error opening " + string + " for input");
            return -5;
        }
    }

    public int openOutput(String string, String string2, int n) {
        try {
            if (n == 4) {
                this.bOut = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(string)));
                this.encString = this.isr.getEncoding();
            } else {
                if (string2 == null && n == 1) {
                    string2 = "UTF-8";
                }
                this.osw = string2 == null ? new FileWriter(string) : new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2);
                this.cOut = new BufferedWriter(this.osw);
                this.encString = this.osw.getEncoding();
            }
            return 0;
        }
        catch (IOException iOException) {
            this.handleException(iOException, "Error opening " + string + " for output");
            return -5;
        }
    }

    public void closeInput() {
        try {
            if (this.bIn != null) {
                this.bIn.close();
            } else if (this.cIn != null) {
                this.cIn.close();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException, "Error closing input file");
        }
    }

    public void closeOutput() {
        try {
            if (this.bOut != null) {
                this.bOut.close();
            } else if (this.cOut != null) {
                this.cOut.close();
            }
        }
        catch (IOException iOException) {
            this.handleException(iOException, "Error closing output file");
        }
    }

    private void handleException(Exception exception, String string) {
        this.errMsg = exception.getLocalizedMessage();
        if (this.errMsg == null) {
            this.errMsg = string;
        }
        System.err.println(this.errMsg);
        exception.printStackTrace();
    }

    int checkFileParams(String string, String string2) {
        int n = 0;
        if (string == null || string.equals("")) {
            this.errMsg = "You have not provided the name of the source file.";
            n = -2;
        } else if (string2 == null || string2.equals("")) {
            this.errMsg = "You have not provided the name for the destination file.";
            n = -2;
        } else {
            File file = new File(string);
            File file2 = new File(string2);
            if (file.compareTo(file2) == 0) {
                this.errMsg = "Source and destination cannot be the same.";
                n = -2;
            }
        }
        if (n != 0) {
            System.err.println("ERROR! " + this.errMsg);
        }
        return n;
    }

    private int checkEncParams(int n, String string, String string2) {
        int n2 = 0;
        switch (n) {
            case 1002: 
            case 1003: 
            case 1004: 
            case 1006: 
            case 1007: 
            case 1011: 
            case 1021: 
            case 2001: 
            case 2008: 
            case 4001: 
            case 5001: 
            case 5002: 
            case 6002: {
                break;
            }
            default: {
                this.errMsg = "Not recognized or not supported conversion.";
                n2 = -3;
            }
        }
        if (n2 == 0) {
            this.convFrom = GreekConvCaps.getConvInput(n);
            this.convInto = GreekConvCaps.getConvOutput(n);
            if (!(this.convFrom != 1 || string != null && string.substring(0, 3).equals("UTF"))) {
                this.errMsg = "Conversion from Greek Unicode needs UTF input file encoding.";
                n2 = -4;
            }
        }
        if (!(n2 != 0 || this.convInto != 1 || string2 != null && string2.substring(0, 3).equals("UTF"))) {
            this.errMsg = "Conversion into Unicode needs UTF output file encoding.";
            n2 = -4;
        }
        if (n2 != 0) {
            System.err.println("ERROR! " + this.errMsg);
        }
        return n2;
    }

    public int convertFile(String string, String string2, int n) {
        return this.convertFile(string, string2, n, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public int convertFile(String var1_1, String var2_2, int var3_3, String var4_4, String var5_5) {
        var6_6 = null;
        var10_7 = 0;
        System.out.println("Invoking method convertFile of class " + this.getClass().getName());
        System.out.println("Version " + GreekFileConverter.getClassInfo(0));
        var11_8 = this.openInput(var1_1, var4_4, this.convFrom);
        if (var11_8 != 0) {
            return var11_8;
        }
        var11_8 = this.openOutput(var2_2, var5_5, this.convInto);
        if (var11_8 != 0) {
            return var11_8;
        }
        this.gc.setMessageLevel(2);
        try {
            block31: {
                if (this.convFrom != 4) ** GOTO lbl89
                var13_9 = false;
                var14_10 = new DynShortArray(512, 255);
                while ((var12_13 = this.bIn.read()) != -1) {
                    if (var12_13 == 10 || var12_13 == 13) {
                        if (!var13_9) {
                            if (var10_7++ % 20 == 0) {
                                System.out.print(".");
                            }
                            var14_10.pushElem((short)0);
                            var9_11 = this.gc.convertStringGreekKeysToUni(var14_10.getArray());
                            this.cOut.write(var9_11, 0, var9_11.length());
                            this.cOut.newLine();
                            var14_10.reset();
                            var13_9 = true;
                            continue;
                        }
                        var13_9 = false;
                        continue;
                    }
                    var14_10.pushElem((short)var12_13);
                }
                if (var14_10.getPos() <= -1) break block31;
                var9_11 = this.gc.convertStringGreekKeysToUni(var14_10.getArray());
                this.cOut.write(var9_11, 0, var9_11.length());
                this.cOut.newLine();
                break block31;
lbl-1000:
                // 1 sources

                {
                    if (var10_7++ % 20 == 0) {
                        System.out.print(".");
                    }
                    if (this.convInto == 4) {
                        var6_6 = this.gc.convertStringUniToGreekKeys(var8_16);
                        this.gc.printMessageQueue("line " + String.valueOf(var10_7 + 1), null);
                        var7_15 = 0;
                        while (var6_6[var7_15] != 0) {
                            this.bOut.write((byte)var6_6[var7_15]);
                            ++var7_15;
                        }
                        this.bOut.write(13);
                        this.bOut.write(10);
                        continue;
                    }
                    switch (var3_3) {
                        case 1002: {
                            var9_12 = this.gc.convertStringUniToBeta(var8_16);
                            break;
                        }
                        case 1006: {
                            var9_12 = this.gc.convertStringUniToAscii(var8_16);
                            break;
                        }
                        case 1003: {
                            var9_12 = this.gc.convertStringUniToHtml(var8_16);
                            break;
                        }
                        case 1007: {
                            var9_12 = this.gc.convertStringUniToName(var8_16);
                            break;
                        }
                        case 2001: {
                            var9_12 = this.gc.convertStringBetaToUni(var8_16);
                            break;
                        }
                        case 2008: {
                            var9_12 = this.gc.convertStringBetaToSp(var8_16);
                            break;
                        }
                        case 6002: {
                            var9_12 = this.gc.convertStringAsciiToBeta(var8_16);
                            break;
                        }
                        case 5002: {
                            var9_12 = this.gc.convertStringBwToBeta(var8_16);
                            break;
                        }
                        case 5001: {
                            var9_12 = this.gc.convertStringBwToUni(var8_16);
                            break;
                        }
                        case 1011: {
                            var9_12 = this.gc.decomposeUnicode(var8_16);
                            break;
                        }
                        case 1021: {
                            var9_12 = this.gc.precomposeUnicode(var8_16);
                            break;
                        }
                        default: {
                            var9_12 = "";
                        }
                    }
                    this.gc.printMessageQueue("line " + String.valueOf(var10_7 + 1), null);
                    this.cOut.write(var9_12, 0, var9_12.length());
                    this.cOut.newLine();
lbl89:
                    // 3 sources

                    ** while ((var8_16 = this.cIn.readLine()) != null)
                }
            }
            this.closeInput();
            this.closeOutput();
            return 0;
        }
        catch (IOException var12_14) {
            this.errMsg = var12_14.getLocalizedMessage();
            if (this.errMsg == null) {
                this.errMsg = "IOError - look at the console window.";
                if (this.convFrom == 1) {
                    this.errMsg = this.errMsg + " (Maybe invalid Unicode input.)";
                }
            }
            if (var10_7 != 0) {
                this.errMsg = this.errMsg + " - line " + String.valueOf(var10_7);
            }
            var12_14.printStackTrace();
            return -6;
        }
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public static void main(String[] stringArray) {
        String string = "GreekFileConverter srcfile destfile convmode [-inputenc value] [-outputenc value]";
        if (stringArray.length == 1 && stringArray[0].equals("-?")) {
            System.out.println(string);
            System.out.println(" srcfile     file name (and path) of the source text file");
            System.out.println(" destfile    file name (and path) of the output destination file");
            System.out.println(" convmode    Greek conversion mode");
            System.out.println(" -inputenc   encoding of srcfile, e.g. US-ASCII, ISO-8859-1, UTF-8");
            System.out.println("             default is the local charset");
            System.out.println(" -outputenc  encoding of destfile, like -inputenc");
            System.out.println(" Valid conversion modes are:");
            System.out.println(GreekConvCaps.getConvModes());
            return;
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        if (stringArray.length < 3) {
            System.err.println("ERROR! Wrong number of parameters. Usage:\n" + string + "\nInvoke with \"-?\" to get help on parameters.");
            System.exit(-1);
        }
        int n = 0;
        while (n < stringArray.length) {
            block18: {
                if (stringArray[n].charAt(0) == '-') {
                    try {
                        string8 = stringArray[n].substring(1);
                        ++n;
                        if (string8.equals("inputenc")) {
                            string5 = stringArray[n];
                            break block18;
                        }
                        if (string8.equals("outputenc")) {
                            string6 = stringArray[n];
                            break block18;
                        }
                        string7 = "Unrecognized option -" + string8;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.err.println("ERROR! Missing value for option -" + string8);
                        System.exit(-7);
                    }
                } else if (string2 == null) {
                    string2 = stringArray[n];
                } else if (string3 == null) {
                    string3 = stringArray[n];
                } else if (string4 == null) {
                    string4 = stringArray[n];
                } else {
                    string7 = "Extra parameter " + stringArray[n];
                }
            }
            if (string7 != null) {
                System.err.println("ERROR! " + string7);
                System.exit(-7);
            }
            ++n;
        }
        GreekFileConverter greekFileConverter = new GreekFileConverter();
        int n2 = greekFileConverter.checkFileParams(string2, string3);
        if (n2 == 0) {
            n2 = greekFileConverter.checkEncParams(Integer.valueOf(string4), string5, string6);
        }
        if (n2 == 0) {
            n2 = greekFileConverter.convertFile(string2, string3, Integer.valueOf(string4), string5, string6);
        }
    }
}

