/*
 * Decompiled with CFR 0.152.
 */
package greekconverter;

import greekconverter.MessageHandler;

public class BetacodeToSPIonic {
    private static final char UNDEFINED_SYMBOL = '\u0000';
    private static final byte WORDEND_NO = 0;
    private static final byte WORDEND_YES = 1;
    private static final byte[] tblWordEnd = new byte[256];
    private static boolean UPPERCASE;

    public static String getClassInfo(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "20-Jun-2004";
                break;
            }
            case 1: {
                string = "Converts a Beta coded string into simplified (SPIonic/Sgreek) Beta code.";
                break;
            }
            case 2: {
                string = "Michael Neuhold <homepage.neuhold@aon.at>";
                break;
            }
            default: {
                string = "Sic itur ad astra.";
            }
        }
        return string;
    }

    public static String convertString(String string) {
        string = string + ' ';
        int n = string.length();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(n);
        MessageHandler.clearMsgQueue();
        MessageHandler.enqueueMsg("Input >" + string + "< has " + n + " characters", 20);
        char c = string.charAt(n2++);
        while (n2 < n) {
            char c2 = string.charAt(n2++);
            switch (c2) {
                case '*': {
                    UPPERCASE = true;
                    break;
                }
                default: {
                    if (!(tblWordEnd[c2] != 1 || c != 'S' && c != 's' || UPPERCASE)) {
                        stringBuffer.append('j');
                        c = c2;
                        break;
                    }
                    if (UPPERCASE) {
                        if (c > '@') {
                            stringBuffer.append(Character.toUpperCase(c));
                            UPPERCASE = false;
                        } else {
                            stringBuffer.append(c);
                        }
                    } else {
                        stringBuffer.append(Character.toLowerCase(c));
                    }
                    c = c2;
                }
            }
            MessageHandler.enqueueMsg(" at pos. " + n2 + "\n");
        }
        return stringBuffer.toString();
    }

    static {
        int n = 0;
        while (n < 256) {
            BetacodeToSPIonic.tblWordEnd[n] = 0;
            ++n;
        }
        BetacodeToSPIonic.tblWordEnd[32] = 1;
        BetacodeToSPIonic.tblWordEnd[46] = 1;
        BetacodeToSPIonic.tblWordEnd[58] = 1;
        BetacodeToSPIonic.tblWordEnd[59] = 1;
        BetacodeToSPIonic.tblWordEnd[44] = 1;
        BetacodeToSPIonic.tblWordEnd[10] = 1;
        BetacodeToSPIonic.tblWordEnd[13] = 1;
        BetacodeToSPIonic.tblWordEnd[9] = 1;
        BetacodeToSPIonic.tblWordEnd[34] = 1;
        BetacodeToSPIonic.tblWordEnd[39] = 1;
        UPPERCASE = false;
    }
}

