/***************************************************************************
                     thmlhtmlhref.cpp  -  ThML to HTML filter with hrefs  
                             -------------------
    begin                    : 2001-09-03
    copyright            : 2001 by CrossWire Bible Society
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <thmlhtmlhref.h>
#include <swmodule.h>
#include <utilxml.h>

SWORD_NAMESPACE_START
 
ThMLHTMLHREF::ThMLHTMLHREF() {
	setTokenStart("<");
	setTokenEnd(">");
/*        
	setEscapeStart("&");
	setEscapeEnd(";");

	setEscapeStringCaseSensitive(true);

	addEscapeStringSubstitute("nbsp", " ");
	addEscapeStringSubstitute("quot", "\"");
	addEscapeStringSubstitute("amp", "&");
	addEscapeStringSubstitute("lt", "<");
	addEscapeStringSubstitute("gt", ">");
	addEscapeStringSubstitute("brvbar", "|");
	addEscapeStringSubstitute("sect", "");
	addEscapeStringSubstitute("copy", "");
	addEscapeStringSubstitute("laquo", "");
	addEscapeStringSubstitute("reg", "");
	addEscapeStringSubstitute("acute", "");
	addEscapeStringSubstitute("para", "");
	addEscapeStringSubstitute("raquo", "");

	addEscapeStringSubstitute("Aacute", "");
	addEscapeStringSubstitute("Agrave", "");
	addEscapeStringSubstitute("Acirc", "");
	addEscapeStringSubstitute("Auml", "");
	addEscapeStringSubstitute("Atilde", "");
	addEscapeStringSubstitute("Aring", "");
	addEscapeStringSubstitute("aacute", "");
	addEscapeStringSubstitute("agrave", "");
	addEscapeStringSubstitute("acirc", "");
	addEscapeStringSubstitute("auml", "");
	addEscapeStringSubstitute("atilde", "");
	addEscapeStringSubstitute("aring", "");
	addEscapeStringSubstitute("Eacute", "");
	addEscapeStringSubstitute("Egrave", "");
	addEscapeStringSubstitute("Ecirc", "");
	addEscapeStringSubstitute("Euml", "");
	addEscapeStringSubstitute("eacute", "");
	addEscapeStringSubstitute("egrave", "");
	addEscapeStringSubstitute("ecirc", "");
	addEscapeStringSubstitute("euml", "");
	addEscapeStringSubstitute("Iacute", "");
	addEscapeStringSubstitute("Igrave", "");
	addEscapeStringSubstitute("Icirc", "");
	addEscapeStringSubstitute("Iuml", "");
	addEscapeStringSubstitute("iacute", "");
	addEscapeStringSubstitute("igrave", "");
	addEscapeStringSubstitute("icirc", "");
	addEscapeStringSubstitute("iuml", "");
	addEscapeStringSubstitute("Oacute", "");
	addEscapeStringSubstitute("Ograve", "");
	addEscapeStringSubstitute("Ocirc", "");
	addEscapeStringSubstitute("Ouml", "");
	addEscapeStringSubstitute("Otilde", "");
	addEscapeStringSubstitute("oacute", "");
	addEscapeStringSubstitute("ograve", "");
	addEscapeStringSubstitute("ocirc", "");
	addEscapeStringSubstitute("ouml", "");
	addEscapeStringSubstitute("otilde", "");
	addEscapeStringSubstitute("Uacute", "");
	addEscapeStringSubstitute("Ugrave", "");
	addEscapeStringSubstitute("Ucirc", "");
	addEscapeStringSubstitute("Uuml", "");
	addEscapeStringSubstitute("uacute", "");
	addEscapeStringSubstitute("ugrave", "");
	addEscapeStringSubstitute("ucirc", "");
	addEscapeStringSubstitute("uuml", "");
	addEscapeStringSubstitute("Yacute", "");
	addEscapeStringSubstitute("yacute", "");
	addEscapeStringSubstitute("yuml", "");

	addEscapeStringSubstitute("deg", "");
	addEscapeStringSubstitute("plusmn", "");
	addEscapeStringSubstitute("sup2", "");
	addEscapeStringSubstitute("sup3", "");
	addEscapeStringSubstitute("sup1", "");
	addEscapeStringSubstitute("nbsp", "");
	addEscapeStringSubstitute("pound", "");
	addEscapeStringSubstitute("cent", "");
	addEscapeStringSubstitute("frac14", "");
	addEscapeStringSubstitute("frac12", "");
	addEscapeStringSubstitute("frac34", "");
	addEscapeStringSubstitute("iquest", "");
	addEscapeStringSubstitute("iexcl", "");
	addEscapeStringSubstitute("ETH", "");
	addEscapeStringSubstitute("eth", "");
	addEscapeStringSubstitute("THORN", "");
	addEscapeStringSubstitute("thorn", "");
	addEscapeStringSubstitute("AElig", "");
	addEscapeStringSubstitute("aelig", "");
	addEscapeStringSubstitute("Oslash", "");
	addEscapeStringSubstitute("curren", "");
	addEscapeStringSubstitute("Ccedil", "");
	addEscapeStringSubstitute("ccedil", "");
	addEscapeStringSubstitute("szlig", "");
	addEscapeStringSubstitute("Ntilde", "");
	addEscapeStringSubstitute("ntilde", "");
	addEscapeStringSubstitute("yen", "");
	addEscapeStringSubstitute("not", "");
	addEscapeStringSubstitute("ordf", "");
	addEscapeStringSubstitute("uml", "");
	addEscapeStringSubstitute("shy", "");
	addEscapeStringSubstitute("macr", "");
*/
	setTokenCaseSensitive(true);

	addTokenSubstitute("note", " <font color=\"#800000\"><small>(");
	addTokenSubstitute("/note", ")</small></font> ");
	addTokenSubstitute("/scripture", "</i> ");
}


bool ThMLHTMLHREF::handleToken(SWBuf &buf, const char *token, BasicFilterUserData *userData) {
	const char *tok;
	if (!substituteToken(buf, token)) { // manually process if it wasn't a simple substitution
		MyUserData *u = (MyUserData *)userData;
		XMLTag tag(token);
		if (tag.getName() && !strcmp(tag.getName(), "sync")) {
			if( tag.getAttribute("type") && !strcmp(tag.getAttribute("type"), "morph")) { //&gt;
				buf += "<small><em>(<a href=\"";
			}
			else {
				buf += "<small><em>&lt;<a href=\"";
			}

			buf += "type=";
			buf += tag.getAttribute("type");

			const char* value = tag.getAttribute("value");
			buf += " value=";
			buf += value ? value : "";
			buf += "\">";

			//add the value
			if (value && tag.getAttribute("type") && strcmp(tag.getAttribute("type"), "morph")) { //not morph type
				value++;
			}
			buf += value ? value : "";

			if(tag.getAttribute("type") && !strcmp(tag.getAttribute("type"), "morph"))
				buf += "</a>) </em></small>";
			else
				buf += "</a>&gt; </em></small>";
		}
		else if (tag.getName() && !strcmp(tag.getName(), "scripture")) {
			u->inscriptRef = true;
			buf += "<i>";
		}
		else if (tag.getName() && !strcmp(tag.getName(), "scripRef")) {
			if (tag.isEndTag()) {
				if (u->inscriptRef) { // like  "<scripRef passage="John 3:16">John 3:16</scripRef>"
					u->inscriptRef = false;
					buf += "</a>";
				}
				else { // end of scripRef like "<scripRef>John 3:16</scripRef>"
					buf += "<a href=\"passage=";
					buf += u->lastTextNode.c_str();
					buf += "\">";

					buf += u->lastTextNode.c_str();
					buf += "</a>";

					// let's let text resume to output again
					u->suspendTextPassThru = false;
				}
			}
			else if (tag.getAttribute("passage")) { //passage given
				u->inscriptRef = true;

				buf += "<a href=\"";
				if (const char* version = tag.getAttribute("version")) {
					buf += "version=";
					buf += version;
					buf += " ";
				}
				if (const char* passage = tag.getAttribute("passage")) {
					buf += "passage=";
					buf += passage;
				}
				buf += "\">";
			}
			else { //no passage or version given
				u->inscriptRef = false;
				// let's stop text from going to output
				u->suspendTextPassThru = true;
			}
		}
		else if (tag.getName() && !strcmp(tag.getName(), "div")) {
			if (tag.isEndTag() && u->SecHead) {
				buf += "</i></b><br />";
				u->SecHead = false;
			}
			else if (tag.getAttribute("class")) {
				if (!stricmp(tag.getAttribute("class"), "sechead")) {
					u->SecHead = true;
					buf += "<br /><b><i>";
				}
				else if (!stricmp(tag.getAttribute("class"), "title")) {
					u->SecHead = true;
					buf += "<br /><b><i>";
				}
			}
		}
/*		else if (!strncmp(token, "sync type=\"Strongs\" value=\"T", 28)) {
			buf +="<a href=\"");
			for (tok = token + 5; *(tok+1); tok++)
				if(*tok != '\"')
					*(*buf)++ = *tok;
			*(*buf)++ = '\"';
			*(*buf)++ = '>';
			for (tok = token + 29; *(tok+2); tok++)				
				if(*tok != '\"') 			
					*(*buf)++ = *tok;		
			buf +="</a>");
		}
*/
		else if (tag.getName() && !strcmp(tag.getName(), "img")) {
			const char *src = strstr(token, "src");
			if (!src)		// assert we have a src attribute
				return false;

			buf += '<';
			for (const char *c = token; *c; c++) {
				if (c == src) {
					for (;((*c) && (*c != '"')); c++)
						buf += *c;

					if (!*c) { c--; continue; }

					buf += '"';
					if (*(c+1) == '/') {
						buf += "file:";
						buf += userData->module->getConfigEntry("AbsoluteDataPath");
						if (buf[buf.length()-2] == '/')
							c++;		// skip '/'
					}
					continue;
				}
				buf += *c;
			}
			buf += '>';
		}
		else {
			buf += '<';
			/*for (const char *tok = token; *tok; tok++)
				buf += *tok;*/
			buf += token;
			buf += '>';
			//return false;  // we still didn't handle token
		}
	}
	return true;
}


SWORD_NAMESPACE_END
