#include <stdlib.h>
#include <stdio.h>

#include <gtk--.h>

#include <swmgr.h>


class SimpleFrontEnd : public Gtk_Window {
	Gtk_Label l1;
	Gtk_Label l2;
	Gtk_Label l3;
	Gtk_Entry kt;
	Gtk_Combo cb;
	Gtk_VBox *vb;
	Gtk_Text *text;
	SWMgr manager;
public:
	SimpleFrontEnd() : l1("Module Name:"), l2("KeyText:"), l3(""), kt(), vb(new Gtk_VBox), text(new Gtk_Text) {
		add(vb);
		vb->pack_start(&l1);
		vb->pack_start(&cb);
		vb->pack_start(&l2);
		vb->pack_start(&kt);
		vb->pack_start(&l3);
		vb->pack_start(text);
		vb->show();
		l1.show();
		l2.show();
		l3.show();
		kt.show();
		cb.show();
		text->set_word_wrap(TRUE);
		text->show();

		connect_to_method(kt.changed,this,&keypress);
		// use SWMgr to traverse installed modules and insert into QComboBox

		ModMap::iterator modIterator;
		G_List cbItems;

		for (modIterator = manager.Modules.begin(); modIterator != manager.Modules.end(); modIterator++)
			cbItems.append((void *)modIterator->first.c_str());
		cb.set_popdown_strings(cbItems);


	}
    
	gint delete_event_impl(GdkEventAny*) { 
		Gtk_Main::instance()->quit(); return 0; 
	}

	void keypress() {
		string keyText;
		string modName;
		ModMap::iterator it;
		gint position=0;

		keyText = kt.get_text();
		modName = cb.entry.get_text();

		it = manager.Modules.find(modName.c_str());
		if (it != manager.Modules.end()) {
			it->second->setKey(keyText.c_str());
			text->delete_text(0, text->get_length());
			text->insert_text((const char *)*it->second, strlen(*it->second), &position);
			l3.set(it->second->KeyText());
		}
	} 

};


int main(int argc, char *argv[]) {
  Gtk_Main m(&argc,&argv);
  SimpleFrontEnd *t=new SimpleFrontEnd;
  t->show();
  m.run();
  printf("After run!\n");
  return(EXIT_SUCCESS);
}












