//---------------------------------------------------------------------------
#include <vcl.h>
#include <vcl/clipbrd.hpp>
#pragma hdrstop

#include "CommentPanel.h"
#pragma package(smart_init)
#include "swdisprtfchap.h"
#include <swconfig.h>
#include <swmodule.h>
#include "Greek2Greek.h"
#include <utilfuns.h>
#include <swmgr.h>
#include <shellapi.h>

class RTFDisp : public SWDisplay {
	SWDispRTF *edit;
public:
	RTFDisp(SWDispRTF *iedit) { edit = iedit; }
	RTFDisp() {}
	char Display(SWModule &imodule) {
		edit->Display(imodule);
	}
};

class DispExternal : public SWDisplay {
public:
	DispExternal() {}
	char Display(SWModule &imodule) {
		SHELLEXECUTEINFO info;
		info.cbSize = sizeof(SHELLEXECUTEINFO);
		info.fMask = SEE_MASK_NOCLOSEPROCESS; //SEE_MASK_CLASSNAME;
		info.hwnd = GetFocus();
		info.lpVerb = "open";
		info.lpFile = (const char *)imodule;
		info.lpParameters = NULL;
		info.lpDirectory = NULL;
		info.nShow = 0;
//		info.lpClass = ".html";
		ShellExecuteEx(&info);
//		ShellExecute(edit->Handle, "open", (char *)imodule, NULL, NULL, SW_SHOWNORMAL);
	}
};

//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TCommentPanel *)
{
	new TCommentPanel(NULL);
}
//---------------------------------------------------------------------------
__fastcall TCommentPanel::TCommentPanel(TComponent* Owner, SWModule *mod, SWMgr *imgr)
	: TPanel(Owner)
{
	module = mod;
	mgr = imgr;
	this->font = 0;
	stdstr(&(this->font), font);
	menu = new TPopupMenu(this);
	menu->OnPopup = PopupMenuPopup;
	
	TMenuItem * newitem;
	newitem = new TMenuItem(menu);
	newitem->Caption = "&Copy";
	newitem->Hint = "Copy text to clipboard";
	newitem->Default = false;
	newitem->OnClick = Copy1Click;
	menu->Items->Add(newitem);
	if (!strcmp(mod->Name(), "N27U4")) {
		newitem = new TMenuItem(menu);
		newitem->Caption = "Copy as &B-Greek Transliteration";
		newitem->Hint = "Copy text to clipboard as B-Greek Transliteration";
		newitem->Default = false;
		newitem->OnClick = CopyasBGreekTransliteration1Click;
		menu->Items->Add(newitem);
	}
	newitem = new TMenuItem(menu);
	newitem->Caption = "Dictionary Lookup";
	newitem->Hint = "Send text to dictionary key for lookup";
	newitem->Default = false;
	newitem->OnClick = DictionaryLookup1Click;
	menu->Items->Add(newitem);
}


void __fastcall TCommentPanel::CreateWnd() {
	TPanel::CreateWnd();

	TWinControl *newrtf;

	if (mgr->config->Sections[module->Name()]["ModDrv"] == "HREFCom") {
//		if (mainmgr->config->Sections[mod->Name()]["External"] == "1") {
			newrtf = new TPanel(this);
			((TPanel *)newrtf)->Caption = "Syncronizing to External Viewer";
			display = new DispExternal();
			module->Disp(display);
/*
		}
		else {
	//		newrtf = new THTML(this->Handle);
	//		newrtf = new SWDispRTF(this);
			newrtf = HTML1;
			newrtf->Visible = true;
			mod->Disp(*displays.insert(displays.begin(), new HREFDisp((THTML *)newrtf)));
	//		mod->Disp(*displays.insert(displays.begin(), new RTFDisp((SWDispRTF *)newrtf)));
		}
*/
	}
	else {
		newrtf = new SWDispRTF(this);
		display = new RTFDisp((SWDispRTF *)newrtf);
		module->Disp(display);
		((SWDispRTF *)newrtf)->ScrollBars = ssVertical;
		((SWDispRTF *)newrtf)->ReadOnly = true;
		if (mgr->config->Sections[module->Name()]["ModDrv"] == "RawFiles") {
//			((SWDispRTF *)newrtf)->PopupMenu = PopupMenu3;
			((SWDispRTF *)newrtf)->ExpandNewLine = false;
		}
//		else	((SWDispRTF *)newrtf)->PopupMenu = PopupMenu2;
		((SWDispRTF *)newrtf)->OnMouseDown = RTFMouseDown;
	}

	newrtf->Parent = this;
	newrtf->Align = alClient;

//	mod->SetKey(DefaultVSKey);
//	return 0;


}
__fastcall TCommentPanel::~TCommentPanel() {
	delete display;
	if (font)
		delete font;
}
//---------------------------------------------------------------------------
namespace Commentpanel
{
	void __fastcall PACKAGE Register()
	{
		TComponentClass classes[1] = {__classid(TCommentPanel)};
		RegisterComponents("Samples", classes, 0);
	}
}
//---------------------------------------------------------------------------
void __fastcall TCommentPanel::PopupMenuPopup(TObject *Sender)
{
}
void TCommentPanel::BuildRTFHeader(char *buf, char *font, int max)
{
	char buf1[1024], buf2[1024];
	SectionMap::iterator sit;
	
	sprintf(buf1, "{\\rtf1\\ansi");
	if (font)
		sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 %s;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f2\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f3\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f4\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}", font);
	else sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 Times New Roman;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}");
	strcat(buf1, buf2);

//	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
//		sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red%d\\green%d\\blue%d;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}",
//			atoi((*sit).second["CurrentVSColorRed"].c_str()),
//			atoi((*sit).second["CurrentVSColorGreen"].c_str()),
//			atoi((*sit).second["CurrentVSColorBlue"].c_str()));
//	}
//	else	
	sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}");
	strcat(buf1, buf2);
	memset(buf, 0, max);
	strncpy(buf, buf1, max);
}


void __fastcall TCommentPanel::CopyasBGreekTransliteration1Click(TObject *Sender)
{
	char *retbuf;
	int len;
	TClipboard *clip = new TClipboard();
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	len = rtf->SelText.Length() * 2;
	retbuf = new char [ len ];
	if (!Greek2bGreek(retbuf, rtf->SelText.c_str(), len)) {
		clip->SetTextBuf(retbuf);
	}
	delete clip;
}

void __fastcall TCommentPanel::Copy1Click(TObject *Sender)
{
	int wordstart;
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length() - 1) - rtf->SelStart - 1;
	}
	rtf->CopyToClipboard();
}
void __fastcall TCommentPanel::DictionaryLookup1Click(TObject *Sender)
{
	int wordstart;
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length() - 1) - rtf->SelStart - 1;
	}
//	DictKeyEdit->Text = Trim(rtf->SelText);
}
void __fastcall TCommentPanel::RTFMouseDown(TObject *Sender, TMouseButton Button,
	 TShiftState Shift, int X, int Y)
{
	((TWinControl *)Sender)->SetFocus();
}
