#include <stdio.h>
#include <stdlib.h>
#include <GUSICommandLine.h>

#include "curlcpp.h"

// ============================================================================

static int sProgress(void *clientp, size_t dltotal, size_t dlnow, size_t ultotal, size_t ulnow)
{
	fprintf((FILE*) clientp, "%lu / %lu\n", (unsigned long) dlnow, (unsigned long) dltotal);
	return 0;
}

static int sPassword(void *clientp, const char *prompt, char *buffer, int buflen)
{
	static char sBuffer[512];
	
	fprintf((FILE*) clientp, prompt);
	gets(sBuffer);
	strncpy(buffer, sBuffer, (size_t) buflen);
	
	return 0;
}

// ============================================================================

#define kFTPUserPassword_Str	"eric:password"
#define kFTPURL_Str				"ftp:.//a.b.c"

static void TestFTP()
{
	curlEasyFTP		theRequest;
	CURLcode		theResult;
	
	theRequest.mUserPassword.SetUserAndPassword(kFTPUserPassword_Str);

	theRequest.SetUseEPSV(false);
	theRequest.SetListFileNamesOnly(true);
	
	theRequest.SetVerbose(true);
	theRequest.SetURL(kFTPURL_Str);
	theResult = theRequest.Perform();
	
	if (theResult != CURLE_OK)
		printf("Error: %s\n", theRequest.GetErrorStr());
}

// ============================================================================

#define kHTTPURL_Str	"http://a.b.c"

static void TestHTTP()
{
	curlEasyHTTP		theRequest;
	CURLcode			theResult;

	theRequest.mHeaders.AddHeader("Super","I love that");
		
	curlOutputFileTrait	theOutput("incoming.txt");
	theRequest.mOutputStorage.SetTrait(&theOutput, false);

	curlOutputFileTrait	theHeader("headers.txt");
	theRequest.mHeaderStorage.SetTrait(&theHeader, false);
	
	theRequest.mProgressCallBack.Set(sProgress, stdout);
	
	theRequest.SetVerbose(true);
	theRequest.SetURL(kHTTPURL_Str);
	theResult = theRequest.Perform();
	
	if (theResult != CURLE_OK)
		printf("Error: %s\n", theRequest.GetErrorStr());
}

// ============================================================================

#define kHTTPPost_Str		"a=1&b=2&c=7"
#define kHTTPPostURL_Str	"http://a.b.c"

static void TestHTTPPost()
{
	curlEasyHTTP		theRequest;
	CURLcode			theResult;

	curlOutputFileTrait	theOutput("incoming.txt");
	theRequest.mOutputStorage.SetTrait(&theOutput, false);

	curlOutputFileTrait	theHeader("headers.txt");
	theRequest.mHeaderStorage.SetTrait(&theHeader, false);
	
	theRequest.mProgressCallBack.Set(sProgress, stdout);
	
	theRequest.mPost.Set(kHTTPPost_Str);
	
	theRequest.SetVerbose(true);
	theRequest.SetURL(kHTTPPostURL_Str);
	theResult = theRequest.Perform();
	
	if (theResult != CURLE_OK)
		printf("Error: %s\n", theRequest.GetErrorStr());
}

// ============================================================================

IMPLEMENT_MAIN(curl)
{
	if (validate_command("h", 0))
		TestHTTP();
	else if (validate_command("f", 0))
		TestFTP();
	else if (validate_command("p", 0))
		TestHTTPPost();
	else
		goto usage;

	return 0;

usage:
	
	printf("Usage: curl option\n");
	printf("\th: http\n");
	printf("\tf: ftp\n");
	printf("\tp: http post\n");
	return 1;
}
