//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "StatusFrm.h"
#include "MainFrm.h"
#include <installmgr.h>
#include <filemgr.h>
#include <vector>

using namespace std;

//---------------------------------------------------------------------------
#pragma package(smart_init)
//#pragma link "IdBaseComponent"
//#pragma link "IdComponent"
//#pragma link "IdFTP"
//#pragma link "IdTCPClient"
//#pragma link "IdTCPConnection"
#pragma resource "*.dfm"
TStatusForm *StatusForm;


//---------------------------------------------------------------------------
__fastcall TStatusForm::TStatusForm(TComponent* Owner)
		: TForm(Owner) {
	suffix = "";
}


__fastcall TStatusForm::~TStatusForm() {
}


//---------------------------------------------------------------------------
void __fastcall TStatusForm::FormShow(TObject *Sender)
{
	ftpThread = new TFTPThread(is, src.c_str(), dest.c_str(), dirTransfer, true, suffix.c_str());
	ftpThread->OnTerminate = Cleanup;
	ftpThread->Resume();
}
//---------------------------------------------------------------------------
__fastcall TStatusForm::TFTPThread::TFTPThread(InstallSource *iis, const char *isrc, const char *idest, bool idirTransfer, bool CreateSuspended, const char *isuffix)
	: TThread(CreateSuspended)
{
	is = iis;
	src = isrc;
	dest = idest;
	suffix = isuffix;
	dirTransfer = idirTransfer;
	Priority = tpNormal;
	FreeOnTerminate = true;
	Synchronize((TThreadMethod)&CreateFTPObject);
}

__fastcall TStatusForm::TFTPThread::~TFTPThread()
{
}


void __fastcall TStatusForm::TFTPThread::Execute() {

	Synchronize((TThreadMethod)&PreConnect);

	int status = MainForm->installMgr->InstallMgr::FTPCopy(is, src, dest, dirTransfer, suffix);

	if (status == -1) {
		MessageBox(0, "Can't connect.  Please check your configuration.", "Connection Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
//	Synchronize((TThreadMethod)&PreDownload1);
	if (status == -2) {
		MessageBox(0, "Can't download file.  If you have not done so recently, you might try pressing the Refresh from Remote Source button.", "Download Error", MB_OK);
		StatusForm->Button1Click(0);	// abort thread
	}
//	Synchronize((TThreadMethod)&PreDownload2);
}


void __fastcall TStatusForm::TFTPThread::FTPLinkPacketRecvd(TObject *Sender)
{
//	Synchronize((TThreadMethod)&UpdateBytes);
}


//void __fastcall TStatusForm::TFTPThread::UpdateBytes(void) {
void __fastcall TStatusForm::UpdateBytes(void) {
}


void __fastcall TStatusForm::TFTPThread::CreateFTPObject(void)
{
//	FTPLink = new TNMFTP(0);
}


void __fastcall TStatusForm::TFTPThread::PreConnect(void)
{
	StatusForm->buffer = "Connecting to server at ";
	StatusForm->buffer += is->source.c_str();
	StatusForm->buffer += "...";
	StatusForm->actionBar->Caption = StatusForm->buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
}


void __fastcall TStatusForm::PreDownload1(void) {
//	SWLog::systemlog->LogInformation("Creating parent dir: %s", buffer.c_str());
//	SWLog::systemlog->LogInformation("Return: %d", ret);
	actionBar->Caption = StatusForm->buffer2.c_str();
	statusBar->Caption = "";
	Repaint();
}


void __fastcall TStatusForm::PreDownload2(void)
{
//	StatusForm->buffer = "Downloading: ";
//	StatusForm->buffer += src.c_str();
	StatusForm->actionBar->Caption = StatusForm->buffer.c_str();
	StatusForm->statusBar->Caption = "";
	StatusForm->Repaint();
//	FileMgr::createParent(dest.c_str());	// make sure parent directory exists
}


void __fastcall TStatusForm::Cleanup(TObject *Sender)
//void __fastcall TStatusForm::TFTPThread::Cleanup()
{
	if (MainForm->installMgr->terminate)
		StatusForm->ModalResult = mrCancel;
	else	StatusForm->ModalResult = mrOk;
//	StatusForm->Close();
}

void __fastcall TStatusForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	suffix = "";
	MainForm->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TStatusForm::Button1Click(TObject *Sender)
{
	MainForm->installMgr->terminate = true;
	ftpThread->Terminate();
}
//---------------------------------------------------------------------------

/*
void __fastcall TStatusForm::ftpConWork(TObject *Sender,
	 TWorkMode AWorkMode, const int AWorkCount)
{
	currentByteCount = AWorkCount;
//	Synchronize((TThreadMethod)&UpdateBytes);
	UpdateBytes();
}
*/
//---------------------------------------------------------------------------

