//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop


#include "MainFrm.h"
#include "StatusFrm.h"
#include "RemoteMntFrm.h"
#include "InfoFrm.h"
#include "cipherfrm.h"
#include "UninstallFrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

#include <swwinlog.h>
#include <shellapi.h>
#include <dirent.h>
#include <fcntl.h>
#include <io.h>
#include <sys/stat.h>
#include <dir.h>
#include <FileCtrl.hpp>
#include <installmgr.h>
#include <filemgr.h>

TMainForm *MainForm;

int InstallMgrWin::FTPCopy(InstallSource *is, const char *src, const char *dest, bool dirTransfer, const char *suffix) {
	StatusForm->is = is;
	StatusForm->src = src;
	StatusForm->dest = dest;
	StatusForm->suffix = suffix;
	StatusForm->dirTransfer = dirTransfer;
	Application->ProcessMessages();
	if (StatusForm->ShowModal() == mrCancel)
		return -1;
	else	return 0;
}

void InstallMgrWin::preDownloadStatus(long totalBytes, long completedBytes, const char *message) {
	StatusForm->totalBytes = totalBytes;
	StatusForm->completedBytes = completedBytes;
	StatusForm->buffer = message;
	StatusForm->PreDownload2();
	Application->ProcessMessages();
}

void InstallMgrWin::statusUpdate(double dltotal, double dlnow) {
	if (!dltotal || !StatusForm->totalBytes)
		return;	// prevent division by zero error below
	int filePercent  = (int)((float)(dlnow + 1) / (float)(dltotal) * 100);
	int totalPercent = (int)((float)(dlnow + StatusForm->completedBytes + 1) / (float)(StatusForm->totalBytes) * 100);
	StatusForm->statusBar->Caption = ::IntToStr((long)dlnow) + " bytes out of " + ::IntToStr((long)dltotal) + " transferred (file: " + IntToStr(filePercent) + "% / total: " + IntToStr(totalPercent) + "%)";
	StatusForm->fileProgress->Position = filePercent;
	StatusForm->totalProgress->Position = totalPercent;
	
	StatusForm->statusBar->Repaint();
	Application->ProcessMessages();
}

bool InstallMgrWin::getCipherCode(const char *modName, SWConfig *config) {
	CipherForm->modName = modName;
	CipherForm->config = config;
	return (CipherForm->ShowModal() == mrCancel);
}

__fastcall InstallSourceTab::InstallSourceTab(TComponent *Owner, InstallSource *is) : TControl(Owner) {
	this->is = is;
}

__fastcall InstallSourceTab::~InstallSourceTab() {
}
	
__fastcall TMainForm::TMainForm(TComponent* Owner)
		: TForm(Owner) {
	try {
	    manager = new SWMgr();
	}
	catch (...) {
		 FileMgr::createPathAndFile("./mods.d/globals.conf");           
		 manager = new SWMgr();
	}

	if (FileMgr::existsFile("./InstallMgr.conf")) {
		FileMgr::copyFile("./InstallMgr.conf", "installMgr/InstallMgr.conf");
		FileMgr::removeFile("./InstallMgr.conf");
	}
	installMgr = new InstallMgrWin("./installMgr");
	localMgr = 0;
}


__fastcall TMainForm::~TMainForm() {
	delete manager;
	if (localMgr)
		delete localMgr;
	delete installMgr;
}


void __fastcall TMainForm::FormCreate(TObject *Sender) {

	refreshPageControl();
	
	if (SWLog::systemlog)
		delete SWLog::systemlog;
	SWLog::systemlog = new SWWinLog(this->Handle);		// set the system logger to our MSWindows specific SWLog class

	fillInstallTree();
	fillSourceTree(localTree);
}


void TMainForm::refreshPageControl() {
	InstallSourceMap::iterator source;

	while (PageControl1->PageCount > 1) {
		delete PageControl1->Pages[1];
	}
	
	for (source = installMgr->sources.begin(); source != installMgr->sources.end(); source++) {
		InstallSourceTab *ist = new InstallSourceTab(this, source->second);
		source->second->userData = (void *)ist;
		addSource(ist);
	}
}


void TMainForm::addSource(InstallSourceTab *ist) {
	TTabSheet *newtab = new TTabSheet(this);
	TTreeView *newtree = new TTreeView(this);
	TSpeedButton *newbutton = new TSpeedButton(this);
	TPanel *newpanel = new TPanel(this);
	char buf[512];
	SectionMap::iterator sit;
	
	newtab->Caption = ist->is->caption.c_str();
	newtab->Hint = ist->is->source.c_str();
	newtab->ShowHint = true;
	newtab->PageControl = PageControl1;
	ist->Parent = newtab;
	ist->tree = newtree;
	newpanel->Parent = newtab;
	newpanel->Align = alTop;
	newpanel->BevelOuter = bvNone;
	newpanel->BevelInner = bvNone;
	newpanel->Height = 25;
	newbutton->Parent = newpanel;
	newbutton->Caption = "Refresh from Remote Source";
	newbutton->Width = 210;
	newbutton->OnClick = RefreshRemoteSource;
	newbutton->Flat = true;
	newbutton->Glyph = SpeedButton2->Glyph;
	newtree->Parent = newtab;
	newtree->Align = alClient;
	newtree->ReadOnly = true;
	newtree->OnDblClick = localTreeDblClick;
	newtree->Images = ImageList1;
	newtree->StateImages = ImageList2;
	fillSourceTree(newtree, ist->is);
}


const char *TMainForm::getLocalDir() {
	ConfigEntMap::iterator entry;

	entry = installMgr->installConf->Sections["Sources"].find("LocalPath");
	if (entry == installMgr->installConf->Sections["Sources"].end()) {
		installMgr->installConf->Sections["Sources"].insert(ConfigEntMap::value_type("LocalPath", "d:/sword"));
		entry = installMgr->installConf->Sections["Sources"].find("LocalPath");
	}
	return entry->second.c_str();
}


void TMainForm::setLocalDir(const char *idir) {
	(*(installMgr->installConf))["Sources"]["LocalPath"] = idir;
}


//---------------------------------------------------------------------------
void __fastcall TMainForm::LocalPath1Click(TObject *Sender) {
	AnsiString Dir = "C:";
	WideString Root = getLocalDir();
	SelectDirectory("Select Local Path", Root , Dir);

	setLocalDir(Dir.c_str());

	installMgr->installConf->Save();
	fillSourceTree(localTree);
}
//---------------------------------------------------------------------------

void TMainForm::fillInstallTree() {
	ModMap::iterator mods;
	TTreeNode *node;
	SWBuf nodeName;
	
	installTree->Items->Clear();

	if (!manager->configPath)
		return;

	for (mods = manager->Modules.begin(); mods != manager->Modules.end(); mods++) {
		for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
			if (!strcmp(node->Text.c_str(), mods->second->Type())) {
				break;
			}
		}
		if (!node) {	// Add Section
			if (!strncmp(mods->second->Type(), "Bibl", 4))	// If Bibles, put first in list
				node = installTree->Items->AddChildFirst(0, mods->second->Type());
			else	node = installTree->Items->AddChild(0, mods->second->Type());
		}
		nodeName = "[";
		nodeName += mods->second->Name();
		nodeName += "] ";
		nodeName += mods->second->Description();
		node = installTree->Items->AddChildObject(node, nodeName.c_str(), mods->second->Name());
	}
	for (node = installTree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = installTree->Items->GetFirstNode();
	if (node)
		node->MakeVisible();
}


void TMainForm::fillSourceTree(TTreeView *tree, InstallSource *is) {
	ModMap::iterator mods;
	TTreeNode *node;
	SectionMap::iterator sections, targetSection;
	ConfigEntMap::iterator entry;
	SWBuf secName;
	const char * modDesc;
	SWBuf nodeName;
	SWBuf targetVersion;
	SWBuf sourceVersion;
	SWBuf softwareVersion;
	bool cipher;
	bool showLocked = LockedModules1->Checked;
	
	SWMgr *mgr;

	if (tree == localTree) {
		if (localMgr)
			delete localMgr;
		mgr = localMgr = new SWMgr(getLocalDir());
	}
	else {
		InstallSourceTab *ist = (InstallSourceTab *) tree->Parent->Controls[0];
		mgr = ist->is->getMgr();
	}
	
	tree->Items->Clear();

	if (!mgr->configPath)
		return;

	for (sections = mgr->config->Sections.begin(); sections != mgr->config->Sections.end(); sections++) {
	
		cipher = false;
		
		if (!strcmp(sections->first.c_str(), "Globals"))	// skip [Globals]
			continue;
			
		entry = sections->second.find("CipherKey");
		if (entry != sections->second.end()) {
			if (showLocked)
				cipher = true;
			else continue;
		}
		
		mods = mgr->Modules.find(sections->first.c_str());
		if (mods != mgr->Modules.end())
			secName = mods->second->Type();
		else {
			secName = "Other";
		}

		SWBuf misc1 = ((entry = sections->second.find("Category")) != sections->second.end()) ? (SWBuf)(*entry).second.c_str() : (SWBuf)"";
		if (misc1.length() > 0)
		   secName = misc1;

		entry = sections->second.find("Description");
		if (entry != sections->second.end())
			modDesc = entry->second.c_str();
		else modDesc = "";
		
		
		targetVersion = "0.0";
		sourceVersion = "1.0";
		softwareVersion = (const char *)SWVersion::currentVersion;
		
		entry = sections->second.find("Version");
		if (entry != sections->second.end())
			sourceVersion = entry->second.c_str();

		entry = sections->second.find("MinimumVersion");
		if (entry != sections->second.end())
			softwareVersion = entry->second.c_str();

		targetSection = manager->config->Sections.find(sections->first);
		if (targetSection != manager->config->Sections.end()) {
			targetVersion = "1.0";
			entry = targetSection->second.find("Version");
			if (entry != targetSection->second.end())
				targetVersion = entry->second;
		}

		if (SWVersion(sourceVersion.c_str()) > SWVersion(targetVersion.c_str())) {
			for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
				if (!strcmp(node->Text.c_str(), secName.c_str())) {
					break;
				}
			}

			if (!node) {	// Add Section
				if (!strncmp(secName.c_str(), "Bibl", 4))	// If Bibles, put first in list
					node = tree->Items->AddChildFirst(0, secName.c_str());
				else	node = tree->Items->AddChild(0, secName.c_str());
				node->ImageIndex = 0;
			}
			nodeName = (SWBuf)"[" + sections->first + "] " + modDesc;
			node = tree->Items->AddChildObject(node, nodeName.c_str(), (void *) sections->first.c_str());
			if (SWVersion(targetVersion.c_str()) < SWVersion("1.0")) {
				node->ImageIndex = 1;
				node->SelectedIndex = 1;
			}
			else {
				node->ImageIndex = 2;
				node->SelectedIndex = 2;
			}
			if (cipher) {
				node->ImageIndex += 2;
				node->SelectedIndex += 2;
			}
			if (SWVersion::currentVersion < SWVersion(softwareVersion.c_str())) {
				node->ImageIndex = 5;
				node->SelectedIndex = 5;
			}
			node->StateIndex = 0;
		}
	}
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling())
		node->Expand(true);
	node = tree->Items->GetFirstNode();
	if (node)
		node->MakeVisible();
}


void __fastcall TMainForm::Button5Click(TObject *Sender) {
	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (node->ImageIndex == 5) {
				SWMgr *mgr = (tree == localTree) ? manager : ((InstallSourceTab *) PageControl1->ActivePage->Controls[0])->is->getMgr();
				SWBuf minVer = (*mgr->config)[(const char *)node->Data]["MinimumVersion"];

				InfoForm->Caption = "Need To Upgrade";
				InfoForm->info = "\\qc {\\b \\fs20 Newer Software Version Required.}\\par\\par\\pard ";
				InfoForm->info += "This module requires a newer version of the SWORD software engine. \\par\\par ";
				InfoForm->info += "Your Current Version: ";
				InfoForm->info += (const char *)SWVersion::currentVersion;
				InfoForm->info += "\\par Required Version: ";
				InfoForm->info += minVer.c_str();
				InfoForm->info += "\\par\\par\\b\\qc Please visit http://www.crosswire.org to upgrade.";
				InfoForm->ShowModal();
				return;
			}

			if (node->StateIndex == 1)
				node->StateIndex = 0; //node->StateIndex;
			else	node->StateIndex = 1;
			tree->Repaint();
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::localTreeDblClick(TObject *Sender) {
	Button5Click(Sender);
}
//---------------------------------------------------------------------------

int TMainForm::selectAll(TTreeView *tree, bool sel) {
	TTreeNode *node;
	TTreeNode *node2;
	int retCount = 0;
	
	for (node = tree->Items->GetFirstNode(); node; node = node->getNextSibling()) {
		for (node2 = node->getFirstChild(); node2; node2 = node2->getNextSibling()) {
			if (node2->ImageIndex != 5) {
				if (node2->StateIndex == 1) {
					if (!sel) {
						node2->StateIndex = 0; //node2->StateIndex;
						retCount++;
					}
				}
				else	{
					if (sel) {
						node2->StateIndex = 1;
						retCount++;
					}
				}
			}
		}
	}
	return retCount;
}


// SELECT ALL
void __fastcall TMainForm::Button6Click(TObject *Sender) {
	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}
	if (!selectAll(tree, true))
		selectAll(tree, false);
	tree->Repaint();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Image1Click(TObject *Sender) {
	ShellExecute(this->Handle, "open", "http://www.crosswire.org", NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------


void	TMainForm::fillAllSourceTrees() {
	fillSourceTree(localTree);
	for (int i = 1; i < PageControl1->PageCount; i++) {
		InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->Pages[i]->Controls[0];
		fillSourceTree(ist->tree, ist->is);
	}
}


// REMOVE MODULE
void __fastcall TMainForm::Button4Click(TObject *Sender) {
	TTreeNode *node = installTree->Selected;
	if (node) {
		if (node->Parent) {
			installMgr->removeModule(manager, (const char *)node->Data);
			delete manager;
			manager = new SWMgr();
			fillInstallTree();
			fillAllSourceTrees();
		}
	}
}
//---------------------------------------------------------------------------

// INSTALL
void __fastcall TMainForm::Button2Click(TObject *Sender) {
	TTreeNode *node;
	int count = 0;
	int abort = 0;

	class TWaitCursor {
	public:
	    TWaitCursor() : oldc(Screen->Cursor) { Screen->Cursor = crHourGlass; }
	    ~TWaitCursor()                       { Screen->Cursor = oldc; }
	private:
	    TCursor oldc;
	} wait; // show hourglass

	TTreeView *tree;
	for (int i = 0; i < PageControl1->ActivePage->ControlCount; i++) {
		if (PageControl1->ActivePage->Controls[i]->ClassNameIs("TTreeView")) {
			tree = (TTreeView*)(PageControl1->ActivePage->Controls[i]);
			break;
		}
	}

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1)
			count++;
	}	// do true progress bar

	if (!count) {
		MessageBox(this->WindowHandle, "Please first choose which modules you would like to install by double-clicking a module in the 'Available' tree.", "Please select modules first.", MB_OK);
		return;		// if nothing is selected, do nothing
	}
		
	progressBar->Max = count;
	progressBar->Position = 0;

	for (node = tree->Items->GetFirstNode(); node; node = node->GetNext()) {
		if (node->StateIndex == 1) {	// if selected for install
			CipherForm->cipherEdit->Text = "";
			if ((node->ImageIndex == 2) || (node->ImageIndex == 4)) {	// if this is an upgrade
				installMgr->removeModule(manager, (const char *)node->Data);
			}
				// install module
			statusBar->Caption = "Installing: " + node->Text + "...";
			statusBar->Repaint();
			if (tree == localTree)
				abort = installMgr->installModule(manager, getLocalDir(), (const char *)node->Data, 0);
			else	abort = installMgr->installModule(manager, 0, (const char *)node->Data, ((InstallSourceTab *) PageControl1->ActivePage->Controls[0])->is);
			if (abort)
				break;
			progressBar->Position++;
		}
	}
	delete manager;
	manager = new SWMgr();
	fillInstallTree();
	fillAllSourceTrees();
	statusBar->Caption = "";
	progressBar->Position = 0;
}


void __fastcall TMainForm::RefreshRemoteSource(TObject *Sender) {
	InstallSourceTab *ist = (InstallSourceTab *) MainForm->PageControl1->ActivePage->Controls[0];
	installMgr->refreshRemoteSource(ist->is);
	fillSourceTree(ist->tree, ist->is);	
}



void __fastcall TMainForm::SpeedButton1Click(TObject *Sender) {
	InfoForm->Caption = "W A R N I N G";
	InfoForm->info = "\\qc {\\b \\fs20 -=+* WARNING *+=- -=+* WARNING *+=-}\\par\\par\\pard ";
	InfoForm->info += "Although Install Manager provides a convenient way for installing and upgrading SWORD components, it also uses a systematic method for accessing sites which gives packet sniffers a target to lock into for singling out users. \\par\\par ";
	InfoForm->info += "\\b\\qc IF YOU LIVE IN A PERSECUTED COUNTRY AND DO NOT WISH TO RISK DETECTION, YOU SHOULD *NOT* USE INSTALL MANAGER'S REMOTE SOURCE FEATURES.";
	InfoForm->ShowModal();
	if (RemoteMntForm->ShowModal() == mrOk) {
		delete installMgr;
		installMgr = new InstallMgrWin("./installMgr");
		refreshPageControl();
	}
}


void __fastcall TMainForm::SpeedButton5Click(TObject *Sender) {
	TTreeView *tree;
	InstallSourceTab *ist = 0;
	SectionMap::iterator module;
	ConfigEntMap::iterator entry, entryEnd;
	SWBuf sourceDir;

	if (PageControl1->ActivePage != PageControl1->Pages[0]) {
		ist = (InstallSourceTab *) PageControl1->ActivePage->Controls[0];
		tree = ist->tree;
	}
	else	tree = localTree;
		
	TTreeNode *node = tree->Selected;
	if (node) {
		if (node->Parent) {
			if (ist)
				sourceDir = (SWBuf)"./installMgr/" + ist->is->source;
			else	sourceDir = getLocalDir();
			SWMgr *mgr = new SWMgr(sourceDir.c_str());
	
			module = mgr->config->Sections.find((const char *)node->Data);

			if (module != mgr->config->Sections.end()) {
				SWBuf targetVersion = "0.0";
				SWBuf sourceVersion = "1.0";
				SectionMap::iterator targetSection;
					
				entry = module->second.find("Version");
				if (entry != module->second.end())
					sourceVersion = entry->second.c_str();

				targetSection = manager->config->Sections.find(module->first);
				if (targetSection != manager->config->Sections.end()) {
					targetVersion = "1.0";
					entry = targetSection->second.find("Version");
					if (entry != targetSection->second.end())
						targetVersion = entry->second;
				}
				if (SWVersion(targetVersion.c_str()) < SWVersion("1.0")) {
					InfoForm->info = "\\pard{\\b * Additional Module Available for Install. } \\par ";
				}
				else {
					InfoForm->info = (SWBuf)"\\pard{\\b + Upgraded Module Available for Install.}\\par\\tab Current Version:  \\tab " + targetVersion + " \\par\\tab Upgrade Version:\\tab " + sourceVersion + " \\par ";
					bool changes = false;
					for (entry = module->second.begin(); entry != module->second.end(); entry++) {
						if (!strncmp(entry->first.c_str(), "History_", 8)) {
							if (SWVersion(&entry->first.c_str()[8]) > SWVersion(targetVersion.c_str())) {
								if (!changes) {
									changes = true;
									InfoForm->info += "\\par{\\b Changes: }\\par ";
								}
								InfoForm->info += "\\tab ";
								InfoForm->info += entry->second.c_str();
								InfoForm->info += "\\par ";
							}
						}
					}
				}

				entry = module->second.find("About");
				if (entry != module->second.end()) {
					InfoForm->info += "\\par{\\b About: } \\par\\par ";
					InfoForm->info += entry->second.c_str();
				}
				InfoForm->Caption = "Module Information";
				InfoForm->ShowModal();
			}
			delete mgr;
		}
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Exit1Click(TObject *Sender) {
	Close();	
}
//---------------------------------------------------------------------------


void TMainForm::deleteAllModules() {

	SWMgr *mgr = new SWMgr();
	

	int count = mgr->Modules.size();

	if (!count)
		return;

	UninstallForm->Show();
	UninstallForm->ProgressBar1->Max = count;
	UninstallForm->ProgressBar1->Position = 0;

	ModMap::iterator it;
	for (it = mgr->Modules.begin(); it != mgr->Modules.end(); it++) {
		SWBuf label = "Uninstalling: [";
		label += it->second->Name();
		label += "] ";
		label += it->second->Description();
		UninstallForm->Label1->Caption = label.c_str();
		UninstallForm->Label1->Repaint();
		installMgr->removeModule(mgr, it->second->Name());
		UninstallForm->ProgressBar1->Position = UninstallForm->ProgressBar1->Position + 1;
		UninstallForm->ProgressBar1->Repaint();
	}
	delete mgr;
	UninstallForm->Hide();
	return;
}


void __fastcall TMainForm::FormShow(TObject *Sender) {
	for (int i=0;i<=ParamCount();i++) {
		if (LowerCase(ParamStr(i)) == "-uninstall") {
			deleteAllModules();
			Application->Terminate();
		}
	}
	
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::LockedModules1Click(TObject *Sender) {
	LockedModules1->Checked = !(LockedModules1->Checked);

	if (LockedModules1->Checked) {
		InfoForm->Caption = "About Locked Modules";
		InfoForm->info = "\\qc {\\b \\fs20 About Locked Modules}\\par\\par\\pard ";

		InfoForm->info += "Unfortunately, we are unable to legally provide these modules to the general public at this time. We are making attempts to gain permission from the copyright holders, but until such an agreement is arranged, these modules are only available to our developers and testers.  We hope to be able to provide some of these to you soon. \\par\\par\\pard ";
		InfoForm->info += "If you would like to contribute to the project by contacting a publisher seeking distribution permission for CrossWire, your efforts would be very appreciated-- especially in regard to non-English texts. Please subscribe to our developers' forum per instructions on our website, following the [Mailing Lists] link, and post a message stating how you would like to help. Thank you. \\par\\par\\pard ";
		InfoForm->info += "\t-CrossWire Bible Society. ";
		InfoForm->ShowModal();
	}
	fillAllSourceTrees();
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Contents1Click(TObject *Sender) {
	SWConfig optionsconf("options.conf");
	SWBuf helpDir;
	ConfigEntMap::iterator it = optionsconf.Sections["Help"].find("Directory");
	if (it != optionsconf.Sections["Help"].end())
		helpDir = (*it).second;
	else helpDir = ".\\help";

	SWBuf helpExe = helpDir + "\\Sword.chm::modulesh.html#instmgr";
	ShellExecute(this->Handle, "open", "hh", helpExe.c_str(), NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------

