//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "SplashPage.h"
#include <winreg.h>
#include <dir.h>
#include "sword.h"
#include <thmlplain.h>

using namespace sword;

USERES("sword.res");
USEFORM("mainfrm.cpp", Form1);
USEFORM("AboutBoxfrm.cpp", AboutBox);
USEFORM("bookmarkfrm.cpp", bookmarkForm);
USEFORM("newbmfilefrm.cpp", NewBMfrm);
USEFORM("optionfrm.cpp", Optionsfrm);
USEFORM("searchfrm.cpp", searchForm);
USEUNIT("biblecsmgr.cpp");
USEFORM("ModInstForm.cpp", ModInstFrm);
USEFORM("vrslstfrm.cpp", VerseListForm);
USEFORM("editentryfrm.cpp", EditEntryForm);
USEFORM("versesel.cpp", VerseSelFrm);
USEFORM("RangeMaintFrm.cpp", RangeMaintForm);
USEFORM("ModVisFrm.cpp", ModVisForm);
USEUNIT("..\..\swdisprtfchap.cpp");
USEUNIT("..\..\swdisprtf.cpp");
USEFORM("DevOfTheDay.cpp", DevOfTheDay2);
USEFORM("SplashPage.cpp", SplashPg);
USEFORM("FontSel.cpp", FontSelFrm);
USEOBJ("rxlib\Rxcombos.obj");
USEOBJ("rxlib\Vclutils.obj");
USEOBJ("rxlib\Rxcconst.obj");
USEOBJ("rxlib\Rxconst.obj");
USEFORM("StudyProfessor.cpp", Form3);
USEOBJ("rxlib\RxRichEd.obj");
USEOBJ("rxlib\Maxmin.obj");
USEUNIT("TModuleFonts.cpp");
USEFORM("rtfhintfrm.cpp", RTFHintForm);
USEUNIT("RxRichEditX.cpp");
USEFORM("PreviewForm.cpp", PreviewForm);
USEFORM("PrintFrm.cpp", PrintForm);
USEOBJ("TntUnicodeControls\Unicode.obj");
USEOBJ("TntUnicodeControls\TntControls.obj");
USEOBJ("TntUnicodeControls\TntForms.obj");
USEOBJ("TntUnicodeControls\TntStdCtrls.obj");
USEOBJ("TntUnicodeControls\TntClasses.obj");
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icudatab.lib");
USE("..\..\..\..\..\icu-sword\as_is\borland\http:\www.crosswire.org\sword\images\sword.gif", File);
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icucommon.lib");
USELIB("..\..\..\..\..\icu-sword\as_is\borland\icui18n.lib");
USELIB("..\..\..\..\lib\libsword.lib");
USEUNIT("..\..\swwinlog.cpp");
USEUNIT("paraldisp.cpp");
//---------------------------------------------------------------------------
AnsiString startVerse = "";

WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {

	   LONG result;

	   try {
			 HKEY hkey;
			 HWND otherInst;
			 ThMLPlain filter;

			 // see if there's a previous instance running
                         AnsiString titleString = Application->Title;
                         Application->Title = "";
			 otherInst = ::FindWindow(NULL, "The SWORD Project");
                         Application->Title = titleString;
			 // if so, and we have an argument, send the argument to the other instance
			 if (*lpCmdLine) {
				int len = (strlen(lpCmdLine) + 1) * 5;
				char *buf = new char [len + 1];
				strcpy(buf, lpCmdLine);
//					filter.ProcessText(buf, len);
				while (true) {
					char *change = strstr(buf, "%20");
					if (change) {
						change[0] = ' ';
						change[1] = ' ';
						change[2] = ' ';
					}
					else {
						change = strstr(buf, "%3A");
						if (change) {
							change[0] = ' ';
							change[1] = ':';
							change[2] = ' ';
						}
						else break;
					}
				}

				if (otherInst != NULL) {
					result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\OpenVerse", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
					result = RegSetValueEx(hkey, NULL, 0, REG_SZ, buf, strlen(buf) + 1);
					result = RegCloseKey(hkey);

					PostMessage(otherInst, WM_VERSE, NULL, NULL);
					delete [] buf;
					return 0;
				}
				startVerse = buf;

				// TODO 5: if we have a cmdline argument, figure we have to change directories.  BAD, FIX.
				result = Application->ExeName.Length();
				char * dir = new char[result + 1];
				strcpy (dir, Application->ExeName.c_str());
				for (;result > 0 && dir[result] != '\\'; result--) {
					dir[result] = 0;
				}
				chdir(dir);
				delete [] dir;
				delete [] buf;
			}

			 // adjust the registry for our private protocol using the current path
			 result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
			 result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
			 result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
			 result = RegCloseKey(hkey);
			 result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
			 result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
			 result = RegCloseKey(hkey);
			 AnsiString opencommand = Application->ExeName + " \"%1\"";
			 result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "sword\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
			 result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
			 result = RegCloseKey(hkey);


		/*
			 // don't override Logos' setting if it exists
			 result = RegOpenKeyEx(HKEY_CLASSES_ROOT, "libronixdls", 0, KEY_READ | KEY_WRITE, &hkey);
			 if (!result) {
				    char* libStr = new char[32];
				    unsigned long libSize = 32;
				    result = RegQueryValueEx(hkey, NULL, NULL, NULL, libStr, &libSize);
				    if (!result) {
						  if (strstr(libStr, "SWORD")) {
								result = 1;
						  }
				    }
			 }
			 if (result) {
				    result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
				    result = RegSetValueEx(hkey, NULL, 0, REG_SZ, "URL:SWORD Protocol", strlen("URL:SWORD Protocol") + 1);
				    result = RegSetValueEx(hkey, "URL Protocol", 0, REG_SZ, "", 1);
				    result = RegCloseKey(hkey);
				    result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\DefaultIcon", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
				    result = RegSetValueEx(hkey, NULL, 0, REG_SZ, Application->ExeName.c_str(), Application->ExeName.Length() + 1);
				    result = RegCloseKey(hkey);
				    AnsiString opencommand = Application->ExeName + " \"%1\"";
				    result = RegCreateKeyEx(HKEY_CLASSES_ROOT, "libronixdls\\shell\\open\\command", NULL, "", NULL, KEY_READ | KEY_WRITE, NULL, &hkey, NULL);
				    result = RegSetValueEx(hkey, NULL, 0, REG_SZ, opencommand.c_str(), opencommand.Length() + 1);
				    result = RegCloseKey(hkey);
			 }
		*/
	   }
	catch (Exception &exception) {
		Application->ShowException(&exception);
	}

	try {
		Application->Initialize();
		Application->Title = "The SWORD Project";
		SplashPg = new TSplashPg(static_cast<void*>(NULL));
		SplashPg->Show();
		Application->ProcessMessages();
		Application->CreateForm(__classid(TForm1), &Form1);
                 Application->CreateForm(__classid(TAboutBox), &AboutBox);
                 Application->CreateForm(__classid(TbookmarkForm), &bookmarkForm);
                 Application->CreateForm(__classid(TNewBMfrm), &NewBMfrm);
                 Application->CreateForm(__classid(TOptionsfrm), &Optionsfrm);
                 Application->CreateForm(__classid(TsearchForm), &searchForm);
                 Application->CreateForm(__classid(TModInstFrm), &ModInstFrm);
                 Application->CreateForm(__classid(TVerseListForm), &VerseListForm);
                 Application->CreateForm(__classid(TEditEntryForm), &EditEntryForm);
                 Application->CreateForm(__classid(TVerseSelFrm), &VerseSelFrm);
                 Application->CreateForm(__classid(TRangeMaintForm), &RangeMaintForm);
                 Application->CreateForm(__classid(TModVisForm), &ModVisForm);
                 Application->CreateForm(__classid(TDevOfTheDay2), &DevOfTheDay2);
                 Application->CreateForm(__classid(TForm3), &Form3);
                 Application->CreateForm(__classid(TRTFHintForm), &RTFHintForm);
                 Application->CreateForm(__classid(TPreviewForm), &PreviewForm);
                 Application->CreateForm(__classid(TPrintForm), &PrintForm);
                 Application->Run();
	}
	catch (Exception &exception) {
		Application->ShowException(&exception);
	}
	return 0;
}
//---------------------------------------------------------------------------










