//---------------------------------------------------------------------------
#ifndef mainfrmH
#define mainfrmH
//---------------------------------------------------------------------------
#include <vcl\Classes.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\Forms.hpp>
#include <vcl\ExtCtrls.hpp>
#include <vcl\ComCtrls.hpp>
#include "biblecsmgr.h"
#include <swtext.h>
#include <strkey.h>
#include <regex.h>
#include <listkey.h>
#include <swgenbook.h>
#include "swdisprtfchap.h"
#include "paraldisp.h"
#include <AppEvnts.hpp>
#include <Buttons.hpp>
#include <DdeMan.hpp>
#include <Graphics.hpp>
#include <ImgList.hpp>
#include <Menus.hpp>
#include <ToolWin.hpp>
#include <vcl\Buttons.hpp>
#include <vcl\Menus.hpp>
#include <vcl\DdeMan.hpp>
#include <OleCtrls.hpp>
#include <ToolWin.hpp>
#include <shellapi.h>
#include <Graphics.hpp>
#include <ImgList.hpp>
#include <jpeg.hpp>
#include "RxRichEdit.hpp"
//#include "MOZILLACONTROLLib_OCX.h"
#include "SHDocVw_OCX.h"
#include <AppEvnts.hpp>
#include <TntStdCtrls.hpp>
#include <ActnList.hpp>
#include "TntButtons.hpp"
#include "TntComCtrls.hpp"
#include "TntExtCtrls.hpp"
#include "TntMenus.hpp"

#ifndef USEOLDRTF
#include "RxRichEdit.hpp"
#else
#define TRxRichEdit TRichEdit
#endif    	

#include <list>
#include <vector>

//#define _tr(text) UTF8ToWideString(LocaleMgr::systemLocaleMgr.translate(text))
#define _tr(text) LocaleMgr::systemLocaleMgr.translate(text)
#define MONITOR_CENTER     0x0001        // center rect to monitor
#define MONITOR_CLIP     0x0000        // clip rect to monitor
#define MONITOR_WORKAREA 0x0002        // use monitor work area
#define MONITOR_AREA     0x0000        // use monitor entire area

using namespace std;

class RTFDisp : public SWDisplay {
	SWDispRTF *edit;
	static SWClass classdef;
public:
	RTFDisp(SWDispRTF *iedit) { myclass = &classdef; edit = iedit; }
	virtual SWDispRTF *editControl() { return edit; }
	RTFDisp() {}
	virtual char Display(SWModule &imodule) {
		return edit->Display(imodule);
	}
};

class RTFBookDisp : public RTFDisp {
	SWDispRTF *edit;
	TTreeView *toc;
public:
	RTFBookDisp(SWDispRTF *iedit, TTreeView *itoc) : RTFDisp(iedit) { toc = itoc;}
	RTFBookDisp() {}

	void fillTreeTOC(TreeKeyIdx treeKey, TTreeView *tree, TTreeNode *parent) {
		TTreeNode *node = tree->Items->AddChildObject(parent, treeKey.getLocalName(), (void *)treeKey.getOffset());
		if (treeKey.firstChild()) {
			fillTreeTOC(treeKey, tree, node);
			treeKey.parent();
		}
		if (treeKey.nextSibling())
			fillTreeTOC(treeKey, tree, parent);
	}

	virtual char Display(SWModule &imodule) {
		if (!toc->Items->GetFirstNode()) {
			//edit->Text = "Loading TOC...";
			imodule = TOP;
			((TreeKeyIdx *)((SWKey *)imodule))->firstChild();
			fillTreeTOC(*(TreeKeyIdx *)((SWKey *)imodule), toc, toc->Selected);
		}
		return RTFDisp::Display(imodule);
	}
};

class HREFDisp : public SWDisplay {
	TCppWebBrowser *edit;
public:
	HREFDisp(TCppWebBrowser *iedit) { edit = iedit; }
	HREFDisp() {}
	char Display(SWModule &imodule) {

		TMemoryStream *stm = new TMemoryStream();

		if ( stm == NULL )
			return 1;

		stm->Clear();
		SWBuf modText = (SWBuf)"<HTML><BODY>" + (SWBuf)imodule.RenderText() + (SWBuf)"</BODY></HTML>";
		stm->WriteBuffer(modText.c_str(), modText.length());

		IPersistStreamInit *psi = NULL;

		stm->Seek( 0, 0 );

		// If you pass soOwned instead, the stream will be freed for you
		TStreamAdapter *sa = new TStreamAdapter( stm, soReference );

		if ( sa == NULL ) {
			delete stm;
			return 1;
		}

		_di_IDispatch doc = edit->Document;
		if ( doc == NULL ) {
			TVariant url = "about:blank";
			edit->Navigate2( &url );
			while ( doc == NULL ) {
				Application->ProcessMessages();
				doc = edit->Document;
			}
		}

//		if ( doc->QueryInterface(IID_IPersistStreamInit, (void**)&psi ) == S_OK ) {
		HRESULT result = doc->QueryInterface(IID_IPersistStreamInit, (void**)&psi );
		if (result == S_OK) {
//		if ( doc->QueryInterface(IID_IWrite, (void**)"test" ) == S_OK ) {
			if ( psi )
				psi->Load( *sa );
		}
		else
			delete sa;

		delete stm;
	
//		edit->SetTextBuf("yo mama");
//		edit->RequestDoc((char *)imodule);
		return 0;
	}
};

class DispExternal : public SWDisplay {
public:
	DispExternal() {}
	char Display(SWModule &imodule) {
		SHELLEXECUTEINFO info;
		info.cbSize = sizeof(SHELLEXECUTEINFO);
		info.fMask = SEE_MASK_NOCLOSEPROCESS; //SEE_MASK_CLASSNAME;
		info.hwnd = GetFocus();
		info.lpVerb = "open";
		info.lpFile = (const char *)imodule;
		info.lpParameters = NULL;
		info.lpDirectory = NULL;
		info.nShow = 0;
//		info.lpClass = ".html";
		ShellExecuteEx(&info);
//		ShellExecute(edit->Handle, "open", (char *)imodule, NULL, NULL, SW_SHOWNORMAL);
		return 0;
	}
};


class ModState {
public:
	ModState(TPageControl *ipc, TTabSheet *iap, SWKey ikey) { pc = ipc; ap = iap; key = ikey; }
	ModState();
	TPageControl *pc;
	TTabSheet* ap;
	SWKey key;
};

//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
        TPanel *pnlTextCom;
	TSplitter *Splitter2;
        TPanel *pnlText;
        TPanel *pnlComment;
	TSplitter *Splitter1;
        TPanel *pnlDict;
        TPageControl *TextPageControl;
        TPageControl *CommentaryPageControl;
	TStatusBar *StatusBar1;
        TPageControl *LexDictPageControl;
        TMainMenu *MainMenu1;
        TMenuItem *Search1;
        TMenuItem *NewSearchWindow1;
        TMenuItem *Help1;
        TMenuItem *About1;
        TPopupMenu *PopupMenu2;
        TMenuItem *DictionaryLookup1;
        TMenuItem *File1;
        TMenuItem *SaveLayout1;
        TMenuItem *Exit1;
        TMenuItem *N1;
	TDdeServerItem *Search;
	TDdeServerItem *Lookup;
	TDdeServerConv *Bible;
        TPopupMenu *PopupMenu1;
        TMenuItem *MenuItem1;
        TMenuItem *Copy1;
        TMenuItem *CopyasBGreekTransliteration1;
        TMenuItem *Copy2;
        TMenuItem *Edit1;
        TMenuItem *Copy3;
        TPopupMenu *BookmarkPopup;
        TMenuItem *AddBookmark1;
        TMenuItem *N2;
        TMenuItem *EditBookmarks1;
        TMenuItem *Options1;
	TCoolBar *CoolBar1;
	TImageList *ImageList1;
	TImage *BackBtnImage;
	TImage *SearchBtnImage;
	TToolBar *ToolBar2;
	TToolButton *ToolButton3;
	TToolButton *ToolButton4;
        TPanel *pnlSpeed;
        TPanel *Panel1;
        TComboBox *cbBookOrig;
	TEdit *CHBox;
	TUpDown *UpDown1;
	TEdit *VSBox;
	TUpDown *UpDown2;
        TSpeedButton *btnLookup;
	TToolBar *ToolBar1;
	TImageList *ImageList2;
	TImage *BookmarkBtnImage;
        TSpeedButton *Bookmarkbtn;
        TPopupMenu *PopupMenu3;
        TMenuItem *Copy4;
        TMenuItem *DictionaryLookup2;
        TMenuItem *N3;
        TMenuItem *EditEntry1;
        TMenuItem *DeleteEntry1;
        TMenuItem *LinktoVerse1;
        TMenuItem *Options2;
        TMenuItem *Contents1;
        TComboBox *freeHandLookupOrig;
        TPanel *Panel2;
	TSplitter *Splitter3;
        TRichEdit *DictKeyEditOld;
        TListBox *lbDictKeysOld;
        TPopupMenu *PopupMenu4;
        TMenuItem *HideShowModules1;
        TMenuItem *DevotionaloftheDay1;
        TMenuItem *Tools1;
        TMenuItem *InstallManager1;
        TMenuItem *SEPERATOR;
	TApplicationEvents *ApplicationEvents1;
        TMenuItem *Print1;
        TMenuItem *N5;
        TMenuItem *SearchForWord1;
        TMenuItem *SearchForWord2;
        TMenuItem *SearchForWord3;
	TActionList *ActionList1;
	TAction *Action1;
        TMenuItem *NewVer1;
        TComboBox *cbBook;
        TComboBox *freeHandLookup;
	TPopupMenu *PopupMenu5;
	TMenuItem *MenuItem2;
	TMenuItem *MenuItem3;
	TMenuItem *MenuItem4;
	TMenuItem *N4;
	void __fastcall TextPageControlChange(TObject *Sender);
	void __fastcall btnLookupClick(TObject *Sender);
	void __fastcall CommentaryPageControlChange(TObject *Sender);
	
	
	
	void __fastcall DictKeyEditOldChange(TObject *Sender);
	void __fastcall LexDictPageControlChange(TObject *Sender);
	void __fastcall NewSearchWindow1Click(TObject *Sender);
	
	void __fastcall Exit1Click(TObject *Sender);
	void __fastcall About1Click(TObject *Sender);
	void __fastcall DictionaryLookup1Click(TObject *Sender);
	void __fastcall SaveLayout1Click(TObject *Sender);
	
	
	void __fastcall FormShow(TObject *Sender);
	
	void __fastcall LookupPokeData(TObject *Sender);
	
	void __fastcall SearchPokeData(TObject *Sender);
	void __fastcall UpDown3Click(TObject *Sender, TUDBtnType Button);
	void __fastcall UpDown1Click(TObject *Sender, TUDBtnType Button);
	
	
	void __fastcall BackbtnClick(TObject *Sender);
	void __fastcall CopyasBGreekTransliteration1Click(TObject *Sender);
	void __fastcall Copy1Click(TObject *Sender);
	
	
	
	void __fastcall AddBookmark1Click(TObject *Sender);
	void __fastcall BookmarkItemClick(TObject *Sender);
	void __fastcall ParallelMenuItemClick(TObject *Sender);
	void __fastcall BookmarkbtnClick(TObject *Sender);
	void __fastcall EditBookmarks1Click(TObject *Sender);
	
	void __fastcall FormKeyDown(TObject *Sender, WORD &Key, TShiftState Shift);
	void __fastcall Options1Click(TObject *Sender);
	void __fastcall cbBookChange(TObject *Sender);
	
	void __fastcall FormCreate(TObject *Sender);
	void __fastcall PopupMenuPopup(TObject *Sender);
	void __fastcall createVerseList(TObject *Sender);
	void __fastcall freeHandLookupoldKeyPress(TObject *Sender, char &Key);
	void __fastcall RTFMouseDown(TObject *Sender, TMouseButton Button,
		TShiftState Shift, int X, int Y);
	void __fastcall RTFURLClick(TObject *Sender, const AnsiString URLText, TMouseButton Button);
	void __fastcall EditEntry1Click(TObject *Sender);
	void __fastcall DeleteEntry1Click(TObject *Sender);
	void __fastcall LinktoVerse1Click(TObject *Sender);
	void __fastcall BookTOCChange(TObject* Sender, TTreeNode* Node);
	
	void __fastcall GlobalOptionChange(TObject *Sender);
	
	
	void __fastcall OptionShowVals(TObject *Sender);
	void __fastcall Contents1Click(TObject *Sender);
	void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
	void __fastcall lbDictKeysOldClick(TObject *Sender);
	void __fastcall verseLookupClick(TObject *Sender);
	void __fastcall HideShowModules1Click(TObject *Sender);
	void __fastcall DevotionaloftheDay1Click(TObject *Sender);
	void __fastcall CppWebBrowser1BeforeNavigate2(TObject *Sender,
		LPDISPATCH pDisp, TVariant *URL, TVariant *Flags,
		TVariant *TargetFrameName, TVariant *PostData, TVariant *Headers,
		TOLEBOOL *Cancel);
	void __fastcall InstallManager1Click(TObject *Sender);
	void __fastcall ApplicationEvents1Hint(TObject *Sender);
	void __fastcall ApplicationEvents1ShowHint(AnsiString &HintStr,
		bool &CanShow, THintInfo &HintInfo);
	void __fastcall Print1Click(TObject *Sender);
	void __fastcall SearchForWord1Click(TObject *Sender);
	void __fastcall Action1Execute(TObject *Sender);
	void __fastcall NewVer1Click(TObject *Sender);
	void __fastcall PopupMenu5Popup(TObject *Sender);
private:	// User declarations
	list <SWDisplay *> displays;	// so we can delete each display we create
	list <ModState *> modstates;
	vector <ModState *> ctrlstates;
	bool logmodstate;
	bool freshdict;
	String clickText;

	char CreateTextPane(SWModule *mod);
	char CreateParallelPane(SWMgr **mgr);
	char CreateCommentPane(SWModule *mod);
	char CreateLDPane(SWModule *mod);
	char CreateBookPane(SWModule *mod);
	void PushState();
	void BackState();
	void ForwardState();
	void AddSectionToMenu(TMenu *menu, TMenuItem *item, TTreeNode *tree);
	void FillDictKeys();
	void AddVerseChoices(TPopupMenu *menu, const char *buf, TRxRichEdit *rtf);
	void fillVKeySelector(VerseKey *vk);
	static bool hasFeature(SWMgr *mgr, const char *modName, const char *feature);
	void NavigateVerseURL(char* verStr);
	void refreshAppearance();

public:		// User declarations
	TTntListBox *lbDictKeys;
	TTntEdit *DictKeyEdit;
	VerseKey *DefaultVSKey;
	SWKey *DefaultStrKey;
	BibleCSMGR *mainmgr;
	SWConfig *layoutconf;
	SWConfig *optionsconf;
	SWDispRTF *currentRTF;
	__fastcall TForm1(TComponent* Owner);
	__fastcall ~TForm1();
	void __fastcall DisplayHint(TObject* Sender);
	void RefreshActiveSheet(TPageControl *ts);
	void TextKeyChanged();		// updates dependents on TextKeyChanged
	void RefreshBookmarksMenu(TMenu *menu, TTreeView *tree);
	void RestoreState(ModState *state);
	void i12ize(const char *lang);
	static WideString TrimJunk(WideString src);
	void __fastcall AppMessage(tagMSG &Msg, bool &Handled);     
	static void ClipOrCenterRectToMonitor(LPRECT prc, UINT flags);
	static void ClipOrCenterWindowToMonitor(HWND hwnd, UINT flags);
	ListKey tmpVerseList;
	String tmpVerseListCaption;
	bool renderingHint;
	bool closing;
	ParallelDisp *parallelDisp;
};

class TRTFHintWindow : public THintWindow {
	typedef THintWindow inherited;

protected:
	virtual void __fastcall Paint(void);
	virtual void __fastcall CreateParams(TCreateParams &Params);

public:
	__fastcall virtual TRTFHintWindow(Classes::TComponent* AOwner);
	__fastcall TRTFHintWindow(HWND ParentWindow) : THintWindow(ParentWindow) { }
	__fastcall virtual ~TRTFHintWindow(void);
	virtual void __fastcall ActivateHint(const /*Windows::*/TRect& Rect,	const AnsiString AHint);
	virtual void __fastcall ActivateHintData(const /*Windows::*/TRect& Rect, const AnsiString AHint, void* AData);
	virtual /*Windows::*/TRect __fastcall CalcHintRect(int MaxWidth, const AnsiString AHint, void* AData);
	virtual bool __fastcall IsHintMsg(tagMSG& Msg);

	__property BiDiMode ;
	__property Caption ;
	__property Color ;
	__property Canvas ;
	__property Font ;

};


//---------------------------------------------------------------------------
extern TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
