//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "FontSel.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma link "RxCombos"
#pragma resource "*.dfm"
TFontSelFrm *FontSelFrm;
//---------------------------------------------------------------------------
__fastcall TFontSelFrm::TFontSelFrm(TComponent* Owner)
	: TForm(Owner)
{
	initialized = false;
	// Put in the RXLib components
	FontComboBox = new TFontComboBox(this);
	FontComboBox->Parent = pnlFontComboBox;
	FontComboBox->Align = alClient;
	FontComboBox->Font->Height = -16;
	FontComboBox->Font->Size = 12;
	FontComboBox->ParentFont = true;
	FontComboBox->UseFonts = true;
	FontComboBox->ItemIndex = FontComboBox->Items->IndexOf("Arial");
	FontComboBox->OnChange = FontComboBoxChange;

	BGColorCmb = new TColorComboBox(this);
	BGColorCmb->Parent = pnlBGColorCmb;
	BGColorCmb->Align = alClient;
	BGColorCmb->ColorValue = clWhite;
	for(int count = 0; count < 15; count++)
		BGColorCmb->ColorNames->Add("");
	BGColorCmb->ColorNames->Add("More...");
	BGColorCmb->OnChange = BGColorCmbChange;

	FGColorCmb = new TColorComboBox(this);
	FGColorCmb->Parent = pnlFGColorCmb;
	FGColorCmb->Align = alClient;
	FGColorCmb->ColorValue = clBlack;
	for(int count = 0; count < 15; count++)
		FGColorCmb->ColorNames->Add("");
	FGColorCmb->ColorNames->Add("More...");
	FGColorCmb->OnChange = FGColorCmbChange;

	Font = new TFont;
	SizeComboBox->ItemIndex = SizeComboBox->Items->IndexOf("10");
	//BGColorDlg->Color = clWhite;
	//BackColor = clWhite;
	//FGColorDlg->Color = clBlack;	
	//Font->Color = clBlack;

}
//---------------------------------------------------------------------------


void __fastcall TFontSelFrm::FormShow(TObject *Sender)
{
	BGColorDlg->Color = BackColor;
	BGColorCmb->ColorValue = BackColor;
	FGColorDlg->Color = Font->Color;
	FGColorCmb->ColorValue = Font->Color;
	FontComboBox->ItemIndex = FontComboBox->Items->IndexOf(Font->Name);
	SizeComboBox->ItemIndex = SizeComboBox->Items->IndexOf(Font->Size);

	UpdatePreview();
	initialized = true;
}

void TFontSelFrm::UpdatePreview()
{
	if(Font){
		SampleText->Font->Color = Font->Color;
		SampleText->Color = BackColor;
		SampleText->Font->Size = Font->Size;
		SampleText->Font->Name = Font->Name;
	}
}

void __fastcall TFontSelFrm::ckShowFontClick(TObject *Sender)
{
	if(ckShowFont->Checked)
		FontComboBox->UseFonts = true;
	else
		FontComboBox->UseFonts = false;

}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::FontComboBoxChange(TObject *Sender)
{
     Font->Name = FontComboBox->Text;
  	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::SizeComboBoxChange(TObject *Sender)
{
	Font->Size = SizeComboBox->Text.ToInt();
	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::BGColorCmbChange(TObject *Sender)
{
	if(initialized){
		if(BGColorCmb->Items->Strings[BGColorCmb->ItemIndex] == "More..."){
			BGColorDlg->Execute();
			BGColorCmb->ColorValue = BGColorDlg->Color;
			BackColor = BGColorDlg->Color;
		}else{
			BGColorDlg->Color = BGColorCmb->ColorValue;
			BackColor = BGColorCmb->ColorValue;
		}
	}
	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::FGColorCmbChange(TObject *Sender)
{
	if(initialized){
		if(FGColorCmb->Items->Strings[FGColorCmb->ItemIndex] == "More..."){
			FGColorDlg->Execute();
			FGColorCmb->ColorValue = FGColorDlg->Color;
			Font->Color = FGColorDlg->Color;
		}else{
			FGColorDlg->Color = FGColorCmb->ColorValue;
			Font->Color = FGColorCmb->ColorValue;
		}
	}
	UpdatePreview();
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::OKBtnClick(TObject *Sender)
{
	ModalResult = mrOk;
	initialized = false;
}
//---------------------------------------------------------------------------

void __fastcall TFontSelFrm::CancelBtnClick(TObject *Sender)
{
	ModalResult = mrCancel;
	initialized = false;
}
//---------------------------------------------------------------------------
