//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <swmgr.h>
#include <listkey.h>
#include "DevOfTheDay.h"
#include "mainfrm.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TDevOfTheDay2 *DevOfTheDay2;
//---------------------------------------------------------------------------
__fastcall TDevOfTheDay2::TDevOfTheDay2(TComponent* Owner)
        : TForm(Owner)
{
	RichTipOld->Visible = false;
	RichTip = new TRxRichEditX(this);
	RichTip->Parent = Panel1;
	RichTip->Align = alClient;
	RichTip->ScrollBars = ssVertical;
	RichTip->ReadOnly = true;
}
//---------------------------------------------------------------------------


void __fastcall TDevOfTheDay2::btnOKClick(TObject *Sender)
{
	DevOfTheDay2->Hide();
	if (Form1->optionsconf) {
		Form1->optionsconf->Sections["General"]["TipOfTheDay"] = (DevOfTheDay2->ckShowTip->Checked) ? "Devotional" : "";
		Form1->optionsconf->Save();
	}
}
//---------------------------------------------------------------------------

void __fastcall TDevOfTheDay2::FormShow(TObject *Sender)
{
	ModMap::iterator it;
	ListKey key;
	String devoKey = TDateTime::CurrentDate().FormatString("mm.dd");
	key << devoKey.c_str();
	SWBuf tmpval = Form1->optionsconf->Sections["ModDefaults"]["DailyDevotion"];
	if ((it = Form1->mainmgr->Modules.find(tmpval)) != Form1->mainmgr->Modules.end()) {
		RichTip->fillWithVerses(it->second, &key, 0, false, false);
	}
	else	DevOfTheDay2->RichTip->Text = "A Daily Devotional is not installed or is not configured for use with the \"Devotional of the Day.\n\nTo configure an installed devotional for use with this dialog box open the Preferences dialog box by going to the \"Options\" menu and selecting \"Preferences...\"; then click the \"Special Modules\" tab. Find the \"Default Devotional\" option and select a devotional to use from the list. If nothing shows up in the pull-down list you will need to install a devotional. This can be done by using the Install Manager. Some examples of devotionals are \"Spurgeon's Morning and Evening\" or \"Jonathan Bagster's Daily Light\".\n\nVisit our website at www.crosswire.org for more information."; 
	// If no devotional text is shown then a general how-to is diplayed.
	
	tmpval = Form1->optionsconf->Sections["General"]["TipOfTheDay"];
	ckShowTip->Checked = (!stricmp(tmpval.c_str(), "Devotional"));
}
//---------------------------------------------------------------------------

