//---------------------------------------------------------------------------
#ifndef MainFrmH
#define MainFrmH
//---------------------------------------------------------------------------
#include <swmgr.h>
//#include <gnome.h>
#include <TCustomImageList.h>
#include <TTreeView.h>
#include <TTreeNode.h>
#include <TTreeNodes.h>


#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


using namespace sword;


class VersionInfo {
	public:
	int major, minor, minor2, minor3;
	
	VersionInfo(const char *version);
	int compare(const VersionInfo &vi) const;
	bool operator>(const VersionInfo &vi) const {return (compare(vi) > 0);}
	bool operator<(const VersionInfo &vi) const {return (compare(vi) < 0);}
	bool operator==(const VersionInfo &vi) const {return (compare(vi) == 0);}
};
		

class InstallSourceTab {
public:
	InstallSourceTab(GtkWidget *Owner, const char *confEnt, const char *type);
	~InstallSourceTab();
	string Type;
	string Source;
	string Directory;
	string Caption;
	GtkWidget *tree;
	SWMgr *mgr;
};


//---------------------------------------------------------------------------
class TMainForm {
	class TWebThread;
	friend class TWebThread;

  GtkAccelGroup *accel_group;
  GtkWidget *menubar1;
  GtkWidget *banner_panel;
  guint tmp_key;
  GtkWidget *file2;
  GtkWidget *file2_menu;
  GtkAccelGroup *file2_menu_accels;
  GtkWidget *exit1;
  GtkWidget *options1;
  GtkWidget *options1_menu;
  GtkAccelGroup *options1_menu_accels;
  GtkWidget *local_path1;
  GtkWidget *manage_remote_sources1;
  GtkWidget *main_window;
  GtkWidget *dock1;
  GtkWidget *vbox1;
  GtkWidget *pixmap1;
  GtkWidget *hpaned1;
  GtkWidget *vbox2;
  GtkWidget *toolbar2;
  GtkWidget *label3;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *GlobeBtn;
  GtkWidget *label5;
  GtkWidget *pixmap2;
  GtkWidget *label4;
  GtkWidget *notebook1;
  GtkWidget *scrolledwindow3;
  GtkWidget *viewport1;
  GtkWidget *label1;
  GtkWidget *toolbar3;
  GtkWidget *InfoBtn;
  GtkWidget *SelectBtn;
  GtkWidget *SelectAllBtn;
  GtkWidget *InstallBtn;
  GtkWidget *vbox3;
  GtkWidget *label2;
  GtkWidget *scrolledwindow4;
  GtkWidget *viewport2;
  GtkWidget *toolbar4;
  GtkWidget *RemoveBtn;
  GtkWidget *appbar1;
//  GtkWidget *InstalledTree;
  TTreeView *installTree;
  TTreeView *localTree;
	TCustomImageList *ImageList1;
	TCustomImageList *ImageList2;

public:
  GtkWidget *localPathDlg;
	void FormCreate(GtkWidget *Sender);
	void LocalPath1Click(GtkWidget *Sender);
	void LocalPath1Click_ok(GtkWidget *Sender);
	void Button5Click(GtkWidget *Sender);
	void Button6Click(GtkWidget *Sender);
	void Button4Click(GtkWidget *Sender);
	void Button2Click(GtkWidget *Sender);
/*
	void localTreeDblClick(GtkWidget *Sender);
	void Image1Click(GtkWidget *Sender);
	void SpeedButton1Click(GtkWidget *Sender);
	void SpeedButton5Click(GtkWidget *Sender);
	void Exit1Click(GtkWidget *Sender);
*/
	void FormShow(GtkWidget *Sender);

	void refreshPageControl();

private:	// User declarations

	SWMgr *manager;
	SWConfig *installConf;
	const char *getLocalDir();
	void setLocalDir(const char *idir);
	void	fillAllSourceTrees();
	void deleteAllModules();
/*
	void addSource(InstallSourceTab *ist);
*/
	
public:		// User declarations
	TMainForm(GtkWidget* Owner);
	~TMainForm();
	int selectAll(TTreeView *tree, bool sel);
	int removeModule(const char *modName);
	int installModule(const char *modName, InstallSourceTab *ist = 0);
	static int createParent(const char *pName);
	int createPathAndFile(const char *fName);
	int copyFile(const char *sourceFile, const char *targetFile);
	int copyFileToCWD(const char *sourceDir, const char *fName);
/*
	void RefreshRemoteSource(GtkWidget *Sender);
	int FTPCopy(InstallSourceTab *ist, const char *src, const char *dest, bool dirTransfer = false);
*/
	SWMgr *localMgr;

protected:
	virtual void fillInstallTree();
	virtual void fillSourceTree(const char *sourceConf, TTreeView *tree);
};

//---------------------------------------------------------------------------
extern TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
