// ActiveDiathekeCtl.cpp : Implementation of the CActiveDiathekeCtrl ActiveX Control class.

#include "stdafx.h"
#include "ActiveDiatheke.h"
#include "ActiveDiathekeCtl.h"
#include "ActiveDiathekePpg.h"
#include "corediatheke.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CActiveDiathekeCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CActiveDiathekeCtrl, COleControl)
	//{{AFX_MSG_MAP(CActiveDiathekeCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_EDIT, OnEdit)
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CActiveDiathekeCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CActiveDiathekeCtrl)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "maxverses", m_maxverses, OnMaxversesChanged, VT_I4)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "outputformat", m_outputformat, OnOutputformatChanged, VT_I2)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "searchtype", m_searchtype, OnSearchtypeChanged, VT_I2)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "book", m_book, OnBookChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "locale", m_locale, OnLocaleChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "key", m_key, OnKeyChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "value", m_value, OnValueChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "autoupdate", m_autoupdate, OnAutoupdateChanged, VT_BOOL)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "strongs", m_strongs, OnStrongsChanged, VT_BOOL)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "footnotes", m_footnotes, OnFootnotesChanged, VT_BOOL)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "headings", m_headings, OnHeadingsChanged, VT_BOOL)
	DISP_PROPERTY_NOTIFY(CActiveDiathekeCtrl, "morphology", m_morphology, OnMorphologyChanged, VT_BOOL)
	DISP_FUNCTION(CActiveDiathekeCtrl, "query", query, VT_I4, VTS_NONE)
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CActiveDiathekeCtrl, COleControl)
	//{{AFX_EVENT_MAP(CActiveDiathekeCtrl)
	EVENT_CUSTOM("ValueChanged", FireValueChanged, VTS_NONE)
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CActiveDiathekeCtrl, 1)
	PROPPAGEID(CActiveDiathekePropPage::guid)
END_PROPPAGEIDS(CActiveDiathekeCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CActiveDiathekeCtrl, "ACTIVEDIATHEKE.ActiveDiathekeCtrl.1",
	0x6bad30cd, 0x3506, 0x42cf, 0xb5, 0x4c, 0xe4, 0x7f, 0x19, 0x26, 0x3, 0x93)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CActiveDiathekeCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DActiveDiatheke =
		{ 0x7445174b, 0x2ef2, 0x42fe, { 0xac, 0xa5, 0xfa, 0xea, 0x52, 0xc3, 0x37, 0x7e } };
const IID BASED_CODE IID_DActiveDiathekeEvents =
		{ 0x8683c608, 0x3e0c, 0x4c2f, { 0xa7, 0x27, 0x9b, 0xae, 0x7a, 0x68, 0x18, 0x9f } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwActiveDiathekeOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CActiveDiathekeCtrl, IDS_ACTIVEDIATHEKE, _dwActiveDiathekeOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::CActiveDiathekeCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CActiveDiathekeCtrl

BOOL CActiveDiathekeCtrl::CActiveDiathekeCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	// TODO: Verify that your control follows apartment-model threading rules.
	// Refer to MFC TechNote 64 for more information.
	// If your control does not conform to the apartment-model rules, then
	// you must modify the code below, changing the 6th parameter from
	// afxRegInsertable | afxRegApartmentThreading to afxRegInsertable.

	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_ACTIVEDIATHEKE,
			IDB_ACTIVEDIATHEKE,
			afxRegInsertable | afxRegApartmentThreading,
			_dwActiveDiathekeOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::CActiveDiathekeCtrl - Constructor

CActiveDiathekeCtrl::CActiveDiathekeCtrl()
{
	InitializeIIDs(&IID_DActiveDiatheke, &IID_DActiveDiathekeEvents);
	query();
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::~CActiveDiathekeCtrl - Destructor

CActiveDiathekeCtrl::~CActiveDiathekeCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::OnDraw - Drawing function

void CActiveDiathekeCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	pdc->FillRect(rcBounds, CBrush::FromHandle((HBRUSH)GetStockObject(WHITE_BRUSH)));
	pdc->ExtTextOut(0, 0, ETO_CLIPPED, rcBounds, "The SWORD Project", NULL);	
	pdc->ExtTextOut(0, 20, ETO_CLIPPED, rcBounds, "ActiveDiatheke", NULL);	
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::DoPropExchange - Persistence support

void CActiveDiathekeCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	PX_String(pPX, _T("book"), m_book, "KJV");
	PX_String(pPX, _T("key"), m_key, "John 3:16");
	PX_String(pPX, _T("locale"), m_locale, "en");

	PX_Bool(pPX, _T("autoupdate"), m_autoupdate, FALSE);

	PX_Bool(pPX, _T("strongs"), m_strongs, FALSE);
	PX_Bool(pPX, _T("footnotes"), m_footnotes, FALSE);
	PX_Bool(pPX, _T("headings"), m_headings, FALSE);
	PX_Bool(pPX, _T("morphology"), m_morphology, FALSE);


	PX_Long(pPX, _T("maxverses"), m_maxverses, -1);

	PX_Short(pPX, _T("outputformat"), m_outputformat, FMT_PLAIN);
	PX_Short(pPX, _T("searchtype"), m_searchtype, ST_NONE);
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl::OnResetState - Reset control to default state

void CActiveDiathekeCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CActiveDiathekeCtrl message handlers

void CActiveDiathekeCtrl::OnMaxversesChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnOutputformatChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnSearchtypeChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnBookChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnLocaleChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnKeyChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

long CActiveDiathekeCtrl::query() 
{
#ifdef _UNICODE
	long count;

	count = m_book.GetLength();
	char * Cm_book = new char[count];
	wcstombs(Cm_book, m_book, count);

	count = m_locale.GetLength();
	char * Cm_locale = new char[count];
	wcstombs(Cm_locale, m_locale, count);

	count = m_key.GetLength();
	char * Cm_key = new char[count];
	wcstombs(Cm_key, m_key, count);	

	char * versevalue = doquery(m_maxverses, m_outputformat, m_strongs * OP_STRONGS + m_footnotes * OP_FOOTNOTES + m_headings * OP_HEADINGS + m_morphology * OP_MORPHOLOGY, m_searchtype, Cm_book, Cm_locale, Cm_key);
	
	delete Cm_key;
	delete Cm_locale;
	delete Cm_book;
#else
	char * versevalue = doquery(m_maxverses, m_outputformat, m_strongs * OP_STRONGS + m_footnotes * OP_FOOTNOTES + m_headings * OP_HEADINGS + m_morphology * OP_MORPHOLOGY, m_searchtype, (LPCTSTR)m_book, (LPCTSTR)m_locale, (LPCTSTR)m_key);
#endif
	if (versevalue) {
		m_value = versevalue;
		delete versevalue;
		FireValueChanged();
		return TRUE;
	}
	return FALSE;
}

void CActiveDiathekeCtrl::OnValueChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnAutoupdateChanged() 
{
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnStrongsChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnFootnotesChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnHeadingsChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}

void CActiveDiathekeCtrl::OnMorphologyChanged() 
{
	if (m_autoupdate)
		query();
	SetModifiedFlag();
}
