//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl/clipbrd.hpp>
#pragma hdrstop

#include "mainfrm.h"
#include "swdisprtfchap.h"
#include "searchfrm.h"
#include "swwinlog.h"
#include "AboutBoxfrm.h"
#include "ModInstForm.h"
#include "biblecsmgr.h"
#include "Greek2Greek.h"
#include "bookmarkfrm.h"
#include "optionfrm.h"
#include "vrslstfrm.h"
#include <utilstr.h>
#include <filemgr.h>
#include <localemgr.h>
#include "editentryfrm.h"
#include "versesel.h"
#include "splashfrm.h"
#include "ModVisFrm.h"

//---------------------------------------------------------------------------
#ifndef USEOLDRTF
#pragma link "RxRichEd"
#endif
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------


__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
	optionsconf = new SWConfig("./options.conf");

	Lookup->Text = "[ SWORD DDE Lookup ]";
	Search->Text = "[ SWORD DDE Search ]";
     modstates.clear();
     displays.clear();
     ctrlstates.clear();
}

void __fastcall TForm1::DisplayHint(TObject* Sender) 
{ 
	StatusBar1->SimpleText = GetLongHint(Application->Hint);
}

//---------------------------------------------------------------------------
__fastcall TForm1::~TForm1()
{

	list <SWDisplay *>::iterator it;
	int loop;

	
	if (mainmgr)
		delete mainmgr;
	for (it = displays.begin(); it != displays.end(); it++)
		delete *it;

	if (layoutconf)
		delete layoutconf;

	if (optionsconf)
		delete optionsconf;
		
	for (loop = 0; loop < 10; loop++) {
		if (ctrlstates[loop])
			delete ctrlstates[loop];
	}

	list <ModState *>::iterator mit;
	for (mit = modstates.begin(); mit != modstates.end(); mit++) {
		delete (*mit);
	}
}
//---------------------------------------------------------------------------
void TForm1::BuildRTFHeader(char *buf, char *font, int max)
{
	char buf1[1024], buf2[1024];
	SectionMap::iterator sit;
	string value;
	ConfigEntMap::iterator entry;
	
	sprintf(buf1, "{\\rtf1\\ansi");
	if (font)
		sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 %s;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f2\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f3\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f4\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}", font);
	else sprintf(buf2, "{\\fonttbl{\\f0\\fdecor\\fprq2 Times New Roman;}{\\f1\\froman\\fcharset0\\fprq2 Times New Roman;}{\\f7\\froman\\fcharset2\\fprq2 Symbol;}{\\f8\\froman\\fcharset2\\fprq2 Symbol;}}");
	strcat(buf1, buf2);

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		ConfigEntMap &section = (*sit).second;
		sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red%d\\green%d\\blue%d;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}",
			((entry = section.find("CurrentVSColorRed")) != section.end()) ? atoi((*entry).second.c_str()) : 0,
			((entry = section.find("CurrentVSColorGreen")) != section.end()) ? atoi((*entry).second.c_str()) : 0,
			((entry = section.find("CurrentVSColorBlue")) != section.end()) ? atoi((*entry).second.c_str()) : 0);
	}
	else	sprintf(buf2, "{\\colortbl;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red0\\green200\\blue50;\\red0\\green0\\blue255;\\red255\\green0\\blue0;}");
	strcat(buf1, buf2);
	memset(buf, 0, max);
	strncpy(buf, buf1, max);
}

char TForm1::CreateTextPane(SWModule *mod, char *font) {
	TTabSheet *newtab = new TTabSheet(this);
	SWDispRTFChap *newrtf = new SWDispRTFChap(this);
	char buf[512];
	SectionMap::iterator sit;
	
	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
	newtab->ParentShowHint = true;
	newtab->PageControl = PageControl1;
	newrtf->Parent = newtab;
	newrtf->Align = alClient;
	newrtf->ScrollBars = ssVertical;
	newrtf->ReadOnly = true;
	newrtf->PopupMenu = (strcmp(mod->Name(), "N27U4")) ? PopupMenu2 : PopupMenu1;
	newrtf->OnMouseDown = RTFMouseDown;
//     newrtf->StreamMode >> smUnicode;
//     newrtf->Font->Charset = CHINESEBIG5_CHARSET;

	BuildRTFHeader(buf, font, 512);
	newrtf->RTFHeader = buf;

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		if ((*sit).second.find("AutoVSColor") != (*sit).second.end())
			newrtf->MarkCurrentVerse = (atoi((*(*sit).second.find("AutoVSColor")).second.c_str())) ? true:false;
	}
	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		if ((*sit).second.find("FontSize") != (*sit).second.end())
			newrtf->FontSize = atoi((*(*sit).second.find("FontSize")).second.c_str());
	}
	SWDisplay *disp = new RTFDisp(newrtf);
	mod->Disp(disp);
	displays.insert(displays.begin(), disp);
	mod->SetKey(DefaultVSKey);

	return 0;
}
//---------------------------------------------------------------------------
char TForm1::CreateCommentPane(SWModule *mod) {
	TTabSheet *newtab = new TTabSheet(this);
	TWinControl *newrtf;
	SectionMap::iterator sit;

	if ((*mainmgr->config->Sections[mod->Name()].find("ModDrv")).second == "HREFCom") {
//		if (mainmgr->config->Sections[mod->Name()]["External"] == "1") {
			newrtf = new TPanel(this);
			((TPanel *)newrtf)->Caption = "Syncronizing to External Viewer";
			SWDisplay *disp = new DispExternal();
			mod->Disp(*displays.insert(displays.begin(), disp));
/*
		}
		else {
	//		newrtf = new THTML(this->Handle);
	//		newrtf = new SWDispRTF(this);
			newrtf = HTML1;
			newrtf->Visible = true;
			mod->Disp(*displays.insert(displays.begin(), new HREFDisp((THTML *)newrtf)));
	//		mod->Disp(*displays.insert(displays.begin(), new RTFDisp((SWDispRTF *)newrtf)));
		}
*/
	}
	else {
		newrtf = new SWDispRTF(this);
		if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
			if ((*sit).second.find("FontSize") != (*sit).second.end())
				((SWDispRTF *)newrtf)->FontSize = atoi((*(*sit).second.find("FontSize")).second.c_str());
		}
		SWDisplay *disp = new RTFDisp((SWDispRTF *)newrtf);
		mod->Disp(*displays.insert(displays.begin(), disp));
		((SWDispRTF *)newrtf)->ScrollBars = ssVertical;
		((SWDispRTF *)newrtf)->ReadOnly = true;

		if ((*mainmgr->config->Sections[mod->Name()].find("ModDrv")).second == "RawFiles") {
			((SWDispRTF *)newrtf)->PopupMenu = PopupMenu3;
			((SWDispRTF *)newrtf)->ExpandNewLine = false;
		}
		else	((SWDispRTF *)newrtf)->PopupMenu = PopupMenu2;
		((SWDispRTF *)newrtf)->OnMouseDown = RTFMouseDown;
	}

	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
	newtab->ParentShowHint = true;
	newtab->PageControl = PageControl2;
	newrtf->Parent = newtab;
	newrtf->Align = alClient;

	mod->SetKey(DefaultVSKey);
	return 0;
}
//---------------------------------------------------------------------------
char TForm1::CreateLDPane(SWModule *mod) {
	TTabSheet *newtab = new TTabSheet(this);
	SWDispRTF *newrtf = new SWDispRTF(this);
	SectionMap::iterator sit;

	newtab->Caption = mod->Name();
	newtab->Hint = mod->Description();
	newtab->ParentShowHint = true;
	newtab->PageControl = PageControl3;
	newrtf->Parent = newtab;
	newrtf->Align = alClient;
	newrtf->ScrollBars = ssVertical;
	newrtf->ReadOnly = true;
	newrtf->PopupMenu = PopupMenu2;
	newrtf->OnMouseDown = RTFMouseDown;

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		if ((*sit).second.find("FontSize") != (*sit).second.end())
			newrtf->FontSize = atoi((*(*sit).second.find("FontSize")).second.c_str());
	}
	SWDisplay *disp = new RTFDisp(newrtf);
	mod->Disp(*displays.insert(displays.begin(), disp));
	mod->SetKey(DefaultStrKey);
	return 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::PageControl1Change(TObject *Sender)
{
	RefreshActiveSheet(PageControl1);
	Form1->ActiveControl = PageControl1;
}
//---------------------------------------------------------------------------
void TForm1::RefreshActiveSheet(TPageControl *pc)
{
	ModMap::iterator it;

	if (mainmgr) {
          it = mainmgr->Modules.find(pc->ActivePage->Caption.c_str());
          if (it != mainmgr->Modules.end()) {
               (*it).second->Display();
               if (logmodstate)
                    modstates.insert(modstates.begin(), new ModState(pc, pc->ActivePage, (*it).second->KeyText()));
          }
	}
}


void TForm1::TextKeyChanged()
{
	cbBook->ItemIndex = cbBook->Items->IndexOf(DefaultVSKey.books[DefaultVSKey.Testament()-1][DefaultVSKey.Book()-1].name);
	CHBox->Text  = DefaultVSKey.Chapter();
	VSBox->Text  = DefaultVSKey.Verse();
	freeHandLookup->Text = (const char *)DefaultVSKey;
	RefreshActiveSheet(PageControl1);
	logmodstate = false;		// only log state once
	RefreshActiveSheet(PageControl2);
	logmodstate = true;
}


void __fastcall TForm1::btnLookupClick(TObject *Sender)
{
	if (!(StrToInt(CHBox->Text)) || (!StrToInt(VSBox->Text)))
		DefaultVSKey.AutoNormalize(0);

	if (StrToInt(CHBox->Text) < 0)
		CHBox->Text = StrToInt(CHBox->Text) + 1;
	if (StrToInt(VSBox->Text) < 0)
		VSBox->Text = StrToInt(VSBox->Text) + 1;

	DefaultVSKey       = (cbBook->Text + " " + CHBox->Text + ":" + VSBox->Text).c_str();
	TextKeyChanged();
	DefaultVSKey.AutoNormalize(1);	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::PageControl2Change(TObject *Sender)
{
	RefreshActiveSheet(PageControl2);
	Form1->ActiveControl = PageControl2;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DictKeyEditChange(TObject *Sender)
{
	if (DictKeyEdit->Modified) {
		DefaultStrKey = DictKeyEdit->Text.c_str();
		RefreshActiveSheet(PageControl3);
		DictKeyEdit->Modified = false;
		FillDictKeys();
	}
}

void TForm1::FillDictKeys() {
	ModMap::iterator it;
	int index = 0;
	SWKey saveKey;
	
	if (mainmgr) {
          it = mainmgr->Modules.find(PageControl3->ActivePage->Caption.c_str());
		if (it != mainmgr->Modules.end()) {
               SWModule *mod = (*it).second;
               mod->KeyText(); // snap to entry
               saveKey = mod->KeyText();
			int count = lbDictKeys->Height / lbDictKeys->ItemHeight;
               lbDictKeys->Items->Clear();
               for (int i = 0; i < (count / 2); i++)
                    (*mod)++;
               for (int i = 0; i < count-1; i++)
                    (*mod)--;
               mod->Error();
               for (;!mod->Error() && count;count--,(*mod)++) {
                    lbDictKeys->Items->Add(mod->KeyText());
                    if (saveKey == mod->Key())
                         index = lbDictKeys->Items->Count-1;
			}
               lbDictKeys->ItemIndex = index;
          }
	}
}


//---------------------------------------------------------------------------
void __fastcall TForm1::PageControl3Change(TObject *Sender)
{
	DefaultStrKey = DictKeyEdit->Text.c_str();
	RefreshActiveSheet(PageControl3);
	Form1->ActiveControl = PageControl3;
	FillDictKeys();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NewSearchWindow1Click(TObject *Sender)
{
	Form2->Show();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
	Close();	
}

void __fastcall TForm1::About1Click(TObject *Sender)
{
	AboutBox->ShowModal();	
}


String TForm1::TrimJunk(String src) {
	bool hasDigit = false;
     bool hasAlpha = false;
     String retVal = "";
     
	char *ch = src.c_str();
     for (;*ch; ch++) {
     	if (isdigit(*ch))
          	hasDigit = true;
          if (isalpha(*ch))
          	hasAlpha = true;
     }
     for (ch = src.c_str(); *ch; ch++) {
     	if (hasDigit && !hasAlpha) {	// number
          	if (isdigit(*ch)) retVal += *ch;
          }
          else if (hasAlpha) {	// alpha
          	if (isalpha(*ch)) retVal += *ch;
         	}
          else	retVal += *ch;
     }
     return retVal;
}


//---------------------------------------------------------------------------
void __fastcall TForm1::DictionaryLookup1Click(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	int wordstart;
	int saveSelStart = rtf->SelStart;
	String lookupKey;
	ConfigEntMap::iterator eit;
	char preChar = 0;
		
	if (!rtf->SelLength) {
#ifndef USEOLDRTF     
     	lookupKey = TrimJunk(rtf->WordAtCursor());
#else
          while (wordstart = rtf->SelStart;((wordstart > -1)&&(isdigit(ch)||isalpha(ch))); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length()) - rtf->SelStart - 1;
		preChar = rtf->Text[(rtf->SelStart)?rtf->SelStart:0];
		lookupKey = Trim(rtf->SelText);
		rtf->SelStart = saveSelStart;
		rtf->SelLength = 0;
#endif
	}
	else	{
		preChar = rtf->Text[(rtf->SelStart)?rtf->SelStart:0];
		lookupKey = Trim(rtf->SelText);
	}
		
	// check if all digits (strongs)
	int i;
	for (i = 0; i < strlen(lookupKey.c_str()); i++) {
		if (!isdigit(lookupKey.c_str()[i]))
			break;
	}

	if ((i == strlen(lookupKey.c_str())) && (i)) {
		String curLex = PageControl3->ActivePage->Caption;
		String feature = (DefaultVSKey.Testament() == 1)?"Hebrew":"Greek";
		feature += (preChar == '(')?"Parse":"Def";
		if (!hasFeature(mainmgr, curLex.c_str(), feature.c_str())) {
			string tmpval = ((eit = optionsconf->Sections["ModDefaults"].find(feature.c_str())) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
			for (int i = 0; i < PageControl3->PageCount; i++) {
				if (!stricmp(PageControl3->Pages[i]->Caption.c_str(), tmpval.c_str())) {
					PageControl3->ActivePageIndex = i;
					break;
				}
			}
		}
	}
	
	DictKeyEdit->Text = lookupKey;
}


void __fastcall TForm1::verseLookupClick(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	int wordstart;
	int saveSelStart = rtf->SelStart;
	
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length()) - rtf->SelStart - 1;
		freeHandLookup->Text = Trim(rtf->SelText);
		rtf->SelStart = saveSelStart;
		rtf->SelLength = 0;
	}
	else	freeHandLookup->Text = Trim(rtf->SelText);
	char ret = '\r';
	freeHandLookupoldKeyPress(Sender, ret);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveLayout1Click(TObject *Sender)
{
	ConfigEntMap sit;
	
	sit = layoutconf->Sections["Screen"];
	sit.erase("MainTop"); sit.insert(ConfigEntMap::value_type("MainTop", IntToStr(Form1->Top).c_str()));
	sit.erase("MainLeft"); sit.insert(ConfigEntMap::value_type("MainLeft", IntToStr(Form1->Left).c_str()));
	sit.erase("MainHeight"); sit.insert(ConfigEntMap::value_type("MainHeight", IntToStr(Form1->Height).c_str()));
	sit.erase("MainWidth"); sit.insert(ConfigEntMap::value_type("MainWidth", IntToStr(Form1->Width).c_str()));
	sit.erase("TextComHeight"); sit.insert(ConfigEntMap::value_type("TextComHeight", IntToStr(pnlTextCom->Height).c_str()));
	sit.erase("TextWidth"); sit.insert(ConfigEntMap::value_type("TextWidth", IntToStr(pnlText->Width).c_str()));
	layoutconf->Sections["Screen"] = sit;
	layoutconf->Save();
}


void TForm1::fillVKeySelector(VerseKey *vk) {
	VerseKey *myVk = (VerseKey *)vk->clone();
	myVk->Error();	//clear error
	(*myVk) = TOP;
	cbBook->Clear();
	while (!myVk->Error()) {
		AnsiString s1 = (const char *)(*myVk);
		s1.SetLength(s1.Length() - 4);
		cbBook->Items->Add(s1);
		myVk->Book(myVk->Book() + 1);
	}
	delete myVk;
}


//---------------------------------------------------------------------------
void __fastcall TForm1::FormShow(TObject *Sender)
{
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit, eitend;
	AnsiString s1;
	char *font;
	int loop;
	int maxFiles;
	string tmpval;
	bool showDevos;

/*
	showLocked = true;
	for (int i=0;i<=ParamCount();i++) {
		if (LowerCase(ParamStr(i)) == "-noLocked")
			showLocked = false;
	}
*/
	
	logmodstate = true;
	freshdict   = true;
	if (SWLog::systemlog)
		delete SWLog::systemlog;
	SWLog::systemlog = new SWWinLog(this->Handle);		// set the system logger to our MSWindows specific SWLog class
	tmpval = ((eit = optionsconf->Sections["System"].find("MaxFiles")) != optionsconf->Sections["System"].end())? (*eit).second : (string)"";
	if ((maxFiles = atoi(tmpval.c_str()))) {
		FileMgr::systemFileMgr.maxFiles = maxFiles;
	}

	
	tmpval = ((eit = optionsconf->Sections["Hints"].find("On")) != optionsconf->Sections["Hints"].end())? (*eit).second : (string)"1";

	if (atoi(tmpval.c_str()))
		Form1->ShowHint = true;
	else Form1->ShowHint = false;

	tmpval = ((eit = optionsconf->Sections["General"].find("DevsAsDicts")) != optionsconf->Sections["General"].end())? (*eit).second : (string)"";
	showDevos = (!stricmp(tmpval.c_str(), "true"));
	
	tmpval = ((eit = optionsconf->Sections["Appearance"].find("locale")) != optionsconf->Sections["Appearance"].end())? (*eit).second : (string)"en_us";
	LocaleMgr::systemLocaleMgr.setDefaultLocaleName(tmpval.c_str());
	DefaultVSKey.setLocale(tmpval.c_str());

	fillVKeySelector(&DefaultVSKey);

	cbBook->ItemIndex = cbBook->Items->IndexOf("James");

	DefaultVSKey.Persist(1);	// when set to a module, make the module hold on to this actual key and not a copy
	DefaultVSKey = "James 1:19"; // set to our standard starting verse
	DefaultStrKey.Persist(1);
	DefaultStrKey = "";

	mainmgr = new BibleCSMGR(ModInstFrm);

	tmpval = ((eit = optionsconf->Sections["General"].find("Splash")) != optionsconf->Sections["General"].end())? (*eit).second : (string)"";
	if (!stricmp(tmpval.c_str(), "Devotional")) {
		String devoKey = TDateTime::CurrentDate().FormatString("mm.dd");

		tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("DailyDevotion")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
		if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
			it->second->SetKey(devoKey.c_str());
			splashForm->devotion->Caption = it->second->StripText();
			splashForm->ShowModal();
		}
	}

	for (it = mainmgr->Modules.begin(); it != mainmgr->Modules.end(); it++) {
		bool devotional = false;

		// leave out enciphered texts with no key
		if ((sit = mainmgr->config->Sections.find((*it).second->Name())) != mainmgr->config->Sections.end()) {
			if ((eit = (*sit).second.find("CipherKey")) != (*sit).second.end()) {
				const char *cipherKey = (char *)(*eit).second.c_str();
				if (strlen(cipherKey) < 1)
					continue;
			}
			for (eit = (*sit).second.lower_bound("Feature"), eitend = (*sit).second.upper_bound("Feature"); eit != eitend; eit++) {
				const char *feature = eit->second.c_str();
				if (!stricmp(feature, "StrongsNumbers"))
					Optionsfrm->strongsNumsCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
				if (!stricmp(feature, "GreekDef"))
					Optionsfrm->greekDefCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
				if (!stricmp(feature, "GreekParse"))
					Optionsfrm->greekParseCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
				if (!stricmp(feature, "HebrewDef"))
					Optionsfrm->hebrewDefCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
				if (!stricmp(feature, "HebrewParse"))
					Optionsfrm->hebrewParseCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
				if (!stricmp(feature, "DailyDevotion")) {
					Optionsfrm->dailyDefaultCB->Items->AddObject(it->second->Description(), (TObject *)it->second->Name());
					devotional = true;
				}
			}
		}

		if (!strcmp((*it).second->Type(), "Biblical Texts")) {
			font = 0;
			if ((sit = mainmgr->config->Sections.find((*it).second->Name())) != mainmgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end()) {
					font = (char *)(*eit).second.c_str();
				}
			}
			CreateTextPane((*it).second, font);
		}
		if (!strcmp((*it).second->Type(), "Commentaries"))
			CreateCommentPane((*it).second);
		if (!strcmp((*it).second->Type(), "Lexicons / Dictionaries")) {
			if (showDevos || !devotional)
				CreateLDPane((*it).second);
		}
	}

	layoutconf = new SWConfig("./layout.conf");

	if ((sit = layoutconf->Sections.find("Screen")) != layoutconf->Sections.end()) {
		if ((eit = (*sit).second.find("MainTop")) != (*sit).second.end())
			Form1->Top = atoi((*eit).second.c_str());
		if ((eit = (*sit).second.find("MainLeft")) != (*sit).second.end())
			Form1->Left = atoi((*eit).second.c_str());
		if ((eit = (*sit).second.find("MainHeight")) != (*sit).second.end())
			Form1->Height = atoi((*eit).second.c_str());
		if ((eit = (*sit).second.find("MainWidth")) != (*sit).second.end())
			Form1->Width = atoi((*eit).second.c_str());
		if ((eit = (*sit).second.find("TextComHeight")) != (*sit).second.end())
			pnlTextCom->Height = atoi((*eit).second.c_str());
		if ((eit = (*sit).second.find("TextWidth")) != (*sit).second.end())
			pnlText->Width = atoi((*eit).second.c_str());
	}


	for (loop = 0; loop < 10; loop++)
		ctrlstates.insert(ctrlstates.begin(), 0);
	Graphics::TBitmap *bitmap = BackBtnImage->Picture->Bitmap;
	TColor transColor = bitmap->Canvas->Pixels[0][0];
	ImageList1->AddMasked(bitmap, transColor);
	
	bitmap = SearchBtnImage->Picture->Bitmap;
	transColor = bitmap->Canvas->Pixels[0][0];
	ImageList1->AddMasked(bitmap, transColor);
	
	bitmap = BookmarkBtnImage->Picture->Bitmap;
	transColor = bitmap->Canvas->Pixels[0][0];
	ImageList2->AddMasked(bitmap, transColor);

	// Add options to Options Main Menu choice
	OptionsList options = mainmgr->getGlobalOptions();
	for (OptionsList::iterator it = options.begin(); it != options.end(); it++) {
		TMenuItem *newitem = new TMenuItem(MainMenu1);
		newitem->Caption = (*it).c_str();
		newitem->Default = false;
		newitem->OnClick = OptionShowVals;
		newitem->Hint = mainmgr->getGlobalOptionTip((*it).c_str());
		OptionsList values = mainmgr->getGlobalOptionValues((*it).c_str());
		for (OptionsList::iterator it2 = values.begin(); it2 != values.end(); it2++) {
			TMenuItem *newitem2 = new TMenuItem(MainMenu1);
			newitem2->Caption = (*it2).c_str();
			newitem2->Default = false;
			newitem2->OnClick = GlobalOptionChange;
			newitem->Add(newitem2);
		}
//		Mainmenu->Items->Add(newitem);
		Options2->Add(newitem);
	}
		

	if ((sit = layoutconf->Sections.find("History")) != layoutconf->Sections.end()) {

		eitend = (*sit).second.upper_bound("SearchText");
		for (eit = (*sit).second.lower_bound("SearchText"); eit != eitend; eit++)
			Form2->SearchText->Items->Add(eit->second.c_str());

		eitend = (*sit).second.upper_bound("LookupText");
		for (eit = (*sit).second.lower_bound("LookupText"); eit != eitend; eit++)
			freeHandLookup->Items->Add(eit->second.c_str());

		if ((eit = (*sit).second.find("LastTextModule")) != (*sit).second.end()) {
			for (int i = 0; i < PageControl1->PageCount; i++) {
				if (!strcmp(PageControl1->Pages[i]->Caption.c_str(), (*eit).second.c_str())) {
					PageControl1->ActivePageIndex = i;
					break;
				}
			}
		}
		if ((eit = (*sit).second.find("LastComModule")) != (*sit).second.end()) {
			for (int i = 0; i < PageControl2->PageCount; i++) {
				if (!strcmp(PageControl2->Pages[i]->Caption.c_str(), (*eit).second.c_str())) {
					PageControl2->ActivePageIndex = i;
					break;
				}
			}
		}
		if ((eit = (*sit).second.find("LastVerse")) != (*sit).second.end()) {
			freeHandLookup->Text = (*eit).second.c_str();
			char ret = '\r';
			freeHandLookupoldKeyPress(0, ret);
		}
	}

	ConfigEntMap *section;
     TPageControl *pc = 0;
    	for (int pcs = 0; pcs < 3; pcs++) {
     	switch (pcs) {
          case 0:
          	pc = PageControl1;
		     section = &(*layoutconf)["TextView"];
               break;
          case 1:
               pc = PageControl2;
		     section = &(*layoutconf)["CommentView"];
               break;
          case 2:
          	pc = PageControl3;
	     	section = &(*layoutconf)["LDView"];
               break;
          }
     	
          for (int i = 0; i < pc->PageCount; i++) {
               string heading = pc->Pages[i]->Caption.c_str();
               pc->Pages[i]->TabVisible = !((*section)[heading.c_str()] == "false");  // !false allows default to be true
          }
     }
}

bool TForm1::hasFeature(SWMgr *mgr, const char *modName, const char *feature) {
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit, eitend;

	if ((sit = mgr->config->Sections.find(modName)) != mgr->config->Sections.end()) {
		for (eit = (*sit).second.lower_bound("Feature"), eitend = (*sit).second.upper_bound("Feature"); eit != eitend; eit++) {
			const char *tfeature = eit->second.c_str();
			if (!stricmp(tfeature, feature))
				return true;
		}
	}
	return false;
}


//---------------------------------------------------------------------------
void __fastcall TForm1::LookupPokeData(TObject *Sender)
{
	char buf[255];
	char *token;
	ModMap::iterator it;

	strncpy(buf, Lookup->Text.c_str(), 254);
	buf[254] = 0;
	token = strtok(buf, " ");
	if ((it = mainmgr->Modules.find(token)) != mainmgr->Modules.end()) {
		token = strtok(NULL, "");
		(*it).second->SetKey(token);
		Lookup->Text = (const char *)(*(*it).second);
	}
	else Lookup->Text = "";
			
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SearchPokeData(TObject *Sender)
{
	char buf[255];
	char *token;
	ModMap::iterator it;
	AnsiString retval = "";

	strncpy(buf, Search->Text.c_str(), 254);
	buf[254] = 0;
	token = strtok(buf, " ");
	if ((it = mainmgr->Modules.find(token)) != mainmgr->Modules.end()) {
		token = strtok(NULL, "");
		ListKey &results = (*it).second->Search(token, REG_ICASE);
		while (!results.Error()) {
			retval = retval + (const char *)results + "; ";
			results++;
		}
		Search->Text = retval;
	}
	else Search->Text = "";
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown3Click(TObject *Sender, TUDBtnType Button)
{
	ModMap::iterator it;
	
	it = mainmgr->Modules.find(PageControl3->ActivePage->Caption.c_str());
	if (it != mainmgr->Modules.end()) {
		if (Button == btNext)
			(*((*it).second))++;
		else	(*((*it).second))--;
		DictKeyEdit->Text = ((*it).second)->KeyText();
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
	btnLookupClick(Sender);
}
//---------------------------------------------------------------------------

void TForm1::RestoreState(ModState *state)
{
	if (state) {
		state->pc->ActivePage = state->ap;
		if ((state->pc == PageControl1) || (state->pc == PageControl2)) {
				DefaultVSKey = state->key;
				TextKeyChanged();
		}
		if (state->pc == PageControl3) {
				DictKeyEdit->Text = (const char *)state->key;
		}
		if (state->pc->ActivePage->ControlCount)
			Form1->ActiveControl = (TWinControl *)state->pc->ActivePage->Controls[0];
	}
}


void __fastcall TForm1::BackbtnClick(TObject *Sender)
{
	list <ModState *>::iterator it;

	logmodstate = false;
	it = modstates.begin();
	if (it != modstates.end()) {
		it++;
	
		if (it != modstates.end()) {
			RestoreState(*it);
			delete *modstates.begin();
			modstates.erase(modstates.begin(), it);
		}
	}
	logmodstate = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
/*
	list <ModState *>::iterator it;
	ListBox1->Clear();
	for (it = modstates.begin(); it != modstates.end(); it++) {
		ListBox1->Items->Add((*it)->ap->Caption.c_str());
	}
*/
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CopyasBGreekTransliteration1Click(TObject *Sender)
{
	char *retbuf;
	int len;
	TClipboard *clip = new TClipboard();
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	len = rtf->SelText.Length() * 2;
	retbuf = new char [ len ];
	if (!Greek2bGreek(retbuf, rtf->SelText.c_str(), len)) {
		clip->SetTextBuf(retbuf);
	}
	delete clip;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Copy1Click(TObject *Sender)
{
	int wordstart;
	
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		for (wordstart = rtf->SelStart; (wordstart > -1)&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart--);
		rtf->SelStart = (wordstart > -1) ? wordstart: 0;
		for (wordstart = rtf->SelStart + 1; (wordstart < rtf->Text.Length())&&(isdigit(rtf->Text[wordstart])||isalpha(rtf->Text[wordstart])); wordstart++);
		rtf->SelLength = ((wordstart < rtf->Text.Length()) ? wordstart : rtf->Text.Length()) - rtf->SelStart - 1;
	}
	rtf->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BookmarkItemClick(TObject *Sender)
{
	TMenuItem *menuchoice = (TMenuItem *)Sender;
	const char *source = menuchoice->Caption.c_str();
	char *value = new char [strlen(source) + 1];
	int k = 0;
	for (unsigned int j = 0; j < strlen(source); j++) {
		if (source[j] != '&')
			value[k++] = source[j];
	}
	value[k] = 0;
	DefaultVSKey = value;	
	delete [] value;
	TextKeyChanged();
}

void __fastcall TForm1::AddBookmark1Click(TObject *Sender)
{
//	TMenuItem *newitem;

	Bookmarksfrm->bmtree->Items->AddChild(Bookmarksfrm->bmtree->Items->Item[0], (const char *)DefaultVSKey);
}

void TForm1::AddSectionToMenu(TMenu *menu, TMenuItem *item, TTreeNode *tree)
{
	TMenuItem *newitem;
	
	for (tree = tree->getFirstChild(); tree; tree = tree->getNextSibling()) {
		newitem = new TMenuItem(menu);
		newitem->Caption = tree->Text;
		if (!tree->getFirstChild()) 
			newitem->OnClick = BookmarkItemClick;
		item->Add(newitem);
		AddSectionToMenu(menu, newitem, tree);
	}
}

void TForm1::RefreshBookmarksMenu(TMenu *menu, TTreeView *treeview)
{
	TMenuItem *newitem;
	TTreeNode *tree = 0;

	if (treeview->Items->Count)
		tree = treeview->Items->Item[0];
	
	while (menu->Items->Count > 3)
		menu->Items->Delete(3);

	for (;tree;tree = tree->getNextSibling()) {
		newitem = new TMenuItem(menu);
		newitem->Caption = tree->Text;
		menu->Items->Add(newitem);
		AddSectionToMenu(menu, newitem, tree);
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::BookmarkbtnClick(TObject *Sender)
{
	TPoint menup, point;
	point.x = 0;
	point.y = Bookmarkbtn->Height;
	menup = Bookmarkbtn->ClientToScreen(point);
	RefreshBookmarksMenu(BookmarkPopup, Bookmarksfrm->bmtree);
	BookmarkPopup->Popup(menup.x, menup.y);	
}
//---------------------------------------------------------------------------


void __fastcall TForm1::EditBookmarks1Click(TObject *Sender)
{
	Bookmarksfrm->Show();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
	char buf[5];
	int val;
	ModMap::iterator it;
	TPageControl *pc = PageControl1;

	if ((Shift.Contains(ssCtrl)) && (!Shift.Contains(ssAlt))) {
		if ((Key >= '0') && (Key <= '9')) {
			sprintf(buf, "%c", Key);
			val = atoi(buf);

			if (!Shift.Contains(ssShift)) {
				if ((Screen->ActiveControl == PageControl2) || (IsChild(PageControl2->Handle, Screen->ActiveControl->Handle)))
					pc = PageControl2;
				if ((Screen->ActiveControl == PageControl3) || (IsChild(PageControl3->Handle, Screen->ActiveControl->Handle)))
					pc = PageControl3;

				it = mainmgr->Modules.find(pc->ActivePage->Caption.c_str());
				if (it != mainmgr->Modules.end()) {
					if (ctrlstates[val])
						delete ctrlstates[val];
					
					ctrlstates[val] = new ModState(pc, pc->ActivePage, (*it).second->KeyText());
				}
			}
			else	RestoreState(ctrlstates[val]);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Options1Click(TObject *Sender)
{
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	ConfigEntMap emap;
	int color;
	string tmpval;

	if ((sit = optionsconf->Sections.find("Appearance")) != optionsconf->Sections.end()) {
		Optionsfrm->CurrentVSColor->Brush->Color = 
			   atoi(sit->second["CurrentVSColorRed"].c_str())
			| (atoi(sit->second["CurrentVSColorGreen"].c_str()) << 8)
			| (atoi(sit->second["CurrentVSColorBlue"].c_str()) << 16);
		Optionsfrm->AutoVSColor->Checked = ((atoi(sit->second["AutoVSColor"].c_str()))?true:false);
		if ((*sit).second.find("FontSize") != (*sit).second.end())
			Optionsfrm->UpDown1->Position = atoi((*(*sit).second.find("FontSize")).second.c_str());
	}
	
	if ((sit = optionsconf->Sections.find("Bookmarks")) != optionsconf->Sections.end()) {
		Optionsfrm->AutoBMPersonal->Checked = ((atoi(sit->second["AutoSavePersonal"].c_str()))?true:false);
		Optionsfrm->AutoBMOther->Checked    = ((atoi(sit->second["AutoSaveOther"].c_str()))?true:false);
	}

	
	Optionsfrm->HintPopups->Checked = true;
	tmpval = ((eit = optionsconf->Sections["Hints"].find("On")) != optionsconf->Sections["Hints"].end())? (*eit).second : (string)"1";
	if (!atoi(tmpval.c_str()))
		Optionsfrm->HintPopups->Checked = false;

	Optionsfrm->devsAsDictsCB->Checked = false;
	tmpval = ((eit = optionsconf->Sections["General"].find("DevsAsDicts")) != optionsconf->Sections["General"].end())? (*eit).second : (string)"false";
	if (!stricmp(tmpval.c_str(), "true"))
		Optionsfrm->devsAsDictsCB->Checked = true;

	Optionsfrm->devSplashCB->Checked = false;
	tmpval = ((eit = optionsconf->Sections["General"].find("Splash")) != optionsconf->Sections["General"].end())? (*eit).second : (string)"";
	if (!stricmp(tmpval.c_str(), "Devotional"))
		Optionsfrm->devSplashCB->Checked = true;

	const char *localeName = LocaleMgr::systemLocaleMgr.getDefaultLocaleName();
	SWLocale *defLocale = LocaleMgr::systemLocaleMgr.getLocale(localeName);
	Optionsfrm->localeCB->ItemIndex = Optionsfrm->localeCB->Items->IndexOf((defLocale)?defLocale->getDescription():"English (US)");

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("GreekDef")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->greekDefCB->ItemIndex = Optionsfrm->greekDefCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("GreekParse")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->greekParseCB->ItemIndex = Optionsfrm->greekParseCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("HebrewDef")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->hebrewDefCB->ItemIndex = Optionsfrm->hebrewDefCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("HebrewParse")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->hebrewParseCB->ItemIndex = Optionsfrm->hebrewParseCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("DailyDevotion")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->dailyDefaultCB->ItemIndex = Optionsfrm->dailyDefaultCB->Items->IndexOf(it->second->Description());
	}

	tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("StrongsNumbers")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
	if ((it = mainmgr->Modules.find(tmpval)) != mainmgr->Modules.end()) {
		Optionsfrm->strongsNumsCB->ItemIndex = Optionsfrm->strongsNumsCB->Items->IndexOf(it->second->Description());
	}

	if (Optionsfrm->ShowModal() == mrOk) {
		emap = optionsconf->Sections["Appearance"];
		color = Optionsfrm->CurrentVSColor->Brush->Color;
		emap.erase("CurrentVSColorRed"); emap.insert(ConfigEntMap::value_type("CurrentVSColorRed", IntToStr(color & 0xFF).c_str()));
		emap.erase("CurrentVSColorGreen"); emap.insert(ConfigEntMap::value_type("CurrentVSColorGreen", IntToStr((color >> 8) & 0xFF).c_str()));
		emap.erase("CurrentVSColorBlue"); emap.insert(ConfigEntMap::value_type("CurrentVSColorBlue", IntToStr((color >> 16) & 0xFF).c_str()));
		emap.erase("AutoVSColor"); emap.insert(ConfigEntMap::value_type("AutoVSColor", IntToStr((Optionsfrm->AutoVSColor->Checked)?1:0).c_str()));
		emap.erase("FontSize"); emap.insert(ConfigEntMap::value_type("FontSize", IntToStr(atoi(Optionsfrm->fontSize->Text.c_str())).c_str()));
		emap.erase("locale"); emap.insert(ConfigEntMap::value_type("locale", (const char *)Optionsfrm->localeCB->Items->Objects[Optionsfrm->localeCB->ItemIndex]));
		optionsconf->Sections["Appearance"] = emap;

		emap = optionsconf->Sections["ModDefaults"];
		
		if (Optionsfrm->greekDefCB->ItemIndex > -1) {
			emap.erase("GreekDef"); emap.insert(ConfigEntMap::value_type("GreekDef", (const char *)Optionsfrm->greekDefCB->Items->Objects[Optionsfrm->greekDefCB->ItemIndex]));
		}
		if (Optionsfrm->greekParseCB->ItemIndex > -1) {
			emap.erase("GreekParse"); emap.insert(ConfigEntMap::value_type("GreekParse", (const char *)Optionsfrm->greekParseCB->Items->Objects[Optionsfrm->greekParseCB->ItemIndex]));
		}
		if (Optionsfrm->hebrewDefCB->ItemIndex > -1) {
			emap.erase("HebrewDef"); emap.insert(ConfigEntMap::value_type("HebrewDef", (const char *)Optionsfrm->hebrewDefCB->Items->Objects[Optionsfrm->hebrewDefCB->ItemIndex]));
		}
		if (Optionsfrm->hebrewParseCB->ItemIndex > -1) {
			emap.erase("HebrewParse"); emap.insert(ConfigEntMap::value_type("HebrewParse", (const char *)Optionsfrm->hebrewParseCB->Items->Objects[Optionsfrm->hebrewParseCB->ItemIndex]));
		}
		if (Optionsfrm->dailyDefaultCB->ItemIndex > -1) {
			emap.erase("DailyDevotion"); emap.insert(ConfigEntMap::value_type("DailyDevotion", (const char *)Optionsfrm->dailyDefaultCB->Items->Objects[Optionsfrm->dailyDefaultCB->ItemIndex]));
		}
		if (Optionsfrm->strongsNumsCB->ItemIndex > -1) {
			emap.erase("StrongsNumbers"); emap.insert(ConfigEntMap::value_type("StrongsNumbers", (const char *)Optionsfrm->strongsNumsCB->Items->Objects[Optionsfrm->strongsNumsCB->ItemIndex]));
		}

		optionsconf->Sections["ModDefaults"] = emap;


		emap = optionsconf->Sections["Bookmarks"];
		emap.erase("AutoSavePersonal"); emap.insert(ConfigEntMap::value_type("AutoSavePersonal", IntToStr((Optionsfrm->AutoBMPersonal->Checked)?1:0).c_str()));
		emap.erase("AutoSaveOther"); emap.insert(ConfigEntMap::value_type("AutoSaveOther", IntToStr((Optionsfrm->AutoBMOther->Checked)?1:0).c_str()));
		optionsconf->Sections["Bookmarks"] = emap;

		emap = optionsconf->Sections["Hints"];
		emap.erase("On"); emap.insert(ConfigEntMap::value_type("On", IntToStr((Optionsfrm->HintPopups->Checked)?1:0).c_str()));
		optionsconf->Sections["Hints"] = emap;

		emap = optionsconf->Sections["General"];
		emap.erase("Splash"); emap.insert(ConfigEntMap::value_type("Splash", (Optionsfrm->devSplashCB->Checked)?"Devotional":""));
		emap.erase("DevsAsDicts"); emap.insert(ConfigEntMap::value_type("DevsAsDicts", (Optionsfrm->devsAsDictsCB->Checked)?"true":"false"));
		optionsconf->Sections["General"] = emap;

		optionsconf->Save();
	}

	tmpval = ((eit = optionsconf->Sections["Hints"].find("On")) != optionsconf->Sections["Hints"].end())? (*eit).second : (string)"1";

	if (atoi(tmpval.c_str()))
		Form1->ShowHint = true;
	else Form1->ShowHint = false;

	tmpval = ((eit = optionsconf->Sections["Appearance"].find("locale")) != optionsconf->Sections["Appearance"].end())? (*eit).second : (string)"en_us";
	LocaleMgr::systemLocaleMgr.setDefaultLocaleName(tmpval.c_str());
	DefaultVSKey.setLocale(tmpval.c_str());
	fillVKeySelector(&DefaultVSKey);
	TextKeyChanged();

}
//---------------------------------------------------------------------------
void __fastcall TForm1::cbBookChange(TObject *Sender)
{
	CHBox->Text = "1";
	VSBox->Text = "1";
	if (Screen->ActiveControl == cbBook)	
		btnLookupClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	Hint = "";
	Application->OnHint = DisplayHint;
	Application->ShowHint = true;
	this->ShowHint = true;
}


void TForm1::AddVerseChoices(TPopupMenu *menu, const char *buf, TRxRichEdit *rtf) {
	TMenuItem *newitem;

	tmpVerseList = DefaultVSKey.ParseVerseList((char *)buf, DefaultVSKey);

	ModMap::iterator target;
	target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		char *keytext = 0;		// check for and remove return at end of keytext
		stdstr(&keytext, (*(*target).second).KeyText());
		if (keytext[strlen(keytext)-1] == '\r')
			keytext[strlen(keytext)-1] = 0;
					
		tmpVerseListCaption = String("VerseList from- ") + (*target).first.c_str() + ": " + keytext;
		delete [] keytext;		// ---------------------------------
	}
	newitem = new TMenuItem(menu);
	newitem->Caption = "-";
	menu->Items->Add(newitem);
	newitem = new TMenuItem(menu);
	newitem->Caption = "Create Verse List";
	newitem->Hint = "Create a New Verse List Window";
	newitem->Default = true;
	newitem->OnClick = createVerseList;
	menu->Items->Add(newitem);
	int breakcnt = 3;
	while (!tmpVerseList.Error()) {
		breakcnt++;
		newitem = new TMenuItem(menu);
		newitem->Caption = (const char *)tmpVerseList;
		newitem->OnClick = BookmarkItemClick;
		if (!(breakcnt%15))
			newitem->Break = mbBreak;
		menu->Items->Add(newitem);
		tmpVerseList++;
	}



}


void __fastcall TForm1::PopupMenuPopup(TObject *Sender) {

	int versestart, verseend;
	TPopupMenu *menu = (TPopupMenu *)Sender;
	int staticMenuItemsCount = 0;
	TMenuItem *newitem;

	if (menu == PopupMenu1)
		staticMenuItemsCount = 3;
	else if (menu == PopupMenu2)
		staticMenuItemsCount = 2;
	else if (menu == PopupMenu3)
		staticMenuItemsCount = 6;
		
	while (menu->Items->Count > staticMenuItemsCount)
		menu->Items->Delete(staticMenuItemsCount);

	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	if (!rtf->SelLength) {
		int entrylen = strlen(rtf->Text.c_str());
		char *entrytext = new char [ entrylen + 1 ];
		int selstart = rtf->SelStart;
		strcpy(entrytext, rtf->Text.c_str());
//		for (versestart = rtf->SelStart; ((versestart)&&(rtf->Text[versestart] != '#')); versestart--);
		for (versestart = selstart; ((versestart)&&(entrytext[versestart] != '#')); versestart--);
		if (versestart) {
			for (verseend = versestart; ((verseend < entrylen) && (entrytext[verseend] != '|')); verseend++);
			if ((verseend < entrylen) && (verseend > selstart)) {
				int len = (verseend - versestart) + 1;
				char *buf = new char [ len + 1 ];
				memset(buf, 0 , len + 1);
				strncpy(buf, &entrytext[versestart+1], len - 2);	// strip the # and | from the string
				int buflen = strlen(buf);
				for (int i = 0; i < buflen; i++) {
					if ((buf[i] == 10) || (buf[i] == 13))
						buf[i] = ' ';
				}
				AddVerseChoices(menu, buf, rtf);
				delete [] buf;
			}
		}
		delete [] entrytext;
	}
	else {
		string highlight = Trim(rtf->SelText).c_str();
		tmpVerseList = DefaultVSKey.ParseVerseList((char *)highlight.c_str(), DefaultVSKey);
		if (tmpVerseList.Count())
			AddVerseChoices(menu, highlight.c_str(), rtf);
			
//		newitem = new TMenuItem(menu);
//		newitem->Caption = "Verse Lookup";
//		newitem->Hint = "Attempt to lookup highlighted text as a verse";
//		newitem->OnClick = verseLookupClick;
//		menu->Items->Add(newitem);
	}
	
}
//---------------------------------------------------------------------------


void __fastcall TForm1::createVerseList(TObject *Sender)
{
	TVerseListFrm *tmpForm = new TVerseListFrm(this, tmpVerseList);
	tmpForm->Caption = tmpVerseListCaption;
	tmpForm->Show();	
}
//---------------------------------------------------------------------------

void __fastcall TForm1::freeHandLookupoldKeyPress(TObject *Sender, char &Key)
{
	if (Key == '\r') {
		ListKey tmpVerseList = DefaultVSKey.ParseVerseList(freeHandLookup->Text.c_str(), DefaultVSKey);

		if (tmpVerseList.Count()) {
			int index = freeHandLookup->Items->IndexOf(freeHandLookup->Text);
			freeHandLookup->Items->Insert(0, freeHandLookup->Text);

			if (index >= 0)
				freeHandLookup->Items->Delete(index+1);
		
			freeHandLookup->ItemIndex = 0;

			if (tmpVerseList.Count() > 1) {
				TVerseListFrm *tmpForm = new TVerseListFrm(this, tmpVerseList);
				tmpForm->Caption = "User Verse List";
				tmpForm->Show();
			}

			tmpVerseList = TOP;
			DefaultVSKey = tmpVerseList;
			TextKeyChanged();
		}
	}
}
//---------------------------------------------------------------------------


void __fastcall TForm1::RTFMouseDown(TObject *Sender, TMouseButton Button, TShiftState Shift, int X, int Y) {
	((TWinControl *)Sender)->SetFocus();
	TRichEdit *rtf = (TRichEdit *)Sender;
	if (Button == mbRight) {
		if (!rtf->SelLength)
			SendMessage(rtf->Handle, WM_LBUTTONDOWN, MK_LBUTTON, MAKELONG(X, Y));
          TPoint menup, point;
          point.x = X;
          point.y = Y;
          menup = rtf->ClientToScreen(point);
          rtf->PopupMenu->Popup(menup.x, menup.y);	
	}
}


//---------------------------------------------------------------------------

void __fastcall TForm1::EditEntry1Click(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	SWModule *module;
//	EditEntry->RichEdit1->Text = rtf->Text;
	ModMap::iterator target;
	target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		EditEntry->Module = module = (*target).second;
		EditEntry->RTFDisplay = rtf;
	}
	else	EditEntry->Module = module = 0;
	EditEntry->ShowModal();
	if (EditEntry->ResultBuf) {
		if (module)
//			DictKeyEdit->Text = EditEntry->ResultBuf;  // for testing purposes
			*module << EditEntry->ResultBuf;
	}
	RefreshActiveSheet(PageControl2);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DeleteEntry1Click(TObject *Sender)
{
	SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
	SWModule *module;
	ModMap::iterator target;

	target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		module = (*target).second;
		module->deleteEntry();
	}
	RefreshActiveSheet(PageControl2);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::LinktoVerse1Click(TObject *Sender)
{
	if (VerseSelFrm->ShowModal() == mrOk) {
		SWDispRTF *rtf = (SWDispRTF *)Screen->ActiveControl;
		SWModule *module;
		ModMap::iterator target;
		SWKey *linkkey = new VerseKey(VerseSelFrm->Panel2->Caption.c_str());

		target = mainmgr->Modules.find(((TPageControl*)rtf->Parent->Parent)->ActivePage->Caption.c_str());
		if (target != Form1->mainmgr->Modules.end()) {
			module = (*target).second;
			*module << linkkey;
		}
		RefreshActiveSheet(PageControl2);
	}
}
//---------------------------------------------------------------------------


void __fastcall TForm1::GlobalOptionChange(TObject *Sender)
{
//	ModMap::iterator it;
//	SectionMap::iterator sit;
//	ConfigEntMap::iterator eit, eitend;
	ConfigEntMap::iterator eit;
	TMenuItem *menuchoice = (TMenuItem *)Sender;
	const char *source = menuchoice->Caption.c_str();
	char *value = new char [strlen(source) + 1];
	int k = 0;
	for (unsigned int j = 0; j < strlen(source); j++) {
		if (source[j] != '&')
			value[k++] = source[j];
	}
	value[k] = 0;
	source = menuchoice->Parent->Caption.c_str();
	char *option = new char [strlen(source) + 1];
	k = 0;
	for (unsigned int j = 0; j < strlen(source); j++) {
		if (source[j] != '&')
			option[k++] = source[j];
	}
	option[k] = 0;
	mainmgr->setGlobalOption(option, value);
	
	if ((!stricmp(option, "Strong's Numbers")) && (!stricmp(value, "On"))) {
		string curText = PageControl1->ActivePage->Caption.c_str();
		if (!hasFeature(mainmgr, curText.c_str(), "StrongsNumbers")) {
			string tmpval = ((eit = optionsconf->Sections["ModDefaults"].find("StrongsNumbers")) != optionsconf->Sections["ModDefaults"].end())? (*eit).second : (string)"";
			for (int i = 0; i < PageControl1->PageCount; i++) {
				if (!stricmp(PageControl1->Pages[i]->Caption.c_str(), tmpval.c_str())) {
					PageControl1->ActivePageIndex = i;
					break;
				}
			}
		}
	}

	
	delete [] option;
	delete [] value;
	TextKeyChanged();
}
//---------------------------------------------------------------------------



void __fastcall TForm1::OptionShowVals(TObject *Sender)
{
	TMenuItem *menuChoice = (TMenuItem *)Sender;

	string option = menuChoice->Caption.c_str();
	int k = 0;
	const char *source = option.c_str();
	char *caption = new char [strlen(source) + 1];
	for (unsigned int j = 0; j < strlen(source); j++) {
		if (source[j] != '&')
			caption[k++] = source[j];
	}
	caption[k] = 0;
		
	string value = mainmgr->getGlobalOption(caption);
	delete [] caption;
	for (int i = 0; i < menuChoice->Count; i++) {
		int k = 0;
		char *source = menuChoice->Items[i]->Caption.c_str();
		char *caption = new char [strlen(source) + 1];
		for (unsigned int j = 0; j < strlen(source); j++) {
			if (source[j] != '&')
				caption[k++] = source[j];
		}
		caption[k] = 0;
		if (!stricmp(caption, value.c_str()))
			menuChoice->Items[i]->Checked = true;
		else	menuChoice->Items[i]->Checked = false;                            
		delete [] caption;
	}
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Contents1Click(TObject *Sender)
{
	string helpDir;
	ConfigEntMap::iterator it = optionsconf->Sections["Help"].find("Directory");
	if (it != optionsconf->Sections["Help"].end())
		helpDir = (*it).second;
	else helpDir = ".\\help";

	string helpExe = helpDir + "\\sword.chm";
	
	if ((int)ShellExecute(this->Handle, "open", helpExe.c_str(), NULL, NULL, SW_SHOWNORMAL) < 33) {
		helpExe = helpDir + "\\index.html";
		ShellExecute(this->Handle, "open", helpExe.c_str(), NULL, NULL, SW_SHOWNORMAL);
	}
}
//---------------------------------------------------------------------------


void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
	int saveCount = 5;
	

	ConfigEntMap section;
	ConfigEntMap::iterator entryIt;
	
	section = layoutconf->Sections["History"];
	entryIt = section.find("SearchSaveCount");
	if (entryIt != section.end())
		saveCount = atoi(entryIt->second.c_str());
	else	section.insert(ConfigEntMap::value_type("SearchSaveCount", "5"));

	section.erase("SearchText");
	for (int loop = 0; ((loop < saveCount) && (loop <	Form2->SearchText->Items->Count)); loop++)
		 section.insert(ConfigEntMap::value_type("SearchText", Form2->SearchText->Items->Strings[loop].c_str()));

	entryIt = section.find("LookupSaveCount");
	if (entryIt != section.end())
		saveCount = atoi(entryIt->second.c_str());
	else	section.insert(ConfigEntMap::value_type("LookupSaveCount", "5"));

	section.erase("LookupText");
	for (int loop = 0; ((loop < saveCount) && (loop <	freeHandLookup->Items->Count)); loop++)
		 section.insert(ConfigEntMap::value_type("LookupText", freeHandLookup->Items->Strings[loop].c_str()));

	section.erase("LastVerse");
	section.insert(ConfigEntMap::value_type("LastVerse", (const char *)DefaultVSKey));

	section.erase("LastTextModule");
	section.insert(ConfigEntMap::value_type("LastTextModule", PageControl1->ActivePage->Caption.c_str()));

	section.erase("LastComModule");
	section.insert(ConfigEntMap::value_type("LastComModule", PageControl2->ActivePage->Caption.c_str()));

	layoutconf->Sections["History"] = section;
	layoutconf->Save();
	
}
//---------------------------------------------------------------------------

void __fastcall TForm1::lbDictKeysClick(TObject *Sender)
{
	DictKeyEdit->Text = lbDictKeys->Items->Strings[lbDictKeys->ItemIndex];
}
//---------------------------------------------------------------------------


void __fastcall TForm1::HideShowModules1Click(TObject *Sender)
{
	ConfigEntMap *section;
     TMenuItem *menuItem = (TMenuItem *)Sender;
     TPopupMenu *menu = (TPopupMenu *)menuItem->GetParentMenu();
     TComponent *comp = menu->PopupComponent;
     TPageControl *pc = 0;
     
     if ((comp == PageControl1) || (comp == pnlText)) {
          pc = PageControl1;
	     section = &(*layoutconf)["TextView"];
     }
     if ((comp == PageControl2) || (comp == pnlComment)) {
     	pc = PageControl2;
	     section = &(*layoutconf)["CommentView"];
     }
     if ((comp == PageControl3) || (comp == pnlDict)) {
     	pc = PageControl3;
     	section = &(*layoutconf)["LDView"];
     }

     if (!pc) return;	// assert pc
     	
	for (int i = 0; i < pc->PageCount; i++) {
     	string heading = pc->Pages[i]->Caption.c_str();
     	(*section)[heading.c_str()] = ((pc->Pages[i]->TabVisible) ? "true" : "false");
     }
     ModVisForm->mgr = mainmgr;
	ModVisForm->section = section;
	if (ModVisForm->ShowModal() == mrOk) {
          for (int i = 0; i < pc->PageCount; i++) {
               string heading = pc->Pages[i]->Caption.c_str();
			pc->Pages[i]->TabVisible = ((*section)[heading.c_str()] == "true");
          }
     }	
}
//---------------------------------------------------------------------------



