//---------------------------------------------------------------------------
#include "BibleCSMGR.h"
#include <swconfig.h>
#include <gbfrtf.h>
#include <rwprtf.h>
#include <rawgbf.h>
#include <thmlrtf.h>
#include <unicodertf.h>
//---------------------------------------------------------------------------
BibleCSMGR::BibleCSMGR(TModInstFrm *iModInstFrm) : SWMgr(0, 0, false)
{
	gbftortf = new GBFRTF();
	rwptortf = new RWPRTF();
	thmltortf = new ThMLRTF();
     unicodetortf = new UnicodeRTF();
	ModInstFrm = iModInstFrm;
	Load();
}


BibleCSMGR::~BibleCSMGR()
{
	if (gbftortf)
		delete gbftortf;
			
	if (rwptortf)
		delete rwptortf;

	if (thmltortf)
		delete thmltortf;
          
	if (unicodetortf)
		delete unicodetortf;
}
			

void BibleCSMGR::AddRenderFilters(SWModule *module, ConfigEntMap &section)
{
	string sourceformat;
	string encoding;                     
	ConfigEntMap::iterator entry;

	sourceformat = ((entry = section.find("SourceType")) != section.end()) ? (*entry).second : (string)"";
	encoding = ((entry = section.find("Encoding")) != section.end()) ? (*entry).second : (string)"";
	// Temporary: To support old module types
//	if (sourceformat.empty()) {
//		try {
//			if (dynamic_cast<RawGBF *>(module))
//				sourceformat = "GBF";
//		}
//		catch ( ... ) {}
//	}
//	
	if (!stricmp(sourceformat.c_str(), "GBF")) {
		module->AddRenderFilter(gbftortf);
	}

	if ((!stricmp(sourceformat.c_str(), "PlainUnicode")) || (!stricmp(encoding.c_str(), "UTF-8"))) {
		module->AddRenderFilter(unicodetortf);
	}

	if (!stricmp(module->Name(), "RWP"))
		module->AddRenderFilter(rwptortf);

	if (!stricmp(sourceformat.c_str(), "THML"))
		module->AddRenderFilter(thmltortf);
}


char BibleCSMGR::AddModToConfig(int conffd, const char *fname)
{
	SWConfig modconf(fname);
	SectionMap::iterator section;
	AnsiString abouttext = "";
	bool logflag;
	TMemoryStream *RTFStream = new TMemoryStream();
	char retval;

	section = modconf.Sections.begin();

	ModInstFrm->ModText->Caption = "";
	ModInstFrm->ModText->Caption = ModInstFrm->ModText->Caption + "Found new module [ " + (*(*section).second.find("Description")).second.c_str() + " ]. Installing...";

	abouttext = abouttext + "{\\fs20\\cf0 " + (*(*section).second.find("About")).second.c_str() + " }";
	RTFStream->Clear();
	RTFStream->WriteBuffer(abouttext.c_str(), abouttext.Length());
	RTFStream->Position = 0;
	ModInstFrm->AboutText->Lines->LoadFromStream(RTFStream);
	delete RTFStream;
	
	ModInstFrm->ShowModal();

	logflag = SWLog::systemlog->log;
	SWLog::systemlog->log = false;	
	retval = SWMgr::AddModToConfig(conffd, fname);
	SWLog::systemlog->log = logflag;
	
	return retval;
}
