//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "searchfrm.h"
#include <listkey.h>
#include "mainfrm.h"
#include <regex.h>
#include "RangeMaintFrm.h"


//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner) {
	pvrtf = new SWDispRTF(this);

	pvrtf->Parent = plPreview;
	pvrtf->Align = alClient;
	pvrtf->ScrollBars = ssVertical;
	pvrtf->ReadOnly = true;
	SearchText->Align = alClient;
//	pvrtf->PopupMenu = PopupMenu2;

//	mod->Disp(*displays.insert(displays.begin(), new RTFDisp(newrtf)));
//	mod->SetKey(DefaultVSKey);
//	return 0;
}
//--------------------------------------------------------------------------- 
void __fastcall TForm2::Button1Click(TObject *Sender)
{
//	ModMap::iterator target;
	class TWaitCursor {
	public:
	    TWaitCursor() : oldc(Screen->Cursor) { Screen->Cursor = crHourGlass; }
	    ~TWaitCursor()                       { Screen->Cursor = oldc; }
	private:
	    TCursor oldc;
	} wait; // show hourglass

	if (!SearchText->Text.Length())
		return;


	int index = SearchText->Items->IndexOf(SearchText->Text);
	SearchText->Items->Insert(0, SearchText->Text);

	if (index >= 0)
		SearchText->Items->Delete(index+1);
		
	SearchText->ItemIndex = 0;
		
	Caption = "";

	targetpc = Form1->PageControl1;

	if ((Form1->ActiveControl == Form1->PageControl2) || (IsChild(Form1->PageControl2->Handle, Form1->ActiveControl->Handle)))
		targetpc = Form1->PageControl2;
	if ((Form1->ActiveControl == Form1->PageControl3) || (IsChild(Form1->PageControl3->Handle, Form1->ActiveControl->Handle)))
		targetpc = Form1->PageControl3;

	
	target = Form1->mainmgr->Modules.find(targetpc->ActivePage->Caption.c_str());
	if (target != Form1->mainmgr->Modules.end()) {
		Caption = Caption + "Searching [" + (*target).first.c_str() + "]...";
		resultsLV->Items->Clear();
		int searchType;
		switch (searchTypeGroup->ItemIndex) {
		case 0:	searchType = -2; break;
		case 1:	searchType = -1; break;
		case 2:	searchType = 0;  break;
		}
		int searchOptions = (CheckBox2->Checked) ? 0 : REG_ICASE;
		Button1->Caption = "Halt";
		Button1->OnClick = TerminateSearch;
		SWKey *scope = 0;
		switch (scopeGroup->ItemIndex) {
		case 2:
			if (ComboBox1->ItemIndex < 0)
				results = VerseKey().ParseVerseList(ComboBox1->Text.c_str(), "", true);
			else {
				TCustomRange *rs = (TCustomRange *)ComboBox1->Items->Objects[ComboBox1->ItemIndex];
				results = VerseKey().ParseVerseList(rs->text.c_str(), "", true);
			}
		case 1: scope = &results; break;
		}
		searchThread = new TSearchThread(this, SearchText->Text.c_str(), searchType, searchOptions, scope);
	}
	else Caption = "Error finding target module";
}


void __fastcall TForm2::TerminateSearch(TObject *Sender)
{
	(*target).second->terminateSearch = true;
}

//---------------------------------------------------------------------------
void __fastcall TForm2::ListBox1DblClick(TObject *Sender)
{
	TListItem *focused = resultsLV->ItemFocused;
	if (focused) {
		int row = focused->Index;
		if (targetpc == Form1->PageControl3) {
			Form1->DictKeyEdit->Text = resultsLV->Items->Item[row]->Caption.c_str();
		}
		else {
			Form1->DefaultVSKey = resultsLV->Items->Item[row]->Caption.c_str();
			Form1->TextKeyChanged();
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm2::ListBox1Click(TObject *Sender)
{
	if (target != Form1->mainmgr->Modules.end()) {
		SWKey savekey = (SWKey)*(*target).second;
		TListItem *focused = resultsLV->ItemFocused;
		if (focused) {
			int row = focused->Index;
			(*target).second->SetKey(resultsLV->Items->Item[row]->Caption.c_str());
			pvrtf->Display(*(*target).second);
			(*target).second->SetKey(savekey);
		}
	}
}

//---------------------------------------------------------------------------

__fastcall TForm2::TSearchThread::TSearchThread(TForm2 *parent, string searchText, int searchType, int searchOptions, SWKey *scope, bool CreateSuspended)
	: TThread(CreateSuspended)
{
	this->parent = parent;
	this->searchText = searchText;
	this->searchType = searchType;
	this->searchOptions = searchOptions;
	this->scope = scope;
	Priority = tpNormal;
	FreeOnTerminate = true;
}


void __fastcall TForm2::TSearchThread::updateProgressBar(void) {
	parent->progressBar->Position = parent->status;
	parent->progressBar->Repaint();
}


void __fastcall TForm2::TSearchThread::updateStatus(void) {
	Synchronize((TThreadMethod)&updateProgressBar);
}


void TForm2::TSearchThread::searchProgressCallback(char status, void *searchThread) {
	TForm2::TSearchThread *thread = (TForm2::TSearchThread *)searchThread;
	thread->parent->status = status;
	thread->updateStatus();
}


void __fastcall TForm2::TSearchThread::FillListBox(void)
{
  TListItem *pItem;

	SWKey *savekey = *(*parent->target).second;
	for (results = TOP; !results.Error(); results++) {
		(*parent->target).second->SetKey(results);
		pItem = parent->resultsLV->Items->Add();
		pItem->Caption = (const char *)results;
		pItem->SubItems->Add((*parent->target).second->StripText());
//		pItem = resultsLV->Items->Add(
	}
	(*parent->target).second->SetKey(*savekey);
// 	ListBox1->Items->Pack();	// so Count is set correctly (per helpfile)
	parent->Caption = "";
	parent->Caption = parent->Caption + "Results from [" + (*(parent->target)).first.c_str() + "] (" + parent->resultsLV->Items->Count + ((parent->resultsLV->Items->Count == 1) ? " match)" : " matches)");
	parent->Button1->Caption = "Search";
	parent->Button1->OnClick = parent->Button1Click;
}

void __fastcall TForm2::TSearchThread::Execute()
{
	results = (*(parent->target)).second->Search(searchText.c_str(), searchType, searchOptions, scope, 0, searchProgressCallback, this);
		
	Synchronize((TThreadMethod)&FillListBox);
	parent->results = results;
}




void __fastcall TForm2::scopeGroupClick(TObject *Sender) {
	bool enabled = (scopeGroup->ItemIndex == 2);
	
	Button2->Enabled = enabled;
	ComboBox1->Enabled = enabled;
}
//---------------------------------------------------------------------------

void __fastcall TForm2::Button2Click(TObject *Sender)
{
	RangeMaintForm->ShowModal();
	populateRanges();	
}
//---------------------------------------------------------------------------

void TForm2::populateRanges() {
	ConfigEntMap::iterator loop, end;
	SWConfig config("./options.conf");	
	ComboBox1->Clear();
	loop = config.Sections["CustomRanges"].begin();
	end = config.Sections["CustomRanges"].end();
	while (loop != end) {
		TCustomRange *rs = new TCustomRange(loop->first.c_str(), loop->second.c_str());
		ComboBox1->Items->AddObject(rs->name.c_str(), rs);
		loop++;
	}
}


void __fastcall TForm2::FormShow(TObject *Sender)
{
	populateRanges();	
}
//---------------------------------------------------------------------------


