#ifndef TTREENODE_H
#define TTREENODE_H

#include <TPersistent.h>
#include <gtk/gtktreeitem.h>
#include <gtk/gtktree.h>
#include <gtk/gtkpixmap.h>
#include <string>

  class TTreeNodes;

  enum TNodeState {nsCut, nsDropHilited, nsFocused, nsSelected, nsExpanded};
  enum TNodeAttachMode {naAdd, naAddFirst, naAddChild, naAddChildFirst, naInsert};
  enum TAddMode {taAddFirst, taAdd, taInsert};

  typedef struct {
    int ImageIndex;
    int SelectedIndex;
    int StateIndex;
    int OverlayIndex;
    void *Data;
    int Count;
    char Text[255];
  } TNodeInfo;


class TTreeNode: public TPersistent {
friend class TTreeNodes;
private:
	TTreeNodes *FOwner;
	GtkTree *subTreeOwner;
	GtkPixmap *image;
	GtkPixmap *stateImage;
	string FText;
    void *FData;
//    FStateIndex: Integer;
	int FStateIndex;
//    FImageIndex: Integer;
	int FImageIndex;
/*
    FItemId: HTreeItem;
    FSelectedIndex: Integer;
    FOverlayIndex: Integer;
    FDeleting: Boolean;
    FInTree: Boolean;
    function CompareCount(CompareMe: Integer): Boolean;
    function DoCanExpand(Expand: Boolean): Boolean;
    procedure DoExpand(Expand: Boolean);
    procedure ExpandItem(Expand: Boolean; Recurse: Boolean);
    function GetAbsoluteIndex: Integer;
    function GetExpanded: Boolean;
    function GetLevel: Integer;
    function GetChildren: Boolean;
    function GetCut: Boolean;
    function GetDropTarget: Boolean;
    function GetFocused: Boolean;
    function GetIndex: Integer;
    function GetItem(Index: Integer): TTreeNode;
    function GetSelected: Boolean;
    function GetState(NodeState: TNodeState): Boolean;
    function GetCount: Integer;
    function GetTreeView: TCustomTreeView;
    procedure InternalMove(ParentNode, Node: TTreeNode; HItem: HTreeItem;
      AddMode: TAddMode);
    function IsEqual(Node: TTreeNode): Boolean;
    function IsNodeVisible: Boolean;
    procedure ReadData(Stream: TStream; Info: PNodeInfo);
    procedure SetChildren(Value: Boolean);
    procedure SetCut(Value: Boolean);
    procedure SetDropTarget(Value: Boolean);
    procedure SetItem(Index: Integer; Value: TTreeNode);
    procedure SetExpanded(Value: Boolean);
    procedure SetFocused(Value: Boolean);
    procedure SetOverlayIndex(Value: Integer);
    procedure SetSelectedIndex(Value: Integer);
    procedure SetSelected(Value: Boolean);
    procedure WriteData(Stream: TStream; Info: PNodeInfo);
*/
//    procedure SetData(Value: Pointer);
	void SetData(void *);
	void *getData() { return FData; }
//	procedure SetText(const S: string);
	void SetText(string S);
	string getText() { return FText; }
//    function GetParent: TTreeNode;
	TTreeNode *GetParent();
//    procedure SetStateIndex(Value: Integer);
	void SetStateIndex(int val);
	int getStateIndex() { return FStateIndex; }
//    procedure SetImageIndex(Value: Integer);
	void SetImageIndex(int val);
	int getImageIndex() { return FImageIndex; }
  public:
	GtkTreeItem *nativeControl;
	TTreeNode(TTreeNodes *AOwner);
	TTreeNode(const TTreeNode &other); // copy constructor;
	TTreeNode(TTreeNodes *AOwner, GtkTree *subTreeOwner, GtkTreeItem *nativeControl, string FText, void *Ptr = 0);
	~TTreeNode();
	TTreeNode *getNextSibling();
//    function getFirstChild: TTreeNode;
	TTreeNode *getFirstChild();
//    function GetNext: TTreeNode;
	TTreeNode *GetNext();
//	property Text: string read FText write SetText;
	property <TTreeNode, string> Text;
//    property StateIndex: Integer read FStateIndex write SetStateIndex;
	property <TTreeNode, int> StateIndex;
//    property ImageIndex: Integer read FImageIndex write SetImageIndex;
	property <TTreeNode, int> ImageIndex;
//    property Data: Pointer read FData write SetData;
	property <TTreeNode, void *> Data;
//    property Parent: TTreeNode read GetParent;
	property <TTreeNode, TTreeNode *> Parent;
/*
    function AlphaSort: Boolean;
    procedure Assign(Source: TPersistent); override;
    procedure Collapse(Recurse: Boolean);
    function CustomSort(SortProc: TTVCompare; Data: Longint): Boolean;
    procedure Delete;
    procedure DeleteChildren;
    function DisplayRect(TextOnly: Boolean): TRect;
    function EditText: Boolean;
    procedure EndEdit(Cancel: Boolean);
    procedure Expand(Recurse: Boolean);
    function GetHandle: HWND;
    function GetLastChild: TTreeNode;
    function GetNextChild(Value: TTreeNode): TTreeNode;
    function GetNextVisible: TTreeNode;
    function GetPrev: TTreeNode;
    function GetPrevChild(Value: TTreeNode): TTreeNode;
    function getPrevSibling: TTreeNode;
    function GetPrevVisible: TTreeNode;
    function HasAsParent(Value: TTreeNode): Boolean;
    function IndexOf(Value: TTreeNode): Integer;
    procedure MakeVisible;
    procedure MoveTo(Destination: TTreeNode; Mode: TNodeAttachMode); virtual;
    property AbsoluteIndex: Integer read GetAbsoluteIndex;
    property Count: Integer read GetCount;
    property Cut: Boolean read GetCut write SetCut;
    property Deleting: Boolean read FDeleting;
    property Focused: Boolean read GetFocused write SetFocused;
    property DropTarget: Boolean read GetDropTarget write SetDropTarget;
    property Selected: Boolean read GetSelected write SetSelected;
    property Expanded: Boolean read GetExpanded write SetExpanded;
    property Handle: HWND read GetHandle;
    property HasChildren: Boolean read GetChildren write SetChildren;
    property Index: Integer read GetIndex;
    property IsVisible: Boolean read IsNodeVisible;
    property Item[Index: Integer]: TTreeNode read GetItem write SetItem; default;
    property ItemId: HTreeItem read FItemId;
    property Level: Integer read GetLevel;
    property OverlayIndex: Integer read FOverlayIndex write SetOverlayIndex;
    property Owner: TTreeNodes read FOwner;
    property SelectedIndex: Integer read FSelectedIndex write SetSelectedIndex;
    property TreeView: TCustomTreeView read GetTreeView;
*/
};

#endif
