unit LogoMain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, Grids, DBGrids, swmodule,
  swkey, swvskey;

type
    TSwordAppForm = class(TForm)
        MainMenu: TMainMenu;
        FileMenu: TMenuItem;
        FileExitItem: TMenuItem;
        Help1: TMenuItem;
        AboutItem: TMenuItem;
        SpeedPanel: TPanel;
        ExitBtn: TSpeedButton;
        StatusBar: TStatusBar;
        TextBox: TRichEdit;
        CommentBox: TRichEdit;
        BookCB: TComboBox;
        CHBox: TEdit;
        VSBox: TEdit;
        Label1: TLabel;
        LookupBtn: TSpeedButton;
        TextKeyText: TLabel;
        LDBox: TRichEdit;
        LDTitle: TLabel;
        Label2: TLabel;
        LDKeyText: TLabel;
        TextTitle: TLabel;
        CommentTitle: TLabel;
    PopupMenu1: TPopupMenu;
    EastonsBibleDictionary1: TMenuItem;
    VinesBibleDictionary1: TMenuItem;
    Webster: TSWModule;
    MHC: TSWModule;
    Eastons: TSWModule;
    Vines: TSWModule;
    CommonKey: TSWVerseKey;
    Button1: TButton;
    Button2: TButton;
    DblClkWordRtClkMouse1: TMenuItem;
    Search1: TMenuItem;
    NewSearchWindow1: TMenuItem;
        procedure FormCreate(Sender: TObject);
        procedure FileExit(Sender: TObject);
        procedure Lookup(Sender: TObject);
        procedure About(Sender: TObject);
        procedure ShowHint(Sender: TObject);
    procedure EastonsBibleDictionary1Click(Sender: TObject);
    procedure TextBoxEnter(Sender: TObject);
    procedure VinesBibleDictionary1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure NewSearchWindow1Click(Sender: TObject);
    private
        curedit: TRichEdit;
  public
    { Public declarations }
  end;

var
  SwordAppForm: TSwordAppForm;

implementation

uses SysUtils, Mapi, About, searchdlg;

{$R *.DFM}
procedure TSwordAppForm.FormCreate(Sender: TObject);
var
	s1: string;
begin
  Application.OnHint := ShowHint;

  CommonKey.Text := 'Genesis 1:1';
  while (CommonKey.Error = 0) do
  begin
    s1 := CommonKey.Text;
    SetLength(s1, (Length(s1) - 4));
    BookCB.Items.Add(s1);
    CommonKey.Book := CommonKey.Book + 1;
  end;
end;


procedure TSwordAppForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TSwordAppForm.Lookup(Sender: TObject);
var
  Buffer: PChar;
  s1: AnsiString;
  hkey: integer;
begin
	if ((StrToInt(CHBox.Text) = 0) or (StrToInt(VSBox.Text) = 0)) then
		CommonKey.AutoNormalize := false;

  CommonKey.Text      := BookCB.Text + ' ' + CHBox.Text + ':' + VSBox.Text;
  TextKeyText.Caption := CommonKey.Text;
  TextBox.Text        := Webster.Text;
  CommentBox.Text     := MHC.Text;

  CommonKey.AutoNormalize := true;
end;

procedure TSwordAppForm.About(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSwordAppForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TSwordAppForm.EastonsBibleDictionary1Click(Sender: TObject);
begin
     Eastons.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Eastons (in fact, it may even not be allocated yet).  We just want to set Eastons with the text and let Eastons worry about allocating keys.}
     LDBox.Text := Eastons.Text;
     LDKeyText.Caption := Eastons.KeyText;
     LDTitle.Caption := Eastons.Description;
end;

procedure TSwordAppForm.TextBoxEnter(Sender: TObject);
begin
     curedit := TRichEdit(Sender);
end;

procedure TSwordAppForm.VinesBibleDictionary1Click(Sender: TObject);
begin
     Vines.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Eastons (in fact, it may even not be allocated yet).  We just want to set Eastons with the text and let Eastons worry about allocating keys.}
     LDBox.Text := Vines.Text;
     LDKeyText.Caption := Vines.KeyText;
     LDTitle.Caption := Vines.Description;
end;

procedure TSwordAppForm.Button1Click(Sender: TObject);
begin
  CommonKey.Dec;
  TextKeyText.Caption := CommonKey.Text;
  TextBox.Text        := Webster.Text;
  CommentBox.Text     := MHC.Text;

end;

procedure TSwordAppForm.Button2Click(Sender: TObject);
begin
  CommonKey.Inc;
  TextKeyText.Caption := CommonKey.Text;
  TextBox.Text        := Webster.Text;
  CommentBox.Text     := MHC.Text;


end;

procedure TSwordAppForm.NewSearchWindow1Click(Sender: TObject);
begin
	SearchForm.Show;
end;

end.

