/******************************************************************************
 *  swmgr.h   - definition of class SWMgr used to interact with an install
 *				base of sword modules.
 *
 * $Id: swmgr.h,v 1.4 1999/01/10 00:50:10 troy Exp $
 *
 * Copyright 1998 CrossWire Bible Society (http://www.crosswire.org)
 *	CrossWire Bible Society
 *	P. O. Box 2528
 *	Tempe, AZ  85280-2528
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation version 2.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 */

#ifndef SWMGR_H
#define SWMGR_H

#include <string>
#include <map>
#include <swmodule.h>
#include <swconfig.h>
#include <swlog.h>

// using namespace std;

typedef map <string, SWModule *, less<string> > ModMap;

class SWMgr {
private:
	SWConfig *myconfig;

	void SWMgr::CreateMods();
	void SWMgr::DeleteMods();
	SWFilter *gbftortf;
	SWFilter *rwptortf;
	char *prefixPath;
	char *configPath;

protected:
	virtual char AddModToConfig(int conffd, const char *fname);
	virtual void findConfig();

public:
	
	SWConfig *config;
	ModMap Modules;

	SWMgr(SWConfig *iconfig = 0, bool autoload = true);
	virtual ~SWMgr();
	void InstallScan(const char *dir);
	void Load();
};
#endif
