unit LogoMain;

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, Grids, DBGrids, swmodule;

type
    TSwordAppForm = class(TForm)
        MainMenu: TMainMenu;
        FileMenu: TMenuItem;
        FileExitItem: TMenuItem;
        Help1: TMenuItem;
        AboutItem: TMenuItem;
        SpeedPanel: TPanel;
        ExitBtn: TSpeedButton;
        StatusBar: TStatusBar;
        TextBox: TRichEdit;
        CommentBox: TRichEdit;
        BookCB: TComboBox;
        CHBox: TEdit;
        VSBox: TEdit;
        Label1: TLabel;
        LookupBtn: TSpeedButton;
        TextKeyText: TLabel;
        LDBox: TRichEdit;
        LDTitle: TLabel;
        Label2: TLabel;
        LDKeyText: TLabel;
        TextTitle: TLabel;
        CommentTitle: TLabel;
    PopupMenu1: TPopupMenu;
    EastonsBibleDictionary1: TMenuItem;
    VinesBibleDictionary1: TMenuItem;
    Webster: TSWModule;
    MHC: TSWModule;
    Eastons: TSWModule;
    Vines: TSWModule;
        procedure FormCreate(Sender: TObject);
        procedure FileExit(Sender: TObject);
        procedure Lookup(Sender: TObject);
        procedure About(Sender: TObject);
        procedure ShowHint(Sender: TObject);
    procedure EastonsBibleDictionary1Click(Sender: TObject);
    procedure TextBoxEnter(Sender: TObject);
    procedure VinesBibleDictionary1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    private
        curedit: TRichEdit;
        commonkey: integer;
        FFileName: String;
  public
    { Public declarations }
  end;

var
  SwordAppForm: TSwordAppForm;

implementation

uses SwordAPI, SysUtils, Mapi, About;

{$R *.DFM}
procedure TSwordAppForm.FormCreate(Sender: TObject);
var
   buf: PChar;
   book: integer;
   s1: AnsiString;
begin
  Application.OnHint := ShowHint;

  commonkey := NewKey('VerseKey');
  GetMem(buf, 255);
  KeySetText(commonkey, 'Genesis 1:1');
  while (KeyError(commonkey) = 0) do
  begin
    KeyGetText(commonkey, buf, 254);
    s1 := strpas(buf);
    SetLength(s1, Length(s1) - 4);
    BookCB.Items.Add(s1);
    book := VerseKeyGetBook(commonkey);
    book := book + 1;
    VerseKeySetBook(commonkey, book);
  end;
  FreeMem(buf, 255);

  KeySetPersist(commonkey, 1);
  ModSetKeyKey(MHC.SWHandle, commonkey);
  ModSetKeyKey(Webster.SWHandle, commonkey);
end;


procedure TSwordAppForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
	DeleteKey(commonkey);
end;


procedure TSwordAppForm.FileExit(Sender: TObject);
begin
  Close;
end;


procedure TSwordAppForm.Lookup(Sender: TObject);
begin
  if ((StrToInt(CHBox.Text) = 0) or (StrToInt(VSBox.Text) = 0)) then
     VerseKeySetAutoNormalize(commonkey, 0);

  Webster.Key.Text    := BookCB.Text + ' ' + CHBox.Text + ':' + VSBox.Text;
  TextKeyText.Caption := Webster.Key.Text;
  TextBox.Text        := Webster.Text;
  CommentBox.Text     := MHC.Text;

  VerseKeySetAutoNormalize(commonkey, 1);
end;

procedure TSwordAppForm.About(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TSwordAppForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TSwordAppForm.EastonsBibleDictionary1Click(Sender: TObject);
begin
     Eastons.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Eastons (in fact, it may even not be allocated yet).  We just want to set Eastons with the text and let Eastons worry about allocating keys.}
     LDBox.Text := Eastons.Text;
     LDKeyText.Caption := Eastons.KeyText;
     LDTitle.Caption := Eastons.Description;
end;

procedure TSwordAppForm.TextBoxEnter(Sender: TObject);
begin
     curedit := TRichEdit(Sender);
end;

procedure TSwordAppForm.VinesBibleDictionary1Click(Sender: TObject);
begin
     Vines.KeyText := Trim(curedit.SelText); { we use .KeyText instead of Key.Text because we don't care about accessing the actual key in Eastons (in fact, it may even not be allocated yet).  We just want to set Eastons with the text and let Eastons worry about allocating keys.}
     LDBox.Text := Vines.Text;
     LDKeyText.Caption := Vines.KeyText;
     LDTitle.Caption := Vines.Description;
end;

end.

