/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  cheatah
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "cheatsig.h"
#include "cheatah.h"
#include <swmgr.h>

MainWindow *cheatahWindow = NULL;
GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *found_widget;

  if (widget->parent)
    widget = gtk_widget_get_toplevel (widget);
  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}



MainWindow::MainWindow() {
	searchType_group = NULL;
	mainMgr = new SWMgr();
	curMod = NULL;
}


MainWindow::~MainWindow() {
	delete mainMgr;
}


GtkWidget* create_mainWindow () {
	GtkWidget *retWidget;
	cheatahWindow = new MainWindow();
	retWidget = cheatahWindow->create();
	cheatahWindow->initSWORD();
	return retWidget;
}

GtkWidget *MainWindow::create() {
  mainWindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "mainWindow", mainWindow);
  gtk_window_set_title (GTK_WINDOW (mainWindow), "Cheatah - SWORD Quick Lookup / Search");
  gtk_window_set_policy (GTK_WINDOW (mainWindow), TRUE, TRUE, FALSE);
  gtk_signal_connect(GTK_OBJECT(mainWindow),
                       "destroy",
                       GTK_SIGNAL_FUNC(gtk_main_quit),
                       NULL);


  mainPanel = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "mainPanel", mainPanel);
  gtk_widget_show (mainPanel);
  gtk_container_add (GTK_CONTAINER (mainWindow), mainPanel);

  headerPanel = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "headerPanel", headerPanel);
  gtk_widget_show (headerPanel);
  gtk_box_pack_start (GTK_BOX (mainPanel), headerPanel, FALSE, TRUE, 0);

  handlebox3 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "handlebox3", handlebox3);
  gtk_widget_show (handlebox3);
  gtk_box_pack_start (GTK_BOX (headerPanel), handlebox3, TRUE, TRUE, 0);

  menubar4 = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "menubar4", menubar4);
  gtk_widget_show (menubar4);
  gtk_container_add (GTK_CONTAINER (handlebox3), menubar4);

  File3 = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "File3", File3);
  gtk_widget_show (File3);
  gtk_container_add (GTK_CONTAINER (menubar4), File3);

  menu13 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "menu13", menu13);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (File3), menu13);

  Exit3 = gtk_menu_item_new_with_label ("Exit");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "Exit3", Exit3);
  gtk_widget_show (Exit3);
  gtk_container_add (GTK_CONTAINER (menu13), Exit3);
  gtk_signal_connect (GTK_OBJECT (Exit3), "activate",
                      GTK_SIGNAL_FUNC (gtk_main_quit),
                      NULL);

  
  View3 = gtk_menu_item_new_with_label ("View");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "View3", View3);
  gtk_widget_show (View3);
  gtk_container_add (GTK_CONTAINER (menubar4), View3);
  gtk_signal_connect (GTK_OBJECT (View3), "activate",
                      GTK_SIGNAL_FUNC (on_View3_activate),
                      NULL);

  menuView = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "menuView", menuView);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (View3), menuView);


  Help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "Help", Help);
  gtk_widget_show (Help);
  gtk_container_add (GTK_CONTAINER (menubar4), Help);
  gtk_signal_connect (GTK_OBJECT (Help), "activate",
                      GTK_SIGNAL_FUNC (on_Help_activate),
                      NULL);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (Help));

  menu14 = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "menu14", menu14);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (Help), menu14);

  About = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "About", About);
  gtk_widget_show (About);
  gtk_container_add (GTK_CONTAINER (menu14), About);
  gtk_signal_connect (GTK_OBJECT (About), "activate",
                      GTK_SIGNAL_FUNC (on_About_activate),
                      NULL);

  handlebox4 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "handlebox4", handlebox4);
  gtk_widget_show (handlebox4);
  gtk_box_pack_start (GTK_BOX (headerPanel), handlebox4, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "hbox6", hbox6);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (handlebox4), hbox6);

  label2 = gtk_label_new ("FreeForm Lookup:");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "label2", label2);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox6), label2, FALSE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label2), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_padding (GTK_MISC (label2), 2, 0);

  lookupText = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "lookupText", lookupText);
  gtk_widget_show (lookupText);
  gtk_box_pack_start (GTK_BOX (hbox6), lookupText, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (lookupText), "changed",
                      GTK_SIGNAL_FUNC (on_lookupText_changed),
                      NULL);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (mainPanel), hbox2, TRUE, TRUE, 0);

  moduleText = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "moduleText", moduleText);
  gtk_widget_show (moduleText);
  gtk_box_pack_start (GTK_BOX (hbox2), moduleText, TRUE, TRUE, 0);
  gtk_text_set_editable (GTK_TEXT (moduleText), FALSE);
  gtk_text_set_word_wrap (GTK_TEXT (moduleText), TRUE);
  gtk_widget_realize (moduleText);

  handlebox5 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "handlebox5", handlebox5);
  gtk_widget_show (handlebox5);
  gtk_box_pack_start (GTK_BOX (hbox2), handlebox5, FALSE, FALSE, 0);
  gtk_container_border_width (GTK_CONTAINER (handlebox5), 5);

  searchPanel = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchPanel", searchPanel);
  gtk_widget_show (searchPanel);
  gtk_container_add (GTK_CONTAINER (handlebox5), searchPanel);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "hbox4", hbox4);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (searchPanel), hbox4, FALSE, FALSE, 0);

  searchText = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchText", searchText);
  gtk_widget_show (searchText);
  gtk_box_pack_start (GTK_BOX (hbox4), searchText, TRUE, TRUE, 0);

  searchButton = gtk_button_new_with_label ("Search");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchButton", searchButton);
  gtk_widget_show (searchButton);
  gtk_box_pack_start (GTK_BOX (hbox4), searchButton, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (searchButton), "clicked",
                      GTK_SIGNAL_FUNC (on_searchButton_clicked),
                      NULL);

  searchSettingsPanel = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchSettingsPanel", searchSettingsPanel);
  gtk_widget_show (searchSettingsPanel);
  gtk_box_pack_start (GTK_BOX (searchPanel), searchSettingsPanel, FALSE, FALSE, 0);

  searchTypePanel = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchTypePanel", searchTypePanel);
  gtk_widget_show (searchTypePanel);
  gtk_box_pack_start (GTK_BOX (searchSettingsPanel), searchTypePanel, FALSE, FALSE, 0);

  regexSearch = gtk_radio_button_new_with_label (searchType_group, "Regular Expression");
  searchType_group = gtk_radio_button_group (GTK_RADIO_BUTTON (regexSearch));
  gtk_object_set_data (GTK_OBJECT (mainWindow), "regexSearch", regexSearch);
  gtk_widget_show (regexSearch);
  gtk_box_pack_start (GTK_BOX (searchTypePanel), regexSearch, FALSE, FALSE, 0);

  phaseSearch = gtk_radio_button_new_with_label (searchType_group, "Exact Phrase");
  searchType_group = gtk_radio_button_group (GTK_RADIO_BUTTON (phaseSearch));
  gtk_object_set_data (GTK_OBJECT (mainWindow), "phaseSearch", phaseSearch);
  gtk_widget_show (phaseSearch);
  gtk_box_pack_start (GTK_BOX (searchTypePanel), phaseSearch, FALSE, FALSE, 0);

  multiWordSearch = gtk_radio_button_new_with_label (searchType_group, "Multi Word");
  searchType_group = gtk_radio_button_group (GTK_RADIO_BUTTON (multiWordSearch));
  gtk_object_set_data (GTK_OBJECT (mainWindow), "multiWordSearch", multiWordSearch);
  gtk_widget_show (multiWordSearch);
  gtk_box_pack_start (GTK_BOX (searchTypePanel), multiWordSearch, FALSE, FALSE, 0);

  searchOptionsPanel = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (mainWindow), "searchOptionsPanel", searchOptionsPanel);
  gtk_widget_show (searchOptionsPanel);
  gtk_box_pack_start (GTK_BOX (searchSettingsPanel), searchOptionsPanel, FALSE, FALSE, 0);

  caseSensitive = gtk_check_button_new_with_label ("Case Sensitive");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "caseSensitive", caseSensitive);
  gtk_widget_show (caseSensitive);
  gtk_box_pack_start (GTK_BOX (searchOptionsPanel), caseSensitive, FALSE, FALSE, 0);

  resultList = gtk_list_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "resultList", resultList);
  gtk_widget_show (resultList);
  gtk_box_pack_start (GTK_BOX (searchPanel), resultList, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (resultList), "selection_changed",
                      GTK_SIGNAL_FUNC (on_resultList_selection_changed),
                      NULL);

/*
  statusbar1 = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (mainWindow), "statusbar1", statusbar1);
  gtk_widget_show (statusbar1);
  gtk_box_pack_start (GTK_BOX (mainPanel), statusbar1, FALSE, TRUE, 0);
*/

  statusbar1 = gtk_label_new ("");
  gtk_object_set_data (GTK_OBJECT (mainWindow), "statusbar1", statusbar1);
  gtk_widget_show (statusbar1);
  gtk_box_pack_start (GTK_BOX (mainPanel), statusbar1, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (statusbar1), GTK_JUSTIFY_LEFT);
  gtk_misc_set_padding (GTK_MISC (statusbar1), 2, 0);

  return mainWindow;
}

void MainWindow::initSWORD() {

	GtkWidget *menuChoice;
	int viewNumber = 1;
	char menuName[64];
	ModMap::iterator it;
	SectionMap::iterator sit;
	ConfigEntMap::iterator eit;
	char *font;
	SWModule *curMod;

	for (it = mainMgr->Modules.begin(); it != mainMgr->Modules.end(); it++) {
		if (!strcmp((*it).second->Type(), "Biblical Texts")) {
			font = 0;
			if ((sit = mainMgr->config->Sections.find((*it).second->Name())) != mainMgr->config->Sections.end()) {
				if ((eit = (*sit).second.find("Font")) != (*sit).second.end()) {
					font = (char *)(*eit).second.c_str();
				}
			}
//			CreateTextPane((*it).second, font);
			curMod = (*it).second;

			if (!this->curMod) 	// set currently selected module for app to first module from SWMgr
				this->curMod = curMod;

			menuChoice = gtk_menu_item_new_with_label (curMod->Name());
			sprintf(menuName, "viewMod%d", viewNumber++);
			gtk_object_set_data (GTK_OBJECT (mainWindow), menuName, menuChoice);
			gtk_widget_show (menuChoice);
			gtk_container_add (GTK_CONTAINER (menuView), menuChoice);
			gtk_signal_connect(GTK_OBJECT (menuChoice), "activate",
				      GTK_SIGNAL_FUNC (on_viewMod_activate),
				      g_strdup(curMod->Name()));

		}
//		if (!strcmp((*it).second->Type(), "Commentaries"))
//			CreateCommentPane((*it).second);
//		if (!strcmp((*it).second->Type(), "Lexicons / Dictionaries"))
//			CreateLDPane((*it).second);
	}
}


void MainWindow::lookupTextChanged() {
	string keyText;
	gchar *entryText;

	entryText = gtk_entry_get_text(GTK_ENTRY(lookupText));
	keyText = entryText;

	if (curMod) {
		gtk_text_backward_delete (GTK_TEXT (moduleText), gtk_text_get_length((GTK_TEXT(moduleText))));
		curMod->SetKey(keyText.c_str());
			int textLen = strlen((const char *)*curMod);
			gtk_text_insert (GTK_TEXT (moduleText), NULL, NULL, NULL, (const char *)*curMod, textLen);
		char statusBuf[255];
		sprintf(statusBuf, "%s (%s)", curMod->KeyText(), curMod->Name());
		gtk_label_set(GTK_LABEL(statusbar1), statusBuf);
	}
}

void MainWindow::viewModActivate(GtkMenuItem *sender, gchar *modName) {
	ModMap::iterator it;

	it = mainMgr->Modules.find(modName);
	if (it != mainMgr->Modules.end())
		curMod = (*it).second;
	else	curMod = 0;
}


void MainWindow::searchButtonClicked() {
	string srchText;
	gchar *entryText;
	SWListKey searchResults;
	GList *fillList = NULL;


        fillList=GTK_LIST(resultList)->children;
        if (fillList) {
		gtk_list_clear_items(GTK_LIST(resultList), 0, g_list_length(fillList));
	}
	entryText = gtk_entry_get_text(GTK_ENTRY(searchText));
	srchText = entryText;

	if (curMod) {
		GtkWidget *listItem;
		for (searchResults = curMod->Search(srchText.c_str()); !searchResults.Error(); searchResults++) {
			listItem = gtk_list_item_new_with_label((const char *)searchResults);
			fillList = g_list_append(fillList, listItem);
			gtk_widget_show(listItem);
			gtk_object_set_data(GTK_OBJECT(listItem), "Verse", g_strdup((const char *)searchResults));

		}
		gtk_list_append_items(GTK_LIST(resultList), fillList);
	}
}


void MainWindow::resultListSelectionChanged() {
	GList *selItem;

	selItem = GTK_LIST(resultList)->selection;
	if (selItem) {
		GtkObject *listItem=GTK_OBJECT(selItem->data);
		char *verseStr = (char *)gtk_object_get_data(listItem, "Verse");
		gtk_entry_set_text(GTK_ENTRY(lookupText), verseStr);
	}
}
