/*  Project sword

    GNU Copyleft GPL  1995. Almost No Rights Reserved.

    SUBSYSTEM:    sword.apx Application
    FILE:         serchdlg.cpp
    AUTHOR:       The Sword Project Team


    OVERVIEW
    ========
    Source file for implementation of SearchDlg (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "serchdlg.h"
#include <swdisp.h>
#include <versekey.h>
#include <swmodule.h>
#include <swlstkey.h>

extern SWDisp   *edit1disp;
extern SWDisp   *edit2disp;
extern SWDisp   *edit3disp;
extern VerseKey *masterkey;
extern SWModule *webster;
extern SWModule *mhc;
extern SWModule *eastons;
extern SWModule *vines;

SWListKey searchlist;

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(SearchDlg, TDialog)
//{{SearchDlgRSP_TBL_BEGIN}}
    EV_BN_CLICKED(IDC_FIND, FindClicked),
    EV_LBN_DBLCLK(IDC_LISTBOX1, searchlbox_Dblclk),
//{{SearchDlgRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{SearchDlg Implementation}}


static SearchDlgXfer SearchDlgData;

SearchDlg::SearchDlg (TWindow* parent, TResId resId, TModule* module):
    TDialog(parent, resId, module)
{
//{{SearchDlgXFER_USE}}
    searchlbox = new TListBox(this, IDC_LISTBOX1);

    SetTransferBuffer(&SearchDlgData);
//{{SearchDlgXFER_USE_END}}

    // INSERT>> Your constructor code here.

}


SearchDlg::~SearchDlg ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}


void SearchDlg::FindClicked ()
{
	char buf[80];
	int loop;

	SetCaption("Search for Text (Searching...)");
	GetDlgItemText(IDC_FINDTEXT, buf, 79);
	searchlbox->ClearList();
	if (*buf) {
		for (searchlist = webster->Search(buf); !searchlist.Error(); searchlist++)
			searchlbox->AddString((char *)searchlist);
	}
	SetCaption("Search for Text");
}


void SearchDlg::searchlbox_Dblclk ()
{
	char buf[80];

	searchlbox->GetString(buf, searchlbox->GetCaretIndex());

	masterkey->AutoNormalize(0);
	*masterkey = buf;

	webster->Display();
	mhc->Display();
	masterkey->AutoNormalize(0);
}

