//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "swdisprtf.h"
//---------------------------------------------------------------------------
static inline SWDispRTF *ValidCtrCheck()
{
	return new SWDispRTF(NULL);
}
//---------------------------------------------------------------------------
__fastcall SWDispRTF::SWDispRTF(TComponent* Owner)
	: TRichEdit(Owner)
{

	RTFHeader = defRTFHeader;
	RTFTrailer = defRTFTrailer;

	RTFChapterMarkPre = defRTFChapterMarkPre;
	RTFChapterMarkPost = defRTFChapterMarkPost;

	RTFVerseMarkPre = defRTFVerseMarkPre;
	RTFVerseMarkPost = defRTFVerseMarkPost;

	RTFVersePre = defRTFVersePre;
	RTFVersePost = defRTFVersePost;
	RTFStream = new TMemoryStream();
	 
}

__fastcall SWDispRTF::~SWDispRTF()
{
	if (RTFStream)
		delete RTFStream;
}


void __fastcall SWDispRTF::Loaded(void)
{
	TRichEdit::Loaded();
	
	if (RTFHeader == "")
		RTFHeader = defRTFHeader;
	if (RTFTrailer == "")
		RTFTrailer = defRTFTrailer;

	if (RTFChapterMarkPre == "")
		RTFChapterMarkPre = defRTFChapterMarkPre;
	if (RTFChapterMarkPost == "")
		RTFChapterMarkPost = defRTFChapterMarkPost;

	if (RTFVerseMarkPre == "")
		RTFVerseMarkPre = defRTFVerseMarkPre;
	if (RTFVerseMarkPost == "")
		RTFVerseMarkPost = defRTFVerseMarkPost;

	if (RTFVersePre == "")
		RTFVersePre = defRTFVersePre;
	if (RTFVersePost == "")
		RTFVersePost = defRTFVersePost;
}


int __fastcall SWDispRTF::GetMySelStart()
{
	CHARRANGE cr;
	
	SendMessage(Handle, EM_EXGETSEL, 0, (long)&cr);
	return cr.cpMin;
}


void __fastcall SWDispRTF::SetMySelStart(int iselstart)
{
	CHARRANGE cr;
	
	cr.cpMin = iselstart;
	cr.cpMax = iselstart;
	SendMessage(Handle, EM_EXSETSEL, 0, (long)&cr);
}


char SWDispRTF::Display(SWModule &Module)
{
	System::AnsiString newtext, tmptext;
//	VerseKey *key = (VerseKey *)(SWKey *)Module;
	
//	chap  = key->Chapter();
//	book  = key->Book();
//	verse = key->Verse();
//	key->Verse(1);
	newtext = RTFHeader;
//	newtext = newtext + RTFChapterMarkPre + IntToStr(chap) + RTFChapterMarkPost;
	Module.Error(); // clear error;
//	currentpos = 0;
//	while ((key->Book() == book) && (key->Chapter() == chap) && (Module.Error() == 0)) {
		newtext = newtext + "\\pard \\nowidctlpar \\cf0 ";
		(char *)Module;	// force key to snap to entry before pulling out the text of the key
		newtext = newtext + RTFVerseMarkPre + Module.KeyText() + RTFVerseMarkPost;
		tmptext = "";
		for (char *loop = (char *)Module; *loop; loop++) {
			if (*loop == '\n')
				tmptext += "\\par ";
			else	tmptext += *loop;
		}
		
		newtext = newtext + RTFVersePre + " " + tmptext + RTFVersePost;
//		Module++;
//	}
	newtext = newtext + RTFTrailer;
//	key->Verse(1); //{ When setting chapter: if (verse <> new chapter range) don't autonormalize. (we could've just turned the autonormalize option off then back on, but this is cooler) }
//	key->Book(book);
//	key->Chapter(chap);
//	key->Verse(verse);
	RTFStream->Clear();
	RTFStream->WriteBuffer(newtext.c_str(), newtext.Length());
	RTFStream->Position = 0;
	Lines->LoadFromStream(RTFStream);
	return 0;
}

/*
void SWDispRTF::SetModule(SWText *imodule)
{
	FModule = imodule;
}


SWText *SWDispRTF::GetModule()
{
	return FModule;
}
*/

//---------------------------------------------------------------------------
namespace Swdisprtf
{
	void __fastcall Register()
	{
		TComponentClass classes[1] = {__classid(SWDispRTF)};
		RegisterComponents("SWORD", classes, 0);
	}
}
//---------------------------------------------------------------------------
 