/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;

public class EnglishLuceneAnalyzer
extends AbstractBookAnalyzer {
    public EnglishLuceneAnalyzer() {
        this.stopSet = StopFilter.makeStopSet((String[])StopAnalyzer.ENGLISH_STOP_WORDS);
        this.setNaturalLanguage("English");
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseTokenizer result = new LowerCaseTokenizer(reader);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter((TokenStream)result, this.stopSet);
        }
        if (this.doStemming) {
            result = new PorterStemFilter((TokenStream)result);
        }
        return result;
    }
}

