/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.OSType;

public final class Project {
    public static final String DIR_NETCACHE = "netcache";
    public static final String DIR_PROJECT = ".jsword";
    public static final String DIR_PROJECT_ALT = "JSword";
    private static final String PROPERTY_JSWORD_HOME = "jsword.home";
    private URI home;
    private static final Logger log = Logger.getLogger((Class)Project.class);
    private static Project instance = new Project();

    public static Project instance() {
        return instance;
    }

    private Project() {
        CWClassLoader.setHome((URI)this.getUserProjectDir());
        try {
            URI uricache = this.getTempScratchSpace(DIR_NETCACHE, true);
            File filecache = new File(uricache.getPath());
            NetUtil.setURICacheDir((File)filecache);
        }
        catch (IOException ex) {
            log.warn("Failed to get directory for NetUtil.setURICacheDir()", (Throwable)ex);
        }
    }

    public URI getUserProjectDir(String hiddenFolderName, String visibleFolderName) {
        return OSType.getOSType().getUserAreaFolder(hiddenFolderName, visibleFolderName);
    }

    public URI getUserProjectDir() {
        String jswordhome;
        if (this.home == null && (jswordhome = System.getProperty(PROPERTY_JSWORD_HOME)) != null) {
            try {
                this.home = new URI("file", null, jswordhome, null);
                if (!NetUtil.canWrite((URI)this.home)) {
                    this.home = null;
                }
            }
            catch (URISyntaxException e) {
                this.home = null;
            }
        }
        if (this.home == null) {
            URI path = this.getUserProjectDir(DIR_PROJECT, DIR_PROJECT_ALT);
            URI oldPath = this.getDeprecatedUserProjectDir();
            this.home = this.migrateUserProjectDir(oldPath, path);
        }
        return this.home;
    }

    public URI getDeprecatedUserProjectDir() {
        return OSType.DEFAULT.getUserAreaFolder(DIR_PROJECT, DIR_PROJECT_ALT);
    }

    private URI migrateUserProjectDir(URI oldPath, URI newPath) {
        if (oldPath.toString().equals(newPath.toString())) {
            return newPath;
        }
        if (NetUtil.isDirectory((URI)oldPath)) {
            File oldDir = new File(oldPath.getPath());
            File newDir = new File(newPath.getPath());
            oldDir.renameTo(newDir);
            if (NetUtil.isDirectory((URI)newPath)) {
                return newPath;
            }
            return oldPath;
        }
        return newPath;
    }

    public URI getWritablePropertiesURI(String subject) {
        return NetUtil.lengthenURI((URI)this.getUserProjectDir(), (String)(subject + ".properties"));
    }

    public URI getTempScratchSpace(String subject, boolean create) throws IOException {
        URI temp = NetUtil.lengthenURI((URI)this.getUserProjectDir(), (String)subject);
        if (create && !NetUtil.isDirectory((URI)temp)) {
            NetUtil.makeDirectory((URI)temp);
        }
        return temp;
    }
}

