/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.Serializable;

public final class BookCategory
implements Serializable,
Comparable {
    public static final BookCategory BIBLE = new BookCategory("Bible");
    public static final BookCategory DICTIONARY = new BookCategory("Dictionary");
    public static final BookCategory COMMENTARY = new BookCategory("Commentary");
    public static final BookCategory DAILY_DEVOTIONS = new BookCategory("Daily Devotional");
    public static final BookCategory GLOSSARY = new BookCategory("Glossaries");
    public static final BookCategory QUESTIONABLE = new BookCategory("Cults / Unorthodox / Questionable Material");
    public static final BookCategory GENERAL_BOOK = new BookCategory("General Books");
    public static final BookCategory OTHER = new BookCategory("Other");
    private String name;
    private static int nextObj;
    private final int obj = nextObj++;
    private static final BookCategory[] VALUES;
    private static final long serialVersionUID = 3256727260177708345L;

    private BookCategory(String name) {
        this.name = name;
    }

    public static BookCategory fromString(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            BookCategory o = VALUES[i];
            if (!o.name.equalsIgnoreCase(name)) continue;
            return o;
        }
        return OTHER;
    }

    public static BookCategory fromInteger(int i) {
        return VALUES[i];
    }

    public int compareTo(Object o) {
        BookCategory that = (BookCategory)o;
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    Object readResolve() {
        return VALUES[this.obj];
    }

    static {
        VALUES = new BookCategory[]{BIBLE, DICTIONARY, COMMENTARY, DAILY_DEVOTIONS, GLOSSARY, QUESTIONABLE, GENERAL_BOOK, OTHER};
    }
}

