/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.event.EventListenerList;
import org.crosswire.bibledesktop.book.BibleComboBoxModel;
import org.crosswire.bibledesktop.book.BibleNameCellRenderer;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.versification.BibleInfo;
import org.crosswire.jsword.versification.BookName;

public class BibleComboBoxModelSet {
    private Verse verse = Verse.DEFAULT;
    protected JComboBox cboBook;
    protected JComboBox cboChapter;
    private JComboBox cboVerse;
    protected BibleComboBoxModel mdlBook;
    protected BibleComboBoxModel mdlChapter;
    protected BibleComboBoxModel mdlVerse;
    protected EventListenerList listeners = new EventListenerList();
    private ItemListener cil = new CustomItemListener();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BibleComboBoxModelSet(JComboBox books, JComboBox chapters, JComboBox verses) {
        this.mdlBook = new BibleComboBoxModel(this, 0);
        this.setBookComboBox(books);
        this.mdlChapter = new BibleComboBoxModel(this, 1);
        this.setChapterComboBox(chapters);
        if (verses != null) {
            this.mdlVerse = new BibleComboBoxModel(this, 2);
            this.setVerseComboBox(verses);
        }
    }

    public final void setBookComboBox(JComboBox cboBook) {
        block2: {
            this.cboBook = cboBook;
            cboBook.setModel(this.mdlBook);
            cboBook.addItemListener(this.cil);
            cboBook.setRenderer(new BibleNameCellRenderer(true));
            try {
                cboBook.setToolTipText(BibleInfo.getLongBookName((int)this.verse.getBook()));
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public final void setChapterComboBox(JComboBox cboChapter) {
        this.cboChapter = cboChapter;
        cboChapter.setModel(this.mdlChapter);
        cboChapter.setPrototypeDisplayValue(new Integer(999));
        cboChapter.addItemListener(this.cil);
    }

    public final void setVerseComboBox(JComboBox cboVerse) {
        this.cboVerse = cboVerse;
        cboVerse.setModel(this.mdlVerse);
        cboVerse.setPrototypeDisplayValue(new Integer(999));
        cboVerse.addItemListener(this.cil);
    }

    public Verse getVerse() {
        return this.verse;
    }

    public void setVerse(Verse newverse) {
        block7: {
            if (this.verse.equals((Object)newverse)) {
                return;
            }
            try {
                Verse oldverse = this.verse;
                this.verse = newverse;
                int bookval = newverse.getBook();
                BookName bookName = BibleInfo.getBookName((int)bookval);
                if (oldverse.getBook() != bookval || !this.cboBook.getSelectedItem().equals(bookName)) {
                    this.cboBook.setSelectedItem(bookName);
                    this.cboBook.setToolTipText(bookName.getLongName());
                }
                int chapterval = newverse.getChapter();
                Integer chapternum = new Integer(chapterval);
                if (oldverse.getChapter() != chapterval || !this.cboChapter.getSelectedItem().equals(chapternum)) {
                    this.cboChapter.setSelectedItem(chapternum);
                }
                if (this.cboVerse != null) {
                    int verseval = newverse.getVerse();
                    Integer versenum = new Integer(verseval);
                    if (oldverse.getVerse() != verseval || !this.cboVerse.getSelectedItem().equals(versenum)) {
                        this.cboVerse.setSelectedItem(versenum);
                    }
                }
                this.fireContentsChanged();
            }
            catch (NoSuchVerseException ex) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)ex);
            }
        }
    }

    public void addActionListener(ActionListener li) {
        this.listeners.add(ActionListener.class, li);
    }

    public void removeActionListener(ActionListener li) {
        this.listeners.remove(ActionListener.class, li);
    }

    protected void fireContentsChanged() {
        Object[] liarray = this.listeners.getListenerList();
        ActionEvent ev = null;
        for (int i = liarray.length - 2; i >= 0; i -= 2) {
            if (liarray[i] != (class$java$awt$event$ActionListener == null ? BibleComboBoxModelSet.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            if (ev == null) {
                ev = new ActionEvent(this, 1001, this.verse.getName());
            }
            ((ActionListener)liarray[i + 1]).actionPerformed(ev);
        }
    }

    static {
        $assertionsDisabled = !BibleComboBoxModelSet.class.desiredAssertionStatus();
    }

    final class CustomItemListener
    implements ItemListener {
        CustomItemListener() {
        }

        public void itemStateChanged(ItemEvent ev) {
            if (ev.getStateChange() == 1) {
                Object source = ev.getSource();
                if (source.equals(BibleComboBoxModelSet.this.cboBook)) {
                    BibleComboBoxModelSet.this.mdlChapter.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlChapter.getSize());
                }
                if (BibleComboBoxModelSet.this.mdlVerse != null && (source.equals(BibleComboBoxModelSet.this.cboBook) || source.equals(BibleComboBoxModelSet.this.cboChapter))) {
                    BibleComboBoxModelSet.this.mdlVerse.fireContentsChanged(this, 0, BibleComboBoxModelSet.this.mdlVerse.getSize());
                }
            }
        }
    }
}

