/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.crosswire.common.xml.FormatType;
import org.crosswire.common.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class PrettySerializingContentHandler
implements ContentHandler {
    private static char[] indentation = new char[]{'\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t', '\t'};
    private int depth;
    private boolean lookingForChars;
    private boolean pendingEndTag;
    private FormatType formatting;
    private Writer writer;

    public PrettySerializingContentHandler() {
        this(FormatType.AS_IS);
    }

    public PrettySerializingContentHandler(FormatType theFormat) {
        this(theFormat, null);
    }

    public PrettySerializingContentHandler(FormatType theFormat, Writer theWriter) {
        this.formatting = theFormat;
        this.writer = theWriter == null ? new StringWriter() : theWriter;
    }

    public String toString() {
        return this.writer.toString();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startElement(String uri, String localname, String qname, Attributes attrs) {
        if (this.depth > 0) {
            this.handlePending();
        }
        this.write(this.getTagStart());
        this.write(this.decorateTagName(localname));
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.write(' ');
            this.write(this.decorateAttributeName(attrs.getLocalName(i)));
            this.write("='");
            this.write(this.decorateAttributeValue(XMLUtil.escape(attrs.getValue(i))));
            this.write('\'');
        }
        this.pendingEndTag = true;
        ++this.depth;
    }

    public void endElement(String uri, String localname, String qname) {
        --this.depth;
        if (this.pendingEndTag) {
            if (this.formatting.isAnalytic() && this.depth > 0) {
                this.emitWhitespace(this.depth - 1);
            }
            this.write(this.getTagEnd());
        }
        if (this.formatting.isClassic()) {
            this.emitWhitespace(this.depth);
        }
        this.write(this.getEndTagStart());
        this.write(this.decorateTagName(localname));
        if (this.formatting.isAnalytic()) {
            this.emitWhitespace(this.depth);
        }
        this.write(this.getTagEnd());
        this.pendingEndTag = false;
        this.lookingForChars = false;
    }

    public void characters(char[] chars, int start, int length) {
        if (!this.lookingForChars) {
            this.handlePending();
        }
        String s = new String(chars, start, length);
        this.write(this.decorateCharacters(s));
        this.lookingForChars = true;
    }

    public void ignorableWhitespace(char[] chars, int start, int length) {
        this.characters(chars, start, length);
    }

    public void processingInstruction(String target, String data) {
        this.handlePending();
        this.write(this.getPIStart());
        this.write(target);
        this.write(' ');
        this.write(this.decorateCharacters(data));
        this.write(this.getPIEnd());
        if (this.formatting.isMultiline()) {
            this.write(this.getNewline());
        }
    }

    public void skippedEntity(String name) {
    }

    protected String getTagStart() {
        return "<";
    }

    protected String getTagEnd() {
        return ">";
    }

    protected String getEmptyTagEnd() {
        return "/>";
    }

    protected String getEndTagStart() {
        return "</";
    }

    protected String getPIStart() {
        return "<!";
    }

    protected String getPIEnd() {
        return "!>";
    }

    protected String getNewline() {
        return "\n";
    }

    protected String decorateTagName(String tagName) {
        return tagName;
    }

    protected String decorateAttributeName(String attrName) {
        return attrName;
    }

    protected String decorateAttributeValue(String attrValue) {
        return attrValue;
    }

    protected String decorateCharacters(String characters) {
        return characters;
    }

    protected String decorateIndent(int indentLevel) {
        return new String(indentation, 0, indentLevel).intern();
    }

    protected void write(String obj) {
        try {
            this.writer.write(obj);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    protected void write(char obj) {
        try {
            this.writer.write(obj);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void handlePending() {
        if (this.pendingEndTag) {
            this.pendingEndTag = false;
            if (this.formatting.isAnalytic()) {
                this.emitWhitespace(this.depth);
            }
            this.write(this.getTagEnd());
        }
        if (this.formatting.isClassic()) {
            this.emitWhitespace(this.depth);
        }
        this.lookingForChars = false;
    }

    private void emitWhitespace(int indentLevel) {
        this.write(this.getNewline());
        if (this.formatting.isIndented()) {
            this.write(this.decorateIndent(indentLevel));
        }
    }
}

