/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.StringUtil;

public class Languages {
    public static final String DEFAULT_LANG_CODE = "en";
    private static final String UNKNOWN_LANG_CODE = "und";
    private static ResourceBundle languages;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Languages() {
    }

    public static boolean isValidLanguage(String iso639Code) {
        String lookup = iso639Code;
        if (lookup == null || lookup.length() == 0) {
            return true;
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Languages.isValidLanguage(locale[0]);
        }
        if (lookup.startsWith("x-") || lookup.startsWith("X-") || lookup.length() > 3) {
            return false;
        }
        try {
            languages.getString(lookup);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static String getLanguage(String iso639Code) {
        String lookup = iso639Code;
        if (lookup == null || lookup.length() == 0) {
            return Languages.getLanguage(DEFAULT_LANG_CODE);
        }
        if (lookup.indexOf(95) != -1) {
            String[] locale = StringUtil.split(lookup, '_');
            return Languages.getLanguage(locale[0]);
        }
        if (lookup.startsWith("x-") || lookup.startsWith("X-") || lookup.length() > 3) {
            return Languages.getLanguage(UNKNOWN_LANG_CODE);
        }
        try {
            return languages.getString(lookup);
        }
        catch (MissingResourceException e) {
            return Languages.getLanguage(UNKNOWN_LANG_CODE);
        }
    }

    static {
        block2: {
            $assertionsDisabled = !Languages.class.desiredAssertionStatus();
            try {
                languages = ResourceBundle.getBundle("iso639", Locale.getDefault(), CWClassLoader.instance());
            }
            catch (MissingResourceException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

