/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.Msg;
import org.crosswire.common.swing.desktop.Titleable;
import org.crosswire.common.swing.desktop.ViewVisitor;
import org.crosswire.common.swing.desktop.Viewable;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;
import org.crosswire.common.util.Iterable;

public abstract class AbstractViewLayout
implements Viewable,
Iterable {
    private List views;
    private EventListenerList listenerList = new EventListenerList();
    private static final int MAX_TITLE_LEN = 30;
    private static int base = 1;
    private JPanel panel = new JPanel(new BorderLayout());

    protected AbstractViewLayout() {
        GuiUtil.applyDefaultOrientation(this.panel);
        this.views = new ArrayList();
        this.listenerList = new EventListenerList();
    }

    public void addView(Component component) {
        this.views.add(component);
    }

    public void removeView(Component component) {
        this.views.remove(component);
        this.fireViewRemoved(new ViewEvent(component));
    }

    protected void forceRemoveView(Component component) {
        this.views.remove(component);
    }

    public Collection getViews() {
        return new ArrayList(this.views);
    }

    public Iterator iterator() {
        return this.getViews().iterator();
    }

    public void moveTo(AbstractViewLayout other) {
        if (this.getClass() == other.getClass()) {
            return;
        }
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Component view = (Component)it.next();
            this.forceRemoveView(view);
            other.addView(view);
        }
    }

    public void closeAll() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Component view = (Component)it.next();
            this.removeView(view);
        }
    }

    public void closeOthers(Component component) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Component view = (Component)it.next();
            if (view == component) continue;
            this.removeView(view);
        }
    }

    public void visit(ViewVisitor visitor) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Component view = (Component)it.next();
            visitor.visitView(view);
        }
    }

    public abstract void updateTitle(Component var1);

    public abstract Component getSelected();

    public abstract void select(Component var1);

    public int getViewCount() {
        return this.views.size();
    }

    public Component getView(int i) {
        return (Component)this.views.get(i);
    }

    protected String getTitle(Component component) {
        if (component instanceof Titleable) {
            Titleable view = (Titleable)((Object)component);
            String title = view.getTitle();
            if (title != null && title.length() > 0) {
                if (title.length() <= 30) {
                    return title;
                }
                return title.substring(0, 27) + "...";
            }
            return this.generateTitle();
        }
        return this.generateTitle();
    }

    private String generateTitle() {
        return Msg.UNTITLED.toString(new Integer(base++));
    }

    protected JPanel getPanel() {
        return this.panel;
    }

    protected Object getConstraint() {
        return null;
    }

    public synchronized void addViewEventListener(ViewEventListener listener) {
        this.listenerList.add(ViewEventListener.class, listener);
    }

    public synchronized void removeViewEventListener(ViewEventListener listener) {
        this.listenerList.remove(ViewEventListener.class, listener);
    }

    public void fireViewRemoved(ViewEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$common$swing$desktop$event$ViewEventListener == null ? AbstractViewLayout.class$("org.crosswire.common.swing.desktop.event.ViewEventListener") : class$org$crosswire$common$swing$desktop$event$ViewEventListener)) continue;
            ((ViewEventListener)listeners[i + 1]).viewRemoved(e);
        }
    }
}

