/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.install;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.EventListenerList;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerEvent;
import org.crosswire.jsword.book.install.InstallerFactory;
import org.crosswire.jsword.book.install.InstallerListener;
import org.crosswire.jsword.util.Project;

public final class InstallManager {
    private static final String PREFIX = "Installer.";
    private Map factories;
    private static final Logger log;
    private Map installers = new LinkedHashMap();
    private static EventListenerList listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InstallManager() {
        try {
            Properties sitemap = ResourceUtil.getProperties(this.getClass());
            this.factories = ClassUtil.getImplementorsMap((Class)InstallerFactory.class);
            int i = 0;
            String def = sitemap.getProperty(PREFIX + ++i);
            while (def != null) {
                try {
                    String[] parts = def.split(",", 3);
                    String type = parts[0];
                    String name = parts[1];
                    String rest = parts[2];
                    Class clazz = (Class)this.factories.get(type);
                    if (clazz == null) {
                        log.warn("");
                    } else {
                        InstallerFactory ifactory = (InstallerFactory)clazz.newInstance();
                        Installer installer = ifactory.createInstaller(rest);
                        this.internalAdd(name, installer);
                    }
                }
                catch (InstantiationException e) {
                    Reporter.informUser((Object)this, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Reporter.informUser((Object)this, (Throwable)e);
                }
                def = sitemap.getProperty(PREFIX + ++i);
            }
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this, (Throwable)ex);
        }
    }

    public void save() {
        Properties props = new Properties();
        StringBuffer buf = new StringBuffer();
        int i = 1;
        Iterator it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Installer installer = (Installer)this.installers.get(name);
            buf.delete(0, buf.length());
            buf.append(installer.getType());
            buf.append(',');
            buf.append(name);
            buf.append(',');
            buf.append(installer.getInstallerDefinition());
            props.setProperty(PREFIX + i++, buf.toString());
        }
        URI outputURI = Project.instance().getWritablePropertiesURI(this.getClass().getName());
        try {
            NetUtil.storeProperties((Properties)props, (URI)outputURI, (String)"Saved Installer Sites");
        }
        catch (IOException e) {
            log.error("Failed to save installers", (Throwable)e);
        }
    }

    public Set getInstallerFactoryNames() {
        return Collections.unmodifiableSet(this.factories.keySet());
    }

    public String getFactoryNameForInstaller(Installer installer) {
        Class<?> match = installer.getClass();
        Iterator it = this.factories.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            Class factclazz = (Class)this.factories.get(name);
            try {
                InstallerFactory ifactory = (InstallerFactory)factclazz.newInstance();
                Class<?> clazz = ifactory.createInstaller().getClass();
                if (clazz != match) continue;
                return name;
            }
            catch (InstantiationException e) {
                log.warn("Failed to instantiate installer factory: " + name + "=" + factclazz.getName(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.warn("Failed to instantiate installer factory: " + name + "=" + factclazz.getName(), (Throwable)e);
            }
        }
        log.warn("Failed to find factory name for " + installer.toString() + " among the " + this.factories.size() + " factories.");
        return null;
    }

    public String getInstallerNameForInstaller(Installer installer) {
        Installer test;
        String name;
        Iterator it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            test = (Installer)this.installers.get(name);
            if (!installer.equals(test)) continue;
            return name;
        }
        log.warn("Failed to find installer name for " + installer.toString() + " among the " + this.installers.size() + " installers.");
        it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            name = (String)it.next();
            test = (Installer)this.installers.get(name);
            log.warn("  it isn't equal to " + test.getInstallerDefinition());
        }
        return null;
    }

    public InstallerFactory getInstallerFactory(String name) {
        block4: {
            Class clazz = (Class)this.factories.get(name);
            try {
                return (InstallerFactory)clazz.newInstance();
            }
            catch (InstantiationException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)e);
                }
            }
            catch (IllegalAccessException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    public Map getInstallers() {
        return Collections.unmodifiableMap(this.installers);
    }

    public Installer getInstaller(String name) {
        return (Installer)this.installers.get(name);
    }

    public void addInstaller(String name, Installer installer) {
        if (!$assertionsDisabled && installer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.removeInstaller(name);
        this.internalAdd(name, installer);
        this.fireInstallersChanged(this, installer, true);
    }

    private void internalAdd(String name, Installer installer) {
        Iterator it = this.installers.keySet().iterator();
        while (it.hasNext()) {
            String tname = (String)it.next();
            Installer tinstaller = (Installer)this.installers.get(tname);
            if (!tinstaller.equals(installer)) continue;
            log.warn("duplicate installers: " + name + "=" + tname + ". removing " + tname);
            it.remove();
            this.fireInstallersChanged(this, tinstaller, false);
        }
        this.installers.put(name, installer);
    }

    public void removeInstaller(String name) {
        if (this.installers.containsKey(name)) {
            Installer old = (Installer)this.installers.remove(name);
            this.fireInstallersChanged(this, old, false);
        }
    }

    public synchronized void addInstallerListener(InstallerListener li) {
        listeners.add(InstallerListener.class, (EventListener)li);
    }

    public synchronized void removeBooksListener(InstallerListener li) {
        listeners.remove(InstallerListener.class, (EventListener)li);
    }

    protected synchronized void fireInstallersChanged(Object source, Installer installer, boolean added) {
        Object[] contents = listeners.getListenerList();
        InstallerEvent ev = null;
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != (class$org$crosswire$jsword$book$install$InstallerListener == null ? InstallManager.class$("org.crosswire.jsword.book.install.InstallerListener") : class$org$crosswire$jsword$book$install$InstallerListener)) continue;
            if (ev == null) {
                ev = new InstallerEvent(source, installer, added);
            }
            if (added) {
                ((InstallerListener)contents[i + 1]).installerAdded(ev);
                continue;
            }
            ((InstallerListener)contents[i + 1]).installerRemoved(ev);
        }
    }

    static {
        $assertionsDisabled = !InstallManager.class.desiredAssertionStatus();
        log = Logger.getLogger((Class)InstallManager.class);
        listeners = new EventListenerList();
    }
}

