/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.book.install.BookNode;
import org.crosswire.bibledesktop.book.install.BookTreeCellRenderer;
import org.crosswire.bibledesktop.book.install.IndexResolver;
import org.crosswire.bibledesktop.book.install.Msg;
import org.crosswire.bibledesktop.book.install.TextPaneBookMetaDataDisplay;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.MsgBase;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookList;
import org.crosswire.jsword.book.BookSet;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.install.InstallException;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;

public class SitePane
extends JPanel {
    private static final String INSTALLED_BOOKS_LABEL = "InstalledBooksLabel";
    private static final String AVAILABLE_BOOKS_LABEL = "AvailableBooksLabel";
    private static final String SELECTED_BOOK_LABEL = "SelectedBookLabel";
    private static final String REFRESH = "Refresh";
    private static final String INSTALL = "Install";
    private static final String INSTALL_SEARCH = "InstallSearch";
    private static final String DELETE = "Delete";
    private static final String UNLOCK = "Unlock";
    private static final String UNINDEX = "Unindex";
    protected transient Installer installer;
    private transient ActionFactory actions;
    private JTree treAvailable;
    private transient TextPaneBookMetaDataDisplay display;
    private JLabel lblDesc;
    private static final long serialVersionUID = 3616445692051075634L;

    public SitePane() {
        this(null, INSTALLED_BOOKS_LABEL);
    }

    public SitePane(Installer bookListInstaller) {
        this(bookListInstaller, AVAILABLE_BOOKS_LABEL);
    }

    private SitePane(Installer bookListInstaller, String labelAcronymn) {
        this.installer = bookListInstaller;
        this.actions = new ActionFactory(SitePane.class, (Object)this);
        Installer bl = this.installer;
        if (bl == null) {
            bl = Books.installed();
            bl.addBooksListener((BooksListener)new CustomBooksListener());
        }
        this.initialize(labelAcronymn, (BookList)bl);
    }

    private void initialize(String labelAcronymn, BookList books) {
        this.lblDesc = new JLabel();
        this.lblDesc.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        Component left = this.createAvailablePanel(labelAcronymn, books);
        Component right = this.createSelectedPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblDesc, "North");
        this.add(this.createSplitPane(left, right), "Center");
        this.updateDescription();
    }

    private void updateDescription() {
        String desc = "#ERROR#";
        if (this.installer == null) {
            int bookCount = Books.installed().getBooks().size();
            desc = Msg.INSTALLED_DESC.toString(new Object[]{new Integer(bookCount)});
        } else {
            int bookCount = this.installer.getBooks().size();
            desc = bookCount == 0 ? Msg.NONE_AVAILABLE_DESC.toString() : Msg.AVAILABLE_DESC.toString(new Object[]{new Integer(bookCount)});
        }
        this.lblDesc.setText(desc);
    }

    private Component createSplitPane(Component left, Component right) {
        FixedSplitPane split = new FixedSplitPane();
        split.setDividerLocation(0.3);
        split.setResizeWeight(0.3);
        split.setOrientation(1);
        split.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        split.setDividerSize(10);
        split.setLeftComponent(left);
        split.setRightComponent(right);
        return split;
    }

    private Component createAvailablePanel(String labelAcronymn, BookList books) {
        JLabel lblAvailable = this.actions.createJLabel(labelAcronymn);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblAvailable, "First");
        panel.add(this.createScrolledTree(books), "Center");
        panel.add(this.createPanelActions(), "Last");
        lblAvailable.setLabelFor(this.treAvailable);
        return panel;
    }

    private Component createSelectedPanel() {
        JLabel lblSelected = this.actions.createJLabel(SELECTED_BOOK_LABEL);
        this.display = new TextPaneBookMetaDataDisplay();
        lblSelected.setLabelFor(this.display.getComponent());
        JScrollPane scrSelected = new JScrollPane();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)lblSelected, "First");
        panel.add((Component)scrSelected, "Center");
        scrSelected.getViewport().add(this.display.getComponent());
        return panel;
    }

    private Component createScrolledTree(BookList books) {
        this.treAvailable = new JTree();
        ToolTipManager.sharedInstance().registerComponent(this.treAvailable);
        this.treAvailable.setCellRenderer(new BookTreeCellRenderer());
        this.setTreeModel(books);
        this.treAvailable.putClientProperty("JTree.lineStyle", "Angled");
        this.treAvailable.getSelectionModel().setSelectionMode(1);
        this.treAvailable.setCellEditor(null);
        this.treAvailable.setRootVisible(false);
        this.treAvailable.setShowsRootHandles(true);
        this.treAvailable.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                SitePane.this.selected();
            }
        });
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.treAvailable);
        return scroller;
    }

    private TreeModel createTreeModel(BookList books) {
        BookSet bmds = new BookSet((Collection)books.getBooks());
        BookNode bookRoot = new BookNode("root", bmds, 0, new Object[]{"Category", "Language"});
        return new DefaultTreeModel(bookRoot);
    }

    private Book getBook(Object anObj) {
        Object obj = anObj;
        if (obj instanceof DefaultMutableTreeNode) {
            obj = ((DefaultMutableTreeNode)obj).getUserObject();
        }
        if (obj instanceof Book) {
            return (Book)obj;
        }
        return null;
    }

    private Component createPanelActions() {
        JPanel panel = new JPanel();
        if (this.installer != null) {
            panel.add(new JButton(this.actions.getAction(INSTALL)));
            panel.add(new JButton(this.actions.getAction(REFRESH)));
        } else {
            panel.add(new JButton(this.actions.getAction(DELETE)));
            panel.add(new JButton(this.actions.getAction(UNLOCK)));
            panel.add(new JButton(this.actions.getAction(UNINDEX)));
        }
        return panel;
    }

    public void doDelete() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        try {
            if (JOptionPane.showConfirmDialog(this, Msg.CONFIRM_DELETE_BOOK.toString(new Object[]{book.getName()}), Msg.CONFIRM_DELETE_TITLE.toString(), 0) == 0) {
                book.getDriver().delete(book);
                IndexManager imanager = IndexManagerFactory.getIndexManager();
                if (imanager.isIndexed(book)) {
                    imanager.deleteIndex(book);
                }
            }
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void doUnlock() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        String unlockKey = (String)JOptionPane.showInputDialog(this, Msg.UNLOCK_BOOK.toString(new Object[]{book.getName()}), Msg.UNLOCK_TITLE.toString(), 3, null, null, book.getUnlockKey());
        if (unlockKey != null && unlockKey.length() > 0) {
            book.unlock(unlockKey);
            Books.installed().addBook(book);
        }
    }

    public void doUnindex() {
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book book = this.getBook(last);
        try {
            IndexManager imanager = IndexManagerFactory.getIndexManager();
            if (imanager.isIndexed(book) && JOptionPane.showConfirmDialog(this, Msg.CONFIRM_UNINSTALL_BOOK.toString(new Object[]{book.getName()}), Msg.CONFIRM_UNINSTALL_TITLE.toString(), 0) == 0) {
                imanager.deleteIndex(book);
            }
            this.actions.getAction(UNINDEX).setEnabled(imanager.isIndexed(book));
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, (LucidException)e);
        }
    }

    public void doRefresh() {
        if (this.installer != null) {
            try {
                this.installer.reloadBookList();
                this.setTreeModel((BookList)this.installer);
            }
            catch (InstallException ex) {
                Reporter.informUser((Object)this, (LucidException)ex);
            }
        }
    }

    public void doInstall() {
        if (this.installer == null) {
            return;
        }
        TreePath path = this.treAvailable.getSelectionPath();
        if (path == null) {
            return;
        }
        Object last = path.getLastPathComponent();
        Book name = this.getBook(last);
        try {
            Book book = Books.installed().getBook(name.getName());
            if (book != null && !this.installer.isNewer(name)) {
                Reporter.informUser((Object)this, (MsgBase)Msg.INSTALLED, (Object)name.getName());
                return;
            }
            float size = (float)this.installer.getSize(name) / 1024.0f;
            Msg msg = Msg.KB_SIZE;
            if (size > 1024.0f) {
                size /= 1024.0f;
                msg = Msg.MB_SIZE;
            }
            if (JOptionPane.showConfirmDialog(this, msg.toString(new Object[]{name.getName(), new Float(size)}), Msg.CONFIRMATION_TITLE.toString(), 0) == 0) {
                this.installer.install(name);
            }
        }
        catch (InstallException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    public void doInstallSearch() {
        this.doInstall();
        TreePath path = this.treAvailable.getSelectionPath();
        if (path != null) {
            Object last = path.getLastPathComponent();
            Book book = this.getBook(last);
            IndexResolver.scheduleIndex(book, this);
        }
    }

    protected void selected() {
        Object last;
        TreePath path = this.treAvailable.getSelectionPath();
        boolean bookSelected = false;
        Book book = null;
        if (path != null && (book = this.getBook(last = path.getLastPathComponent())) != null) {
            bookSelected = true;
        }
        this.display.setBook(book);
        if (book == null) {
            return;
        }
        boolean canInstall = bookSelected && book.isSupported();
        IndexManager imanager = IndexManagerFactory.getIndexManager();
        this.actions.getAction(DELETE).setEnabled(bookSelected && book.getDriver().isDeletable(book));
        this.actions.getAction(UNLOCK).setEnabled(bookSelected && book.isEnciphered());
        this.actions.getAction(UNINDEX).setEnabled(bookSelected && imanager.isIndexed(book));
        this.actions.getAction(INSTALL).setEnabled(canInstall);
        this.actions.getAction(INSTALL_SEARCH).setEnabled(canInstall && book.getBookCategory() == BookCategory.BIBLE);
    }

    public void setTreeModel(BookList books) {
        this.treAvailable.setModel(this.createTreeModel(books));
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.installer = null;
        this.display = null;
        this.actions = new ActionFactory(SitePane.class, (Object)this);
        is.defaultReadObject();
    }

    final class CustomBooksListener
    implements BooksListener {
        CustomBooksListener() {
        }

        public void bookAdded(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }

        public void bookRemoved(BooksEvent ev) {
            SitePane.this.setTreeModel((BookList)ev.getSource());
        }
    }
}

