/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.xml;

import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.crosswire.common.xml.XMLFeature;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class XMLFeatureSet {
    private Map features = new TreeMap();
    private Map states = new TreeMap();

    public XMLFeatureSet() {
        this.features.put("n", new XMLFeatureState(XMLFeature.NAMESPACES, true));
        this.features.put("np", new XMLFeatureState(XMLFeature.NAMESPACE_PREFIX));
        this.features.put("v", new XMLFeatureState(XMLFeature.VALIDATION));
        this.features.put("xd", new XMLFeatureState(XMLFeature.LOAD_EXTERNAL_DTD, true));
        this.features.put("s", new XMLFeatureState(XMLFeature.SCHEMA_VALIDATION));
        this.features.put("f", new XMLFeatureState(XMLFeature.SCHEMA_FULL_CHECKING));
        this.features.put("va", new XMLFeatureState(XMLFeature.VALIDATE_ANNOTATIONS));
        this.features.put("dv", new XMLFeatureState(XMLFeature.DYNAMIC_VALIDATION));
        this.features.put("xi", new XMLFeatureState(XMLFeature.XINCLUDE));
        this.features.put("xb", new XMLFeatureState(XMLFeature.XINCLUDE_FIXUP_BASE_URIS, true));
        this.features.put("xl", new XMLFeatureState(XMLFeature.XINCLUDE_FIXUP_LANGUAGE, true));
        Iterator iter = this.features.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.states.put(((XMLFeatureState)entry.getValue()).getFeature(), entry.getKey());
        }
    }

    public void setFeatureState(XMLFeature feature, boolean state) {
        ((XMLFeatureState)this.features.get(this.states.get(feature))).setState(state);
    }

    public void setFeatureStates(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            String option;
            String key;
            XMLFeatureState feature;
            String arg = argv[i];
            if (arg.charAt(0) != '=' || (feature = (XMLFeatureState)this.features.get(key = (option = arg.substring(1)).toLowerCase(Locale.ENGLISH))) == null) continue;
            feature.setState(option.equals(key));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('\n');
        Iterator iter = this.features.values().iterator();
        while (iter.hasNext()) {
            XMLFeatureState state = (XMLFeatureState)iter.next();
            buf.append(state.getFeature().toString()).append('\n');
        }
        return buf.toString();
    }

    public void printUsage() {
        System.err.println("XML Feature Set options:");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
    }

    public void setFeatures(XMLReader parser) {
        Iterator iter = this.features.values().iterator();
        while (iter.hasNext()) {
            XMLFeatureState state = (XMLFeatureState)iter.next();
            state.setFeature(parser);
        }
    }

    private static class XMLFeatureState {
        private boolean state;
        private XMLFeature feature;

        public XMLFeatureState(XMLFeature feature, boolean state) {
            this.feature = feature;
            this.state = state;
        }

        public XMLFeatureState(XMLFeature feature) {
            this(feature, false);
        }

        public XMLFeature getFeature() {
            return this.feature;
        }

        public boolean getState() {
            return this.state;
        }

        public void setState(boolean newState) {
            this.state = newState;
        }

        public void setFeature(XMLReader parser) {
            String control = this.feature.getControl();
            try {
                parser.setFeature(control, this.state);
            }
            catch (SAXNotRecognizedException e) {
                System.err.println("warning: Parser does not recognize feature (" + control + ")");
            }
            catch (SAXNotSupportedException e) {
                System.err.println("warning: Parser does not support feature (" + control + ")");
            }
        }
    }
}

