/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.jar.JarEntry;
import org.crosswire.common.util.Logger;
import org.crosswire.common.util.Msg;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.util.URLFilter;
import org.crosswire.common.util.WebResource;

public final class NetUtil {
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_FTP = "ftp";
    public static final String PROTOCOL_JAR = "jar";
    public static final String INDEX_FILE = "index.txt";
    public static final String SEPARATOR = "/";
    public static final String AUTH_SEPERATOR_USERNAME = "@";
    public static final String AUTH_SEPERATOR_PASSWORD = ":";
    private static final String TEMP_SUFFIX = "tmp";
    private static File cachedir;
    private static final Logger log;
    static final /* synthetic */ boolean $assertionsDisabled;

    private NetUtil() {
    }

    public static void makeDirectory(URL orig) throws MalformedURLException {
        NetUtil.checkFileURL(orig);
        File file = new File(orig.getFile());
        if (file.isFile()) {
            throw new MalformedURLException(Msg.IS_FILE.toString(orig));
        }
        if (!file.isDirectory()) {
            file.mkdirs();
            if (!file.isDirectory()) {
                throw new MalformedURLException(Msg.CREATE_DIR_FAIL.toString(orig));
            }
        }
    }

    public static void makeFile(URL orig) throws MalformedURLException, IOException {
        NetUtil.checkFileURL(orig);
        File file = new File(orig.getFile());
        if (file.isDirectory()) {
            throw new MalformedURLException(Msg.IS_DIR.toString(orig));
        }
        if (!file.isFile()) {
            FileOutputStream fout = new FileOutputStream(file);
            fout.close();
            if (!file.isFile()) {
                throw new MalformedURLException(Msg.CREATE_FILE_FAIL.toString(orig));
            }
        }
    }

    public static boolean isFile(URL url) {
        if (url.getProtocol().equals(PROTOCOL_FILE)) {
            return new File(url.getFile()).isFile();
        }
        try {
            url.openStream().close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean isDirectory(URL orig) {
        if (!orig.getProtocol().equals(PROTOCOL_FILE)) {
            return false;
        }
        return new File(orig.getFile()).isDirectory();
    }

    public static boolean canWrite(URL orig) {
        if (!orig.getProtocol().equals(PROTOCOL_FILE)) {
            return false;
        }
        return new File(orig.getFile()).canWrite();
    }

    public static boolean move(URL oldUrl, URL newUrl) throws IOException {
        NetUtil.checkFileURL(oldUrl);
        NetUtil.checkFileURL(newUrl);
        File oldFile = new File(oldUrl.getFile());
        File newFile = new File(newUrl.getFile());
        return oldFile.renameTo(newFile);
    }

    public static boolean delete(URL orig) throws IOException {
        NetUtil.checkFileURL(orig);
        return new File(orig.getFile()).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getAsFile(URL url) throws IOException {
        if (url.getProtocol().equals(PROTOCOL_FILE)) {
            return new File(url.getFile());
        }
        String hashString = (url.toExternalForm().hashCode() + "").replace('-', 'm');
        File workingDir = NetUtil.getURLCacheDir();
        File workingFile = null;
        workingFile = workingDir != null && workingDir.isDirectory() ? new File(workingDir, hashString) : File.createTempFile(hashString, TEMP_SUFFIX);
        workingFile.deleteOnExit();
        FileOutputStream output = null;
        InputStream input = null;
        try {
            output = new FileOutputStream(workingFile);
            input = url.openStream();
            byte[] data = new byte[512];
            int read = 0;
            while (read != -1) {
                ((OutputStream)output).write(data, 0, read);
                read = input.read(data);
            }
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            finally {
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
        }
        return workingFile;
    }

    public static URL shortenURL(URL orig, String strip) throws MalformedURLException {
        String test;
        String file = orig.getFile();
        char lastChar = file.charAt(file.length() - 1);
        if (NetUtil.isSeparator(lastChar)) {
            file = file.substring(0, file.length() - 1);
        }
        if (!(test = file.substring(file.length() - strip.length())).equals(strip)) {
            throw new MalformedURLException(Msg.CANT_STRIP.toString(new Object[]{orig, strip}));
        }
        String newFile = file.substring(0, file.length() - strip.length());
        return new URL(orig.getProtocol(), orig.getHost(), orig.getPort(), newFile);
    }

    public static URL lengthenURL(URL orig, String anExtra) {
        String extra = anExtra;
        try {
            char firstChar = extra.charAt(0);
            if (NetUtil.isSeparator(firstChar)) {
                extra = extra.substring(1);
            }
            if (orig.getProtocol().equals(PROTOCOL_FILE)) {
                String file = orig.toExternalForm();
                char lastChar = file.charAt(file.length() - 1);
                if (NetUtil.isSeparator(lastChar)) {
                    return new URL(orig.getProtocol(), orig.getHost(), orig.getPort(), orig.getFile() + extra);
                }
                return new URL(orig.getProtocol(), orig.getHost(), orig.getPort(), orig.getFile() + File.separator + extra);
            }
            return new URL(orig.getProtocol(), orig.getHost(), orig.getPort(), orig.getFile() + SEPARATOR + extra);
        }
        catch (MalformedURLException ex) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)ex);
            }
            return null;
        }
    }

    private static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static OutputStream getOutputStream(URL url) throws IOException {
        return NetUtil.getOutputStream(url, false);
    }

    public static OutputStream getOutputStream(URL url, boolean append) throws IOException {
        if (url.getProtocol().equals(PROTOCOL_FILE)) {
            return new FileOutputStream(url.getFile(), append);
        }
        URLConnection cnx = url.openConnection();
        cnx.setDoOutput(true);
        return cnx.getOutputStream();
    }

    public static String[] list(URL url, URLFilter filter) throws MalformedURLException, IOException {
        String[] reply;
        block6: {
            reply = new String[]{};
            try {
                URL search = NetUtil.lengthenURL(url, INDEX_FILE);
                reply = NetUtil.listByIndexFile(search, filter);
            }
            catch (FileNotFoundException ex) {
                log.warn("index file for " + url.toExternalForm() + " was not found.");
                if (!url.getProtocol().equals(PROTOCOL_FILE)) break block6;
                return NetUtil.listByFile(url, filter);
            }
        }
        if (url.getProtocol().equals(PROTOCOL_FILE)) {
            String[] files = NetUtil.listByFile(url, filter);
            if (files.length != reply.length) {
                log.warn("index file for " + url.toExternalForm() + " has incorrect number of entries.");
            } else {
                List<String> list = Arrays.asList(files);
                for (int i = 0; i < files.length; ++i) {
                    if (list.contains(files[i])) continue;
                    log.warn("file: based index found " + files[i] + " but this was not found using index file.");
                }
            }
        }
        return reply;
    }

    public static String[] listByFile(URL url, URLFilter filter) throws MalformedURLException {
        File fdir = new File(url.getFile());
        if (!fdir.isDirectory()) {
            throw new MalformedURLException(Msg.NOT_DIR.toString(url.toExternalForm()));
        }
        return fdir.list(new URLFilterFilenameFilter(filter));
    }

    public static String[] listByIndexFile(URL index, URLFilter filter) throws IOException {
        InputStream in = index.openStream();
        String contents = StringUtil.read(new InputStreamReader(in));
        ArrayList<String> list = new ArrayList<String>();
        String[] names = StringUtil.split(contents, "\n");
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].trim();
            if (name.length() <= 0 || name.charAt(0) == '#' || name.equals(INDEX_FILE) || !filter.accept(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[list.size()]);
    }

    public static int getSize(URL url) {
        return NetUtil.getSize(url, null, null);
    }

    public static int getSize(URL url, String proxyHost) {
        return NetUtil.getSize(url, proxyHost, null);
    }

    public static int getSize(URL url, String proxyHost, Integer proxyPort) {
        if (url.getProtocol().equals(PROTOCOL_HTTP)) {
            return new WebResource(url, proxyHost, proxyPort).getSize();
        }
        try {
            return url.openConnection().getContentLength();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static long getLastModified(URL url) {
        return NetUtil.getLastModified(url, null, null);
    }

    public static long getLastModified(URL url, String proxyHost) {
        return NetUtil.getLastModified(url, proxyHost, null);
    }

    public static long getLastModified(URL url, String proxyHost, Integer proxyPort) {
        if (url.getProtocol().equals(PROTOCOL_HTTP)) {
            return new WebResource(url, proxyHost, proxyPort).getLastModified();
        }
        try {
            URLConnection urlConnection = url.openConnection();
            long time = urlConnection.getLastModified();
            if (urlConnection instanceof JarURLConnection) {
                JarURLConnection jarConnection = (JarURLConnection)urlConnection;
                JarEntry jarEntry = jarConnection.getJarEntry();
                time = jarEntry.getTime();
            }
            return time;
        }
        catch (IOException ex) {
            log.warn("Failed to get modified time", ex);
            return new Date().getTime();
        }
    }

    public static boolean isNewer(URL left, URL right) {
        return NetUtil.isNewer(left, right, null, null);
    }

    public static boolean isNewer(URL left, URL right, String proxyHost) {
        return NetUtil.isNewer(left, right, proxyHost, null);
    }

    public static boolean isNewer(URL left, URL right, String proxyHost, Integer proxyPort) {
        return NetUtil.getLastModified(left, proxyHost, proxyPort) > NetUtil.getLastModified(right, proxyHost, proxyPort);
    }

    private static void checkFileURL(URL url) throws MalformedURLException {
        if (!url.getProtocol().equals(PROTOCOL_FILE)) {
            throw new MalformedURLException(Msg.NOT_FILE_URL.toString(url));
        }
    }

    public static File getURLCacheDir() {
        return cachedir;
    }

    public static void setURLCacheDir(File cachedir) {
        NetUtil.cachedir = cachedir;
    }

    public static URL getURL(File file) {
        try {
            return new URL(PROTOCOL_FILE, null, -1, file.getCanonicalPath());
        }
        catch (IOException ex) {
            log.error("Failed to create URL", ex);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new IllegalArgumentException(ex.toString());
        }
    }

    public static URL getTemporaryURL(String prefix, String suffix) throws IOException {
        File tempFile = File.createTempFile(prefix, suffix);
        return NetUtil.getURL(tempFile);
    }

    static {
        $assertionsDisabled = !NetUtil.class.desiredAssertionStatus();
        log = Logger.getLogger(NetUtil.class);
    }

    public static class IsDirectoryURLFilter
    implements URLFilter {
        private URL parent;

        public IsDirectoryURLFilter(URL parent) {
            this.parent = parent;
        }

        public boolean accept(String name) {
            return NetUtil.isDirectory(NetUtil.lengthenURL(this.parent, name));
        }
    }

    public static class URLFilterFilenameFilter
    implements FilenameFilter {
        private URLFilter filter;

        public URLFilterFilenameFilter(URLFilter filter) {
            this.filter = filter;
        }

        public boolean accept(File arg0, String name) {
            return this.filter.accept(name);
        }
    }
}

